<?php get_header(); ?>

<main id="blog" class="search">
  <section class="container-fluid secao-filtros py-3">
    <div class="row">
      <div class="filtros col-12 d-flex flex-wrap justify-content-md-between">
        <div class="left col-md-4 pl-md-0 d-flex align-items-center">
          <form action="" class="flex-wrap categorias d-none">
            <select id="categorias" name="categorias" data-name="categorias">
              <option value="">Categorias</option>
              <?php
              $estados = get_terms(array('taxonomy' => 'category'));
              foreach ($estados as $estado) : ?>
                <option value="<?= $estado->name ?>"><?= $estado->name ?></option>
              <?php endforeach;
              ?>
            </select>
          </form>
          <a href="<?= site_url(); ?>/materiais-ricos" class="link">Materiais Ricos</a>
        </div>
        <div class="right d-flex col-md-8 flex-wrap justify-content-md-end d-none">
          <?php get_search_form(); ?>
          <a href="<?= site_url(); ?>/blog/#newsletter" class="cta">Assine a nossa newsletter</a>
        </div>
      </div>
    </div>
  </section>
  <section class="secao-postagens py-5 mt-5">
    <div class="container-fluid">
      <div class="container">
        <div class="container-boxes row">
          <?php if (have_posts()) : ?>
            <h2 class="col-12 titulo">Resultados da busca para "<?php the_search_query(); ?>"</h2>
            <?php while (have_posts()) : the_post();
              $post_categories = get_the_category(get_the_ID());
              if (!empty($post_categories)) {
                $post_category = esc_html($post_categories[0]->name);
              } else {
                $post_category = "";
              }
              $post_thumbnail_id = intval(get_post_thumbnail_id($post->ID));
              $array_thumbnail = wp_get_attachment_image_src($post_thumbnail_id, 'thumbnail_size');
              if ($array_thumbnail == '') {
                $thumbn = get_stylesheet_directory_uri() . '/assets/img/bg-topo-blog.jpg';
              } else {
                $thumbn = $array_thumbnail[0];
              }
            ?>
              <div class="col-md-4 my-3">
                <a href="<?= get_permalink($recent["ID"]) ?>" class="block">
                  <img src="<?= $thumbn; ?>" alt="<?= $recent['post_title']; ?>" width="100%">
                  <div class="tags">
                    <span><?= $post_category ?></span>
                  </div>
                  <div class="texto">
                    <h2><?php the_title(); ?></h2>
                  </div>
                </a>
              </div>
            <?php endwhile; ?>
        </div>
      </div>
      <div class="d-flex justify-content-center">
        <?php echo paginate_links(); ?>
      </div>
    <?php else : echo  "<p class='col-12 mb-5 text-center'>Nenhum resultado encontrado.</p><a href='/' class='cta' style='margin:0 auto;'>Voltar para o site</a>" ?> <?php endif; ?>
    </div>
  </section>
</main>
<?php get_footer(); ?>