<?php
// Template name: Home
get_header(); ?>
<main id="home">
  <section class="container-fluid banner-principal">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-6" data-anime="left">
          <img src="<?php the_field('imagem_banner_principal'); ?>" alt="" style="max-width:100%;">
        </div>
        <div class="col-md-6" data-anime="right">
          <h1 class="mb-3"><?php the_field('titulo_princial'); ?></h1>
          <?php the_field('texto_banner_princial'); ?>
          <a href="<?php the_field('link_banner_principal'); ?>" class="cta">Saiba mais</a>
        </div>
      </div>
    </div>
  </section>
  <section class="atuacao container-fluid px-0 py-md-5 py-3">
    <div class="container">
      <h3 class="titulo-secao mb-3 mb-md-5" data-anime="down">Nossas <strong>áreas</strong> de atuação</h3>
      <div class="row justify-content-center" data-anime="top">
        <?php if (have_rows('areas_de_atuacao')) : while (have_rows('areas_de_atuacao')) : the_row(); ?>
            <div class="col-md-4 bg-cover box d-flex justify-content-center align-items-center" style="background-image: url('<?php the_sub_field('imagem'); ?>');">
              <div class="texto">
                <h2><?php the_sub_field('texto'); ?></h2>
              </div>
              <a href="<?php the_sub_field('link'); ?>" target="_blank" class="cta">Saiba mais</a>
            </div>
        <?php endwhile;
        endif; ?>
      </div>
    </div>
  </section>
  <section class="mapa container-fluid px-0 py-md-5 py-3">
    <div class="container">
      <h3 class="titulo-secao mb-3 mb-md-5" data-anime="down">Onde <strong>estamos</strong></h3>
      <div class="row justify-content-center">
        <div class="col-md-10" data-anime="top">
          <img src="<?php the_field('imagem_mapa'); ?>" alt="imagem mapa" style="max-width:100%;">
        </div>
      </div>
    </div>
  </section>
  <section class="cards container-fluid py-md-5 py-3 bg-cover" style="background-image: url('<?php echo get_stylesheet_directory_uri() ?>/assets/img/bg-blue.jpg');">
    <div class="container py-md-5">
      <div class="row justify-content-center pt-md-5" data-anime="down">
        <?php if (have_rows('cards')) : while (have_rows('cards')) : the_row(); ?>
            <div class="col-md-3 my-3">
              <a href="<?php the_sub_field('link'); ?>" target="_blank" class="box">
                <div class="cta"><?php the_sub_field('titulo'); ?></div>
                <?php the_sub_field('texto'); ?>
              </a>
            </div>
        <?php endwhile;
        endif; ?>
      </div>
    </div>
  </section>
<!--   <section class="depoimentos container-fluid py-md-5 py-3">
    <div class="container py-md-5">
      <div class="row justify-content-center">
        <div class="col-12 slide">
          <?php if (have_rows('depoimentos')) : while (have_rows('depoimentos')) : the_row(); ?>
              <div class="d-flex flex-wrap align-items-center justify-content-center">
                <div class="col-md-4 text-right" data-anime="left">
                  <p><?php the_sub_field('texto'); ?></p>
                  <div class="autor">
                    <p class="mb-2"><strong><?php the_sub_field('autor'); ?></strong></p>
                    <p><?php the_sub_field('cargo'); ?></p>
                  </div>
                </div>
                <div class="col-md-6" data-anime="right">
                  <img src="<?php the_sub_field('imagem'); ?>" alt="imagem autor depoimento">
                </div>
              </div>
          <?php endwhile;
          endif; ?>
        </div>
      </div>
    </div>
  </section> -->
  <section class="parcerias container-fluid py-md-5 py-3">
    <div class="container py-md-5">
      <h3 class="titulo-secao mb-3 mb-md-5" data-anime="down">Nossas <strong>parcerias</strong></h3>
      <div class="row justify-content-center align-items-center" data-anime="top">
        <?php if (have_rows('parcerias')) : while (have_rows('parcerias')) : the_row(); ?>
            <div class="col-md-2 col-6">
              <img src="<?php the_sub_field('logo'); ?>" alt="logo parceiro" style="max-width:100%;">
            </div>
        <?php endwhile;
        endif; ?>
      </div>
    </div>
  </section>
</main>

<?php get_footer(); ?>