<?php get_header();
$blog = get_page_by_title('blog'); ?>

<main id="blog" class="single interna">
  <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
      <section class="container-fluid secao-filtros py-3">
        <div class="row">
          <div class="filtros col-12 d-flex flex-wrap justify-content-md-between">
            <div class="left col-md-4 pl-md-0 d-flex align-items-center">
              <form action="" class="flex-wrap categorias d-none" slidesToScroll: 1, arrows: true, responsive: [{ breakpoint: 500, settings: { slidesToShow: 1, slidesToScroll: 1, } }] }); </script>
                <script>
                  // Formulário
                  $(document).ready(function() {
                    $('.minus').click(function() {
                      var $input = $(this).parent().find('input');
                      var count = parseInt($input.val()) - 1;
                      count = count < 1 ? 1 : count;
                      $input.val(count);
                      $input.change();
                      return false;
                    });
                    $('.plus').click(function() {
                      var $input = $(this).parent().find('input');
                      $input.val(parseInt($input.val()) + 1);
                      $input.change();
                      return false;
                    });
                  });

                  $('.radio input').click(function() {
                    if ($('#incluir').is(':checked')) {
                      $('.coberturas').removeClass('d-none');
                      $('.coberturas').addClass('d-flex');
                    } else {
                      $('.coberturas').removeClass('d-flex');
                      $('.coberturas').addClass('d-none');
                    }
                  });
                </script>
                </body>>
                <select id="categorias" name="categorias" data-name="categorias">
                  <option value="">Categorias</option>
                  <?php
                  $estados = get_terms(array('taxonomy' => 'category'));
                  foreach ($estados as $estado) : ?>
                    <option value="<?= $estado->name ?>"><?= $estado->name ?></option>
                  <?php endforeach;
                  ?>
                </select>
              </form>
              <a href="<?= site_url(); ?>/materiais-ricos" class="link">Materiais Ricos</a>
            </div>
            <div class="right d-flex col-md-8 flex-wrap justify-content-md-end">
              <?php get_search_form(); ?>
              <a href="#newsletter" class="cta">Assine a nossa newsletter</a>
            </div>
          </div>
        </div>
      </section>
      <section class="secao-principal py-md-5 py-3">
        <div class="container postagem">
          <div class="row justify-content-center">
            <div class="col-12">
              <img src="<?php the_post_thumbnail_url(); ?>" class="thumb" alt="<?php the_title() ?>" width="100%">
            </div>
            <div class="col-md-7">
              <h1 class="titulo"><?php the_title(); ?></h1>
              <div class="tags">
                <?php the_category(); ?>
              </div>
              <div class="content">
                <?php the_content(); ?>
              </div>
            </div>
            <div class="col-md-4 offset-md-1 sidebar">
              <h3 class="titulo">Posts populares</h3>

              <!--QUERY POST ANTERIORES-->
              <?php
              $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
              $pp_page = $wp_query->query_vars['posts_per_page'];
              $offset = 5 + ($pp_page * ($paged - 1));
              $args = array(
                'post_type' => 'post',
                'post_status' => 'publish',
                'posts_per_page' => 3, // As per the post below you need to have a set number of posts.
                'paged' => $paged,
                'offset' => $offset,
                'orderby' => 'date',
                'order' => 'DESC',
                'ignore_sticky_posts' => true,
              );
              $wpb_all_query = new WP_Query($args); ?>
              <?php if ($wpb_all_query->have_posts()) {
                while ($wpb_all_query->have_posts()) {
                  $wpb_all_query->the_post();
                  $post_categories = get_the_category(get_the_ID());
                  if (!empty($post_categories)) {
                    $post_category = esc_html($post_categories[0]->name);
                  } else {
                    $post_category = "";
                  }
                  $post_thumbnail_id = intval(get_post_thumbnail_id($post->ID));
                  $array_thumbnail = wp_get_attachment_image_src($post_thumbnail_id, 'thumbnail_size');
                  if ($array_thumbnail == '') {
                    $thumbn = get_stylesheet_directory_uri() . '/images/placeholder.png';
                  } else {
                    $thumbn = $array_thumbnail[0];
                  }
              ?>
                  <a href="<?= get_permalink($recent["ID"]) ?>" class="block">
                    <div class="tags">
                      <span><?= $post_category ?></span>
                    </div>
                    <div class="texto">
                      <h2><?php the_title(); ?></h2>
                    </div>
                  </a>

                <?php
                } ?>
                <!-- <div id="navegacao"> -->
                <!-- <?php next_posts_link('<span class="navegacao" style="float:right">Posts Mais Antigos</span>', $wpb_all_query->max_num_pages); ?> -->
                <!-- <?php previous_posts_link('<span class="navegacao" style="float:left">Posts Mais Recentes</span>'); ?> -->
                <!-- </div> -->
              <?php
                wp_reset_postdata();
              } else {
                echo '<p>Nenhum post antigo, veja nossos últimos conteúdos acima!</p>';
                echo '</div>';
              }
              ?>
              <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/banner-lateral.jpg" alt="banner lateral" class="banner-lateral" width="100%">
            </div>
          </div>
        </div>
      </section>
      <section id="newsletter" class="secao-newsletter container-fluid py-md-5 py-3">
        <div class="container">
          <div class="row align-items-center justify-content-center">
            <div class="texto col-12 text-center">
              <h3>Assine nossa newsletter</h3>
              <p><?php the_field('frase_newsletter'); ?></p>
              <div class="formulario">
                <form action="https://webto.salesforce.com/servlet/servlet.WebToLead?encoding=UTF-8" method="POST">
                  <input type=hidden name="oid" value="00D2E000001FV2g">
                  <input type=hidden name="retURL" value="https://www.lojaclamper.com.br/">

                  <div class="form-row">
                    <div class="form-group col-md-4">
                      <label for="first_name">Primeiro Nome</label>
                      <input id="first_name" maxlength="40" name="first_name" size="20" type="text" class="form-control" required />
                    </div>
                    <div class="form-group col-md-4">
                      <label for="last_name">Sobrenome</label>
                      <input id="last_name" maxlength="80" name="last_name" size="20" type="text" class="form-control" required />
                    </div>
                    <div class="form-group col-md-4">
                      <label for="email">Email</label>
                      <input id="email" maxlength="80" name="email" size="20" type="text" class="form-control" required />
                    </div>
                  </div>
                  <input id="00N2E00000JWzQC" name="00N2E00000JWzQC" type="checkbox" value="1" required />
                  <label for="00N2E00000JWzQC">Aceite Termos e Políticas de Privacidade:</label>
                  <input id="00N2E00000JWzQD" name="00N2E00000JWzQD" type="checkbox" value="1" required />
                  <label for="00N2E00000JWzQD">Aceito Receber Emails da Clamper:</label>
                  <input type="hidden" name="lead_source" id="lead_source" value="Website">
                  <input type="submit" name="submit" class="cta">
                </form>
              </div>
            </div>
          </div>
        </div>
      </section>
      <section class="container py-5 relacionados">
        <div class="row">
          <h3 class="titulo col-12">Leia também</h3>
          <div class="col-12 container-boxes px-0 d-flex flex-wrap">
            <?php
            $related = get_posts(array('category__in' => wp_get_post_categories($post->ID), 'numberposts' => 3, 'post__not_in' => array($post->ID)));
            if ($related) foreach ($related as $post) {
              setup_postdata($post);
              $post_categories = get_the_category(get_the_ID());
              if (!empty($post_categories)) {
                $post_category = esc_html($post_categories[0]->name);
              } else {
                $post_category = "";
              }

              $post_thumbnail_id = intval(get_post_thumbnail_id(get_the_ID()));
              $array_thumbnail = wp_get_attachment_image_src($post_thumbnail_id, 'thumbnail_size');
              if ($array_thumbnail == '') {
                $thumbn = get_stylesheet_directory_uri() . '/images/placeholder.png';
              } else {
                $thumbn = $array_thumbnail[0];
              }
            ?>
              <div class="col-md-4 my-3">
                <a href="<?= get_permalink($recent["ID"]) ?>" class="block">
                  <img src="<?= $thumbn; ?>" alt="<?php the_title(); ?>" width="100%">
                  <div class="texto">
                    <h2><?php the_title(); ?></h2>
                  </div>
                </a>
              </div>
            <?php }
            wp_reset_postdata(); ?>
          </div>
        </div>
      </section>
    <?php endwhile;
  else : ?>

    <p>Essa página não existe</p>

  <?php endif; ?>
</main>


<?php get_footer(); ?>