<?php
// Template name: Sobre
get_header(); ?>
<main id="sobre">
  <section class="sobre container-fluid px-0 py-md-5 py-3 bg-cover" style="background-image: url('<?php the_post_thumbnail_url(); ?>');">
    <div class="container">
      <h3 class="titulo-secao mb-3 mb-md-5" data-anime="down">Quem <strong>Somos</strong></h3>
      <div class="row" data-anime="top">
        <div class="col-12">
			<?php the_content(); ?>
		  </div>
      </div>
    </div>
  </section>
  <section class="missao container-fluid px-0 py-md-5 py-3">
    <div class="container">
      <h3 class="titulo-secao mb-3 mb-md-5" data-anime="down">Nossa <strong>Missão</strong></h3>
      <div class="row">
        <div class="col-12" data-anime="top">
          <?php the_field('missao'); ?>
        </div>
      </div>
    </div>
  </section>
  <section class="numeros container-fluid pt-md-5 pt-3">
    <div class="container">
      <div class="row" data-anime="down">
		  <div class="col-12">
			  <h3 class="titulo-secao mb-3 mb-md-5" data-anime="down">Nossos <strong>números</strong></h3>
		  </div>
        <?php if (have_rows('numeros')) : while (have_rows('numeros')) : the_row(); ?>
            <div class="box col-md-3 col-6 my-3 d-flex flex-column align-items-center">
				<img src="<?php the_sub_field('icone'); ?>" alt="ícone número">
				<span><?php the_sub_field('numero'); ?></span>
				<p>
					<?php the_sub_field('texto'); ?>
				</p>
            </div>
        <?php endwhile;
        endif; ?>
      </div>
    </div>
  </section>
  <section class="atendimento container-fluid px-0 py-md-5 py-3">
    <div class="container">
      <h3 class="titulo-secao" data-anime="down"><strong>Atendimentos</strong> mensais</h3>
		<h4 class="mb-3 mb-md-4">
			Por áreas de atuação
		</h4>
      <div class="row justify-content-center">
        <div class="col-12" data-anime="top">
          <?php the_field('atendimentos_mensais'); ?>
        </div>
      </div>
    </div>
  </section>
  <section class="objetivos container-fluid pt-md-5 pt-3">
    <div class="container">
		<h4>
			Objetivos de
		</h4>
      <h3 class="titulo-secao mb-3 mb-md-5" data-anime="down"><strong>Desenvolvimento sustentável</strong></h3>
      <div class="row" data-anime="top">
		  <div class="col-md-5">
			  <?php the_field('texto_desenvovimento'); ?>
		  </div>
		  <div class="col-md-7">
			  <img src="<?php the_field('imagem_desenvolvimento'); ?>" alt="imagem objetivos de desenvolvimento sustentável" width="100%">
		  </div>
      </div>
    </div>
  </section>
</main>

<?php get_footer(); ?>