<?php
// Template name: Projetos
get_header(); ?>
<main id="projetos">
  <?php if (have_rows('projeto_luar')) : while (have_rows('projeto_luar')) : the_row(); ?>
      <section class="container-fluid luar">
        <div class="container">
          <div class="row align-items-center">
            <div class="col-md-6">
              <img src="<?php the_sub_field('logo'); ?>" class="logo mb-3 mb-md-0" alt="Logo projeto Luar" width="100%">
            </div>
            <div class="col-md-6">
              <?php the_sub_field('texto'); ?>
            </div>
            <div class="col-12 mt-5">
              <img src="<?php the_sub_field('imagem'); ?>" alt="imagem Luar" width="100%">
            </div>
          </div>
        </div>
      </section>
  <?php endwhile;
  endif; ?>
  <?php if (have_rows('projeto_jogada')) : while (have_rows('projeto_jogada')) : the_row(); ?>
      <section class="container-fluid jogada">
        <div class="container">
          <div class="row">
            <div class="col-md-6">
              <img src="<?php the_sub_field('logo'); ?>" class="logo mb-3" alt="Logo projeto Jogada de mestre" width="100%">
              <?php the_sub_field('texto'); ?>
            </div>
            <div class="col-md-6 right">
              <img src="<?php the_sub_field('imagem'); ?>" alt="Imagem projeto jogada" width="100%">
            </div>
            <div class="col-12 mt-5">
              <img src="<?php the_sub_field('imagem_2'); ?>" alt="imagem projeto jogada 2" width="100%">
            </div>
          </div>
        </div>
      </section>
  <?php endwhile;
  endif; ?>
  <?php if (have_rows('projeto_programa')) : while (have_rows('projeto_programa')) : the_row(); ?>
      <section class="container-fluid programa bg-cover" style="background-image: url('<?php the_sub_field('background'); ?>');">
        <div class="container">
          <div class="row align-items-center">
            <div class="col-md-6 order-1 order-md-0">
              <?php the_sub_field('texto'); ?>
            </div>
            <div class="col-md-6">
              <img src="<?php the_sub_field('logo'); ?>" class="logo mb-3 mb-md-0" alt="Logo programa de aceleração em empreendedorismo" width="100%">
            </div>
            <div class="col-12 order-2 mt-5">
              <img src="<?php the_sub_field('imagem'); ?>" alt="imagem programa de aceleração em empreendedorismo" width="100%">
            </div>
          </div>
        </div>
      </section>
  <?php endwhile;
  endif; ?>
  <?php if (have_rows('projeto_agua')) : while (have_rows('projeto_agua')) : the_row(); ?>
      <section class="container-fluid agua bg-cover" style="background-image: url('<?php the_sub_field('background'); ?>');">
        <div class="container">
          <div class="row align-items-center">
            <div class="col-md-6">
              <img src="<?php the_sub_field('logo'); ?>" class="logo mb-md-5 mb-3 d-block mx-auto" alt="Logo projeto água viva" width="100%">
              <?php the_sub_field('texto'); ?>
            </div>
            <div class="col-md-5 offset-md-1">
              <img src="<?php the_sub_field('imagem'); ?>" alt="imagem projeto água viva" width="100%">
            </div>
          </div>
        </div>
      </section>
  <?php endwhile;
  endif; ?>
  <?php if (have_rows('projeto_voa')) : while (have_rows('projeto_voa')) : the_row(); ?>
      <section class="container-fluid voa">
        <div class="row align-items-center">
          <div class="col-md-6 pl-0 order-1 order-md-0">
            <img src="<?php the_sub_field('imagem'); ?>" alt="imagem projeto voa literatura" width="100%">
          </div>
          <div class="col-md-6 right">
            <img src="<?php the_sub_field('logo'); ?>" class="mb-5" alt="logo projeto voa literatura" width="100%">
            <?php the_sub_field('texto'); ?>
          </div>
        </div>
      </section>
  <?php endwhile;
  endif; ?>
  <?php if (have_rows('programa_elas')) : while (have_rows('programa_elas')) : the_row(); ?>
      <section class="container-fluid elas px-0">
        <div class="row align-items-center mx-0">
          <div class="col-md-6 py-5 text-center">
            <img src="<?php the_sub_field('logo'); ?>" class="logo" alt="logo programa para elas" width="100%">
          </div>
          <div class="col-md-6 px-0">
            <?php if (have_rows('projetos')) : while (have_rows('projetos')) : the_row(); ?>
                <div class="projeto d-flex flex-wrap align-items-center p-md-5 p-3">
                  <div class="col-md-8 order-1 order-md-0">
                    <?php the_sub_field('texto'); ?>
                  </div>
                  <div class="col-md-4">
                    <img src="<?php the_sub_field('imagem'); ?>" class="mb-3 mb-md-0" alt="imagem projeto programa para elas" width="100%">
                  </div>
                </div>
            <?php endwhile;
            endif; ?>
          </div>
        </div>
      </section>
  <?php endwhile;
  endif; ?>
  <?php if (have_rows('projeto_bebe')) : while (have_rows('projeto_bebe')) : the_row(); ?>
      <section class="container-fluid bebe bg-cover" style="background-image: url('<?php the_sub_field('background'); ?>');">
        <div class="container">
          <div class="row align-items-center">
            <div class="offset-md-6 col-md-4">
              <img src="<?php the_sub_field('logo'); ?>" class="logo mb-5 mx-auto d-block" alt="Logo projeto bebê a bordo" width="100%">
              <?php the_sub_field('texto'); ?>
            </div>
          </div>
        </div>
      </section>
  <?php endwhile;
  endif; ?>
</main>

<?php get_footer(); ?>