<?php
add_action('wp_head', 'frontend_ajaxurl');
function frontend_ajaxurl()
{
?>
  <script type="text/javascript">
    var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
  </script>
  <?php
}

function custom_enqueue()
{
  wp_enqueue_script('scriptsjs', get_template_directory_uri() . '/assets/js/scripts.js', array(), '1.0.0', true);
}
add_action('wp_enqueue_scripts', 'custom_enqueue');

@ini_set('upload_max_size', '256M');
@ini_set('post_max_size', '256M');
@ini_set('max_execution_time', '300');

// Funções para Limpar o Header
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'wlwmanifest_link');
remove_action('wp_head', 'start_post_rel_link', 10, 0);
remove_action('wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);
remove_action('wp_head', 'feed_links_extra', 3);
remove_action('wp_head', 'wp_generator');
remove_action('wp_head', 'print_emoji_detection_script', 7);
remove_action('admin_print_scripts', 'print_emoji_detection_script');
remove_action('wp_print_styles', 'print_emoji_styles');
remove_action('admin_print_styles', 'print_emoji_styles');

// Habilitar Menus
add_theme_support('menus');

// Registrar Menu
function register_my_menus()
{
  register_nav_menus(
    array(
      'menu-principal' => __('Menu Principal')
    )
  );
}
add_action('init', 'register_my_menus');

function add_additional_class_on_li($classes, $item, $args)
{
  if (isset($args->add_li_class)) {
    $classes[] = $args->add_li_class;
  }
  return $classes;
}
add_filter('nav_menu_css_class', 'add_additional_class_on_li', 1, 3);


// Custom Images Sizes
function my_custom_sizes()
{
  add_image_size('large', 1400, 380, true);
  add_image_size('medium', 768, 380, true);
}
add_action('after_setup_theme', 'my_custom_sizes');


//Adiciona suporte a Post Thumbnails no Tema
add_theme_support('post-thumbnails');


function get_excerpt()
{
  $excerpt = get_the_content();
  $excerpt = preg_replace(" (\[.*?\])", '', $excerpt);
  $excerpt = strip_shortcodes($excerpt);
  $excerpt = strip_tags($excerpt);
  $excerpt = substr($excerpt, 0, 100);
  $excerpt = substr($excerpt, 0, strripos($excerpt, " "));
  $excerpt = trim(preg_replace('/\s+/', ' ', $excerpt));
  return $excerpt;
}

/**
 * Filter the except length to 20 words.
 *
 * @param int $length Excerpt length.
 * @return int (Maybe) modified excerpt length.
 */
function wpdocs_custom_excerpt_length($length)
{
  return 35;
}
add_filter('excerpt_length', 'wpdocs_custom_excerpt_length', 999);


// Requisição AJAX Materiais

add_action('wp_ajax_selectDistribuidoresEstado', 'buscarDistribuidoresEstado');
add_action('wp_ajax_nopriv_selectDistribuidoresEstado', 'buscarDistribuidoresEstado');

function buscarDistribuidoresEstado()
{

  global $post;

  $categoriaSelecionada = array();
  if (!empty($_GET['categorias'])) {
    $categoriaSelecionada[] = array(
      'taxonomy' => 'estados_distribuidores',
      'field' => 'name',
      'terms' => $_GET['categorias'],
    );
  }

  $argsPosts = array(
    'post_type' => 'distribuidores',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'orderby' => 'name',
    'order' => 'ASC',
  );

  if (!empty($categoriaSelecionada)) {
    $argsPosts['tax_query'] = $categoriaSelecionada;
  }

  //print_r ($argsPosts);

  $queryPosts = new WP_Query($argsPosts);
  queryPostsDistribuidores($queryPosts);
  exit;
}

function queryPostsDistribuidores($queryPosts)
{
  global $post;
  if ($queryPosts->have_posts()) {
    while ($queryPosts->have_posts()) {
      $queryPosts->the_post();
  ?>
      <div class="box col-12 px-0 cinza d-flex align-items-center flex-wrap">
        <div class="col-md-4">
          <p><strong><?php the_title(); ?></strong></p>
        </div>
        <div class="col-md-4">
          <p><?php the_field('endereco'); ?></p>
        </div>
        <div class="col-md-4 text-center">
          <p><?php the_field('telefone'); ?></p>
        </div>
      </div>
    <?php } ?>
  <?php
    wp_reset_postdata();
  } else {
  ?>
    <p class="text-center">Nenhum distribuidor encontrado!</p>
    <?php
  }
}

// Requisição AJAX Filtros Receitas

add_action('wp_ajax_selectLojista', 'buscarLojista');
add_action('wp_ajax_nopriv_selectLojista', 'buscarLojista');

function buscarLojista()
{

  global $post;

  $categoriaSelecionada = array();
  if (!empty($_GET['setorLojista'])) {
    $categoriaSelecionada[] = array(
      'taxonomy' => 'setores',
      'field' => 'name',
      'terms' => $_GET['setorLojista'],
    );
  }

  $argsPosts = array(
    'post_type' => 'lojistas',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'paged' => $_GET['pagina'],
    'orderby' => 'name',
    'order' => 'ASC',
  );

  if (!empty($categoriaSelecionada)) {
    $argsPosts['tax_query'] = $categoriaSelecionada;
  }

  if (!empty($_GET['textoBusca'])) {
    $argsPosts['meta_value'] = $_GET['textoBusca'];
    $argsPosts['meta_key'] = 'endereco';
    $argsPosts['meta_compare'] = 'LIKE';
  }



  //print_r ($argsPosts);

  $queryPosts = new WP_Query($argsPosts);
  queryPostsLojistas($queryPosts);
  exit;
}

function queryPostsLojistas($queryPosts)
{
  global $post;
  if ($queryPosts->have_posts()) {
    while ($queryPosts->have_posts()) {
      $queryPosts->the_post();
    ?>

      <div class="box col-12 px-0 cinza d-flex align-items-center flex-wrap">
        <div class="col-md-4">
          <p><strong><?php the_title(); ?></strong></p>
        </div>
        <div class="col-md-4">
          <p><?php the_field('endereco'); ?></p>
        </div>
        <div class="col-md-4 text-center">
          <p><?php the_field('telefone'); ?></p>
        </div>
      </div>
    <?php } ?>
  <?php
    wp_reset_postdata();
  } else {
  ?>
    <p class="text-center">Nenhum lojista encontrado.</p>
    <?php
  }
}


// Requisição AJAX Data

add_action('wp_ajax_selectDataEvento', 'buscarDataEvento');
add_action('wp_ajax_nopriv_selectDataEvento', 'buscarDataEvento');

function buscarDataEvento()
{

  global $post;

  $argsPosts = array(
    'post_type' => 'eventos',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'orderby' => 'name',
    'order' => 'ASC',
  );

  $intervalo = explode(' - ', $_GET['data']);

  if (!empty($_GET['data'])) {
    $argsPosts['meta_query'] = [
      [
        'key' => 'data_inicial',
        'value' => $intervalo[1],
        'compare' => '<=',
        'type' => 'DATE',
      ],
      [
        'key' => 'data_final',
        'value' => $intervalo[0],
        'compare' => '>=',
        'type' => 'DATE',
      ]

    ];
  }


  $queryPosts = new WP_Query($argsPosts);
  queryEventosData($queryPosts);

  // print_r($queryPosts->posts);
  // print_r($queryPosts->request);
  exit;
}
function queryEventosData($queryPosts)
{
  global $post;
  if ($queryPosts->have_posts()) {
    while ($queryPosts->have_posts()) {
      $queryPosts->the_post();
    ?>

      <div class="col-md-3 d-flex flex-column align-items-center">
        <img src="<?php the_post_thumbnail_url(); ?>" alt="">
        <p><strong><?php the_title(); ?></strong></p>
        <p><?php the_field('data_inicial'); ?> à <?php the_field('data_final'); ?></p>
        <p><?php the_field('horario'); ?></p>
        <p><?php the_field('local'); ?></p>
        <?php if (get_field('link_evento')) { ?>
          <a href="<?php the_field('link_evento'); ?>" target="_blank" class="cta">Acesse o site do evento</a>
        <?php } ?>
      </div>
    <?php } ?>
  <?php
    wp_reset_postdata();
  } else {
  ?>
    <p class="text-center">Nenhum evento encontrado.</p>
    <?php
  }
}

// Requisição AJAX Segmento

add_action('wp_ajax_selectSegmentoEvento', 'buscarSegmentoEvento');
add_action('wp_ajax_nopriv_selectSegmentoEvento', 'buscarSegmentoEvento');

function buscarSegmentoEvento()
{

  global $post;

  $categoriaSelecionada = array();
  if (!empty($_GET['segmento'])) {
    $categoriaSelecionada[] = array(
      'taxonomy' => 'segmentos',
      'field' => 'name',
      'terms' => $_GET['segmento'],
    );
  }

  $argsPosts = array(
    'post_type' => 'eventos',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'paged' => $_GET['pagina'],
    'orderby' => 'name',
    'order' => 'ASC',
  );

  if (!empty($categoriaSelecionada)) {
    $argsPosts['tax_query'] = $categoriaSelecionada;
  }


  $queryPosts = new WP_Query($argsPosts);
  queryEventosSegmento($queryPosts);

  // print_r($queryPosts->posts);
  // print_r($queryPosts->request);
  exit;
}
function queryEventosSegmento($queryPosts)
{
  global $post;
  if ($queryPosts->have_posts()) {
    while ($queryPosts->have_posts()) {
      $queryPosts->the_post();
    ?>

      <div class="col-md-3 d-flex flex-column align-items-center">
        <img src="<?php the_post_thumbnail_url(); ?>" alt="">
        <p><strong><?php the_title(); ?></strong></p>
        <p><?php the_field('data_inicial'); ?> à <?php the_field('data_final'); ?></p>
        <p><?php the_field('horario'); ?></p>
        <p><?php the_field('local'); ?></p>
        <?php if (get_field('link_evento')) { ?>
          <a href="<?php the_field('link_evento'); ?>" target="_blank" class="cta">Acesse o site do evento</a>
        <?php } ?>
      </div>
    <?php } ?>
  <?php
    wp_reset_postdata();
  } else {
  ?>
    <p class="text-center">Nenhum evento encontrado.</p>
<?php
  }
}
