<?php get_header(); ?>

<main id="blog">
  <section class="container-fluid secao-filtros py-3">
    <div class="row">
      <div class="filtros col-12 d-flex flex-wrap justify-content-md-between">
        <div class="left col-md-4 pl-md-0 d-flex align-items-center">
          <form action="" class="flex-wrap categorias d-none">
            <select id="categorias" name="categorias" data-name="categorias">
              <option value="">Categorias</option>
              <?php
              $estados = get_terms(array('taxonomy' => 'category'));
              foreach ($estados as $estado) : ?>
                <option value="<?= $estado->name ?>"><?= $estado->name ?></option>
              <?php endforeach;
              ?>
            </select>
          </form>
          <a href="<?= site_url(); ?>/materiais-ricos" class="link">Materiais Ricos</a>
        </div>
        <div class="right d-flex col-md-8 flex-wrap justify-content-md-end">
          <?php get_search_form(); ?>
          <a href="#newsletter" class="cta">Assine a nossa newsletter</a>
        </div>
      </div>
    </div>
  </section>
  <section class="secao-topo container-fluid">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-md-6 pl-md-0 text-center">
          <h2 class="titulo"><strong><?= single_cat_title(); ?></strong></h2>
          <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.
            Sem sagittis at eget curabitur faucibus ut.</p>
        </div>
      </div>
    </div>
  </section>
  <section class="secao-destaque container-fluid py-md-5 py-3">
    <!--GRID DESTAQUE-->
    <div class="container">
      <div class="row justify-content-center container-boxes" style="position: relative;">
        <div class="col-md-6 left">

          <?php
          $args = array('post_type' => 'post', 'post_status' => 'publish', 'numberposts' => '4', 'order' => 'DESC', 'orderby' => 'date');
          $recent_posts = wp_get_recent_posts($args);
          $postsnum = count($recent_posts);
          foreach ($recent_posts as $key => $recent) {
            $post_categories = get_the_category($recent['ID']);
            if (!empty($post_categories)) {
              $post_category = esc_html($post_categories[0]->name);
            } else {
              $post_category = "";
            }
            $post_thumbnail_id = intval(get_post_thumbnail_id($recent['ID']));
            $array_thumbnail = wp_get_attachment_image_src($post_thumbnail_id, 'thumbnail_size');
            if ($array_thumbnail == '') {
              $thumbn = get_stylesheet_directory_uri() . '/images/placeholder.png';
            } else {
              $thumbn = $array_thumbnail[0];
            }
            switch ($key) {
              case 0:
          ?>
                <a href="<?= get_permalink($recent["ID"]) ?>" class="block">
                  <img src="<?= $thumbn; ?>" alt="<?= $recent['post_title']; ?>" width="100%">
                  <div class="tags">
                    <span><?= $post_category ?></span>
                  </div>
                  <div class="texto">
                    <h2><?= $recent['post_title']; ?></h2>
                  </div>
                </a>
        </div>
      <?php
                break;
              case 1:
      ?>
        <div class="col-md-6 px-0 right d-flex flex-wrap">
          <h3 class="titulo col-12">Posts Populares</h3>
          <div class="col-12">
            <a href="<?= get_permalink($recent["ID"]) ?>" class="block">
              <div class="tags">
                <span><?= $post_category ?></span>
              </div>
              <div class="texto">
                <h2><?= $recent['post_title']; ?></h2>
              </div>
            </a>

          </div>
        <?php
                break;
              case 2:
        ?>
          <div class="col-12">
            <a href="<?= get_permalink($recent["ID"]) ?>" class="block">
              <div class="tags">
                <span><?= $post_category ?></span>
              </div>
              <div class="texto">
                <h2><?= $recent['post_title']; ?></h2>
              </div>
            </a>
          </div>
        <?php
                break;
              case 3:
        ?>
          <div class="col-12 mb-md-0">
            <a href="<?= get_permalink($recent["ID"]) ?>" class="block">
              <div class="tags">
                <span><?= $post_category ?></span>
              </div>
              <div class="texto">
                <h2><?= $recent['post_title']; ?></h2>
              </div>
            </a>
          </div>

    <?php
                break;
            }
          }
          wp_reset_query();
          wp_reset_postdata();
    ?>
        </div>
      </div>
    </div>
  </section>
  <section class="secao-secundaria container py-md-5 py-3 px-0">
    <div class="container">
      <div class="row">
        <div class="col-12 container-boxes d-flex flex-wrap">
          <!--QUERY POST ANTERIORES-->
          <?php
          $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
          $pp_page = $wp_query->query_vars['posts_per_page'];
          $offset = 5 + ($pp_page * ($paged - 1));
          $args = array(
            'post_type' => 'post',
            'post_status' => 'publish',
            'posts_per_page' => 12, // As per the post below you need to have a set number of posts.
            'paged' => $paged,
            'offset' => $offset,
            'orderby' => 'date',
            'order' => 'DESC',
            'ignore_sticky_posts' => true,
          );
          $wpb_all_query = new WP_Query($args); ?>
          <?php if ($wpb_all_query->have_posts()) {
            while ($wpb_all_query->have_posts()) {
              $wpb_all_query->the_post();
              $post_categories = get_the_category(get_the_ID());
              if (!empty($post_categories)) {
                $post_category = esc_html($post_categories[0]->name);
              } else {
                $post_category = "";
              }
              $post_thumbnail_id = intval(get_post_thumbnail_id($post->ID));
              $array_thumbnail = wp_get_attachment_image_src($post_thumbnail_id, 'thumbnail_size');
              if ($array_thumbnail == '') {
                $thumbn = get_stylesheet_directory_uri() . '/images/placeholder.png';
              } else {
                $thumbn = $array_thumbnail[0];
              }
          ?>
              <div class="col-md-4 my-3">
                <a href="<?= get_permalink($recent["ID"]) ?>" class="block">
                  <img src="<?= $thumbn; ?>" alt="<?= $recent['post_title']; ?>" width="100%">
                  <div class="tags">
                    <span><?= $post_category ?></span>
                  </div>
                  <div class="texto">
                    <h2><?= $recent['post_title']; ?></h2>
                  </div>
                </a>
              </div>
            <?php
            } ?>
            <!-- <div id="navegacao"> -->
            <!-- <?php next_posts_link('<span class="navegacao" style="float:right">Posts Mais Antigos</span>', $wpb_all_query->max_num_pages); ?> -->
            <!-- <?php previous_posts_link('<span class="navegacao" style="float:left">Posts Mais Recentes</span>'); ?> -->
            <!-- </div> -->
          <?php
            wp_reset_postdata();
          } else {
            echo '<p>Nenhum post antigo, veja nossos últimos conteúdos acima!</p>';
            echo '</div>';
          }
          ?>
        </div>
      </div>
      <div class="row mt-5 justify-content-center">
        <a href="<?= site_url(); ?>/todos-os-posts" class="cta">Ver todos os posts</a>
      </div>
    </div>
  </section>
  <section id="newsletter" class="secao-newsletter container-fluid py-md-5 py-3">
    <div class="container">
      <div class="row align-items-center justify-content-center">
        <div class="texto col-12 text-center">
          <h3>Assine nossa newsletter</h3>
          <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sem sagittis at eget curabitur faucibus ut.</p>
          <div class="formulario">
            <form action="https://webto.salesforce.com/servlet/servlet.WebToLead?encoding=UTF-8" method="POST">
              <input type=hidden name="oid" value="00D2E000001FV2g">
              <input type=hidden name="retURL" value="https://www.lojaclamper.com.br/">

              <div class="form-row">
                <div class="form-group col-md-4">
                  <label for="first_name">Primeiro Nome</label>
                  <input id="first_name" maxlength="40" name="first_name" size="20" type="text" class="form-control" required />
                </div>
                <div class="form-group col-md-4">
                  <label for="last_name">Sobrenome</label>
                  <input id="last_name" maxlength="80" name="last_name" size="20" type="text" class="form-control" required />
                </div>
                <div class="form-group col-md-4">
                  <label for="email">Email</label>
                  <input id="email" maxlength="80" name="email" size="20" type="text" class="form-control" required />
                </div>
              </div>
              <input id="00N2E00000JWzQC" name="00N2E00000JWzQC" type="checkbox" value="1" required />
              <label for="00N2E00000JWzQC">Aceite Termos e Políticas de Privacidade:</label>
              <input id="00N2E00000JWzQD" name="00N2E00000JWzQD" type="checkbox" value="1" required />
              <label for="00N2E00000JWzQD">Aceito Receber Emails da Clamper:</label>
              <input type="hidden" name="lead_source" id="lead_source" value="Website">
              <input type="submit" name="submit" class="cta">
            </form>
          </div>
        </div>
      </div>
    </div>
  </section>
</main>

<?php get_footer(); ?>