/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-12-12 20:38:38 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=41071 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2969 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=223 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpfm_backup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_name` text DEFAULT NULL,
  `backup_date` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2023-03-14 00:37:52", "2023-03-14 00:37:52", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://en.gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20241212_institutoalbertsabin", "972a5b9fc236f5d44421_20241212203827", "21", "2024-12-12 20:38:38", "asther", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-12-12 20:38:27\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:7:\"10.6.20\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:29:\"20241212_institutoalbertsabin\";s:4:\"Hash\";s:35:\"972a5b9fc236f5d44421_20241212203827\";s:8:\"NameHash\";s:65:\"20241212_institutoalbertsabin_972a5b9fc236f5d44421_20241212203827\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:75:\"20241212_institutoalbertsabin_972a5b9fc236f5d44421_20241212203827_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.4\";s:6:\"WPUser\";s:6:\"asther\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:77:\"20241212_institutoalbertsabin_972a5b9fc236f5d44421_20241212203827_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:34:\"/home/institutoalberts/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:807;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:5896;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-12-12 20:38:27\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:7:\"10.6.20\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:29:\"20241212_institutoalbertsabin\";s:4:\"Hash\";s:35:\"972a5b9fc236f5d44421_20241212203827\";s:8:\"NameHash\";s:65:\"20241212_institutoalbertsabin_972a5b9fc236f5d44421_20241212203827\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:83:\"20241212_institutoalbertsabin_972a5b9fc236f5d44421_20241212203827_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:48:\"/home/institutoalberts/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:78:\"20241212_institutoalbertsabin_972a5b9fc236f5d44421_20241212203827_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:145:\"/home/institutoalberts/public_html/wp-content/backups-dup-lite/tmp/20241212_institutoalbertsabin_972a5b9fc236f5d44421_20241212203827_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:43:\"/home/institutoalberts/public_html/wp-admin\";i:1;s:46:\"/home/institutoalberts/public_html/wp-includes\";i:2;s:55:\"/home/institutoalberts/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:34:\"/home/institutoalberts/public_html\";i:1;s:34:\"/home/institutoalberts/public_html\";i:2;s:45:\"/home/institutoalberts/public_html/wp-content\";i:3;s:53:\"/home/institutoalberts/public_html/wp-content/uploads\";i:4;s:53:\"/home/institutoalberts/public_html/wp-content/plugins\";i:5;s:56:\"/home/institutoalberts/public_html/wp-content/mu-plugins\";i:6;s:52:\"/home/institutoalberts/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:66:\"/home/institutoalberts/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://institutoalbertsabin.com.br", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://institutoalbertsabin.com.br", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Instituto Albert Sabin", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "lais@i2w.com.br", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "d/m/Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "H:i", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:95:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=7&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:9:{i:0;s:34:\"advanced-custom-fields-pro/acf.php\";i:1;s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";i:2;s:33:\"classic-editor/classic-editor.php\";i:3;s:25:\"cloudflare/cloudflare.php\";i:4;s:32:\"duplicate-page/duplicatepage.php\";i:5;s:25:\"duplicator/duplicator.php\";i:6;s:59:\"simple-cloudflare-turnstile/simple-cloudflare-turnstile.php\";i:7;s:33:\"wps-hide-login/wps-hide-login.php\";i:8;s:35:\"wps-limit-login/wps-limit-login.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:88:\"/home/institutoalberts/public_html/wp-content/themes/institutoalbertsabin/page-sobre.php\";i:2;s:83:\"/home/institutoalberts/public_html/wp-content/themes/institutoalbertsabin/style.css\";i:3;s:84:\"/home/institutoalberts/public_html/wp-content/themes/institutoalbertsabin/header.php\";i:4;s:88:\"/home/institutoalberts/public_html/wp-content/themes/institutoalbertsabin/front-page.php\";i:5;s:84:\"/home/institutoalberts/public_html/wp-content/themes/institutoalbertsabin/footer.php\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "institutoalbertsabin", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "institutoalbertsabin", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "58975", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "America/Sao_Paulo", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "7", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1749506137", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "53496", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"llar_admin\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("102", "user_count", "2", "no");
INSERT INTO `wp_options` VALUES("103", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("105", "cron", "a:11:{i:1734036246;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1734050273;a:3:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1734050274;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1734050503;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1734050865;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1734050866;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1734116835;a:1:{s:21:\"ai1wm_storage_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1734368400;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1734482273;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1734734690;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("106", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "nonce_key", "|_g.O+kEo&l|5_,j&OL[g^K;_zWzpbBEn}wV6I3RdL2v6,Mv};#&b<{$JQc4/V>k", "no");
INSERT INTO `wp_options` VALUES("116", "nonce_salt", ",mrUNmA4t#4rN]tU|8]<g]E{Xy/1az@r;L-k{kW5*g{HsrF(%}:r)XCg&H6Eq9e&", "no");
INSERT INTO `wp_options` VALUES("117", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("118", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("120", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("121", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("123", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("126", "theme_mods_twentytwentythree", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1678755324;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "no");
INSERT INTO `wp_options` VALUES("129", "https_detection_errors", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("136", "auth_key", "Rf_S%:d1!j:<ste,KWn`VK)#tHc0}/UyL#YU2-):F61h(SL}/[%:g!?vDQRbrI.o", "no");
INSERT INTO `wp_options` VALUES("137", "auth_salt", "cnbz!raYC6j4%DVxfaT8&z +Y]7`U:E1a`z/DlKny:v/?ESr]i[O.{v-Jq_G~Q6`", "no");
INSERT INTO `wp_options` VALUES("138", "logged_in_key", "}P~8{}kn/jFy2]DimI6guE`V0DtLP1-O=Qy[f0F)FNyAIea4>DCW)I(GLsf/3JVs", "no");
INSERT INTO `wp_options` VALUES("139", "logged_in_salt", "n@gxI<|R]bX&f.o6_s$S!1C71O|wA&_4L)5v9:x,^O4/2eAn$4(%h66~VJC>P~lQ", "no");
INSERT INTO `wp_options` VALUES("162", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("163", "WPLANG", "pt_BR", "yes");
INSERT INTO `wp_options` VALUES("164", "new_admin_email", "suporte@asther.com.br", "yes");
INSERT INTO `wp_options` VALUES("171", "recently_activated", "a:1:{s:63:\"limit-login-attempts-reloaded/limit-login-attempts-reloaded.php\";i:1734035371;}", "off");
INSERT INTO `wp_options` VALUES("178", "acf_version", "6.0.7", "yes");
INSERT INTO `wp_options` VALUES("179", "current_theme", "Instituto Albert Sabin", "yes");
INSERT INTO `wp_options` VALUES("180", "theme_mods_institutoalbertsabin", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:14:\"menu-principal\";i:3;}s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `wp_options` VALUES("181", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("224", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("411", "secure_auth_key", "irex.cdP5P&4LUux`:]=(][(d)+W8#ivxsSa!0w,|V@7DZs. _xM}Wi166=7m@?r", "no");
INSERT INTO `wp_options` VALUES("412", "secure_auth_salt", "VaYr?dTao=H-6P,Hp.#0R:Gb^pcQ&#|[Z]A|KZ$xA<capN_=`!y>G~V>b(+5T`F7", "no");
INSERT INTO `wp_options` VALUES("469", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:15:\"lais@i2w.com.br\";s:7:\"version\";s:5:\"6.7.1\";s:9:\"timestamp\";i:1732236275;}", "off");
INSERT INTO `wp_options` VALUES("819", "fm_key", "kTBlQ4qoFvwp0tXaxgP9Zye5J", "yes");
INSERT INTO `wp_options` VALUES("822", "filemanager_email_verified_1", "yes", "yes");
INSERT INTO `wp_options` VALUES("1314", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2183", "ai1wm_backups_path", "/home/institutoalberts/public_html/wp-content/ai1wm-backups", "yes");
INSERT INTO `wp_options` VALUES("2187", "swift_performance_plugin_organizer", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2188", "jetpack_active_modules", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2269", "ai1wm_secret_key", "BBibdbZvllIs", "yes");
INSERT INTO `wp_options` VALUES("2270", "ai1wm_backups_labels", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2271", "ai1wm_sites_links", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2272", "ai1wm_status", "a:3:{s:4:\"type\";s:4:\"done\";s:5:\"title\";s:35:\"Seu site foi importado com sucesso!\";s:7:\"message\";s:408:\"» <a class=\"ai1wm-no-underline\" href=\"https://institutoalbertsabin.com.br/wp-admin/options-permalink.php#submit\" target=\"_blank\">Salvar a estrutura dos links permanentes</a>. (abre uma nova janela)<br />» <a class=\"ai1wm-no-underline\" href=\"https://wordpress.org/support/view/plugin-reviews/all-in-one-wp-migration?rate=5#postform\" target=\"_blank\">Opcionalmente, avalie o plugin</a>. (abre uma nova janela)\";}", "yes");
INSERT INTO `wp_options` VALUES("2308", "_transient_health-check-site-status-result", "{\"good\":18,\"recommended\":4,\"critical\":1}", "yes");
INSERT INTO `wp_options` VALUES("2312", "ai1wm_updater", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2313", "_site_transient_ai1wm_last_check_for_updates", "1734008710", "off");
INSERT INTO `wp_options` VALUES("3086", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("7791", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("38065", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"98c6c54397c4a57be055741480ba55fe\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_options` VALUES("40754", "_site_transient_timeout_php_check_990bfacb848fa087bcfc06850f5e4447", "1734483767", "off");
INSERT INTO `wp_options` VALUES("40755", "_site_transient_php_check_990bfacb848fa087bcfc06850f5e4447", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("40757", "_transient_timeout_acf_plugin_updates", "1734051772", "off");
INSERT INTO `wp_options` VALUES("40758", "_transient_acf_plugin_updates", "a:5:{s:7:\"plugins\";a:1:{s:34:\"advanced-custom-fields-pro/acf.php\";a:11:{s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:6:\"plugin\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"new_version\";s:6:\"6.3.11\";s:3:\"url\";s:36:\"https://www.advancedcustomfields.com\";s:6:\"tested\";s:5:\"6.7.1\";s:7:\"package\";s:0:\"\";s:5:\"icons\";a:1:{s:7:\"default\";s:64:\"https://connect.advancedcustomfields.com/assets/icon-256x256.png\";}s:7:\"banners\";a:2:{s:3:\"low\";s:66:\"https://connect.advancedcustomfields.com/assets/banner-772x250.jpg\";s:4:\"high\";s:67:\"https://connect.advancedcustomfields.com/assets/banner-1544x500.jpg\";}s:8:\"requires\";s:3:\"6.0\";s:12:\"requires_php\";s:3:\"7.4\";s:12:\"release_date\";s:8:\"20241112\";}}s:9:\"no_update\";a:0:{}s:10:\"expiration\";i:172800;s:6:\"status\";i:1;s:7:\"checked\";a:1:{s:34:\"advanced-custom-fields-pro/acf.php\";s:5:\"6.0.7\";}}", "off");
INSERT INTO `wp_options` VALUES("40845", "_site_transient_timeout_browser_a69b52f9d7f760edf3fd052bcda2542f", "1734558938", "off");
INSERT INTO `wp_options` VALUES("40846", "_site_transient_browser_a69b52f9d7f760edf3fd052bcda2542f", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:5:\"133.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("40847", "can_compress_scripts", "1", "on");
INSERT INTO `wp_options` VALUES("40848", "_site_transient_timeout_community-events-cba969cb7cb4b90ba8757af551ae6c2b", "1733997340", "off");
INSERT INTO `wp_options` VALUES("40849", "_site_transient_community-events-cba969cb7cb4b90ba8757af551ae6c2b", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"189.101.10.0\";}s:6:\"events\";a:1:{i:0;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:39:\"State of the Word 2024 – Tokyo, Japan\";s:3:\"url\";s:106:\"https://wordpress.org/state-of-the-word/?utm_source=private&utm_medium=events_widget&utm_campaign=sotw2024\";s:6:\"meetup\";s:0:\"\";s:10:\"meetup_url\";s:0:\"\";s:4:\"date\";s:19:\"2024-12-16 18:00:00\";s:8:\"end_date\";s:19:\"2024-12-16 20:00:00\";s:20:\"start_unix_timestamp\";i:1734339600;s:18:\"end_unix_timestamp\";i:1734346800;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"JP\";s:8:\"latitude\";d:35.65283199999999652618498657830059528350830078125;s:9:\"longitude\";d:139.839478000000013935277820564806461334228515625;}}}}", "off");
INSERT INTO `wp_options` VALUES("40850", "_transient_timeout_feed_b85365aa61afaf3d4189819a6f57c4c4", "1733997341", "off");
INSERT INTO `wp_options` VALUES("40851", "_transient_feed_b85365aa61afaf3d4189819a6f57c4c4", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Blog – WordPress.org Brasil\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://br.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 21 Nov 2024 16:18:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"pt-BR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.8-alpha-59505\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Blog – WordPress.org Brasil\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://br.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:76:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"WordPress 6.7.1 – Atualização de manutenção\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://br.wordpress.org/2024/11/21/wordpress-6-7-1-atualizacao-de-manutencao/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://br.wordpress.org/2024/11/21/wordpress-6-7-1-atualizacao-de-manutencao/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 21 Nov 2024 16:18:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=3193\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:335:\"O WordPress 6.7.1 já está disponível! Esta versão menor apresenta 16 correções de erros em todo o núcleo e no editor de blocos. O WordPress 6.7.1 é uma versão rápida, com um foco estrito em erros introduzidos no WordPress 6.7. O próximo grande lançamento será a versão 6.8, prevista para abril de 2025. Se você [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8449:\"\n<p>O WordPress 6.7.1 já está disponível!</p>\n\n\n\n<p>Esta versão menor apresenta 16 correções de erros em todo o <a href=\"https://core.trac.wordpress.org/query?resolution=fixed&amp;milestone=6.7.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">núcleo</a> e no <a href=\"https://github.com/WordPress/wordpress-develop/pull/7851\">editor de blocos</a>.</p>\n\n\n\n<p>O WordPress 6.7.1 é uma versão rápida, com um foco estrito em erros introduzidos no WordPress 6.7. O próximo grande lançamento será a <a href=\"https://make.wordpress.org/core/6-8/\">versão 6.8</a>, <a href=\"https://make.wordpress.org/core/2024/11/19/proposal-major-releases-for-2025/\">prevista para abril de 2025</a>.</p>\n\n\n\n<p>Se você tiver sites que suportam atualizações automáticas em segundo plano, o processo de atualização será iniciado automaticamente.</p>\n\n\n\n<p>Você pode <a href=\"https://wordpress.org/wordpress-6.7.1.zip\">baixar o WordPress 6.7.1 do WordPress.org</a> ou visitar o seu Painel WordPress, clicar em &#8220;Atualizações&#8221; e, em seguida, clique em &#8220;Atualizar agora&#8221;.</p>\n\n\n\n<p>Para mais informações sobre esta versão, visite o <a href=\"https://wordpress.org/support/wordpress-version/version-6-7-1\">HelpHub</a>. Você pode encontrar um resumo das atualizações de manutenção nesta versão no anúncio do <a href=\"https://make.wordpress.org/core/?p=116365\">Release Candidate</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Agradecemos aos colaboradores do WordPress</h2>\n\n\n\n<p>Este lançamento foi liderado por <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> e <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a>.</p>\n\n\n\n<p>O WordPress 6.7.1 não teria sido possível sem a colaboração das pessoas a seguir. Suas contribuições para fornecer correções de manutenção em uma versão estável é uma prova do poder e capacidade da comunidade WordPress.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/abcsun/\">abcsun</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/ahsankhan316/\">Ahsan Khan</a>, <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/albigdd/\">Alexander Bigga</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a>, <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a>, <a href=\"https://profiles.wordpress.org/bluantinoo/\">bluantinoo</a>, <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a>, <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/charleslf/\">charleslf</a>, <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a>, <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>, <a href=\"https://profiles.wordpress.org/dhewercorus/\">dhewercorus</a>, <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a>, <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a>, <a href=\"https://profiles.wordpress.org/dooperweb/\">dooperweb</a>, <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/finntown/\">finntown</a>, <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a>, <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/glynnquelch/\">glynnquelch</a>, <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a>, <a href=\"https://profiles.wordpress.org/jagirbahesh/\">jagirbahesh</a>, <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a>, <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a>, <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a>, <a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/leecollings/\">Lee Collings</a>, <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a>, <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a>, <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a>, <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a>, <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a>, <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a>, <a href=\"https://profiles.wordpress.org/369work/\">miroku</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a>, <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a>, <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/ramonopoly/\">ramonopoly</a>, <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a>, <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a>, <a href=\"https://profiles.wordpress.org/room34/\">room34</a>, <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a>, <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a>, <a href=\"https://profiles.wordpress.org/sailpete/\">sailpete</a>, <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a>, <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sirlouen/\">SirLouen</a>, <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a>, <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/stimul/\">stimul</a>, <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a>, <a href=\"https://profiles.wordpress.org/tigriweb/\">TigriWeb</a>, <a href=\"https://profiles.wordpress.org/timwhitlock/\">Tim W</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a>, <a href=\"https://profiles.wordpress.org/twvania/\">Vania</a>, <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a>, <a href=\"https://profiles.wordpress.org/yowangdu/\">YoWangdu</a>, <a href=\"https://profiles.wordpress.org/zargarov/\">Zargarov</a> e <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Como contribuir</h2>\n\n\n\n<p>Para se envolver no desenvolvimento do núcleo do WordPress, dirija-se ao Trac, <a href=\"https://core.trac.wordpress.org/report/6\">escolha um ticket</a> e participe da conversa nos canais <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> de <a href=\"https://wordpress.slack.com/archives/C07BTF54N68\"></a><a href=\"https://wordpress.slack.com/archives/C080HLPP2Q6\">#6-8-release-leads</a>. Precisa de ajuda? Confira o <a href=\"https://make.wordpress.org/core/handbook/\">manual do colaborador do núcleo</a>.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Agradecemos a <em><a href=\"https://profiles.wordpress.org/marybaum/\">@marybaum</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell/\">@aaroncampbell</a>, <a href=\"https://profiles.wordpress.org/jeffpaul/\">@jeffpaul</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">@audrasjb</a>, <a href=\"https://profiles.wordpress.org/cbravobernal/\">@cbravobernal</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">@ankit-k-gupta</a></em></em> <em>pela revisão.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://br.wordpress.org/2024/11/21/wordpress-6-7-1-atualizacao-de-manutencao/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3193\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"WordPress 6.7 “Rollins”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://br.wordpress.org/2024/11/12/wordpress-6-7-rollins/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Nov 2024 22:21:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=3156\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:130:\"O WordPress 6.7 estreia o moderno tema Twenty Twenty-Five, o controle a tipografia do site, o novo recurso Zoom Out, e muito mais!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:70399:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://br.wordpress.org/files/2024/11/Release-Edition-Featured-Image-1.png\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"535\" src=\"https://br.wordpress.org/files/2024/11/Release-Edition-Featured-Image-1-1024x535.png\" alt=\"\" class=\"wp-image-3158\" srcset=\"https://br.wordpress.org/files/2024/11/Release-Edition-Featured-Image-1-1024x535.png 1024w, https://br.wordpress.org/files/2024/11/Release-Edition-Featured-Image-1-300x157.png 300w, https://br.wordpress.org/files/2024/11/Release-Edition-Featured-Image-1-768x401.png 768w, https://br.wordpress.org/files/2024/11/Release-Edition-Featured-Image-1-1536x802.png 1536w, https://br.wordpress.org/files/2024/11/Release-Edition-Featured-Image-1-2048x1070.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Cada lançamento do WordPress celebra um artista que deixou uma marca indelével no mundo da música. O WordPress 6.7, codinome “Rollins”, presta homenagem ao lendário saxofonista de jazz Sonny Rollins. Conhecido como um dos maiores improvisadores e pioneiros do jazz, Rollins influenciou gerações de músicos com seu brilho técnico, espírito inovador e abordagem destemida à expressão musical.</p>\n\n\n\n<p>O trabalho de Sonny Rollins é caracterizado por sua energia e profundidade emocional incomparáveis. Suas composições, como “St. Thomas”, “Oleo” e “Airegin”, são padrões de jazz atemporais, celebrados por sua complexidade rítmica e inventividade melódica. O estilo ousado e exploratório de Rollins ressoa com o próprio compromisso do WordPress de capacitar os criadores a ultrapassar fronteiras e explorar novas possibilidades na expressão digital.</p>\n\n\n\n<p>Abrace o espírito de inovação e espontaneidade que define o som do Rollins enquanto mergulha nos novos recursos e aprimoramentos do WordPress 6.7.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Saudações ao WordPress 6.7!</h2>\n\n\n\n<p>O WordPress 6.7 estreia o moderno tema Twenty Twenty-Five, oferecendo a máxima flexibilidade de design para qualquer blog em qualquer escala. Controle a tipografia do seu site como nunca antes com novos recursos de gerenciamento de fontes. O novo recurso Zoom Out permite projetar seu site com uma visão macro, afastando-se dos detalhes para dar vida à imagem geral.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpress.org/wordpress-6.7.zip\">Baixar o WordPress 6.7 &#8220;Rollins&#8221;</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Conheça o Twenty Twenty-Five</h2>\n\n\n\n<h4 class=\"wp-block-heading\">Possibilidade sem complexidade</h4>\n\n\n\n<p>O Twenty Twenty-Five oferece um tema flexível e focado em design que permite criar locais deslumbrantes com facilidade. Adapte sua estética com uma variedade de opções de estilo, padrões de blocos e paletas de cores. Em resumo, este é um tema que pode realmente crescer com você.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" width=\"900\" height=\"900\" src=\"https://br.wordpress.org/files/2024/11/feature-tt5-2.png\" alt=\"\" class=\"wp-image-3171\" srcset=\"https://br.wordpress.org/files/2024/11/feature-tt5-2.png 900w, https://br.wordpress.org/files/2024/11/feature-tt5-2-300x300.png 300w, https://br.wordpress.org/files/2024/11/feature-tt5-2-150x150.png 150w, https://br.wordpress.org/files/2024/11/feature-tt5-2-768x768.png 768w\" sizes=\"(max-width: 900px) 100vw, 900px\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Obtenha uma visão geral com Zoom Out</h3>\n\n\n\n<h4 class=\"wp-block-heading\">Explore seu conteúdo de uma nova perspectiva</h4>\n\n\n\n<p>Edite e organize seções inteiras do seu conteúdo como nunca antes. Uma visão mais ampla do seu site permite que você adicione, edite, embaralhamento ou remova padrões ao seu gosto. Abrace o seu arquiteto interior.</p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" width=\"900\" height=\"900\" src=\"https://br.wordpress.org/files/2024/11/feature-zoom-2.png\" alt=\"\" class=\"wp-image-3172\" srcset=\"https://br.wordpress.org/files/2024/11/feature-zoom-2.png 900w, https://br.wordpress.org/files/2024/11/feature-zoom-2-300x300.png 300w, https://br.wordpress.org/files/2024/11/feature-zoom-2-150x150.png 150w, https://br.wordpress.org/files/2024/11/feature-zoom-2-768x768.png 768w\" sizes=\"(max-width: 900px) 100vw, 900px\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Conecte blocos e campos personalizados sem códigos</h3>\n\n\n\n<h4 class=\"wp-block-heading\">Uma maneira simplificada de criar conteúdo dinâmico</h4>\n\n\n\n<p>Esse recurso introduz uma nova interface de usuário para conectar blocos a campos personalizados, colocando o controle de conteúdo dinâmico diretamente no editor. Vincule blocos com campos em apenas alguns cliques, aumentando a flexibilidade e a eficiência ao construir. Seus clientes vão amar, como se eles ainda não o fizessem.</p>\n\n\n\n<figure class=\"wp-block-image\"><img loading=\"lazy\" decoding=\"async\" width=\"900\" height=\"900\" src=\"https://br.wordpress.org/files/2024/11/feature-block-bindings-2.png\" alt=\"\" class=\"wp-image-3170\" srcset=\"https://br.wordpress.org/files/2024/11/feature-block-bindings-2.png 900w, https://br.wordpress.org/files/2024/11/feature-block-bindings-2-300x300.png 300w, https://br.wordpress.org/files/2024/11/feature-block-bindings-2-150x150.png 150w, https://br.wordpress.org/files/2024/11/feature-block-bindings-2-768x768.png 768w\" sizes=\"auto, (max-width: 900px) 100vw, 900px\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Abrace sua fonte interna</h3>\n\n\n\n<h4 class=\"wp-block-heading\">Seção de novo estilo, novas possibilidades</h4>\n\n\n\n<p>Crie, edite, remova e aplique predefinições de tamanho de fonte com a próxima adição a interface de estilos, substituindo o tema padrão ou criando seu próprio tamanho de fonte personalizado, completo, e com tipografia fluida para dimensionamento de fonte responsiva. Entre nos detalhes!</p>\n\n\n\n<figure class=\"wp-block-image\"><img loading=\"lazy\" decoding=\"async\" width=\"900\" height=\"900\" src=\"https://br.wordpress.org/files/2024/11/feature-font-presets-2.png\" alt=\"\" class=\"wp-image-3169\" srcset=\"https://br.wordpress.org/files/2024/11/feature-font-presets-2.png 900w, https://br.wordpress.org/files/2024/11/feature-font-presets-2-300x300.png 300w, https://br.wordpress.org/files/2024/11/feature-font-presets-2-150x150.png 150w, https://br.wordpress.org/files/2024/11/feature-font-presets-2-768x768.png 768w\" sizes=\"auto, (max-width: 900px) 100vw, 900px\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Desempenho</h3>\n\n\n\n<p>O WordPress 6.7 oferece atualizações importantes de desempenho, incluindo carregamento de padrões mais rápido, visualizações otimizadas no componente de visualizações de dados, suporte aprimorado ao PHP 8+, remoção de código obsoleto, tamanhos automáticos para imagens carregadas com carregamento tardio e processamento de tags mais eficiente na API de HTML.</p>\n\n\n\n<h3 class=\"wp-block-heading\">A acessibilidade</h3>\n\n\n\n<p>Mais de 65 correções de acessibilidade e aprimoramentos se concentram em aspectos fundamentais da experiência do WordPress, desde a melhoria dos componentes da interface do usuário e a navegação do teclado no editor, até um cabeçalho acessível nas telas de login do WordPress e rotulagem mais clara por toda parte.</p>\n\n\n\n<h3 class=\"wp-block-heading\">E muito mais</h3>\n\n\n\n<p>Para uma visão geral e abrangente de todos os novos recursos e aprimoramentos do WordPress 6.7, visite o site da mostra de recursos.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpress.org/download/releases/6-7/\">Veja o que há de novo</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Saiba mais sobre o WordPress 6.7</h2>\n\n\n\n<p>O <a href=\"https://learn.wordpress.org/\">Learn WordPress</a> é um recurso gratuito para usuários novos e experientes do WordPress. O Learn é abastecido com vídeos de instruções sobre o uso de vários recursos no WordPress, <a href=\"https://learn.wordpress.org/social-learning/\">workshops interativos</a> para explorar tópicos em profundidade e planos de aula para mergulhar profundamente em áreas específicas do WordPress.</p>\n\n\n\n<p>Leia as <a href=\"https://wordpress.org/documentation/wordpress-version/version-6.7\">notas de lançamento do WordPress 6.7</a> para obter informações sobre instalação, aprimoramentos, problemas corrigidos, colaboradores de lançamento, recursos de aprendizado e a lista de alterações de arquivos.</p>\n\n\n\n<p>Explore o <a href=\"https://make.wordpress.org/core/wordpress-6-7-field-guide/\">guia de campo do WordPress 6.7</a> e saiba mais sobre as mudanças nesta versão, com notas detalhadas do desenvolvedor para ajudá-lo a construir com o WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">O esquadrão da versão 6.7</h2>\n\n\n\n<p>Cada lançamento vem para você de uma equipe dedicada de colaboradores entusiasmados que ajudam a manter as coisas no caminho certo e se movendo suavemente. A equipe que liderou o WordPress 6.7 é um grupo multifuncional de colaboradores que estão sempre prontos para defender ideias, remover bloqueadores e resolver problemas.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Líder de Lançamento: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordenador da versão: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a></li>\n\n\n\n<li>Principais líderes de tecnologia: <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a></li>\n\n\n\n<li>Líderes técnicos do editor: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>, <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>, <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a></li>\n\n\n\n<li>Principais líderes de triagem: <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a>, <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a></li>\n\n\n\n<li>Líderes de triagem do editor: <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>, <a href=\"https://wordpress.org/support/users/colorful-tones/\">Damon Cook</a></li>\n\n\n\n<li>Líderes documentação: <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kogy</a>, <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a></li>\n\n\n\n<li>Líderes de teste: <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K. Gupta (Gupta)</a></li>\n\n\n\n<li>Líder de design: <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a></li>\n\n\n\n<li>Líder de desempenho: <a href=\"https://profiles.wordpress.org/adamsilverstein/\"></a><a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Líder de design do tema padrão: <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li>\n\n\n\n<li>Líderes de desenvolvimento do tema padrão: <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Agradecimento aos colaboradores</h2>\n\n\n\n<p>A missão do WordPress é <a href=\"https://wordpress.org/about/\">democratizar a publicação</a> e incorporar as <a href=\"https://opensource.org/osd-annotated\">liberdades que vêm com código aberto</a>. Uma comunidade global e diversificada de pessoas que colaboram para fortalecer o software suporta esse esforço.</p>\n\n\n\n<p>O WordPress 6.7 reflete os esforços incansáveis e a paixão de mais de 780 colaboradores em países de todo o mundo. Este lançamento também recebeu mais de 230 colaboradores pela primeira vez!</p>\n\n\n\n<p>Suas colaborações entregaram mais de 340 aprimoramentos e correções, garantindo uma versão estável para todos. Uma prova do poder e da capacidade da comunidade de código aberto do WordPress.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/75thtrombone/\">75thtrombone</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/aware/\">Aaron Ware</a> · <a href=\"https://profiles.wordpress.org/aatanasov/\">aatanasov</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/ababir/\">Abir</a> · <a href=\"https://profiles.wordpress.org/acafourek/\">acafourek</a> · <a href=\"https://profiles.wordpress.org/adamkheckler/\">Adam Heckler</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adamwood/\">Adam Wood</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/adrian2k7/\">Adrian</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/ah72king/\">ah72king</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akashdhawade/\">Akash Dhawade</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/alaminfirdows/\">Al-Amin Firdows</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/alessandrotesoro/\">Alessandro Tesoro</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alex27/\">alex27</a> · <a href=\"https://profiles.wordpress.org/digitalex11/\">Alexander Frank</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/harlet7/\">Alexandru Horeanu</a> · <a href=\"https://profiles.wordpress.org/alexcu21/\">alexcu21</a> · <a href=\"https://profiles.wordpress.org/ali7ali/\">Ali Ali</a> · <a href=\"https://profiles.wordpress.org/aliaghdam/\">aliaghdam</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/alvitazwar052/\">Alvi Tazwar</a> · <a href=\"https://profiles.wordpress.org/amincharoliya/\">Amin Charoliya</a> · <a href=\"https://profiles.wordpress.org/amirthepiper/\">Amir Abbas</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/amjadr360/\">Amjad Ali</a> · <a href=\"https://profiles.wordpress.org/anthakkar08/\">Anand Thakkar</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andreiglingeanu/\">andreiglingeanu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey “Rarst” Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/la-geek/\">Angelika Reisiger</a> · <a href=\"https://profiles.wordpress.org/aniketpatel/\">Aniket Patel</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankit k gupta/\">Ankit K. Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/the-ank/\">Ankur Vishwakarma</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antoniosejas/\">Antonio Sejas</a> · <a href=\"https://profiles.wordpress.org/apmeyer/\">apmeyer</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/perezcarreno/\">Armando J. Perez Carreno</a> · <a href=\"https://profiles.wordpress.org/armandsdz/\">Armands</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/ambrosiawt/\">Art Smith</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/arypneta/\">arypneta</a> · <a href=\"https://profiles.wordpress.org/asafm7/\">asafm7</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/nmutua/\">Autumn</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/bjerke-johannessen/\">Bård Bjerke Johannessen</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barryceelen/\">Barry Ceelen</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/neoxx/\">Bernhard Riedl</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berubenic/\">berubenic</a> · <a href=\"https://profiles.wordpress.org/bhaveshdesai13/\">Bhavesh</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">bijit027</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/blindmikey/\">blindmikey</a> · <a href=\"https://profiles.wordpress.org/bobbyleenoblestudios/\">bobbyleenoblestudios</a> · <a href=\"https://profiles.wordpress.org/bogdannikolic/\">Bogdan Nikolic</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bradley2083/\">brad hogan</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/brentjettgmailcom/\">Brent Jett</a> · <a href=\"https://profiles.wordpress.org/brettshumaker/\">Brett Shumaker</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/bgosnell/\">Brian Gosnell</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/bridgetwes/\">bridgetwes</a> · <a href=\"https://profiles.wordpress.org/brobken/\">brobken</a> · <a href=\"https://profiles.wordpress.org/freibergergarcia/\">Bruno Freiberger Garcia</a> · <a href=\"https://profiles.wordpress.org/cambabutonono/\">Cambabutonono</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/carstenbach/\">Carsten Bach</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/mchirag2002/\">Chirag Mathur</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/eclare/\">Chris Trynkiewicz (Sukces Strony)</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/cfinke/\">Christopher Finke</a> · <a href=\"https://profiles.wordpress.org/ckanitz/\">Christopher Kanitz</a> · <a href=\"https://profiles.wordpress.org/nyiriland/\">Christy Nyiri</a> · <a href=\"https://profiles.wordpress.org/butterflymedia/\">Ciprian</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/craynor/\">craynor</a> · <a href=\"https://profiles.wordpress.org/creativethemeshq/\">creativethemeshq</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/da5f656f/\">da5f656f</a> · <a href=\"https://profiles.wordpress.org/xendo/\">Dademaru</a> · <a href=\"https://profiles.wordpress.org/daleharrison/\">daleharrison</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/colorful tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/itsdanny/\">Danny</a> · <a href=\"https://profiles.wordpress.org/dannyreaktiv/\">dannyreaktiv</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/d-signed/\">Dareth NHANG</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/daveagp/\">daveagp</a> · <a href=\"https://profiles.wordpress.org/fac3less/\">David</a> · <a href=\"https://profiles.wordpress.org/dballari/\">David Ballarin Prunera</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/davidhbrown/\">David Brown</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/davidgodleman10up/\">David Godleman</a> · <a href=\"https://profiles.wordpress.org/dhenriet/\">David Henriet</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/ddewan/\">ddewan</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/deepakvijayan/\">Deepak Vijayan</a> · <a href=\"https://profiles.wordpress.org/dekadinious/\">Dekadinious</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dsmart/\">Derek Smart</a> · <a href=\"https://profiles.wordpress.org/deryck/\">Deryck</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/devspace/\">devspace</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divibanks/\">Divi Banks</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/djennez/\">djennez</a> · <a href=\"https://profiles.wordpress.org/cyberorca/\">Doni Kuntoro</a> · <a href=\"https://profiles.wordpress.org/dorzki/\">Dor Zuberi</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/drzraf/\">drzraf</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/eballeste/\">eballeste</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/beckej/\">Ed Beck</a> · <a href=\"https://profiles.wordpress.org/ejnwebmaster/\">ejnwebmaster</a> · <a href=\"https://profiles.wordpress.org/elfu98/\">elfu98</a> · <a href=\"https://profiles.wordpress.org/eliorivero/\">Elio Rivero</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/erichmond/\">Elliott Richmond</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanue ATSÉ</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/emmanuel78/\">emmanuel78</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique Sánchez</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/erikiva/\">erikiva</a> · <a href=\"https://profiles.wordpress.org/erikyo/\">erikyo</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/fahimmurshed/\">FahimMurshed</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/iamfarhan09/\">Farhan Ahmed</a> · <a href=\"https://profiles.wordpress.org/fayyazfayzi/\">Fayyaz</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/fjorgemota/\">Fernando Jorge Mota (a11n)</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/fullworks/\">fullworks</a> · <a href=\"https://profiles.wordpress.org/gwallace87/\">Gale Wallace</a> · <a href=\"https://profiles.wordpress.org/gansbrest/\">gansbrest</a> · <a href=\"https://profiles.wordpress.org/garethelwell/\">Gareth Elwell</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gauravtiwari/\">Gaurav Tiwari</a> · <a href=\"https://profiles.wordpress.org/gauravsingh7/\">gauravsingh7</a> · <a href=\"https://profiles.wordpress.org/georgwordpress/\">Georg</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/germanfrelo/\">Germán Freixinós</a> · <a href=\"https://profiles.wordpress.org/gmariani405/\">gmariani405</a> · <a href=\"https://profiles.wordpress.org/graemef/\">GraemeF</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/greentreefrog/\">greentreefrog</a> · <a href=\"https://profiles.wordpress.org/greenworld/\">GreenWorld</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gyurmey/\">Gyurmey</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/halilesen/\">Halil ESEN</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardipparmar/\">Hardip Parmar</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/plaidharper/\">Harper Holsinger</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harshvaishnav/\">harshvaishnav</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hectorjarquin/\">hectorjarquin</a> · <a href=\"https://profiles.wordpress.org/hedgefield/\">hedgefield</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hirschferkel/\">hirschferkel</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/htmgarcia/\">htmgarcia</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/kardi420/\">Ibrahim</a> · <a href=\"https://profiles.wordpress.org/ibrahimriaz/\">Ibrahim Riaz</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itapress/\">itapress</a> · <a href=\"https://profiles.wordpress.org/ivanottinger/\">Ivan Ottinger</a> · <a href=\"https://profiles.wordpress.org/jpstevens/\">Jack Stevens</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/smithjw1/\">Jacob Smith</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">jagirbahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/jtgreyd/\">Jakob Trost</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jamesosborne/\">James Osborne</a> · <a href=\"https://profiles.wordpress.org/jamesros161/\">James Rosado</a> · <a href=\"https://profiles.wordpress.org/jwgoedert/\">James Wesley Goedert</a> · <a href=\"https://profiles.wordpress.org/janpfeil/\">Jan Pfeil</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/ipajen/\">Jarko Piironen</a> · <a href=\"https://profiles.wordpress.org/jasonbahl/\">Jason Bahl</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javad2000/\">javad2000</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/jawadwp/\">Jawad Malik</a> · <a href=\"https://profiles.wordpress.org/topdownjimmy/\">Jay</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/drjosh07/\">jbrya029</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">JD Ahir</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jenilk/\">Jenil Kanani</a> · <a href=\"https://profiles.wordpress.org/jennifarhat/\">Jennifer Farhat</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">Jerry Jones</a> · <a href=\"https://profiles.wordpress.org/skobe/\">Jesko Bendmann</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jetaldobariya1/\">jetaldobariya1</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jimmyh61/\">jimmyh61</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnillo/\">John Espiritu</a> · <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/lwangaman/\">JohnRDOrazio</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/elbsegler/\">Jonas</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnywatersbb/\">Jonny Waters</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josklever/\">Jos Klever</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/jossnaz/\">Jossnaz</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/julianoe/\">julianoe</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/junedsabaliya/\">Juned Sabaliya</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kaavyaiyer/\">Kaavya Iyer (woo-hc)</a> · <a href=\"https://profiles.wordpress.org/arkenon/\">Kadim Gültekin</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kamran8176/\">Kamran Hussen</a> · <a href=\"https://profiles.wordpress.org/karan4word/\">Karan Gupta</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/kartikmehta/\">Kartik Mehta</a> · <a href=\"https://profiles.wordpress.org/kartik-suthar/\">Kartik Suthar</a> · <a href=\"https://profiles.wordpress.org/kbrownkd/\">kbrownkd (a11n)</a> · <a href=\"https://profiles.wordpress.org/keffr3n/\">Keffr3n</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/kellenmace/\">Kellen Mace</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/kevinb/\">Kevin Behrens</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kevinswalsh/\">kevinswalsh</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kisquian/\">kisquian</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kowsar89/\">Kowsar Hossain</a> · <a href=\"https://profiles.wordpress.org/kracked888/\">kracked888</a> · <a href=\"https://profiles.wordpress.org/krishneup/\">Krishna Neupane</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kmadhak/\">Kunal Madhak</a> · <a href=\"https://profiles.wordpress.org/gohelkunjan/\">Kunjan Gohel</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/mlaetitia/\">Lae</a> · <a href=\"https://profiles.wordpress.org/notlaura/\">Lara Schenck</a> · <a href=\"https://profiles.wordpress.org/lastsplash/\">lastsplash (a11n)</a> · <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/oncecoupled/\">Lauren</a> · <a href=\"https://profiles.wordpress.org/laranz/\">Lawrence Joe</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/lifelightweb/\">lifelightweb</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/linsoftware/\">Linnea Huxford</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/crixu/\">Lucas</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukasbesch/\">lukasbesch</a> · <a href=\"https://profiles.wordpress.org/lukecarbis/\">Luke Carbis</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/nadimcse/\">Mahmudul Haque Nadim</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/manbo/\">manbo</a> · <a href=\"https://profiles.wordpress.org/maneshtimilsina/\">Manesh Timilsina</a> · <a href=\"https://profiles.wordpress.org/targz-1/\">Manuel Schmalstieg</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani (a11n)</a> · <a href=\"https://profiles.wordpress.org/marianguas/\">María Anguas</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a> · <a href=\"https://profiles.wordpress.org/mardroid/\">Marcel Tannich</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/iworks/\">Marcin Pietrzak</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/pereirinha/\">Marco Pereirinha</a> · <a href=\"https://profiles.wordpress.org/marcwieland95/\">marcwieland95</a> · <a href=\"https://profiles.wordpress.org/igreenie/\">Marek Železný</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/marius84/\">mariushosting</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markparnell/\">Mark Parnell</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">marybaum</a> · <a href=\"https://profiles.wordpress.org/mat_/\">mat_</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattormeeple/\">Matt Sherman</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/lonelyvegan/\">Matthew Riley MacPherson</a> · <a href=\"https://profiles.wordpress.org/kittmedia/\">Matthias Kittsteiner</a> · <a href=\"https://profiles.wordpress.org/mattraines/\">mattraines</a> · <a href=\"https://profiles.wordpress.org/maurodf/\">maurodf</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/mcrisp1972/\">mcrisp1972</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/istiaqhossain/\">Md. Istiaq Hossain</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/iammehedi1/\">Mehedi Hassan</a> · <a href=\"https://profiles.wordpress.org/mehulkaklotar/\">Mehul Kaklotar</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/meteorlxy/\">meteorlxy</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/tw2113/\">Michael Beckwith</a> · <a href=\"https://profiles.wordpress.org/michaelbourne/\">Michael Bourne</a> · <a href=\"https://profiles.wordpress.org/hrkhal/\">Michael James Ilett</a> · <a href=\"https://profiles.wordpress.org/michaelpick/\">michaelpick</a> · <a href=\"https://profiles.wordpress.org/michaelwp85/\">michaelwp85</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/mielbu/\">Michelle Bulloch</a> · <a href=\"https://profiles.wordpress.org/miguelaxcar/\">Miguel Axcar</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/migueluy/\">Miguel Lezama</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikeb8s/\">mikeb8s</a> · <a href=\"https://profiles.wordpress.org/mikeybinns/\">Mikey Binns</a> · <a href=\"https://profiles.wordpress.org/milamj/\">milamj</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mklusak/\">mklusak</a> · <a href=\"https://profiles.wordpress.org/mleathem/\">mleathem</a> · <a href=\"https://profiles.wordpress.org/mlf20/\">mlf20</a> · <a href=\"https://profiles.wordpress.org/mobarak/\">Mobarak Ali</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/morganestes/\">Morgan Estes</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mossy2100/\">mossy2100</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir a11n</a> · <a href=\"https://profiles.wordpress.org/naeemhaque/\">Naeem Haque</a> · <a href=\"https://profiles.wordpress.org/nagpai/\">Nagesh Pai</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">Nate Finch</a> · <a href=\"https://profiles.wordpress.org/nateinaction/\">Nate Gay</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/nebojsajurcic/\">Nebojša Jurčić</a> · <a href=\"https://profiles.wordpress.org/nek285/\">nek285</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">neo2k23</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a> · <a href=\"https://profiles.wordpress.org/nickbohle/\">Nick Bohle</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nick_thegeek/\">Nick the Geek</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nurielmeni/\">nurielmeni</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/olivierlafleur/\">Olivier Lafleur</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/oscarhugopaz/\">Oscar Hugo Paz</a> · <a href=\"https://profiles.wordpress.org/prestonwordsworth/\">p15h</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/otakupahp/\">Pablo Hernández</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pamprn/\">Pamela Ribeiro</a> · <a href=\"https://profiles.wordpress.org/pander/\">pander</a> · <a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/obrienlabs/\">Pat O’Brien</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulschreiber/\">Paul Schreiber</a> · <a href=\"https://profiles.wordpress.org/paulwilde/\">Paul Wilde</a> · <a href=\"https://profiles.wordpress.org/paulcline/\">paulcline</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/pcarvalho/\">pcarvalho</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/perryrylance/\">perryrylance</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/pevogam/\">pevogam</a> · <a href=\"https://profiles.wordpress.org/mr2p/\">Phi Phan</a> · <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pgeorgiev/\">Plamen Georgiev</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/porg/\">porg</a> · <a href=\"https://profiles.wordpress.org/ppolo99/\">ppolo99</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pranitdugad/\">Pranit Dugad</a> · <a href=\"https://profiles.wordpress.org/pratikkry/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prettyboymp/\">prettyboymp</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/pwtyler/\">pwtyler</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/spanglishwebs/\">Rachel Winspear</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rafaelgalani/\">Rafael Gallani</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/rahmatgumilar/\">Rahmat Gumilar</a> · <a href=\"https://profiles.wordpress.org/rahulharpal/\">rahulharpal</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/shashwatahalder01/\">rajkumar shashwata halder</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramon-fincken/\">ramon fincken</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ramswarup/\">Ramswarup Rathod</a> · <a href=\"https://profiles.wordpress.org/xyulex/\">Raul Martinez</a> · <a href=\"https://profiles.wordpress.org/rcneil/\">rcneil</a> · <a href=\"https://profiles.wordpress.org/realthemes/\">realthemes</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/reputeinfosystems/\">reputeinfosystems</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rhellewellgmailcom/\">Rick Hellewell</a> · <a href=\"https://profiles.wordpress.org/riddhipatel/\">Riddhi Patel</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rithik56/\">rithik56</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/robert-biswas/\">Robert Biswas</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/rocketworks/\">rocket.works – Dominik Friedrich</a> · <a href=\"https://profiles.wordpress.org/rodelgc/\">Rodel Calasagsag a11n</a> · <a href=\"https://profiles.wordpress.org/rghedin/\">Rodrigo</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Wolný</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roygbyte/\">roygbyte</a> · <a href=\"https://profiles.wordpress.org/royho/\">royho</a> · <a href=\"https://profiles.wordpress.org/rpf5573/\">rpf5573</a> · <a href=\"https://profiles.wordpress.org/rslee/\">rslee</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rayhatron/\">Rufaro Madamombe</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rleeson/\">Ryan Leeson</a> · <a href=\"https://profiles.wordpress.org/ryancurban/\">Ryan Urban</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sadmansh/\">sadmansh</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sahiladit/\">sahiladit</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sakibmd/\">Sakib Mohammed</a> · <a href=\"https://profiles.wordpress.org/samtoohey93/\">Sam Toohey</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/samuelsilvapt/\">Samuel Silva</a> · <a href=\"https://profiles.wordpress.org/sannevndrmeulen/\">Sanne van der Meulen</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarahricker/\">sarahricker</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/sauliusv/\">Saulius Vikerta</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/scholdstrom/\">scholdstrom</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scottculverhouse/\">scottculverhouse</a> · <a href=\"https://profiles.wordpress.org/seanavers/\">seanavers</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/kuuuzya/\">Sergey</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/zahardoc/\">Serhiy Zakharchenko</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/sharonaustin/\">Sharon Austin</a> · <a href=\"https://profiles.wordpress.org/sheulyshila/\">sheulyshila</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/showravhasan/\">Showrav Hasan</a> · <a href=\"https://profiles.wordpress.org/shreya0204/\">Shreya Agarwal</a> · <a href=\"https://profiles.wordpress.org/silaskoehler/\">Silas Köhler</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/sophiegy/\">Sophie – a11n</a> · <a href=\"https://profiles.wordpress.org/souptik/\">Souptik Datta</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/staurand/\">staurand</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/thompsonsj/\">Steven Thompson</a> · <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a> · <a href=\"https://profiles.wordpress.org/styleshit/\">styleshit</a> · <a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">Sunil Prajapati</a> · <a href=\"https://profiles.wordpress.org/quadthemes/\">Sunny</a> · <a href=\"https://profiles.wordpress.org/superchlorine/\">superchlorine</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/jannathsyeda/\">Syeda Fahima Jannath</a> · <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Takahashi Fumiki</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/tanvirul/\">Tanvirul Haque</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tdrayson/\">tdrayson</a> · <a href=\"https://profiles.wordpress.org/iamjaydip/\">thejaydip</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tmanoilov/\">tmanoilov</a> · <a href=\"https://profiles.wordpress.org/toastercookie/\">toastercookie</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/thomasdevisser/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomhine/\">tomhine</a> · <a href=\"https://profiles.wordpress.org/tomllobet/\">tomllobet</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/twstokes/\">twstokes</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umesh84/\">Umesh Gupta</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/valer1e/\">valer1e</a> · <a href=\"https://profiles.wordpress.org/vertisoft/\">vertisoft</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/ghorivipul97/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">vipulpatil</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">vrishabhsk</a> · <a href=\"https://profiles.wordpress.org/wbdv/\">wbdv</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/webwurm/\">webwurm</a> · <a href=\"https://profiles.wordpress.org/wesrapyd/\">wesrapyd</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williamalexander/\">William Alexander</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/wpeople/\">WPeople</a> · <a href=\"https://profiles.wordpress.org/wpsoul/\">wpsoul</a> · <a href=\"https://profiles.wordpress.org/wzieba/\">wzieba</a> · <a href=\"https://profiles.wordpress.org/xipasduarte/\">xipasduarte</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/collet/\">Yann</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/ytfeldrawkcab/\">ytfeLdrawkcaB</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yukinobu/\">Yukinobu Asakawa</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/zackkrida/\">Zack Krida</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zitaruksergij/\">zitaruksergij</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a></p>\n\n\n\n<p>Mais de <a href=\"https://translate.wordpress.org/stats/\">40 localidades traduziram totalmente</a> o WordPress 6.7 para suas línguas, tornando este um dos lançamentos mais traduzidos do primeiro dia. Os tradutores comunitários estão trabalhando duro para garantir que mais traduções estejam a caminho. Agradecemos a todos que ajudam a disponibilizar o WordPress em 200 idiomas.</p>\n\n\n\n<p>Por último, mas não menos importante, agradecemos aos voluntários que contribuem para os <a href=\"https://wordpress.org/support/\">fóruns de apoio</a>, respondendo a perguntas de usuários do WordPress em todo o mundo.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Entre na causa</h2>\n\n\n\n<p>A participação no WordPress vai muito além da codificação, e aprender mais e se envolver é fácil. Descubra as equipes que se reúnem para <a href=\"https://make.wordpress.org/\">criar o WordPress</a> e use <a href=\"https://make.wordpress.org/contribute/\">esta ferramenta interativa</a> para ajudá-lo a decidir qual é o certo para você.<a href=\"https://profiles.wordpress.org/benniledl/\"></a></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3156\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.7 Release Candidate 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://br.wordpress.org/2024/11/06/wordpress-6-7-release-candidate-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Nov 2024 11:50:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=3152\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"O terceiro release candidate (RC3) para o WordPress 6.7 está pronto para baixar e testar!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9131:\"\n<p>O terceiro release candidate (RC3) para o WordPress 6.7 está pronto para baixar e testar!</p>\n\n\n\n<p><strong>Esta versão do software WordPress está em desenvolvimento</strong>. <strong>Não instale, execute ou teste esta versão do WordPress em sites de produção ou de missão crítica.</strong> Em vez disso, avalie o RC3 em um servidor de teste ou em um ambiente local.</p>\n\n\n\n<p>Alcançar esta fase do ciclo de lançamento é um marco importante. Embora o release candidate seja considerado pronto para o lançamento, os testes continuam vitais para garantir que tudo no WordPress 6.7 seja o melhor possível.</p>\n\n\n\n<p>Você pode testar o WordPress 6.7 RC3 de quatro maneiras:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><th>Plugin</th><td>Instale e ative o plugin <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> em uma instalação do WordPress. (Selecione o canal “Bleeding edge” e o fluxo “Beta/RC Only”).</td></tr><tr><th>Baixe diretamente</th><td>Baixe a <a href=\"https://wordpress.org/wordpress-6.7-RC3.zip\">versão RC3 (zip)</a> e instalá-lo em um site WordPress.</td></tr><tr><th>Linha de comando</th><td>Use o seguinte comando <a href=\"https://make.wordpress.org/cli/\">WP-CLI:</a><br><code>wp core update --version=6.7-RC3</code></td></tr><tr><th>WordPress Playground</th><td>Use uma <a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20%5B%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20%5D%20%7D\">instância 6.7 RC3 do WordPress Playground</a> (disponível dentro de 35 minutos após o lançamento estar pronto) para testar o software diretamente no seu navegador sem a necessidade de um site ou configuração separada.</td></tr></tbody></table></figure>\n\n\n\n<p>A meta atual para o lançamento da versão do WordPress 6.7 é 12 <strong>de novembro de 2024</strong>. Obtenha uma visão geral do <a href=\"https://make.wordpress.org/core/6-7/\">ciclo de lançamento da versão 6.7</a> e confira o <a href=\"https://make.wordpress.org/core/\">blog Make WordPress Core</a> para <a href=\"https://make.wordpress.org/core/tag/6-7/\">posts relacionados a versão 6.7</a> nas próximas semanas para obter mais detalhes.</p>\n\n\n\n<h2 class=\"wp-block-heading\">O que há no WordPress 6.7 RC3?</h2>\n\n\n\n<p>Obtenha uma visão geral dos principais recursos do WordPress 6.7 no <a href=\"https://br.wordpress.org/2024/10/01/wordpress-6-7-beta-1/\">anúncio da versão Beta 1.</a> Para obter mais informações técnicas relacionadas a problemas resolvidos desde a versão RC2, você pode navegar pelos seguintes links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.7?since=2024-10-29&amp;until=2024-11-05\">Tíquetes do GitHub para a versão 6.7</a> desde 29 de outubro.</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F29%2F2024..11%2F05%2F2024&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Tíquetes fechados do Trac</a> desde 29 de outubro.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Como contribuir?</h2>\n\n\n\n<p>O WordPress é um software de código aberto possibilitado pela comunidade de pessoas que colaboram e contribuem para o seu desenvolvimento. Os recursos abaixo descrevem uma variedade de maneiras pelas quais você pode ajudar, independentemente de sua experiência técnica.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Envolva-se nos testes</h3>\n\n\n\n<p>Testar problemas é fundamental para garantir que o WordPress seja performante e estável. Também é uma maneira significativa de qualquer pessoa contribuir. <a href=\"https://make.wordpress.org/test/2024/10/01/help-test-wordpress-6-7/\">Este guia detalhado</a> irá orientá-lo através de recursos de teste no WordPress 6.7. Para aqueles que estão começando a testar, sigam <a href=\"https://make.wordpress.org/test/2024/02/15/help-test-wordpress-6-5-beta-1\">este guia de testes geral</a> para obter mais detalhes sobre como começar.</p>\n\n\n\n<p>Se você encontrar um problema, informe-o na <a href=\"https://wordpress.org/support/forum/alphabeta/\">área Alpha / Beta</a> dos fóruns de suporte ou diretamente ao <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> se você estiver confortável escrevendo um relatório de erros reprodutível. Você também pode verificar seu problema em relação a uma lista de <a href=\"https://core.trac.wordpress.org/tickets/major\">erros conhecidos</a>.</p>\n\n\n\n<p>Curioso sobre os testes de lançamentos em geral? Acompanhe as <a href=\"https://make.wordpress.org/test/\">iniciativas de teste</a> no <a href=\"https://make.wordpress.org/test/\">Make WordPress Core</a> e junte-se ao <a href=\"https://wordpress.slack.com/messages/core-test/\">canal #core-test</a> no <a href=\"https://wordpress.slack.com/\">Slack do WordPress</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">A recompensa de vulnerabilidade dobra durante as versões Beta/RC</h3>\n\n\n\n<p>Durante a fase de lançamento do WordPress 6.7 (agendado para 12 de novembro de 2024), a <a href=\"https://make.wordpress.org/security/2024/02/12/welcoming-2024-with-wordpress-6-5-beta-1/\">recompensa monetária por relatar novas vulnerabilidades de segurança não lançadas é dobrada</a>. Siga as práticas de divulgação responsável, conforme detalhado nas práticas e políticas de segurança do projeto descritas na <a href=\"https://hackerone.com/wordpress\">página do HackerOne</a> e no <a href=\"https://wordpress.org/about/security/\">white paper de segurança</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Atualize seu tema ou plugin</h3>\n\n\n\n<p>Para autores de plugins e temas, seus produtos desempenham um papel fundamental na extensão da funcionalidade e valor do WordPress para todos os usuários.</p>\n\n\n\n<p>Agradecemos por continuar a testar seus temas e plugins com as versões beta do WordPress 6.7. Com o RC3, você vai querer concluir seus testes e atualizar a versão <em>“Tested up to”</em> no <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">arquivo readme do seu plugin</a> para a versão 6.7.</p>\n\n\n\n<p>Se você encontrar problemas de compatibilidade, publique informações detalhadas no <a href=\"https://wordpress.org/support/forum/alphabeta/\">fórum de suporte</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Traduza o WordPress</h2>\n\n\n\n<p><a href=\"https://translate.wordpress.org/projects/wp/dev/pt-br/default/\">Ajude-nos a traduzir o WordPress para o português!</a>&nbsp;O lançamento dessa versão também significa que&nbsp;<a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">novas strings para a tradução</a>&nbsp;da versão 6.7 serão evitadas.</p>\n\n\n\n<p><em>Agradecemos aos seguintes contribuidores por colaborarem com este post:</em> <em><a href=\"https://profiles.wordpress.org/peterwilsoncc/\">@peterwilsoncc</a>, <a href=\"https://profiles.wordpress.org/joedolson/\">@joedolson</a></em> e <a href=\"https://profiles.wordpress.org/sabernhardt/\">@sabernhardt</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3152\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.7 Release Candidate 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://br.wordpress.org/2024/10/29/wordpress-6-7-release-candidate-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 29 Oct 2024 18:41:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=3148\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"O segundo release candidate (RC2) para o WordPress 6.7 está pronto para baixar e testar!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9072:\"\n<p>O segundo release candidate (RC2) para o WordPress 6.7 está pronto para baixar e testar!</p>\n\n\n\n<p><strong>Esta versão do software WordPress está em desenvolvimento</strong>. <strong>Não instale, execute ou teste esta versão do WordPress em sites de produção ou de missão crítica.</strong> Em vez disso, avalie o RC2 em um servidor de teste ou em um ambiente local.</p>\n\n\n\n<p>Alcançar esta fase do ciclo de lançamento é um marco importante. Embora os release candidates sejam considerados prontos para lançamento, os testes continuam vitais para garantir que tudo no WordPress 6.7 seja o melhor possível.</p>\n\n\n\n<p>Você pode testar o WordPress 6.7 RC2 de quatro maneiras:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><th>Plugin</th><td>Instale e ative o plugin <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> em uma instalação do WordPress. (Selecione o canal “Bleeding edge” e o fluxo “Beta/RC Only”).</td></tr><tr><th>Baixar diretamente</th><td>Baixe a <a href=\"https://wordpress.org/wordpress-6.7-RC2.zip\">versão RC2 (zip)</a> e instale-a em um site WordPress.</td></tr><tr><th>Linha de comando</th><td>Use este comando <a href=\"https://make.wordpress.org/cli/\">WP-CLI:</a><br><code>wp core update --version=6.7-RC2</code></td></tr><tr><th>WordPress Playground</th><td>Use a <a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22https://playground.wordpress.net/plugin-proxy.php?build-ref=5087acab42d5354c8766303d13b78c8a77ac331b%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20%5B%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20%5D%20%7D\">instância 6.7 RC2 do WordPress Playground</a> (disponível dentro de 35 minutos após o lançamento estar pronto) para testar o software diretamente no seu navegador sem a necessidade de um site ou configuração separada.</td></tr></tbody></table></figure>\n\n\n\n<p>A meta atual para o lançamento da versão do WordPress 6.7 é 12 <strong>de novembro de 2024</strong>. Obtenha uma visão geral do <a href=\"https://make.wordpress.org/core/6-7/\">ciclo de lançamento da versão 6.7</a> e confira o <a href=\"https://make.wordpress.org/core/\">blog Make WordPress Core</a> para <a href=\"https://make.wordpress.org/core/tag/6-7/\">posts relacionadas a versão 6.7</a> nas próximas semanas para obter mais detalhes.</p>\n\n\n\n<h2 class=\"wp-block-heading\">O que há de novo no WordPress 6.7 RC2?</h2>\n\n\n\n<p>Obtenha uma visão geral dos principais recursos do WordPress 6.7 no <a href=\"https://br.wordpress.org/2024/10/01/wordpress-6-7-beta-1/\">anúncio da versão Beta 1.</a> Para obter mais informações técnicas relacionadas a problemas resolvidos desde a versão RC1, você pode navegar pelos seguintes links</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.7?since=2024-10-22&amp;until=2024-10-29\">Tíquetes do GitHub para a versão 6.7</a> desde 22 de outubro.</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F22%2F2024..10%2F29%2F2024&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Tíquetes fechados do Trac</a> desde 22 de outubro.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Como contribuir?</h2>\n\n\n\n<p>O WordPress é um software de código aberto possibilitado pela comunidade de pessoas que colaboram e contribuem para o seu desenvolvimento. Os recursos abaixo descrevem uma variedade de maneiras pelas quais você pode ajudar, independentemente de sua experiência técnica.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Envolva-se nos testes</h3>\n\n\n\n<p>Testar problemas é fundamental para garantir que o WordPress seja performante e estável. Também é uma maneira significativa de qualquer pessoa contribuir. <a href=\"https://make.wordpress.org/test/2024/10/01/help-test-wordpress-6-7/\">Este guia detalhado</a> irá orientá-lo através de recursos de teste no WordPress 6.7. Para aqueles que estão começando a testar, sigam <a href=\"https://make.wordpress.org/test/2024/02/15/help-test-wordpress-6-5-beta-1\">este guia de testes geral</a> para obter mais detalhes sobre como começar.</p>\n\n\n\n<p>Se você encontrar um problema, informe-o na <a href=\"https://wordpress.org/support/forum/alphabeta/\">área Alpha / Beta</a> dos fóruns de suporte ou diretamente ao <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> se você estiver confortável escrevendo um relatório de erros reprodutível. Você também pode verificar seu problema em relação a uma lista de <a href=\"https://core.trac.wordpress.org/tickets/major\">erros conhecidos</a>.</p>\n\n\n\n<p>Curioso sobre os testes de lançamentos em geral? Acompanhe as <a href=\"https://make.wordpress.org/test/\">iniciativas de teste</a> no <a href=\"https://make.wordpress.org/test/\">Make WordPress Core</a> e junte-se ao <a href=\"https://wordpress.slack.com/messages/core-test/\">canal #core-test</a> no <a href=\"https://wordpress.slack.com/\">Slack do WordPress</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">A recompensa de vulnerabilidade dobra durante as versões Beta/RC</h3>\n\n\n\n<p>Durante a fase de lançamento do WordPress 6.7 (agendado para 12 de novembro de 2024), a <a href=\"https://make.wordpress.org/security/2024/02/12/welcoming-2024-with-wordpress-6-5-beta-1/\">recompensa monetária por relatar novas vulnerabilidades de segurança não lançadas é dobrada</a>. Siga as práticas de divulgação responsável, conforme detalhado nas práticas e políticas de segurança do projeto descritas na <a href=\"https://hackerone.com/wordpress\">página do HackerOne</a> e no <a href=\"https://wordpress.org/about/security/\">white paper de segurança</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Atualize seu tema ou plugin</h3>\n\n\n\n<p>Para autores de plugins e temas, seus produtos desempenham um papel fundamental na extensão da funcionalidade e valor do WordPress para todos os usuários.</p>\n\n\n\n<p>Agradecemos por continuar a testar seus temas e plugins com as versões beta do WordPress 6.7. Com o RC2, você vai querer concluir seus testes e atualizar a versão <em>“Tested up to”</em> no <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">arquivo readme do seu plugin</a> para a versão 6.7.</p>\n\n\n\n<p>Se você encontrar problemas de compatibilidade, publique informações detalhadas no <a href=\"https://wordpress.org/support/forum/alphabeta/\">fórum de suporte</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Traduza o WordPress</h2>\n\n\n\n<p><a href=\"https://translate.wordpress.org/projects/wp/dev/pt-br/default/\">Ajude-nos a traduzir o WordPress para o português!</a>&nbsp;O lançamento dessa versão também significa que&nbsp;<a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">novas strings para a tradução</a>&nbsp;da versão 6.7 serão evitadas.</p>\n\n\n\n<p><em>Agradecemos aos seguintes contribuidores por colaborarem com este post:</em> <em><a href=\"https://profiles.wordpress.org/jorbin/\">@jorbin</a></em>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3148\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.7 Release Candidate 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://br.wordpress.org/2024/10/23/wordpress-6-7-release-candidate-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 23 Oct 2024 13:26:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=3145\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"O primeiro release candidate (RC1) para o WordPress 6.7 está pronto para baixar e testar!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11132:\"\n<p>O primeiro release candidate (RC1) para o WordPress 6.7 está pronto para baixar e testar!</p>\n\n\n\n<p><strong>Esta versão do software WordPress está em desenvolvimento</strong>. <strong>Não instale, execute ou teste esta versão do WordPress em sites de produção ou de missão crítica.</strong> Em vez disso, avalie o RC1 em um servidor de teste ou em um ambiente local.</p>\n\n\n\n<p>Alcançar esta fase do ciclo de lançamento é um marco importante. Embora os release candidates sejam considerados prontos para lançamento, os testes continuam vitais para garantir que tudo no WordPress 6.7 seja o melhor possível.</p>\n\n\n\n<p>Você pode testar o WordPress 6.7 RC1 de quatro maneiras:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><th>Plugin</th><td>Instale e ative o plugin <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> em uma instalação do WordPress. (Selecione o canal “Bleeding edge” e o fluxo “Beta/RC Only”).</td></tr><tr><th>Baixar diretamente</th><td>Baixe a <a href=\"https://wordpress.org/wordpress-6.7-RC1.zip\">versão RC1 (zip)</a> e instale-a em um site WordPress.</td></tr><tr><th>Linha de comando</th><td>Use este comando <a href=\"https://make.wordpress.org/cli/\">WP-CLI:</a><br><code>wp core update --version=6.7-RC1</code></td></tr><tr><th>WordPress Playground</th><td>Use a <a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22https://playground.wordpress.net/plugin-proxy.php?build-ref=5087acab42d5354c8766303d13b78c8a77ac331b%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20%5B%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20%5D%20%7D\">instância 6.7 RC1 do WordPress Playground</a> (disponível dentro de 35 minutos após o lançamento estar pronto) para testar o software diretamente no seu navegador sem a necessidade de um site ou configuração separada.</td></tr></tbody></table></figure>\n\n\n\n<p>O meta atual para o lançamento da versão do WordPress 6.7 é 12 <strong>de novembro de 2024</strong>. Obtenha uma visão geral do <a href=\"https://make.wordpress.org/core/6-7/\">ciclo de lançamento da versão 6.7</a> e confira o <a href=\"https://make.wordpress.org/core/\">blog Make WordPress Core</a> para <a href=\"https://make.wordpress.org/core/tag/6-7/\">posts relacionadas a versão 6.7</a> nas próximas semanas para obter mais detalhes.</p>\n\n\n\n<h2 class=\"wp-block-heading\">O que há de novo no WordPress 6.7 RC1?</h2>\n\n\n\n<p>Obtenha uma visão geral dos principais recursos do WordPress 6.7 no <a href=\"https://br.wordpress.org/2024/10/01/wordpress-6-7-beta-1/\">anúncio da versão Beta 1.</a> Para obter mais informações técnicas relacionadas a problemas resolvidos desde a versão Beta 3, você pode navegar pelos seguintes links:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.5?since=2024-10-15&amp;until=2024-10-22\">Tíquetes do GitHub para a versão 6.7</a> desde 15 de outubro.</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F15%2F2024..10%2F22%2F2024&amp;milestone=6.7&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Tíquetes fechados do Trac</a> desde 15 de outubro.</li>\n</ul>\n\n\n\n<p>Quer olhar mais detalhadamente para os detalhes e notas técnicas para esta versão? Os links a seguir cobrem algumas das atualizações mais recentes:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/\">Novas APIs de registro de tipo de bloco para melhorar o desempenho no WordPress 6.7</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/08/15/automatic-conversion-of-heic-images-to-jpeg-in-wordpress-6-7/\">Conversão automática de imagens HEIC para JPEG no WordPress 6.7</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/\">Tamanhos automáticos para imagens que usam carregamento tardio no WordPress 6.7</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/10/20/new-plugin-template-registration-api-in-wordpress-6-7/\">Nova API de registro de modelos de plugins no WordPress 6.7</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/10/21/developer-notes-for-zoom-out-in-wordpress-6-7/\">Notas do desenvolvedor para recurso de Zoom Out no WordPress 6.7</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/10/21/block-bindings-improvements-to-the-editor-experience-in-6-7/\">Melhorias na experiência do editor na versão 6.7</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/\">Melhorias na internacionalização na versão 6.7</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/10/17/updates-to-the-html-api-in-6-7/\">Atualizações para a API de HTML na versão 6.7</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/10/20/miscellaneous-block-editor-changes-in-wordpress-6-7/\">Alterações diversas para o editor de blocos no WordPress 6.7</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/tag/dev-notes+6-7/\">Todas as notas de desenvolvedor relacionadas a versão 6.7</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Como contribuir?</h2>\n\n\n\n<p>O WordPress é um software de código aberto possibilitado pela comunidade de pessoas que colaboram e contribuem para o seu desenvolvimento. Os recursos abaixo descrevem uma variedade de maneiras pelas quais você pode ajudar, independentemente de sua experiência técnica.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Envolva-se nos testes</h3>\n\n\n\n<p>Testar problemas é fundamental para garantir que o WordPress seja performante e estável. Também é uma maneira significativa de qualquer pessoa contribuir. <a href=\"https://make.wordpress.org/test/2024/10/01/help-test-wordpress-6-7/\">Este guia detalhado</a> irá orientá-lo através de recursos de teste no WordPress 6.7. Para aqueles que estão começando a testar, sigam <a href=\"https://make.wordpress.org/test/2024/02/15/help-test-wordpress-6-5-beta-1\">este guia de testes geral</a> para obter mais detalhes sobre como começar.</p>\n\n\n\n<p>Se você encontrar um problema, informe-o na <a href=\"https://wordpress.org/support/forum/alphabeta/\">área Alpha / Beta</a> dos fóruns de suporte ou diretamente ao <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> se você estiver confortável escrevendo um relatório de erros reprodutível. Você também pode verificar seu problema em relação a uma lista de <a href=\"https://core.trac.wordpress.org/tickets/major\">erros conhecidos</a>.</p>\n\n\n\n<p>Curioso sobre os testes de lançamentos em geral? Acompanhe as <a href=\"https://make.wordpress.org/test/\">iniciativas de teste</a> no <a href=\"https://make.wordpress.org/test/\">Make WordPress Core</a> e junte-se ao <a href=\"https://wordpress.slack.com/messages/core-test/\">canal #core-test</a> no <a href=\"https://wordpress.slack.com/\">Slack do WordPress</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">A recompensa de vulnerabilidade dobra durante as versões Beta/RC</h3>\n\n\n\n<p>Durante a fase de lançamento do WordPress 6.7 (agendado para 12 de novembro de 2024), a <a href=\"https://make.wordpress.org/security/2024/02/12/welcoming-2024-with-wordpress-6-5-beta-1/\">recompensa monetária por relatar novas vulnerabilidades de segurança não lançadas é dobrada</a>. Siga as práticas de divulgação responsável, conforme detalhado nas práticas e políticas de segurança do projeto descritas na <a href=\"https://hackerone.com/wordpress\">página do HackerOne</a> e no <a href=\"https://wordpress.org/about/security/\">white paper de segurança</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Atualize seu tema ou plugin</h3>\n\n\n\n<p>Para autores de plugins e temas, seus produtos desempenham um papel fundamental na extensão da funcionalidade e valor do WordPress para todos os usuários.</p>\n\n\n\n<p>Agradecemos por continuar a testar seus temas e plugins com as versões beta do WordPress 6.7. Com o RC1, você vai querer concluir seus testes e atualizar a versão <em>“Tested up to”</em> no <a href=\"https://developer.wordpress.org/plugins/wordpress-org/how-your-readme-txt-works/\">arquivo readme do seu plugin</a> para a versão 6.7.</p>\n\n\n\n<p>Se você encontrar problemas de compatibilidade, publique informações detalhadas no <a href=\"https://wordpress.org/support/forum/alphabeta/\">fórum de suporte</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Traduza o WordPress</h2>\n\n\n\n<p><a href=\"https://translate.wordpress.org/projects/wp/dev/pt-br/default/\">Ajude-nos a traduzir o WordPress para o português!</a>&nbsp;O lançamento dessa versão também significa que&nbsp;<a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">novas strings para a tradução</a>&nbsp;da versão 6.7 serão evitadas.</p>\n\n\n\n<p><em><em>Agradecemos aos seguintes contribuidores por colaborarem com este post:</em></em> <em><a href=\"https://profiles.wordpress.org/atachibana/\">@atachibana</a> e <a href=\"https://profiles.wordpress.org/jorbin/\">@jorbin</a></em>.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3145\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.7 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://br.wordpress.org/2024/10/15/wordpress-6-7-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Oct 2024 11:22:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=3138\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:152:\"O WordPress 6.7 Beta 3 já está disponível, contendo mais de 26 atualizações e correções para o editor e 18 melhorias para o núcleo do WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8364:\"\n<p>O WordPress 6.7 Beta 3 já está disponível!</p>\n\n\n\n<p id=\"block-79834dd4-c99a-477a-b722-091806a32976\"><strong>Esta versão beta do software WordPress está em desenvolvimento. </strong>Por favor, não instale, execute ou teste esta versão do WordPress em produção ou sites de missão crítica, você corre o risco de resultados inesperados se o fizer.</p>\n\n\n\n<p id=\"block-79834dd4-c99a-477a-b722-091806a32976\">Em vez disso, instale a versão Beta 3 em locais e ambientes de teste usando qualquer uma dessas quatro maneiras:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><th>Plugin</th><td>Instale e ative o plugin <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> em uma instalação do WordPress. (Selecione o canal “Bleeding edge” e o fluxo “Beta/RC Only”).</td></tr><tr><th>Baixe diretamente</th><td>Baixe a <a href=\"https://wordpress.org/wordpress-6.7-beta3.zip\">versão Beta 3 (zip)</a> e instale-a em um site WordPress.</td></tr><tr><th>Linha de comando</th><td>Use o comando do <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a>:<br><code>wp core update --version=6.7-beta3</code></td></tr><tr><th>WordPress Playground</th><td>Use uma <a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22https://playground.wordpress.net/plugin-proxy.php?build-ref=11b364fbffbab28d9127be91ee2d48f6645a6509%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20%5B%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20%5D%20%7D\">instância da versão 6.7 Beta 3 no WordPress Playground</a> para testar o software diretamente no seu navegador. Esta pode ser a maneira mais fácil, sem sites separados, sem configuração. Basta clicar e utilizar!</td></tr></tbody></table></figure>\n\n\n\n<p>A data de lançamento final programada para o WordPress 6.7 é <strong><strong>12 de novembro de 2024</strong></strong>. Sua ajuda para testar as versões Beta e RC nas próximas quatro semanas é vital para garantir que a versão final seja tudo o que deve ser: estável, poderosa e intuitiva.</p>\n\n\n\n<p id=\"block-93b754f0-e211-47b7-ac89-349d85c2f02f\">Obtenha uma visão geral do <a href=\"https://make.wordpress.org/core/6-7/\">ciclo de lançamento da versão 6.7</a> e verifique o blog <a href=\"https://make.wordpress.org/core/\">Make WordPress Core</a> para <a href=\"https://make.wordpress.org/core/tag/6-7/\">posts relacionados a versão 6.7</a> nas próximas semanas para mais informações.</p>\n\n\n\n<p id=\"block-7b5d791d-225a-4623-83ee-19a586c7094b\"><strong>Acompanhe o que há de novo no WordPress 6.7:</strong> Leia os anúncios das versões <a href=\"https://br.wordpress.org/2024/10/01/wordpress-6-7-beta-1/\">Beta 1</a> e <a href=\"https://br.wordpress.org/2024/10/08/wordpress-6-7-beta-2/\">Beta 2</a> para detalhes e destaques.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"block-f1abd396-a019-4c9a-bcb8-9ac381a61ca1\">Como testar esta versão</h2>\n\n\n\n<p>Sua ajuda para testar a versão do WordPress 6.7 Beta 3 é fundamental para garantir que tudo no lançamento seja o melhor que pode ser. Embora o teste do processo de atualização seja essencial, experimentar novos recursos é igualmente importante. <a href=\"https://make.wordpress.org/test/2024/10/01/help-test-wordpress-6-7/\">Este guia detalhado</a> irá orientá-lo através de recursos de teste no WordPress 6.7.</p>\n\n\n\n<p id=\"block-92dfcab6-d2a8-4753-84ce-8ef7b6dd1e90\">Se você se deparar com um problema, por favor, compartilhe-o na <a href=\"https://wordpress.org/support/forum/alphabeta/\">área Alpha/Beta</a> dos fóruns de suporte. Se você estiver confortável em enviar um relatório de erros reprodutível, você pode fazê-lo <a href=\"https://core.trac.wordpress.org/newticket\">através do WordPress Trac</a>. Você também pode verificar seu problema em relação a uma lista de <a href=\"https://core.trac.wordpress.org/tickets/major\">erros conhecidos</a>.</p>\n\n\n\n<p>Curioso sobre os lançamentos de testes em geral? Acompanhe as <a href=\"https://make.wordpress.org/test/\">iniciativas de teste em Make Core</a> e junte-se ao <a href=\"https://wordpress.slack.com/messages/core-test/\">canal de teste central</a> no <a href=\"https://wordpress.slack.com/\">Slack do WordPress</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A recompensa da vulnerabilidade duplica no período beta</h2>\n\n\n\n<p>Entre o Beta 1, lançado em 1 de outubro de 2024, e o Release Candidate final (RC) programado para 5 de novembro de 2024, a <a href=\"https://make.wordpress.org/security/2024/02/12/welcoming-2024-with-wordpress-6-5-beta-1/\">recompensa monetária por relatar novas vulnerabilidades de segurança inéditas</a> é duplicada. Siga as práticas de divulgação responsáveis conforme detalhado nas práticas e políticas de segurança do projeto descritas na <a href=\"https://hackerone.com/wordpress\">página do HackerOne</a> e no <a href=\"https://wordpress.org/about/security/\">white paper de segurança</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"block-14306771-b240-4e15-948f-7504757bbb61\">Atualizações e destaques</h2>\n\n\n\n<p id=\"block-93917d31-4478-45b5-b71c-1c8a1f49cc65\">O WordPress 6.7 Beta 3 contém mais de 26 atualizações e correções para o editor desde o lançamento da versão Beta 2, incluindo 18 tíquetes para o núcleo do WordPress.</p>\n\n\n\n<p id=\"block-ffdc1220-c2f5-4c23-982b-60c366c629d1\">Cada ciclo beta se concentra em correções de erros, e mais estão a caminho com sua ajuda através dos testes. Você pode procurar os detalhes técnicos de todos os problemas abordados desde a versão Beta 1 usando estes links:</p>\n\n\n\n<ul id=\"block-3fcf78c7-bebc-42e1-96f6-8b605ea23aae\" class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.7?since=2024-10-09&amp;until=2024-10-14\">Tíquetes do GitHub para a versão 6.7</a> desde 9 de outubro de 2024.</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F09%2F2024..10%2F14%2F2024&amp;milestone=6.7&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Tíquetes fechados do Trac</a> desde 9 de outubro de 2024.</li>\n</ul>\n\n\n\n<p class=\"has-text-align-right\"><em>Agradecemos a <a href=\"https://profiles.wordpress.org/joedolson/\">@joedolson</a> e </em><a href=\"https://profiles.wordpress.org/jeffpaul/\">@jeffpaul </a><em><em>pela colaboração e revisão.</em></em></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3138\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.7 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://br.wordpress.org/2024/10/08/wordpress-6-7-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 08 Oct 2024 10:51:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=3134\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:130:\"O WordPress 6.7 Beta 2 já está disponível, incluindo mais de 18 atualizações e correções do editor, desde a versão Beta 1.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8004:\"\n<p>O WordPress 6.7 Beta 2 já está disponível.</p>\n\n\n\n<p id=\"block-79834dd4-c99a-477a-b722-091806a32976\"><strong>Esta versão beta do software WordPress está em desenvolvimento. </strong>Não instale, execute ou teste esta versão do WordPress em produção ou sites de missão crítica, você corre o risco de ter resultados inesperados.</p>\n\n\n\n<p id=\"block-79834dd4-c99a-477a-b722-091806a32976\">Em vez disso, instale o Beta 2 em ambientes de teste usando qualquer uma dessas quatro maneiras:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><th>Plugin</th><td>Instale e ative o plugin <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> em uma instalação do WordPress. (Selecione o canal “Bleeding edge” e o fluxo “Beta/RC Only”).</td></tr><tr><th>Baixe diretamente</th><td>Baixe a <a href=\"https://wordpress.org/wordpress-6.7-beta2.zip\">versão Beta 2 (zip)</a> e instale-a em um site WordPress.</td></tr><tr><th>Linha de comando</th><td>Use o seguinte comando <a href=\"https://make.wordpress.org/cli/\">WP-CLI:</a><br><code>wp core update --version=6.7-beta</code>2</td></tr><tr><th>WordPress Playground</th><td>Use a <a href=\"https://playground.wordpress.net/#{%20%22preferredVersions%22:%20{%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20},%20%22features%22:%20{%20%22networking%22:%20true%20},%20%22steps%22:%20[%20{%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20},%20{%20%22step%22:%20%22importFile%22,%20%22file%22:%20{%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20}%20},%20{%20%22step%22:%20%22importFile%22,%20%22file%22:%20{%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20},%20%22options%22:%20{%20%22activate%22:%20false%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20},%20{%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20{%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20},%20%22progress%22:%20{%20%22weight%22:%202%20}%20}%20]%20}\">instância do 6.7 Beta 2 do WordPress Playground</a> para testar o software diretamente no seu navegador sem a necessidade de um site ou configuração separada.</td></tr></tbody></table></figure>\n\n\n\n<p id=\"block-93b754f0-e211-47b7-ac89-349d85c2f02f\">A meta atual para o lançamento da versão final do WordPress 6.7 é <strong>12 de novembro de 2024</strong>. Obtenha uma visão geral do <a href=\"https://make.wordpress.org/core/6-7/\">ciclo de lançamento da versão 6.7</a> e confira o <a href=\"https://make.wordpress.org/core/\">blog Make WordPress Core</a> para <a href=\"https://make.wordpress.org/core/tag/6-7/\">posts relacionados a versão 6.7</a> nas próximas semanas para mais informações.</p>\n\n\n\n<p id=\"block-7b5d791d-225a-4623-83ee-19a586c7094b\"><strong>Acompanhe o que há de novo no WordPress 6.7:</strong> <a href=\"https://br.wordpress.org/2024/10/01/wordpress-6-7-beta-1/\">Leia o anúncio da versão Beta 1</a> para obter mais detalhes sobre os destaques.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"block-f1abd396-a019-4c9a-bcb8-9ac381a61ca1\">Como testar esta versão</h2>\n\n\n\n<p id=\"block-92dfcab6-d2a8-4753-84ce-8ef7b6dd1e90\">Sua ajuda para testar a versão Beta 2 do WordPress 6.7 é fundamental para garantir que tudo no lançamento seja o melhor possível. Embora o teste do processo de atualização seja essencial, experimentar novos recursos é igualmente importante. <a href=\"https://make.wordpress.org/test/2024/10/01/help-test-wordpress-6-7/\">Este guia detalhado</a> irá orientá-lo através dos recursos para testes no WordPress 6.7.</p>\n\n\n\n<p id=\"block-6519fad7-59ea-45f1-9b8f-ca14c09c865d\">Se você encontrar um problema, informe-o na <a href=\"https://wordpress.org/support/forum/alphabeta/\">área Alpha / Beta</a> dos fóruns de suporte ou diretamente ao <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> se você estiver confortável escrevendo um relatório de erros reprodutível. Você também pode verificar se seu problema já está presente em uma lista de <a href=\"https://core.trac.wordpress.org/tickets/major\">erros conhecidos</a>.</p>\n\n\n\n<p id=\"block-4bd66b13-6784-4a4f-bb7a-b4dab8e5fc12\">Curioso sobre os testes de lançamentos em geral? Acompanhe as <a href=\"https://make.wordpress.org/test/\">iniciativas de teste em Make WordPress Core</a> e junte-se ao <a href=\"https://wordpress.slack.com/messages/core-test/\">canal de teste central</a> no <a href=\"https://wordpress.slack.com/\">Slack do WordPress</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A recompensa da vulnerabilidade duplica no período beta</h2>\n\n\n\n<p>Entre o Beta 1, lançado em 1 de outubro de 2024, e o Release Candidate final (RC) programado para 5 de novembro de 2024, a <a href=\"https://make.wordpress.org/security/2024/02/12/welcoming-2024-with-wordpress-6-5-beta-1/\">recompensa monetária por relatar novas vulnerabilidades de segurança inéditas</a> é duplicada. Siga as práticas de divulgação responsáveis conforme detalhado nas práticas e políticas de segurança do projeto descritas na <a href=\"https://hackerone.com/wordpress\">página do HackerOne</a> e no <a href=\"https://wordpress.org/about/security/\">white paper de segurança</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"block-14306771-b240-4e15-948f-7504757bbb61\">Atualizações e destaques do Beta 2</h2>\n\n\n\n<p id=\"block-93917d31-4478-45b5-b71c-1c8a1f49cc65\">O WordPress 6.7 Beta 2 inclui mais de 18 atualizações e correções do editor, desde a versão Beta 1, incluindo <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=02%2F14%2F2024..02%2F19%2F2024&amp;milestone=6.5&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">28 tíquetes para o núcleo do WordPress</a>.</p>\n\n\n\n<p id=\"block-ffdc1220-c2f5-4c23-982b-60c366c629d1\">Cada ciclo beta se concentra em correções de erros, e mais estão a caminho com sua ajuda através dos testes. Você pode procurar os detalhes técnicos de todos os problemas abordados desde a versão Beta 1 usando estes links:</p>\n\n\n\n<ul id=\"block-3fcf78c7-bebc-42e1-96f6-8b605ea23aae\" class=\"wp-block-list\">\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.7?since=2024-10-02&amp;until=2024-10-07\">Tíquetes do GitHub relacionados a versão 6.7</a> desde 2 de outubro de 2024.</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F02%2F2024..10%2F07%2F2024&amp;milestone=6.7&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Tíquetes fechados do Trac</a> desde 2 de outubro de 2024.</li>\n</ul>\n\n\n\n<p class=\"has-text-align-right\">Agradecemos a <em><a href=\"https://profiles.wordpress.org/jeffpaul/\">@jeffpaul</a></em> para revisão do conteúdo.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3134\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.7 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://br.wordpress.org/2024/10/01/wordpress-6-7-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Oct 2024 12:11:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=3128\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:213:\"O WordPress 6.7 Beta 1 contém mais de 500 melhorias e mais de 500 correções de erros para o editor, incluindo mais de 200 tíquetes para o núcleo do WordPress 6.7. Aqui está um vislumbre do que está por vir\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13974:\"\n<p id=\"block-0eaa018b-f0fe-49ae-a80b-762dd1f69d27\">O WordPress 6.7 Beta 1 já está disponível.</p>\n\n\n\n<p><strong>Esta versão beta do software WordPress está em desenvolvimento. </strong>Por favor, não instale, execute ou teste esta versão do WordPress em produção ou sites de missão crítica, você corre o risco de ter resultados inesperados se o fizer.</p>\n\n\n\n<p>Em vez disso, instale o Beta 1 em locais e ambientes de teste com qualquer uma dessas quatro maneiras:</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Plugin</strong></td><td>Instale e ative o plugin&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;em uma instalação do WordPress. Selecione o canal “Bleeding edge” e o fluxo “Beta/RC Only”.</td></tr><tr><td><strong>Baixe diretamente</strong></td><td>Baixe a&nbsp;<a href=\"https://wordpress.org/wordpress-6.7-beta1.zip\">versão Beta 1 (zip)</a>&nbsp;e instale-a em um site WordPress.</td></tr><tr><td><strong>Linha de comando (WP-CLI)</strong></td><td>Use este comando <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> :<br><code>wp core update --version=6.7-beta1</code></td></tr><tr><td><strong>WordPress Playground</strong></td><td>Use uma <a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\">instância do WordPress Playground 6.7 Beta 1</a> para testar o software diretamente no seu navegador. Não é necessária configuração, basta clicar e pronto!</td></tr></tbody></table></figure>\n\n\n\n<p>A data de lançamento final programada para o WordPress 6.7 é <strong>12 de novembro de 2024.</strong> Sua ajuda testando as versões Beta e RC nas próximas seis semanas é essencial para garantir que o lançamento final seja tudo o que deveria ser: estável, poderoso e intuitivo.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Quão importante é o seu teste?</strong></h2>\n\n\n\n<p>Testar é uma parte essencial do desenvolvimento de qualquer software e é uma maneira significativa de qualquer pessoa contribuir, independentemente de ter experiência ou não.</p>\n\n\n\n<p>Se você encontrar um problema, compartilhe-o na <a href=\"https://wordpress.org/support/forum/alphabeta/\">área Alpha/Beta</a> dos fóruns de suporte. Se você se sentir confortável em enviar um relatório de bug reproduzível, você pode fazer isso via <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> . Você também pode verificar seu problema em uma lista de <a href=\"https://core.trac.wordpress.org/tickets/major\">erros conhecidos</a>.</p>\n\n\n\n<p>Curioso sobre testes de lançamentos em geral e como começar? Acompanhe as <a href=\"https://make.wordpress.org/test/\">iniciativas de teste no Make WordPress Core</a> e junte-se ao <a href=\"https://wordpress.slack.com/messages/core-test/\">canal #core-test</a> no <a href=\"https://wordpress.slack.com/\">Slack do WordPress</a>.</p>\n\n\n\n<p>O WordPress 6.7 incluirá muitos novos recursos que antes estavam disponíveis apenas no plugin Gutenberg. Saiba mais sobre as atualizações do Gutenberg desde o WordPress 6.7 nos posts <a href=\"https://make.wordpress.org/core/tag/gutenberg-new/\">O que há de novo no Gutenberg</a> para as versões <a href=\"https://make.wordpress.org/core/2024/06/09/what-is-new-in-gutenberg-18-5-05-jun/\">18.5</a>, <a href=\"https://make.wordpress.org/core/2024/06/20/whats-new-in-gutenberg-18-6/\">18.6</a>, <a href=\"https://make.wordpress.org/core/2024/07/04/whats-new-in-gutenberg-18-7-03-july/\">18.7</a>, <a href=\"https://make.wordpress.org/core/2024/07/17/whats-new-in-gutenberg-18-8-17-july/\">18.8</a>, <a href=\"https://make.wordpress.org/core/2024/07/31/whats-new-in-gutenberg-18-9-31-july/\">18.9</a>, <a href=\"https://make.wordpress.org/core/2024/08/14/whats-new-in-gutenberg-19-0-14-august/\">19.0</a>, <a href=\"https://make.wordpress.org/core/2024/08/28/whats-new-in-gutenberg-19-1-28-august/\">19.1</a>, <a href=\"https://make.wordpress.org/core/2024/09/12/what-is-new-in-gutenberg-19-2-11-september/\">19.2</a> e <a href=\"https://make.wordpress.org/core/2024/09/25/whats-new-in-gutenberg-19-3-25-september/\">19.3</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>O que há de novo no WordPress 6.7 Beta 1</strong></h2>\n\n\n\n<p>O WordPress 6.7 Beta 1 contém mais de 500 melhorias e mais de 500 correções de erros para o editor, incluindo mais de <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.7&amp;group=component&amp;max=500&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">200 tíquetes para o núcleo do WordPress 6.7</a>. Aqui está um vislumbre do que está por vir:</p>\n\n\n\n<h3 class=\"wp-block-heading\">Conheça o tema Twenty Twenty-Five</h3>\n\n\n\n<p>Lançado com o WordPress 6.7, o novo tema padrão <a href=\"https://make.wordpress.org/core/2024/08/15/introducing-twenty-twenty-five/\">Twenty Twenty-Five</a> incorpora a máxima flexibilidade e adaptabilidade, mostrando como o WordPress capacita você a contar sua história com uma rica seleção de padrões e estilos. Inspirado por vislumbres de beleza natural e herança ancestral, o terma evoca ideias de impermanência, passagem do tempo e evolução contínua, refletindo a jornada da vida. Experimente a criação de sites sem esforço com o Twenty Twenty-Five e acompanhe seu progresso ou relate problemas neste <a href=\"https://github.com/wordpress/twentytwentyfive\">repositório do GitHub</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Diminua o zoom para compor com padrões</h3>\n\n\n\n<p>A visualização Zoom Out simplifica sua experiência de edição permitindo que você crie e edite no nível do padrão em vez de focar em blocos individuais. Alterne facilmente essa visualização na barra de ferramentas para agilizar seu processo de construção de site, tornando mais rápido e intuitivo projetar páginas usando padrões.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Melhorias na mídia&nbsp;</h3>\n\n\n\n<p>Agora com suporte para uploads de imagens HEIC, convertidos automaticamente para JPEG para compatibilidade máxima, você pode adicionar imagens de alta qualidade sem se preocupar com o suporte do navegador. Além disso, aproveite o dimensionamento automático para imagens com carregamento tardio e opções de imagem de fundo expandidas em níveis individuais e globais, dando a você maior controle sobre os visuais e o desempenho do seu site.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Expansão do suporte a blocos</h3>\n\n\n\n<p>Vários blocos agora vêm com opções de suporte expandidas, permitindo ainda mais possibilidades de design. Notavelmente, o suporte de sombra há muito solicitado para grupo de blocos foi adicionado, uma grande vitória para designers e desenvolvedores de temas!</p>\n\n\n\n<h3 class=\"wp-block-heading\">API de opções de visualização</h3>\n\n\n\n<p>A versão mais recente do WordPress aprimora as opções de visualização no editor de blocos, capacitando os desenvolvedores a personalizar as visualizações de conteúdo. Uma nova API permite que plugins e temas adicionem itens personalizados ao menu suspenso de visualização, permitindo que os usuários vejam o conteúdo em diferentes formatos ou ambientes. Essa flexibilidade enriquece a experiência de edição, mantendo a estrutura familiar existente do menu suspenso de visualização.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Visualizações de dados refinadas</h3>\n\n\n\n<p>As Data Views introduzidas na versão 6.5 continuam sendo aprimoradas. Esta versão está focada em refinar a experiência com alguns novos recursos que visam tornar essas visualizações mais flexíveis para personalização e mais funcionais para uso.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Gerenciar ligações de bloco diretamente</h3>\n\n\n\n<p>A API Block Bindings agora apresenta uma interface que permite conectar atributos com dados dinâmicos para serem vinculados a atributos de bloco, resolvendo muitos casos de uso para blocos personalizados e potencializando outros recursos, como substituições em padrões sincronizados. As atualizações desta API na versão 6.7 aprimoram as APIs subjacentes, melhorando a experiência geral do usuário e adicionam uma interface de usuário (UI) que permite conectar atributos com suas fontes de vinculação. Esta nova UI torna possível criar vinculações diretamente em um bloco em vez de precisar usar o editor de códigos.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bloco de loop de consulta simplificado e mais inteligente</h3>\n\n\n\n<p>O bloco Query Loop foi melhorado, pois agora ele herda automaticamente a consulta do modelo por padrão, eliminando a necessidade de configuração manual. Isso significa que seus posts são exibidos imediatamente no editor e no site, simplificando o processo para que os usuários possam se concentrar no conteúdo sem necessidade de configuração extra.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Editar e controlar predefinições de tamanho de fonte</h3>\n\n\n\n<p>Uma interface de estilos aprimorada permite maior flexibilidade ao criar, editar, remover e aplicar predefinições de tamanho de fonte. Agora você pode modificar facilmente as predefinições fornecidas por um tema ou criar suas próprias opções personalizadas. Um recurso importante é a capacidade de alternar a tipografia fluida, o que permite dimensionamento de fonte responsivo com opções adicionais para controle mais fino sobre a responsividade.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Visualização de metabox no editor</h3>\n\n\n\n<p>Uma nova opção de visualização dividida foi introduzida, permitindo que você acesse tanto a tela do editor quanto as metaboxes durante a edição. Essa mudança fornecerá uma experiência consistente entre as visualizações do editor e do site.</p>\n\n\n\n<h3 class=\"wp-block-heading\">API de registro de modelo</h3>\n\n\n\n<p>Com este lançamento, os desenvolvedores agora podem registrar modelos de blocos personalizados com mais facilidade, sem filtros complexos. Simplifique seu processo de desenvolvimento e crie modelos personalizados com facilidade.&nbsp;</p>\n\n\n\n<p><strong>Os recursos incluídos nesta primeira versão beta podem mudar antes do lançamento final do WordPress 6.7, com base no que testadores como você descobrirem.</strong></p>\n\n\n\n<p>Obtenha uma visão geral do <a href=\"https://make.wordpress.org/core/6-7/\">ciclo de lançamento do 6.7</a> e confira o <a href=\"https://make.wordpress.org/core/\">blog Make WordPress Core</a> para <a href=\"https://make.wordpress.org/core/tag/6-7/\">posts relacionados a versão 6.7</a> nas próximas semanas para mais detalhes.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>A recompensa da vulnerabilidade duplica no período beta</strong></h2>\n\n\n\n<p>A comunidade WordPress patrocina uma <a href=\"https://make.wordpress.org/security/2024/02/12/welcoming-2024-with-wordpress-6-5-beta-1/\">recompensa monetária para relatar novas vulnerabilidades de segurança não lançadas</a>. Essa recompensa dobra durante o período entre o Beta 1 em 1º de outubro de 2024 e o Release Candidate (RC) final agendado para 5 de novembro de 2024. Siga as práticas de divulgação responsável conforme detalhado nas práticas e políticas de segurança do projeto descritas na <a href=\"https://hackerone.com/wordpress\">página do HackerOne</a> e no <a href=\"https://wordpress.org/about/security/\">white paper de segurança</a>.</p>\n\n\n\n<p><em>Agradecemos a <em><a href=\"https://profiles.wordpress.org/annezazu/\">@annezazu</a>, </em><a href=\"https://profiles.wordpress.org/cbringmann/\">@cbringmann</a>, <em><a href=\"https://profiles.wordpress.org/courane01/\">@courane01</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">@desrosj</a>, <a href=\"https://profiles.wordpress.org/marybaum/\">@marybaum</a>, e @preithor</em> por revisarem e colaborarem com este post!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3128\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 6.6.2– Atualização de manutenção\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://br.wordpress.org/2024/09/11/wordpress-6-6-2-atualizacao-de-manutencao/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Sep 2024 12:57:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:12:\"Lançamentos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=3123\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:380:\"O WordPress 6.6.2 já está disponível! Esta versão apresenta 15 correções de erros no núcleo e 11 correções no editor de blocos, abordando problemas como mudanças inesperadas de especificidade de CSS em determinados temas. Para um resumo completo das atualizações de manutenção, você pode consultar o anúncio do Release Candidate. O WordPress 6.6.2 é uma [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7622:\"\n<p><strong>O WordPress 6.6.2 já está disponível!</strong></p>\n\n\n\n<p>Esta versão apresenta <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;id=!61982&amp;milestone=6.6.2&amp;group=status&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;col=keywords&amp;order=id\">15 correções de erros no núcleo</a> e <a href=\"https://core.trac.wordpress.org/ticket/61982#comment:5\">11 correções no editor de blocos</a>, abordando problemas como mudanças inesperadas de especificidade de CSS em determinados temas. Para um resumo completo das atualizações de manutenção, você pode consultar o <a href=\"https://make.wordpress.org/core/2024/09/04/wordpress-6-6-2-rc1-is-now-available/\">anúncio do Release Candidate</a>.</p>\n\n\n\n<p>O WordPress 6.6.2 é uma versão de ciclo curto. O próximo grande lançamento será a <a href=\"https://make.wordpress.org/core/6-7/\">versão 6.7</a> planejada para 12 de novembro de 2024.</p>\n\n\n\n<p>Se você tiver sites que suportam atualizações automáticas em segundo plano, o processo de atualização será iniciado automaticamente.</p>\n\n\n\n<p>Você pode <a href=\"https://wordpress.org/wordpress-6.6.2.zip\">baixar o WordPress 6.6.2 em WordPress.org</a> ou visitar seu Painel WordPress, clicar em “Atualizações” e clicar em “Atualizar agora”.</p>\n\n\n\n<p>Para mais informações sobre esta versão, visite <a href=\"https://wordpress.org/support/wordpress-version/version-6-6-2\">o site HelpHub</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Agradecimento aos colaboradores</h2>\n\n\n\n<p>Este lançamento foi liderado por <a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a> e <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a>, com <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> nas orientações.</p>\n\n\n\n<p>O WordPress 6.6.2 não teria sido possível sem as contribuições das pessoas a seguir. Suas contribuições para fornecer correções de manutenção em uma versão estável é uma prova do poder e capacidade da comunidade WordPress.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/aaronrobertshaw\">Aaron Robertshaw</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/wildworks\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/atachibana\">Akira Tachibana</a>, <a href=\"https://profiles.wordpress.org/akshat2802\">Akshat Kakkad</a>, <a href=\"https://profiles.wordpress.org/harlet7\">Alexandru Horeanu</a>, <a href=\"https://profiles.wordpress.org/amitraj2203\">Amit Raj</a>, <a href=\"https://profiles.wordpress.org/andreiglingeanu\">andreiglingeanu</a>, <a href=\"https://profiles.wordpress.org/andrewserong\">Andrew Serong</a>, <a href=\"https://profiles.wordpress.org/the-ank\">Ankur Vishwakarma</a>, <a href=\"https://profiles.wordpress.org/ahortin\">Anthony Hortin</a>, <a href=\"https://profiles.wordpress.org/apmeyer\">apmeyer</a>, <a href=\"https://profiles.wordpress.org/aristath\">Ari Stathopoulos</a>, <a href=\"https://profiles.wordpress.org/rainbowgeek\">Benjamin Denis</a>, <a href=\"https://profiles.wordpress.org/bernhard-reiter\">bernhard-reiter</a>, <a href=\"https://profiles.wordpress.org/ironprogrammer\">Brian Alexander</a>, <a href=\"https://profiles.wordpress.org/freibergergarcia\">Bruno Freiberger Garcia</a>, <a href=\"https://profiles.wordpress.org/poena\">Carolina</a><a href=\"https://profiles.wordpress.org/costdev\">Colin Stewart</a><a href=\"https://profiles.wordpress.org/talldanwp\">Daniel Richards</a><a href=\"https://profiles.wordpress.org/dballari\">David Ballarin Prunera</a><a href=\"https://profiles.wordpress.org/davidbaumwald\">David Baumwald</a><a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a><a href=\"https://profiles.wordpress.org/dsas\">Dean Sas</a>, <a href=\"https://profiles.wordpress.org/debarghyabanerjee\">DEBARGHYA BANERJEE</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">Dennis Snell</a>, <a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziókowski</a>, <a href=\"https://profiles.wordpress.org/jamesros161\">James Rosado</a>, <a href=\"https://profiles.wordpress.org/madtownlems\">Jason LeMahieu (MadtownLems</a>), <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jeherve\">Jeremy Herve</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>, <a href=\"https://profiles.wordpress.org/josklever\">Jos Klever</a>, <a href=\"https://profiles.wordpress.org/karan4word\">karan4official</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Choyce-Dwan</a>, <a href=\"https://profiles.wordpress.org/kowsar89\">Kowsain</a>, <a href=\"https://profiles.wordpress.org/kracked888\">kracked</a><a href=\"https://profiles.wordpress.org/luisherranz\">luisherranz</a><a href=\"https://profiles.wordpress.org/clorith\"> J.</a>, <a href=\"https://profiles.wordpress.org/marius84\">mariushosting</a>, <a href=\"https://profiles.wordpress.org/markhowellsmead\">Mark Howells-Mead</a>, <a href=\"https://profiles.wordpress.org/mattraines\">mattraines</a>, <a href=\"https://profiles.wordpress.org/michaelwp85\">michaelwp85</a>, <a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/munyagu\">munyagu</a>, <a href=\"https://profiles.wordpress.org/narenin\">Narendra Sishodiya</a>, <a href=\"https://profiles.wordpress.org/ndiego\">Nick Diego</a>, <a href=\"https://profiles.wordpress.org/nithi22\">Nithin John</a>, <a href=\"https://profiles.wordpress.org/nithins53\">Nithin SreeRaj</a>, <a href=\"https://profiles.wordpress.org/alshakero\">Omar Alshaker</a>, <a href=\"https://profiles.wordpress.org/paaljoachim\">Paal Joachim Romdahl</a>, <a href=\"https://profiles.wordpress.org/pamprn\">Pamela Ribeiro</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/pbiron\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/presstoke\">presstoke</a>,<a href=\"https://profiles.wordpress.org/ramonopoly\">ramonopoly</a><a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a><a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a><a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a><a href=\"https://profiles.wordpress.org/shailu25\">Shail Mehta</a><a href=\"https://profiles.wordpress.org/smerriman\">Sr.smerriman</a>, <a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a>, <a href=\"https://profiles.wordpress.org/vcanales\">Vicente Canales</a>, <a href=\"https://profiles.wordpress.org/wongjn\">wongjn</a> e <a href=\"https://profiles.wordpress.org/ytfeldrawkcab\">ytfeLdrawkcaB</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Como contribuir</h2>\n\n\n\n<p>Para se envolver no desenvolvimento do núcleo do WordPress, dirija-se ao Trac, <a href=\"https://core.trac.wordpress.org/report/6\">escolha um ticket</a> e participe da conversa nos canais <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> de <a href=\"https://wordpress.slack.com/archives/C07BTF54N68\"></a><a href=\"https://wordpress.slack.com/archives/C07BTF54N68\">#6-7-release-leads</a>. Precisa de ajuda? Confira o <a href=\"https://make.wordpress.org/core/handbook/\">manual do colaborador do núcleo</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3123\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"Últimas vagas para o WordCamp Rio 2024!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://br.wordpress.org/2024/08/03/ultimas-vagas-para-o-wordcamp-rio-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://br.wordpress.org/2024/08/03/ultimas-vagas-para-o-wordcamp-rio-2024/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 03 Aug 2024 20:25:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WordCamps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://br.wordpress.org/?p=3104\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:356:\"WordCamps são eventos organizados pela comunidade do WordPress e um ótimo lugar para quem busca conhecimento, inspiração e novas amizades! Você é nosso(a) convidado(a) especial para viver a magia do WordPress no WordCamp Rio 2024, que acontece nos dias 16 e 17 de agosto. Serão dois dias totalmente dedicados ao WordPress em uma cidade que [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Andre Ribeiro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5570:\"\n<figure class=\"wp-block-image size-full\"><a href=\"https://riodejaneiro.wordcamp.org/2024\"><img loading=\"lazy\" decoding=\"async\" width=\"1023\" height=\"683\" src=\"https://br.wordpress.org/files/2024/08/wordcamprj-2016-foto-243.jpg\" alt=\"\" class=\"wp-image-3117\" srcset=\"https://br.wordpress.org/files/2024/08/wordcamprj-2016-foto-243.jpg 1023w, https://br.wordpress.org/files/2024/08/wordcamprj-2016-foto-243-300x200.jpg 300w, https://br.wordpress.org/files/2024/08/wordcamprj-2016-foto-243-768x513.jpg 768w\" sizes=\"auto, (max-width: 1023px) 100vw, 1023px\" /></a></figure>\n\n\n\n<p>WordCamps são eventos organizados pela comunidade do WordPress e um ótimo lugar para quem busca conhecimento, inspiração e novas amizades!</p>\n\n\n\n<p>Você é nosso(a) convidado(a) especial para viver a magia do WordPress no WordCamp Rio 2024, que acontece nos dias 16 e 17 de agosto.</p>\n\n\n\n<p>Serão dois dias totalmente dedicados ao WordPress em uma cidade que nos presenteia com toda a sua natureza exuberante e se consagra como um dos destinos mais belos e procurados do país.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Ambiente confortável para participantes e palestrantes</h2>\n\n\n\n<p>O WordCamp Rio vai receber pessoas de inúmeros cantos do Brasil. Para garantir que sejam recebidos em um ambiente moderno, inspirador e confortável, essa edição será divida em dois ambientes — um voltado para pessoas mais técnicas (como desenvolvedores) e outro mais geral para empresários, designers, redatores e entusiastas do WordPress.</p>\n\n\n\n<p>O espaço do primeiro dia de evento, 16 de agosto, será no WeWork do Bossa Nova Mall, um espaço moderno e vibrante que proporcionará um ambiente perfeito para as primeiras atividades do WordCamp Rio 2024. Será um dia voltado a colaboração com o WordPress.</p>\n\n\n\n<p>Já no dia 17 de agosto, o evento ocorrerá no Centro Cultural Justiça Federal (CCJF), um local que combina história e elegância para embalar o aprendizado e as conexões. Por lá teremos workshops e palestras sobre diferentes assuntos relacionados a WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Uma programação com palestras inspiradoras&nbsp;</h2>\n\n\n\n<p>O evento contará com <a href=\"https://riodejaneiro.wordcamp.org/2024/palestrantes/\" target=\"_blank\" rel=\"noreferrer noopener\">mais de 22 palestrantes incríveis</a> (+10 já anunciados) que ao longo dos dois dias de WordCamp abordarão inúmeros temas relacionados ao WordPress, como criação de conteúdo, marketing, negócios, inteligência artificial e muito mais.</p>\n\n\n\n<p><strong>Entre os nomes confirmados estão: Rodrigo Primo, Sandra Peres, Mônica Craveiro, Daniel Kossmann e Leo Baiano.&nbsp;</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">Por que você deve participar do WordCamp Rio 2024?</h2>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://riodejaneiro.wordcamp.org/2024\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://br.wordpress.org/files/2024/08/WordCamp-Rio-2024-1024x576.png\" alt=\"\" class=\"wp-image-3108\" srcset=\"https://br.wordpress.org/files/2024/08/WordCamp-Rio-2024-1024x576.png 1024w, https://br.wordpress.org/files/2024/08/WordCamp-Rio-2024-300x169.png 300w, https://br.wordpress.org/files/2024/08/WordCamp-Rio-2024-768x432.png 768w, https://br.wordpress.org/files/2024/08/WordCamp-Rio-2024.png 1200w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>O WordPress é o CMS mais utilizado no planeta. Criado em 2003 por Matt Mullenweg, o WordPress está presente em 45,3% de toda a web.&nbsp;</p>\n\n\n\n<p>Por isso, se você quer saber mais sobre esse universo, prepare-se para uma experiência única e imperdível. <strong>O foco desta edição é a Colaboração, Cultura e Negócios.</strong> Juntos, eles são os fundamentos que mantêm o WordPress vivo e em crescimento há tantos anos.&nbsp;</p>\n\n\n\n<p>E se você ainda está em dúvida se esse evento é para você. Confira 3 motivos que farão você querer fazer parte deste momento:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Aprendizado: Aumente seus conhecimentos sobre WordPress com os melhores profissionais da área.</li>\n\n\n\n<li>Networking: Conecte-se com outros apaixonados por WordPress e faça novas amizades.</li>\n\n\n\n<li>Inspiração: Descubra novas possibilidades e tendências para seus projetos.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Como adquirir seu ingresso:</h2>\n\n\n\n<p>O WordCamp Rio 2024 é uma oportunidade imperdível para designers, empreendedores, redatores, desenvolvedores e entusiastas do WordPress aprenderem mais sobre a ferramenta e se tornarem parte desta comunidade.</p>\n\n\n\n<p>Para participar, você pode adquirir seu ingresso <a href=\"https://riodejaneiro.wordcamp.org/2024/ingressos/\" target=\"_blank\" rel=\"noreferrer noopener\">através do site oficial do evento.</a> O ingresso custa R$ 95,00 (e também conta com uma opção com desconto para pessoas iniciantes com baixa renda).</p>\n\n\n\n<p>Se você quiser participar e também contribuir com a organização do evento, é só adquirir o ingresso micro patrocínio no valor de R$&nbsp;395,00. <strong>Mas corra que as vagas são limitadas!</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">Não moro no Rio de Janeiro: onde devo ficar?</h2>\n\n\n\n<p>Se você não mora no Rio de Janeiro, a organização do evento preparou uma lista com hotéis na região para você se hospedar.</p>\n\n\n\n<p>Confira a lista de hotéis e mais informações sobre a edição do WordCamp Rio 2024 <a href=\"https://riodejaneiro.wordcamp.org/2024/local/\" target=\"_blank\" rel=\"noreferrer noopener\">neste link</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://br.wordpress.org/2024/08/03/ultimas-vagas-para-o-wordcamp-rio-2024/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3104\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://br.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"13096052\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 11 Dec 2024 21:55:41 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Thu, 21 Nov 2024 16:18:57 GMT\";s:4:\"link\";s:61:\"<https://br.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";i:1731463280;s:21:\"cache_expiration_time\";i:1733997341;s:23:\"__cache_expiration_time\";i:1733997341;}", "off");
INSERT INTO `wp_options` VALUES("40852", "_transient_timeout_feed_mod_b85365aa61afaf3d4189819a6f57c4c4", "1733997341", "off");
INSERT INTO `wp_options` VALUES("40853", "_transient_feed_mod_b85365aa61afaf3d4189819a6f57c4c4", "1733954141", "off");
INSERT INTO `wp_options` VALUES("40854", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1733997342", "off");
INSERT INTO `wp_options` VALUES("40855", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Court Grants WP Engine Preliminary Injunction Against Automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=182125\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/court-grants-wp-engine-preliminary-injunction-against-automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6304:\"<p>Judge Araceli Martínez-Olguín of the Northern California District Court has granted WP Engine’s motion for a <a href=\"https://storage.courtlistener.com/recap/gov.uscourts.cand.437474/gov.uscourts.cand.437474.64.0.pdf\">preliminary injunction</a> against Automattic and Matt Mullenweg. The ruling follows a November 26, 2024, hearing where the judge <a href=\"https://wptavern.com/wp-engine-v-automattic-judge-inclined-to-grant-injunction-orders-status-quo\">expressed an inclination</a> to approve WP Engine&#8217;s request for injunction. Both parties were directed to collaborate on a stipulated order, but having failed to reach an agreement, they submitted competing proposals on December 2, 2024.</p>\n\n\n\n<p>The Court directed Automattic and Matt Mullenweg to immediately stop:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Blocking or interfering with WP Engine’s access to WordPress.org.</li>\n\n\n\n<li>Disrupting WP Engine’s control over its plugins hosted on WordPress.org.</li>\n\n\n\n<li>Interfering with WP Engine-related WordPress installations via unauthorized auto-migration or updates.</li>\n</ol>\n\n\n\n<p>Also within 72 hours, Automattic and Matt must:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Remove WP Engine customer data from the “domains.csv” file on the <a href=\"https://wptavern.com/automattic-launches-wp-engine-tracker-to-monitor-sites-leaving-wp-engine-sparking-controversy\">WP Engine Tracker website</a>.</li>\n\n\n\n<li>Restore WP Engine’s <a href=\"https://wptavern.com/wp-engine-banned-from-using-wordpress-org-resources\">WordPress.org access</a>, including employee login credentials, to the state of September 20, 2024.</li>\n\n\n\n<li>Remove the <a href=\"https://wptavern.com/wordpress-org-login-gets-mandatory-affiliation-checkbox-following-wp-engine-dispute\">mandatory checkbox</a> on the WordPress.org login page.</li>\n\n\n\n<li>Reinstate WP Engine’s access to the<a href=\"https://wptavern.com/acf-plugin-forked-to-secure-custom-fields-plugin\"> Advanced Custom Fields (ACF)</a> plugin.</li>\n</ul>\n\n\n\n<p>In granting the injunction, the Court evaluated the four Winter elements.</p>\n\n\n\n<p><strong>Success on the Merits</strong>: The Court found that WPEngine is likely to succeed on the merits of its intentional interference with contractual relations claim and Automattic’s arguments do not compel a different conclusion.</p>\n\n\n\n<p><strong>Irreparable Harm</strong>: The court determined that WP Engine’s evidence of harm, including the loss of a $40,000 client contract, was persuasive. Defendants countered with four arguments but “None is persuasive.” The court accepted that WPEngine will suffer irreparable harm without preliminary injunctive relief.</p>\n\n\n\n<p><strong>Balance of Equities</strong>: Banning WP Engine from accessing WordPress.org, taking over ACF plugin, and the additional burdens imposed on WPEngine’s customers demonstrates that WPEngine has a significant interest in obtaining preliminary injunctive relief and Automattic’s arguments in opposition do not establish that they will suffer any damage that overrides WPEngine’s interest in obtaining relief. Thus the balance of hardships tips in favor of WP Engine.</p>\n\n\n\n<p><strong>Public Interest</strong>: The court said the public consequences of withholding injunctive relief are significant as Mullenweg himself acknowledges that more than 40% of all websites run on WordPress. Those who depend on WordPress&#8217;s stability should not be forced to endure the uncertainty, financial losses, and increased operational costs arising from the ongoing dispute between the parties. Thus, “the final Winter element – the public interest – weighs in favor of granting preliminary injunctive relief.”</p>\n\n\n\n<p>The Court accepted WP Engine’s claims of irreparable harm, citing losses of existing and potential customers, damage to customer relationships, market share erosion, harm to goodwill and reputation, and broader negative impacts on the WordPress community.&nbsp;</p>\n\n\n\n<p>WP Engine told the court that the company experienced a 14% increase in the average number of daily cancellation requests between September 26 and 30, and an increase of 17% in cancellation requests between October 1 and October 14, as compared to September 1 through September 25. The Court concluded that WP Engine would suffer irreparable harm without injunctive relief.&nbsp;</p>\n\n\n\n<p>The Court also declined to require WPEngine to post a bond as “the Court finds that any harm to Defendants resulting from the issuance of preliminary injunctive relief is unlikely, as it merely requires them to revert to business as usual as of September 20, 2024.”</p>\n\n\n\n<p>Automattic responded to the ruling on <a href=\"https://x.com/automattic/status/1866644684057248090\">Twitter</a>, “Today’s ruling is a preliminary order designed to maintain the status quo. It was made without the benefit of discovery, our motion to dismiss, or the counterclaims we will be filing against WP Engine shortly. We look forward to prevailing at trial as we continue to protect the open source ecosystem during full-fact discovery and a full review of the merits.”</p>\n\n\n\n<p>WP Engine also <a href=\"https://x.com/wpengine/status/1866691174599131634\">tweeted</a>, “We are grateful that the court has granted our motion for a preliminary injunction that restores access to and functionality of wordpressdotorg for WP Engine, its customers and its users. This ruling provides much-needed stability for the WordPress ecosystem. We deeply appreciate our customers for their continued trust and support. We remain committed to serving them and their sites with the performance, availability and integrity they deserve while collaborating to ensure a vigorous, thriving and stable WordPress community.”</p>\n\n\n\n<p>The ruling does not mention anything about the “Secure Custom Fields” (<a href=\"https://wordpress.org/plugins/secure-custom-fields/\">https://wordpress.org/plugins/secure-custom-fields/</a>) plugin that WordPress.org released with <a href=\"https://wptavern.com/wordpress-org-releases-new-secure-custom-fields-plugin-with-acf-pro-features\">ACF Pro features</a>.&nbsp;</p>\n\n\n\n<p>The preliminary injunction is effective immediately and will remain in place until a final judgment is issued after the trial.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Dec 2024 17:50:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WordPress.org blog: Openverse.org: A Sight for Sore Eyes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18168\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2024/12/openverse-org-a-sight-for-sore-eyes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3810:\"<img width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Dark-home-with-yellow-background.png?resize=1024%2C576&ssl=1\" alt=\"\" class=\"wp-image-18196\" />\n\n\n\n<p><a href=\"https://openverse.org/\">Openverse.org</a>, the vibrant platform for openly licensed media, has introduced a sleek and modern Dark Mode feature. This new site theme is designed to enhance users&#8217; comfort and style as they explore the extensive library of creative resources. Whether for late-night browsing or simply a preference for darker aesthetics, Dark Mode makes engaging with Openverse easier on the eyes and more personalized than ever.</p>\n\n\n\n<p>By reducing screen brightness in low-light settings, Dark Mode offers a more relaxed viewing experience, helping to minimize eye strain. It also caters to users with light sensitivity, creating a more inclusive browsing environment. This thoughtful addition underscores Openverse’s commitment to delivering tools that are as functional as they are visually appealing.</p>\n\n\n\n<div class=\"wp-block-jetpack-slideshow\"><div class=\"wp-block-jetpack-slideshow_container swiper-container\"><ul class=\"wp-block-jetpack-slideshow_swiper-wrapper swiper-wrapper\"><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><img width=\"1024\" height=\"573\" alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-18188\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Audio-results-and-player-2.png?resize=1024%2C573&ssl=1\" /></li><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><img width=\"1024\" height=\"545\" alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-18189\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Search-results-switcher-2.png?resize=1024%2C545&ssl=1\" /></li><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><img width=\"1024\" height=\"553\" alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-18195\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Audio-single-page.png?resize=1024%2C553&ssl=1\" /></li></ul><a class=\"wp-block-jetpack-slideshow_button-prev swiper-button-prev swiper-button-white\"></a><a class=\"wp-block-jetpack-slideshow_button-next swiper-button-next swiper-button-white\"></a><a class=\"wp-block-jetpack-slideshow_button-pause\"></a><div class=\"wp-block-jetpack-slideshow_pagination swiper-pagination swiper-pagination-white\"></div></div></div>\n\n\n\n<p>The release of Dark Mode is part of Openverse’s broader effort to innovate and adapt to the needs of its growing community. From the thoughtful interface design to the careful attention to accessibility, every detail was crafted to reflect Openverse’s mission of empowering creativity. By embracing modern frontend implementations like Dark Mode without compromising usability or accessibility, Openverse continues to grow while honoring the brand’s essence. In addition, this update lays the groundwork for future developments aimed at providing even more customization options and improved user experiences.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p><em>“Dark Mode marks an exciting step forward for Openverse. We designed and implemented a new user interface that keeps the brand&#8217;s essence while providing the same search experience. We’re thrilled to see how this feature fits within users&#8217; preferences and enhances the creative journey.”&nbsp; – Francisco Vera. Designer</em></p>\n</blockquote>\n\n\n\n<p></p>\n\n\n\n<img width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Theme-switcher-flow.gif?resize=1024%2C576&ssl=1\" alt=\"\" class=\"wp-image-18174\" />\n\n\n\n<p>Ready to explore Openverse in a whole new light? Head to <a href=\"https://openverse.org/\">Openverse.org</a> today and look for the Dark Mode toggle in the site footer.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Dec 2024 17:45:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WPTavern: #149 – Corey Maass on Optimising WordPress Images\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=182072\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wptavern.com/podcast/149-corey-maass-on-optimising-wordpress-images\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:55532:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, optimizing images in your WordPress projects.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice. Or by going to wptavern.com/feed/podcast. And you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Corey Maass. Corey has been building for the web since 1996, with a focus on WordPress since 2011. He started his first SaaS app in 2004, and is launched dozens since. For over 10 years, he&#8217;s combined his love for entrepreneurship and WordPress by building, launching, and selling numerous WordPress plugins and SaaS apps built on WordPress. Currently he&#8217;s focused on the OMGIMG WordPress plugin.</p>\n\n\n\n<p>In this episode, Corey talks about the role of social media, and your websites, presence on social platforms. He talks about how optimized web sharing images are important in today&#8217;s digital landscape. He explains how shareable webpages on platforms like X, and Facebook, drive online traffic more than direct visits, and emphasizes the power of third party endorsements in adding credibility and authenticity.</p>\n\n\n\n<p>He discusses the need for efficient, user-friendly, solutions built for this task, right inside of WordPress. A time-saver for anyone tasked with updating content in multiple places.</p>\n\n\n\n<p>Corey also talks about the latest technological advancements, including WebAssembly, and how modern image formats like WebP and AVIF can offer higher quality images with smaller file sizes.</p>\n\n\n\n<p>We get into the challenges and future improvements due to come in the WordPress Media Library. The significance of dedicated tools for image creation, and how Corey&#8217;s OMGIMG plugin leverages is in-browser capabilities to simplify image handling without relying on server side processes.</p>\n\n\n\n<p>Towards the end, Corey shares his insights on how custom social images can enhance engagement and conversions, and the importance of optimized images in improving online content presentation.</p>\n\n\n\n<p>If you&#8217;re a WordPress user looking to streamline your workflow, and boost your social media game, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes</p>\n\n\n\n<p>as well. And so, without further delay, I bring you Corey Maass.</p>\n\n\n\n<p>I am joined on the podcast today by Corey Maass. Hello Corey.</p>\n\n\n\n<p>[00:03:35] <strong>Corey Maass:</strong> Hello.</p>\n\n\n\n<p>[00:03:36] <strong>Nathan Wrigley:</strong> Very nice to have you with us. Corey&#8217;s joining us today and we&#8217;re going to talk about images, which we haven&#8217;t done for the longest amount of time. It may seem like images are, well, a pretty obvious subject, but there&#8217;s a load more to it, especially in the recent past. Things have been changing within browsers and within WordPress.</p>\n\n\n\n<p>Corey, just before we begin that, I wonder, would you mind just telling us a little bit about your background, especially with WordPress, and some of the things that you&#8217;ve created in the WordPress space. I know you&#8217;ve been on the podcast before, but people might like to hear it again, or if they&#8217;ve never heard your voice, they&#8217;d hear it for the first time.</p>\n\n\n\n<p>[00:04:06] <strong>Corey Maass:</strong> I honestly have to describe what I look like. There&#8217;s no end of irony that we&#8217;re going to talk about imagery on an audio only podcast. I also got all dressed up. I&#8217;m here in a bird suit, with a mohawk, and disco ball glasses, but nobody can see it.</p>\n\n\n\n<p>But there is something to be said, I mean, maybe we&#8217;ve actually made a higher level point here of just how powerful imagery can be.</p>\n\n\n\n<p>Anyway, hello, hello. I&#8217;m Cory Maass. I currently live in New Hampshire in the northeast of the United States. I&#8217;ve been building websites since the late nineties. Yes, I am that old. Experienced, wizened.</p>\n\n\n\n<p>I caught the SaaS entrepreneurial bug in the early two thousands, and so I&#8217;ve got a long history of building websites, building web apps, trying to build businesses online.</p>\n\n\n\n<p>Along the way WordPress started taking off, and I think I got started around 2010 with WordPress. For a long, long time was building WordPress websites for clients during the day as a freelancer, and then working on SaaS apps and other products at night. And then at some point went to, I was living in Nashville at the time, and I went to WordCamp Atlanta and met a bunch of people who were building successful businesses within WordPress, off of plugins in particular. And I went, what am I doing? Why am I separating, keeping these things separated?</p>\n\n\n\n<p>Ever since then, my focus has been, I still freelance during the day, but also building products and services around WordPress, because WordPress just keeps getting bigger and bigger, and people seem to like it.</p>\n\n\n\n<p>[00:05:41] <strong>Nathan Wrigley:</strong> Do you want to just tell us some of the products that you&#8217;ve had? I mean, some of them may have come and gone. I&#8217;m not sure if they&#8217;ve all stood the test of time, but it&#8217;d be interesting to hear the range of things that you&#8217;ve built.</p>\n\n\n\n<p>[00:05:51] <strong>Corey Maass:</strong> Yeah, the first big product that I built was Kanban Board, so kind of a Trello built into WordPress. Because at the time I was CTO at a music startup. It was Nashville after all. And running a small tech team, we didn&#8217;t need any of the big, big Jira style project management suites. And being a typical developer, I can&#8217;t bring myself to use somebody else&#8217;s product. I have to build it myself.</p>\n\n\n\n<p>I actually saw value, since we&#8217;re dipping into, at least my original vision was we were dipping into WordPress all day, every day. And if I&#8217;m working with clients who are signing into WordPress, why make them sign into something else?</p>\n\n\n\n<p>And then also GDPR was starting to take hold. There were a lot more concerns about privacy and where is your data stored, and especially for project management, a lot of this stuff can be proprietary.</p>\n\n\n\n<p>And so I ran that for a handful of years. Grew it to some success, but never enough to become my day job. It was a lot of fun. Some interesting use cases. It wound up being used more by small HVAC companies, you don&#8217;t know what that is. Heating and air conditioning type companies, because most of them had some sort of basic WordPress brochure site. And then they had, somebody&#8217;s nephew worked in house as the, quote unquote, IT guy. And so here&#8217;s just an easy way to get everybody to use a simple project management, or in this case more like sales tracking going sideways, or account tracking.</p>\n\n\n\n<p>Somebody had called and made an appointment, the truck is out, the repairs are done, we&#8217;ve ordered the parts, blah, blah, blah. You know, as you move across columns.</p>\n\n\n\n<p>Sold that, probably five years ago now, and then started, very typical developer. So I&#8217;m also a musician, DJ and music producer, and was doing more marketing for myself as a musician for a while there. Again, typical developer, everybody around me was using Linktree as a, that one pager. About.me is another one. Or Carrd, with two Rs is another one.</p>\n\n\n\n<p>Typical me, I was like, I will not pay $8 a month. I will dedicate hundreds of hours of my life to build my own. But I actually, again, I saw a good use case inside WordPress, and it was an interesting experience because I did submit a free version to the plugin repo, and the plugin team initially pushed back hard because they&#8217;re like, you basically built WordPress inside WordPress. Why would you do this?</p>\n\n\n\n<p>But I&#8217;m like, there&#8217;s a difference between all of the pages on your website and the one page, mobile friendly, landing page that you&#8217;re going to link to from all of your socials. Very different use case.</p>\n\n\n\n<p>They did eventually approve it. Ran that for a few years, but it was never, again, I built it because I could, not because I was really so impassioned with it. I used it, I still actually use it. But then I sold that two years ago at WordCamp US. I stood up in the cafeteria and held up a placard, that&#8217;s not true, but did meet with the buyer at WordCamp US, which was great because we got to actually go over all the documentation and everything in person. And he took that and ran with it.</p>\n\n\n\n<p>I was offloading that. Again, I built it because I could, not because I really was in love with that concept. And then also I had started working with Cory Miller on what was to become OMGIMG, which is my current plugin that I&#8217;m building, promoting, pushing.</p>\n\n\n\n<p>Fast forward to now where, again, freelancing during the day, but also working hard to flush out the product that I&#8217;m currently working on called OMGIMG, which builds featured images, generates featured images edits, featured images, but also open graph images, the images that you see when you share a URL on Twitter, now X, or Facebook, or LinkedIn, or any of those. That little preview that you see, that image, that&#8217;s called an open graph image. A lot of people just call it the social image. But it&#8217;s kind of a hole in a lot of people&#8217;s WordPress websites, and so that&#8217;s the problem I&#8217;m trying to solve.</p>\n\n\n\n<p>[00:09:50] <strong>Nathan Wrigley:</strong> We&#8217;ll get into that I think a little bit later, because it&#8217;d be really interesting to think about whether a featured image has certain success criteria attached to it, if you know what I mean. Especially if you want to deploy it in certain places, like maybe a YouTube thumbnail image, or something like that, or a blog post image. I wonder if there&#8217;s certain criteria which tick boxes for success and otherwise.</p>\n\n\n\n<p>But before we get to that, I think it&#8217;s really interesting, if you rewound the clock 25 years, the internet was text, basically it was just text. It was a bunch of texts with hyperlinks and that was it.</p>\n\n\n\n<p>Fast forward, images come along. And now really it&#8217;s more or less everything. It&#8217;s audio, it&#8217;s video, and increasingly I think audio and video are kind of, especially video, are really taking over. It&#8217;s dramatic what can be done on the internet more broadly, including apps and things like that.</p>\n\n\n\n<p>But images, a seriously important part of it. And if you were to strip out images from just about any website that you visit on a daily basis, and take a look at it. It would probably feel, kind of a poor version of the original. So images are really important.</p>\n\n\n\n<p>For the longest time, we&#8217;ve been familiar with the image formats of JPEG and PNG, that&#8217;s how I pronounce it. I&#8217;m sorry, I know people pronounce it in different ways, like ping and so on. But more recently there&#8217;s been some images, new formats coming along out of some different companies. So for example, Google, I think were behind the WebP image format. And I don&#8217;t know who&#8217;s behind the AVIF image format, but I know that&#8217;s gaining in popularity.</p>\n\n\n\n<p>The browser support, depending on which month you&#8217;re listening to this in will be different. But it&#8217;s climbing and climbing, to the point where I think most of those image formats can be fairly used.</p>\n\n\n\n<p>There&#8217;s a whole environmental debate about pushing pixels around, and whether or not that&#8217;s good for the environment. You know, a large image that doesn&#8217;t need to be large is pointless and wasteful.</p>\n\n\n\n<p>Then you&#8217;ve got things like SVGs, scalable vector graphics. The point is it&#8217;s complicated, and it&#8217;s getting more complicated.</p>\n\n\n\n<p>Where are we right now in terms of the state of images? Should we now no longer be using things like JPEGs and PNGs? Should we be using these more modern WebPs and AVIF formats?</p>\n\n\n\n<p>[00:11:53] <strong>Corey Maass:</strong> 50, 50. There&#8217;s no right answer, or there&#8217;s no clear answer. It&#8217;s Google, right? So they were hyping their new format, which in many instances is better. In that you can push higher quality images, bigger images, essentially by having a file size be smaller, they will be delivered faster.</p>\n\n\n\n<p>But I&#8217;ve found that it&#8217;s not a hundred percent better. It was supposed to be the silver bullet. But I mean, there&#8217;s a reason why these other image standards came along and have stuck around for so long, they have solved a problem, right? And at the end of the day, there are still zeros and ones behind all of this. And so you can only push things so far. You can only encode so much data at such a small size or whatever.</p>\n\n\n\n<p>So there&#8217;s no harm in using these things. Personally I struggle with, this is a very edge case scenario, but I struggle with these other formats because they don&#8217;t download easily and, or you can&#8217;t necessarily download them and then view them in other apps, or you can&#8217;t drag them from window to window. And most people don&#8217;t use the internet like I use the internet, I&#8217;m a developer, and site maintainer, and whatnot. So I&#8217;m constantly interacting with things. But that&#8217;s another little thing.</p>\n\n\n\n<p>So for me, what I advise most of my clients to do is stick with PNG if it&#8217;s graphics, big blocks of color. JPEG if it&#8217;s photo, lots of detail, gradients. And then we use a plugin. And there are a number of plugins for WordPress that will convert to these other formats. And so then you kind of don&#8217;t have to worry about the delivery.</p>\n\n\n\n<p>And the other thing that we&#8217;re running into now is people taking pictures with their phones, which again ends up being HEIC, another format, which is not easily, previewable in some apps, depending on what platform you use and yada, yada, yada.</p>\n\n\n\n<p>So these days it&#8217;s complicated. Pictures should be a picture, should be a picture in theory. But from a tech standpoint, there&#8217;s all these different formats, and there&#8217;s these different aspects to it. I generally have my clients, I try to get them to compress images before they upload. But there are also services that will run in the background and compress images. But if it&#8217;s done automatically, there&#8217;s nobody there to see it. If an image is compressed on a server, but there&#8217;s nobody there to see it, did it really happen?</p>\n\n\n\n<p>But realistically, you know, you&#8217;d rather have somebody compress it locally, verify that it looks good before uploading it, and then WordPress might resize it anyway, which might undo some of the compression and on, and on, and on.</p>\n\n\n\n<p>[00:14:20] <strong>Nathan Wrigley:</strong> I think WordPress has taken quite a few interesting steps in terms of images in the more recent past. I couldn&#8217;t point to the exact version number, not off the top of my head, or the date and month when it happened, but in the more recent past, WordPress has taken the initiative in cropping, for want of a better word, the file size of an image.</p>\n\n\n\n<p>So if you upload some gigantic image and you haven&#8217;t in some way fiddled with your WordPress website, it&#8217;s now going to scale that back to, I think it&#8217;s something like two and half thousand pixels wide by whatever the dimensions would be for its height.</p>\n\n\n\n<p>[00:14:50] <strong>Corey Maass:</strong> Which is sensible.</p>\n\n\n\n<p>[00:14:50] <strong>Nathan Wrigley:</strong> Yeah, I mean most people looking at that, even on a large monitor, it would still be pretty acceptable. But the idea would be cut out waste. Delete the original one which has no purpose sort of living anywhere, because it&#8217;s never going to be displayed.</p>\n\n\n\n<p>But also, WordPress in this version that just got released, so 6.7 just the other day, is starting to convert HEIC images, which you mentioned, which I believe is an Apple format.</p>\n\n\n\n<p>[00:15:15] <strong>Corey Maass:</strong> High efficiency image file format.</p>\n\n\n\n<p>[00:15:18] <strong>Nathan Wrigley:</strong> The idea being that an iPhone creates these, and if you are in the Apple ecosystem, and you view everything on Apple products, you would never know that that was a quirky image format that not everything can view.</p>\n\n\n\n<p>[00:15:29] <strong>Corey Maass:</strong> Until you try to upload it to various platforms.</p>\n\n\n\n<p>[00:15:31] <strong>Nathan Wrigley:</strong> Right, and until 6.7 in WordPress, if you tried to upload it to WordPress, it would do nothing. Now, because it&#8217;s non-viewable in most browsers.</p>\n\n\n\n<p>[00:15:40] <strong>Corey Maass:</strong> Safari only.</p>\n\n\n\n<p>[00:15:41] <strong>Nathan Wrigley:</strong> Yeah, I was going to say, I expect that Safari would be the one that it would be available on, given that it&#8217;s Apple&#8217;s own browser. WordPress will now do a conversion on the fly and turn it into an equivalent JPEG, without you having to think.</p>\n\n\n\n<p>If I was to talk to a non-technical user, so just walk down the street, find some random user of the internet, but has no history with web development and just ask them, what&#8217;s a PNG? What&#8217;s a jpeg? What&#8217;s an HEIC? I don&#8217;t know. No idea, and I don&#8217;t care. Do you like looking at pictures online? Yes. Do you know what image format it is? No. And they don&#8217;t want to know.</p>\n\n\n\n<p>And it is the kind of technology which you hope would go away. You know, you don&#8217;t really want to, in a WordPress website, care about any of this. You just want it all to work. But I suppose the stumbling block is the browser support. If, for example, WebP is non-visible, I don&#8217;t know, I&#8217;m guessing here, in Firefox, then that&#8217;s a problem and you have to fall back to previous defaults that will work like JPEG. So it&#8217;s an interesting time that we live in.</p>\n\n\n\n<p>[00:16:34] <strong>Corey Maass:</strong> We&#8217;ve gone through this before. I remember when PNG came out and you had to have a fallback from JPEG to PNG. The oscillations will lessen. There&#8217;s a less nerdy way to say that. It&#8217;ll smooth itself out in the end.</p>\n\n\n\n<p>But yeah, you&#8217;re absolutely right. To me it&#8217;s analogous to people who are growing up with the internet now, often don&#8217;t know what a file is, because they&#8217;re just used to working in the cloud, right? So open a document, ie, click on a link so that you&#8217;re viewing it. But there&#8217;s no sense of putting it somewhere on your hard drive, and then having an index that points to it kind of thing, right? It&#8217;s just a list of files, and you click on them, and everything in the browser.</p>\n\n\n\n<p>And frankly, that&#8217;s how it should be. There&#8217;s reasons to download files for backup purposes and to not have Google own everything that you do. Not that they don&#8217;t already have a copy. But aside from that, we&#8217;d like it to be, and most of the internet works just fine in that you can take a picture, upload it to Instagram, regardless of what kind of device you&#8217;re on, and show it to the world. And that&#8217;s kind of how we want the internet to work. But yeah, from a technical standpoint, in the background there are all these little levers and gears that need to run.</p>\n\n\n\n<p>[00:17:44] <strong>Nathan Wrigley:</strong> Yeah, it&#8217;s interesting. If you look on an iPhone, typically, if you take a picture it just goes into, let&#8217;s call it the camera roll. And the camera roll just feels like a bucket. It&#8217;s not a file system, is it? It&#8217;s just, you open the photos app, look there, they all are, and they&#8217;re organised by date. But there&#8217;s no notion that that is a file. Look, it&#8217;s the picture, there&#8217;s the picture.</p>\n\n\n\n<p>And I think to some extent we&#8217;ve got the same thing in WordPress, haven&#8217;t you? With the Media Library. It&#8217;s just, well, where are your pictures? Well, they&#8217;re in that thing there. It&#8217;s called the Media Library, and you click on it with no conception that there&#8217;s a whole stack of different things going on in the background to upload them into files on a server somewhere, which are organized possibly by date or what have you. And it&#8217;s all going on in background, but nobody wants to know for a good reason.</p>\n\n\n\n<p>[00:18:24] <strong>Corey Maass:</strong> WordPress natively puts your images in a year, and then month directory, but that&#8217;s not represented in the Media Library, which is just confounding. You never stop seeing requests on Reddit, or Twitter, or wherever, and even a client came to me recently and was like, can we have folders in the Media Library?</p>\n\n\n\n<p>And I&#8217;m like, there are a couple of plugins, and I&#8217;ve tried them over the years with degrees of success, I&#8217;m sure they&#8217;ve ironed out the wrinkles at this point. When I tried them five years ago when I was like, I really want directories, I found that they bogged the site down because they were constantly running in the background. I&#8217;m sure, again, most tech has been updated, but bugs have been fixed.</p>\n\n\n\n<p>But it&#8217;s a dump, right? And so you hope that, in this day and age, yet another compelling reason like, please, anybody who ever uploads an image, give it a good alt tag for all the right reasons. But if you&#8217;re selfish, if nothing else, the fringe benefit is that the words and the alt tag are what are going to let you search for your images. Also give it a caption, also give it a title.</p>\n\n\n\n<p>But all of these things are how you&#8217;re going to find images. Otherwise, like one of my primary client websites is a magazine that&#8217;s been online for 12 years. There&#8217;s 12, literally 12,000 posts, and tens of thousands of images. And so trying to find something from last year, you just can&#8217;t. You&#8217;re just scrolling, scrolling, scrolling. Skimming, skimming, skimming, and dumb luck if your eye happens to fall on the right image at the right time. Like, there&#8217;s just no coming back from that basically. Like you said, it&#8217;s just one big camera roll.</p>\n\n\n\n<p>[00:19:58] <strong>Nathan Wrigley:</strong> It would be kind of nice, and I think that there&#8217;s initiatives to really wrangle the Media Library into something a little bit more akin to something usable for the edge cases that you described. But it&#8217;s the 80 20 rule in WordPress, isn&#8217;t it? You know, if 80% of the people need it, then it will be put into Core.</p>\n\n\n\n<p>[00:20:17] <strong>Corey Maass:</strong> And there are, again, a couple of great plugins for adding essentially virtual, but it feels real, directories. The problem is, right, you have to, essentially it&#8217;s the same as tagging posts. And so you really want to have started that at the beginning. I pulled this site over from, it was a Drupal. I wound up migrating this site over from Drupal with, again, 12,000 posts, and tens of thousands of images, damage done.</p>\n\n\n\n<p>We could start putting images in directories now, not actually a bad thing, but we&#8217;re relying largely on tags, on descriptions on recent, the fact that they float to the top essentially. Because it ends up adding more complexity. Like there&#8217;s definitely a lot of use cases for having media directories. I would really love a directory, or a folder, a virtual folder that has logos and other assets like that in it, so that you always know where to go grab the right logo, formatted correctly. Maybe it&#8217;s got a transparent background or not. Black on white, white on black, these kinds of things.</p>\n\n\n\n<p>But all of the images that go with posts, given that we publish half a dozen every day, those images are going to end up going down, down, down anyway. How would you categorise them other than month and day, which hopefully we could pick up from the actual directories that they&#8217;re in on the server kind of thing.</p>\n\n\n\n<p>[00:21:41] <strong>Nathan Wrigley:</strong> It&#8217;d be kind of interesting in the future to see if AI could do a job of backfilling. As an example, here are all the images of cats in your WordPress website. Here&#8217;s every image that&#8217;s got some background transparency in it. Here are things which we suspect might be logos, here&#8217;s everything with blue in it, and you get the idea. And in that way, the AI could probably backfill it.</p>\n\n\n\n<p>But you&#8217;re right, I would basically want something a bit like the options that you have in the Finder or Windows Explorer inside the Media Library. So the option to, I don&#8217;t know, zoom in so that the icons become really large. If I pull some kind of slider left and right I can increase the size, decrease the size. I can put them in a list view. I can see by folder structure, that would be really great.</p>\n\n\n\n<p>But obviously for historical reasons, that&#8217;s not what WordPress did. And we&#8217;ve got stuck with the legacy of it. But like I say, the work is being done to modify that, and we&#8217;ll have to see as 2025 rolls along, not the theme, the year. We&#8217;ll see if any of that has an impact, I think it will.</p>\n\n\n\n<p>The other thing to say is that there&#8217;s some interesting work going on with technologies like WebAssembly to do a lot of interesting things within the browser. So I will link in the show notes to some videos that I saw probably six months ago, maybe more now, by a Googler who&#8217;s in the WordPress space called Pascal Birchler. And he has been working on blocks which consume, for example, let&#8217;s say a JPEG. You drag a JPEG in from your computer. Drag it onto the block editor. The block editor will then recognise that that&#8217;s an image. But you would tell that block, okay, every time a JPEG is put up, please convert it into a PNG, for example, or whatever you like, and make it this dimension. So crop it in this way, in that way.</p>\n\n\n\n<p>And all of that is happening kind of interestingly, not by sending it off to some server somewhere, which is what typically happens now, but it&#8217;s happening inside the browser. The browser and your local computer are doing all the necessary grunt work to make that happen. And it happens right in front of your eyes in a heartbeat. So by the time you&#8217;ve dragged it in and it&#8217;s taken, you know, a few milliseconds really to display it on the screen, it&#8217;s all happened. And you are now looking at the result of that.</p>\n\n\n\n<p>And he&#8217;s also been working on video in the same way, you know, cropping video, and minimising the footprint of video, and what have you. It&#8217;s really interesting work. An easier time of it in the future with images, and videos, and things like that, and the browser handling a lot of the heavy lifting.</p>\n\n\n\n<p>[00:24:03] <strong>Corey Maass:</strong> This is the modern web. There&#8217;s so much that JavaScript can now do, and it&#8217;s been moved a little bit to the server side, or it can be moved to the server side, which I think in part is what has empowered it to become more powerful in the front end browser.</p>\n\n\n\n<p>So as you and I are sitting here chatting, we are looking at each other and recording this, and a lot of this is just going to be in browser functionality. It&#8217;s not necessarily relying on some connection to some server. You hope it does, so that if my computer shuts down, I don&#8217;t lose everything.</p>\n\n\n\n<p>But this is what allows a lot of the web apps that we&#8217;re now seeing to function, including my own OMGIMG plugin is image rendering in the browser. It&#8217;s incredibly powerful, it&#8217;s not totally foolproof, but it gives you most of the options for most of the things that you need. And I&#8217;m seeing, recently I was looking at a library that was using React, which is essentially a framework for JavaScript, that would let you build or design, and then render out videos.</p>\n\n\n\n<p>And so I was specifically looking at it for a new webpage that I&#8217;m building, I want to have an explainer, so-called explainer video at the top. Click on this to see a demo of the product kind of thing. And rather than trying to capture footage of a screencast of me clicking around, and then dragging that into iMovie or something, and editing it all together. Actually using JavaScript to programmatically say, grab these frames, or grab this screenshot. Put them together in such and such a way, click a button, and then it&#8217;ll download an MP4 that I can do whatever with.</p>\n\n\n\n<p>And all of it in the browser. That&#8217;s the backend, and then there&#8217;s front end products. Like I know that Canva, incredibly powerful browser editor. Also like you said, WebAssembly. And so it&#8217;s JavaScript and good product development combined with these very, very powerful in browser capabilities that we have now, libraries. There&#8217;s so much we can do, and again, so much less of it relies on external services or the server.</p>\n\n\n\n<p>That was actually one of the things that, when Corey and I first came up with the idea for OMG, I had already built an external service for taking screenshots. And then when I went back and looked at it, I was like, wait, I can just do this in the browser. Like I don&#8217;t actually have to talk to a third party. And it was one of the initial differentiators and still maybe, I think it is still. So compared to the few other products that do similar things, most of them rely on talking to a third party product, or talking to the backend, and OMG is entirely in the browser.</p>\n\n\n\n<p>So there&#8217;s fewer concerns about tech requirements. There&#8217;s fewer concerns about privacy. There&#8217;s fewer concerns about bandwidth or whatever. Like WordPress wants to be self-contained. That&#8217;s one of the things that&#8217;s always been great about it, and why I&#8217;ve long advocated for, if you have a WordPress install, turn it into whatever you want it to be.</p>\n\n\n\n<p>You know, use it to run your business, let it do product management, or let it be your to-do list, or all these things, because it&#8217;s essentially an operating system and you can run software within that operating system and you control it all.</p>\n\n\n\n<p>And so with that ethos in mind, here&#8217;s a way that you can generate images, manipulate images, or as the example you brought up, also video. But imagine doing all of that built right into a thing that you own safely on the internet, you&#8217;re not reliant on third party products or whatnot. You just have to have a modern enough computer, and probably a browser like Chrome.</p>\n\n\n\n<p>[00:27:38] <strong>Nathan Wrigley:</strong> I do remember when Google first launched their Chromebook initiative, and I remember thinking, what&#8217;s the point of that? You know, it&#8217;s got no memory, as in storage, why would anybody want that? And as time has crept on, we&#8217;re probably a decade or more into that project, I kind of see the utility of it more and more. I mean, in my case, I&#8217;d still want some of the power that the operating system that I prefer has. So for example, doing audio editing, you&#8217;ll know about that, and video editing. There&#8217;s just so much that needs a bit of horsepower.</p>\n\n\n\n<p>But for a typical user, I think we are reaching the point where the browser can do the vast majority of what you want it to do. And WordPress can be the fulcrum of that. I mean, it won&#8217;t do everything unless somebody builds a credible plugin for it.</p>\n\n\n\n<p>But your example is perfect. So we are recording on an online platform at the moment. We&#8217;re both in a browser. We&#8217;re watching the video. It&#8217;s recording the audio. It&#8217;s sending that data synchronously to some server somewhere so that there&#8217;s a backup if we get cut off. It can have up to 10 people doing the same thing at the same time.</p>\n\n\n\n<p>I&#8217;ve got a similar piece of software, which will then allow me to edit the video in real time, again, all in the browser. And really, if you weren&#8217;t technical, and you were to look at it, you would imagine that it was some app that I downloaded from the Mac App Store or what have you. But it&#8217;s not, it&#8217;s just sitting inside the browser, and it is pretty remarkable.</p>\n\n\n\n<p>I think the future in terms of what blocks will bring, and the fact that blocks can be sometimes like a little atomised app if you like. You know, it can handle app-like functionality within it, I think it&#8217;s going to be curious what people do in the future.</p>\n\n\n\n<p>So let&#8217;s just turn our attention to your plugin then. First of all, the URL omgimg.co, so .co, go and find that. Is this an endeavor to get people to go the last mile? You know that final thing that you&#8217;ve got to do every time you write a blog post, which is the featured image. And it&#8217;s the last thing that you want to do at that moment because you&#8217;ve already spent hours creating and crafting the text.</p>\n\n\n\n<p>And you&#8217;re finally hit with that, oh really? And then you&#8217;ve got to go and open up Canva or Photoshop and spend time doing something that you probably don&#8217;t have the skillset to do. Have I kind of got the idea there? It&#8217;s just a dead easy drop in for, here&#8217;s a templated way of doing it, click some buttons, you&#8217;re off to the races.</p>\n\n\n\n<p>[00:29:57] <strong>Corey Maass:</strong> Yeah. That was the problem that we originally were looking at solving. You&#8217;re, generating content, you&#8217;re writing long blog posts, or short blog posts, up to you. Or even uploading products into WooCommerce, or whatever it is that you are using WordPress for.</p>\n\n\n\n<p>But if it&#8217;s a thing that&#8217;s going to be shared, there is this social image. And there&#8217;s this misconception that a lot of people have, which is that the featured image is also the social image. And it&#8217;s true because it can be true, but it doesn&#8217;t have to be true. And you&#8217;re honestly doing yourself a disservice by not differentiating these two things.</p>\n\n\n\n<p>A lot of SEO plugins very correctly will try their best, they will go and grab the featured image, or the first image that they find inside the content of whatever post you&#8217;ve published, and serve that up, and if not, they will default to a, probably a site-wide image that you&#8217;ve uploaded.</p>\n\n\n\n<p>But the idea here is yeah, the hard work, and what we&#8217;ve experienced, and I think a lot of people experience is not necessarily, I mean, it&#8217;s hard enough writing words. If you&#8217;re writing blog posts, it&#8217;s hard enough writing words, or if you&#8217;ve recorded a podcast episode and you&#8217;ve uploaded it, you&#8217;ve spent hours, and hours, and hours editing it.</p>\n\n\n\n<p>And then you groan because you pull up your reusable to-do list and go, okay, now what are all the things I&#8217;ve got to do? Now I&#8217;ve got to categorise it. Now I&#8217;ve got to tag it. Now I&#8217;ve got to grab a transcript. Now I&#8217;ve got to find a featured image. Now I&#8217;ve got to upload the featured image.</p>\n\n\n\n<p>[00:31:26] <strong>Nathan Wrigley:</strong> You&#8217;ve just described my life, Corey.</p>\n\n\n\n<p>[00:31:28] <strong>Corey Maass:</strong> And I want to give you a hug. And that&#8217;s the good and bad of what we do, right? We want to be the rockstar millionaire or whatever, who is like, I&#8217;ve appeared on camera, and now I walk away, and all the talent, you know, all my underlings can go and do all the other work. But most of us are independent on some level, and subsequently are trapped to a desk doing most of the hard work ourselves. The boring work, the grinding, right?</p>\n\n\n\n<p>And one of those things, as we found, was finding a stock photo is sort of a different thing because it kind of depends on what it is you&#8217;re doing. Most people kind of have a source for that. But there&#8217;s a really strong argument for a featured image that is edited. Meaning it&#8217;s got words on it. It&#8217;s got a logo on it. It&#8217;s color edited so that it matches your branding, your site. Because just uploading the first picture that you find on Unsplash, just like everybody else, is not going to do your content any good.</p>\n\n\n\n<p>Like a lot of people correctly believe that adding a photo does lead to more conversions, but just adding some stock photo isn&#8217;t the right answer. So taking that a step further, making that image good, cropping it to the right size, enhancing it essentially. And then the next thing would be the image for social, which is often based off of that featured image.</p>\n\n\n\n<p>But we found last year that Twitter actually got rid of the title. If you share a website, it used to have the social image, and then it used to have the title of the website, and a description, and the URL, like Facebook still has this, LinkedIn still has this, Slack and other services that&#8217;ll pull in this preview still have it.</p>\n\n\n\n<p>Twitter got rid of it because they were like, most people, they&#8217;re just lying, or they&#8217;re just adding crappy content, and or some wanting to be more like Instagram. They&#8217;re like, we are photo only. And so you need something more than just an image because just an image, it&#8217;s a picture of Nathan&#8217;s smiling face, it&#8217;s like, I might click on it, I might not click on it.</p>\n\n\n\n<p>For those of you listening, because we are not on video, he just smiled ear to ear. Hamming it up as usual in the background. People go, oh, it&#8217;s Nathan, but why? I don&#8217;t know what he&#8217;s promoting. I don&#8217;t know what he&#8217;s talking about. I don&#8217;t know why he&#8217;s, maybe he&#8217;s just happy today. You need a title that says, Nathan Interviews genius developer named Corey. You know, words on an image so that people go, oh, this is why I should click on this. It&#8217;s a small thing, but it&#8217;s a very powerful thing. And this is largely the problem I&#8217;m solving.</p>\n\n\n\n<p>[00:33:53] <strong>Nathan Wrigley:</strong> I remember speaking recently with Jamie Marsland, he&#8217;s an Automattician, so he&#8217;s employed by Automattic, and his job title is the head of WordPress YouTube, and so he&#8217;s in charge of that channel. And I know that I could have found this information out elsewhere, but he really was the first person who&#8217;d kind of described it to me.</p>\n\n\n\n<p>He spent a long time researching images that would be the thumbnail image on YouTube because the attention span on YouTube, I think is prodigious low. You really are competing in a marketplace of milliseconds. And if for a fleeting moment you manage to get your featured image in front of somebody, you&#8217;ve got to convert it almost immediately.</p>\n\n\n\n<p>And so there&#8217;s kind of a playbook if you like, and I haven&#8217;t yet talked to Jamie about what that playbook is, but he does say that he spends a lot of time playing with the featured image, just because he knows now what works, and what converts, and what doesn&#8217;t. And it may not be that he&#8217;s got it perfected, and I imagine that algorithm over time will change or what have you. But there is some kind of psychology behind what&#8217;s going to work, and the kind of text to put on there, and whether it&#8217;s a, I don&#8217;t know, a question, or what the kind of font is.</p>\n\n\n\n<p>And we see patterns, don&#8217;t we? We see popular ways of doing it. So for the longest time, we&#8217;ve seen, on YouTube videos, featured images, we&#8217;ve seen shocked looking people with a background, and they&#8217;ve got like a little white border around their cut out picture of themselves and so on. And everybody&#8217;s doing it. And if everybody&#8217;s doing it, there&#8217;s probably something effective about that. You know, not everybody can be doing it if it doesn&#8217;t work.</p>\n\n\n\n<p>[00:35:20] <strong>Corey Maass:</strong> Look at movie posters. That was how it was explained to me first. All these movie posters for most movies these days look the same. It&#8217;s a montage of all the characters in kind of a pyramid, in a triangle with the title at the bottom, right? Like, there&#8217;s a reason why it sells. And at some point, I mean, just like any advertising or any trends in advertising, we eventually become immune to it, and so it probably has to change.</p>\n\n\n\n<p>But yeah, the YouTube thumbnails, another perfect example, and actually something that I&#8217;m starting to look at for OMG as well, which is essentially generating a media kit. So it&#8217;s like, if you create a post, also create a square image for Instagram, and also create a thumbnail for YouTube.</p>\n\n\n\n<p>But yeah, there&#8217;s an immense amount of psychology that goes into this stuff. And a lot of it is just, also as you said, what people have gotten used to. But it also, there&#8217;s at least some element of AB testing, or experimenting for your own audience, because kids on YouTube are going to react differently, or click on different things than developers, or techy people, or WordPress people.</p>\n\n\n\n<p>And then, yeah, do you look shocked? What word do you put over your head? Do you put question marks? Is it a question that people want answered? Is it you looking satisfied because you&#8217;ve figured something out? You have to figure out how to take the content that is in that video and then convey that in one compelling image.</p>\n\n\n\n<p>And I&#8217;ve heard from a lot of the YouTube folks that they record their content and then spend the next five minutes striking various poses. It looks like they&#8217;re voguing. They&#8217;ve got to look shocked, and they&#8217;ve got to look angry, and they&#8217;ve got to look frustrated. And then later they go back through and go, well, maybe this one, this one I&#8217;m squinting. Okay, not that one. But yeah, this is the one, you know? And a lot, a lot of time gets spent on those thumbnails because it&#8217;s the poster for your movie.</p>\n\n\n\n<p>[00:37:07] <strong>Nathan Wrigley:</strong> What&#8217;s the workflow for OMGIMG then? If I&#8217;m in a WordPress, let&#8217;s say a blog post, let&#8217;s use that example, and I&#8217;ve written it out, I&#8217;m very happy with it, in every way I&#8217;m ready to go. I&#8217;ve got my SEO settings all done, and the text is ready and optimised and what have you. But the only thing that&#8217;s missing is some kind of imagery. How does it work? Do I click a button and then I&#8217;m interacting with some kind of editor that you provide? What&#8217;s going on?</p>\n\n\n\n<p>[00:37:29] <strong>Corey Maass:</strong> The big update that I made earlier this year was shifting from essentially a Canva style editor in WordPress, which still exists, but you now use that predominantly to create a template. So you&#8217;re like, I want the featured image in the background. I want the title of my post in the lower left, and I want my logo in the top right, and a border or something.</p>\n\n\n\n<p>And you save that as a template, and so now as part of your workflow, you finish writing, you fill out all the SEO fields, and then there&#8217;s a little button, an OMG meta box off to the side, and you click generate, and it opens a little window and you choose the preset, the template that you want to use. It creates the image in three seconds or less, and you hit save and you&#8217;re done.</p>\n\n\n\n<p>[00:38:12] <strong>Nathan Wrigley:</strong> Do you at that point get to, I don&#8217;t know, overwrite the texts, or write the title, or does it just consume the title from the blog post?</p>\n\n\n\n<p>[00:38:19] <strong>Corey Maass:</strong> It just consumes the content right now. I am adding, it has been requested that, oh, well for this, maybe I want to tweak the featured image slightly, or I want to take a word out of the title because it&#8217;s too long for the template that I built, kind of thing. So that&#8217;s coming soon, to be able to tweak those things slightly.</p>\n\n\n\n<p>What I&#8217;ve heard from most of my customers, users, is that what they care the most about is, again, abbreviating that workflow. And so there&#8217;s a little bit of tweaking or making it perfect, but for the most part, people are like, just make it fast. Just take this line item off of my to-do list so that if I finish writing a blog post, and then I&#8217;ve finished adding all of the SEO things, and then I&#8217;ve finished finding the perfect featured image, and then I&#8217;ve finished categorising it. Don&#8217;t make me open Canva, find the document, copy a page, copy the post title over, blah, blah, blah. You get the point.</p>\n\n\n\n<p>And so they&#8217;re willing to have essentially that mini version. And obviously, again, I want people to be able to make it perfect, but what I&#8217;ve been hearing more than make it perfect is make it fast. And so that&#8217;s what I&#8217;m focused on.</p>\n\n\n\n<p>[00:39:30] <strong>Nathan Wrigley:</strong> Yeah, have you come across a SaaS app called RelayThat? RelayThat&#8217;s a really interesting example because its prime purpose is to, much like you&#8217;ve just described, you create a template, and then you decide where the text is going to go. And once you&#8217;ve got that template, you have basically a bunch of text fields, and you just go and copy and paste the text in.</p>\n\n\n\n<p>So in your case, you could handle that natively. But you copy and paste the title in. You copy and paste, you know, in my case there might be a space here for the guest name or something like that. You might upload a featured image. In this case it would be, I&#8217;d copy and paste your name, copy and paste an image of you that you&#8217;d sent to me, and do the title. And so I&#8217;ve had to amend three fields, and then I can download it.</p>\n\n\n\n<p>But the interesting thing that it does as well is that it will create that exact image in just every size format. So it will do it for Instagram, for YouTube, all the different ones. And it&#8217;s optimised in that way. And obviously you can go in and set each one.</p>\n\n\n\n<p>And it&#8217;s a real pain the first time you use it, you know, it really genuinely takes hours to get everything just how you want it and figure it all out. But then on the back end of that, it&#8217;s seconds to do, but you&#8217;ve got to open up an app, log in, dah, dah, dah, dah. Whereas I can see the utility, if you&#8217;re inside WordPress and it can do all of those kind of things. That was the closest comparison I could draw. It&#8217;s definitely worth looking at if you&#8217;ve not come across that before.</p>\n\n\n\n<p>[00:40:52] <strong>Corey Maass:</strong> In my research for OMG, I&#8217;ve seen different apps, and also other apps that work similarly for generating banners, or generating social images, or generating whatnot. And this is part of what gave me confidence that this was a problem worth solving, because almost everybody has bought into something because it&#8217;s necessary.</p>\n\n\n\n<p>In this day and age, most of us want our web pages shared, right? The day of people just coming to your website over, and over, and over again, hoping that there&#8217;s new content is largely over. Unless you&#8217;re the New York Times or something. Unless you&#8217;re a destination.</p>\n\n\n\n<p>Most of the internet now is based around aggregation, which is Twitter or Facebook. And so people go to these single sources where they&#8217;re hoping that everybody has kind of dumped their stuff in, or other people have dumped other people&#8217;s stuff in. And that&#8217;s how we can consume it all in one feed. Very convenient.</p>\n\n\n\n<p>But this is why it&#8217;s more and more important that how you are represented on those platforms, often without knowing about it. And this is one of the things that I struggled early on to explain to, like I gave a talk about images, and open graph, and all this stuff to a meetup here in New Hampshire. And it was eye-opening because trying to explain the importance of this, and the scenario of, it&#8217;s not even about you sharing your website, it&#8217;s about Nathan sharing my website with Michelle without me knowing, right?</p>\n\n\n\n<p>And so it&#8217;s how I am represented without me being present. And so I need to set myself up for success for that scenario. And because it&#8217;s that third party validation is the biggest, still the most compelling sales technique, right? There&#8217;s a reason why all of us have testimonials on our landing pages. Somebody else telling somebody else about how great I am is way better than me telling them how great I am. And this is that same thing. Nathan sharing my website with somebody else is way more compelling to that other person.</p>\n\n\n\n<p>They&#8217;re going, well, I trust Nathan, smart. He&#8217;s got that fancy accent, so he must know what he&#8217;s talking about. And it lends authenticity, it lends value to whatever he&#8217;s sharing. And so if he shares that link and then a little gray box pops up. I was talking to somebody this week, they were like, yeah, I always assume that that&#8217;s spam. And I was like, wow, that&#8217;s really, really powerful, that people go, I&#8217;m really hesitant to click on this thing because it&#8217;s a gray box.</p>\n\n\n\n<p>And it&#8217;s the same as 25 years ago, 30 years ago, now when I first started. It was the first wave of, you are not a legitimate business if you do not have a website. And this was a compelling way for when I started my career to get clients, because I could go in and go, look, people are not taking you seriously because you don&#8217;t have a website. But it&#8217;s all these little boxes that you have to tick to represent yourself the best you can on the internet.</p>\n\n\n\n<p>[00:43:42] <strong>Nathan Wrigley:</strong> I think that&#8217;s totally true. I mean, we&#8217;re all, whether we like it or not, we are all in some way shape or form involved in social media. If you&#8217;re a business and you&#8217;re not on social media, and you remain in business, well, you&#8217;re very lucky. Most of the rest of us have to do that job.</p>\n\n\n\n<p>And you are right, if you see something and there isn&#8217;t some kind of featured image attached, you do have that little spidey sense, well, that&#8217;s kind of curious and strange, that doesn&#8217;t quite look legitimate.</p>\n\n\n\n<p>And the ability to speed it up inside of WordPress natively is fascinating. And let&#8217;s not forget that the majority of people who are using WordPress are not the likes of you and I, who have been obsessed with computers ever since, you know, they came around. These are people who, they&#8217;re using WordPress in some kind of utilitarian way that, you know, they&#8217;ve been handed the job of creating blog posts, and the faster that they can get in and get out and do the other 3000 tasks that they&#8217;ve got on their plate this week, the better.</p>\n\n\n\n<p>And so, yeah, it&#8217;s an exciting time with all the technologies that are happening inside of the browser, WebAssembly and so on, but also the technologies that people like you are building inside a WordPress. Yeah, it&#8217;s fascinating.</p>\n\n\n\n<p>Corey, where can we find you? If people have listened to this and they&#8217;re curious to get in touch and talk to you about images, where do we find you best?</p>\n\n\n\n<p>[00:44:50] <strong>Corey Maass:</strong> Sure. Corey Maass, M A A S S on Twitter is where I&#8217;m most active. My company is called Gel Form, gelform.com, and of course omgimg.co.</p>\n\n\n\n<p>[00:45:04] <strong>Nathan Wrigley:</strong> Cory Maass, thank you so much for chatting to me today. I really appreciate it.</p>\n\n\n\n<p>[00:45:07] <strong>Corey Maass:</strong> Thanks for having me.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://x.com/coreymaass\">Corey Maass</a>.</p>\n\n\n\n<p>Corey has been building for the web since 1996, with a focus on WordPress since 2011. He started his first SaaS app in 2004 and has launched dozens since. For over ten years, he’s combined his love for entrepreneurship and WordPress by building, launching, and selling numerous WordPress plugins and SaaS apps built on WordPress. Currently, he’s focused on the OMGIMG WordPress plugin.</p>\n\n\n\n<p>In this episode, Corey talks about the role of social media and your website’s presence on social platforms. He talks about how optimised web sharing images are important in today&#8217;s digital landscape. He explains how shareable web pages on platforms like X and Facebook drive online traffic more than direct visits, and emphasises the power of third-party endorsements in adding credibility and authenticity.</p>\n\n\n\n<p>He discusses the need for efficient, user-friendly, solutions built for this task, right inside of WordPress. A timesaver for anyone tasked with updating content in multiple places.</p>\n\n\n\n<p>Corey also talks about the latest technological advancements, including WebAssembly, and how modern image formats like WebP and AVIF can offer higher-quality images with smaller file sizes.</p>\n\n\n\n<p>We get into the challenges and future improvements due to come in the WordPress Media Library, the significance of dedicated tools for image creation, and how Corey&#8217;s OMGIMG plugin leverages in-browser capabilities to simplify image handling without relying on server-side processes.</p>\n\n\n\n<p>Towards the end, Corey shares his insights on how custom social images can enhance engagement and conversions, and the importance of optimised images in improving online content presentation.</p>\n\n\n\n<p>If you&#8217;re a WordPress user looking to streamline your workflow and boost your social media game, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://kanbanwp.com/\">Kanban for WordPress</a></p>\n\n\n\n<p><a href=\"https://linktr.ee/\">Linktree</a></p>\n\n\n\n<p><a href=\"https://about.me/\">About.me</a></p>\n\n\n\n<p><a href=\"https://carrd.co/\">Carrd</a></p>\n\n\n\n<p><a href=\"https://omgimg.co/\">OMGIMG plugin</a></p>\n\n\n\n<p><a href=\"https://x.com/swissspidy/status/1733138082591912154\">Pascal Birchler&#8217;s X thread about image manipulation in the browser</a></p>\n\n\n\n<p><a href=\"https://www.canva.com/\">Canva</a></p>\n\n\n\n<p><a href=\"https://www.youtube.com/wordpress\">WordPress YouTube channel</a></p>\n\n\n\n<p><a href=\"https://www.relaythat.com/\">RelayThat</a></p>\n\n\n\n<p><a href=\"https://gelform.com/\">Gelform website</a></p>\n\n\n\n<p><a href=\"https://x.com/coreymaass\">Corey&#8217;s on X</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Dec 2024 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Akismet: Email Leads: 17 Proven Tactics to Generate Them Effectively\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://akismet.com/?p=284252\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://akismet.com/blog/email-leads/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:32916:\"<p>They say the money is in the list. And it is. Having an active email list gives you a reliable source of revenue you can tap into regularly. But that means you need to be consistently attracting new email leads. Once you have them, you can nurture them, convert them into customers, motivate repeat purchases, ask for reviews, and do all the other marketing activities email makes possible with existing&nbsp;customers.</p>\n\n\n<p>So how do you get more email leads?&nbsp;</p>\n\n\n\n<span id=\"more-284252\"></span>\n\n\n<h2 id=\"what-is-an-email lead\" class=\"wp-block-heading\">What is an email&nbsp;lead?</h2>\n\n\n<p>An email lead refers to anyone who has subscribed to your email list but hasn’t yet made a purchase. This is distinct from paying customers who have provided their email address and subscribed (given permission) to receive email marketing from your company.&nbsp;</p>\n\n\n<p>Email leads are on your email subscriber list and have also given permission to receive marketing from you, but haven’t yet made a&nbsp;purchase.</p>\n\n<h2 id=\"why-are-email-leads-crucial-for-marketing-and sales\" class=\"wp-block-heading\">Why are email leads crucial for marketing and&nbsp;sales?</h2>\n\n\n<p>Email marketing remains one of the most profitable forms of marketing from an ROI perspective. That’s because it’s a direct line of communication to people who have asked you to send marketing to them.&nbsp;</p>\n\n\n\n<p>And, it’s relatively low-cost compared to almost every other marketing channel.&nbsp;</p>\n\n\n<p>When people click and make purchases in response to emails they’ve received, a larger portion of that revenue is&nbsp;profit.</p>\n\n\n<p>Email is also the easiest way to stay in touch with customers and prospects. You don’t have to hope they see your display ad, or are watching TV when your ad shows up, or happen to see your social media post while they’re busy scrolling by. Emails go straight to them.&nbsp;</p>\n\n\n\n<p>For all these reasons, email also offers a great way to nurture and follow up with leads and customers. You can send a series of emails for one campaign. You can send thank you emails, follow-up emails, survey emails, review request emails, abandoned cart emails, welcome emails, and automated emails of many sorts.&nbsp;</p>\n\n\n<p>No other marketing channel allows for so much direct communication at so little cost — and with trackable&nbsp;data.</p>\n\n<h2 id=\"17-ways-to-enhance-your-email-lead generation\" class=\"wp-block-heading\">17 ways to enhance your email lead&nbsp;generation</h2>\n\n\n<p>With such a valuable marketing channel, here’s a checklist you can use to level up your email lead generation.&nbsp;</p>\n\n\n<h3 id=\"1-understand-your-audience-at-a-deep level\" class=\"wp-block-heading\">1. Understand your audience at a deep&nbsp;level</h3>\n\n\n<p>Lead generation begins with knowing what your target audience wants. The idea is to offer them something that will make them say “Yes!” when asked to join your email list. They join because they want the thing you’re offering.&nbsp;</p>\n\n\n\n<p>As long as the thing you’re offering appeals to your target audience, a portion of them will respond to this offer and fill out your opt-in form.&nbsp;</p>\n\n\n<h3 id=\"2-create-a-sense-of-urgency-or scarcity\" class=\"wp-block-heading\">2. Create a sense of urgency or&nbsp;scarcity</h3>\n\n\n<p>With lead generation, this could mean a deadline for when a particularly appealing offer gets taken away. Maybe you just wrote a book related to your industry, and are giving away the first 100 copies to whoever joins your list. Maybe you’re giving away extra large discounts for people who join your list in the next ten days.&nbsp;</p>\n\n\n\n<p>Deadlines and scarcity like that work well to grow your list fast, in surges.&nbsp;</p>\n\n\n<p>But you can also use urgency that doesn’t require constantly coming up with new offers. How might this look? Urgency can also result when people feel left out. For&nbsp;example:</p>\n\n<p>“Join the community and see the juicy secrets we share every week in our&nbsp;newsletter!”</p>\n\n<p>That is the language of urgency, but it’s not tied to a deadline or a finite amount of&nbsp;something.</p>\n\n<h3 id=\"3-make-your-lead-magnet irresistible\" class=\"wp-block-heading\">3. Make your lead magnet&nbsp;irresistible</h3>\n\n\n<p>The above example also serves to demonstrate the idea of an irresistible lead magnet. The more the lead magnet aligns with things your audience cares about, the more irresistible it will be.&nbsp;</p>\n\n\n\n<img width=\"1600\" height=\"780\" src=\"https://akismet.com/wp-content/uploads/2024/12/vip.png\" alt=\"form on the WordPress VIP site showing an example of a lead capture\" class=\"wp-image-284255\" />\n\n\n\n<p>This is why the tried and true methods like free guides, eBooks, white papers, and special reports still work wonders. As long as the content in those digital marketing documents relates to topics, desires, and needs your audience shares, they will want it badly enough to join your email list if that’s what it takes to get it.&nbsp;</p>\n\n\n<p>But the more perks you can throw in, the harder it will be for people to resist joining. You can also offer a combination. For example, a business could give a free report, a 20% off coupon for first&#8209;time buyers, and access to a private Facebook page for everyone who joins their email&nbsp;list.</p>\n\n<h3 id=\"4-build-a-form-that-minimizes friction\" class=\"wp-block-heading\">4. Build a form that minimizes&nbsp;friction</h3>\n\n<p>Attracting and converting email leads requires more than just a great offer. It also requires an opt&#8209;in form that works. The less cumbersome your forms, the more people will do the work required to get through them. This means, among other&nbsp;things:</p>\n\n\n<ul class=\"wp-block-list\"><li>Keep your number of form fields to a&nbsp;minimum</li>\n\n<li>Use clearly&#8209;labeled&nbsp;fields</li>\n\n<li>Consider multistep forms if you need to collect more&nbsp;information</li>\n\n\n<li>Minimize clutter</li>\n\n\n<li>Don’t bury your forms on your website in places that are easy to&nbsp;overlook</li></ul>\n\n\n<h3 id=\"5-avoid-captcha-at-all costs\" class=\"wp-block-heading\">5. Avoid CAPTCHA at all&nbsp;costs</h3>\n\n\n<p>Another common source of friction arises from a very common but extremely annoying feature of many website opt-in forms. Many website owners have been duped into thinking they need to use a CAPTCHA in order to prevent spammers and bots from clogging up their inboxes by filling out their forms over and over.&nbsp;</p>\n\n\n\n<p>Are bots and spammers a problem? Yes, very much so.&nbsp;</p>\n\n\n<p>But CAPTCHA is about the worst way to solve that problem. Why? Because website users hate them. Picture&nbsp;this:</p>\n\n\n<p>You have a great lead magnet. Your form is easy to use. Your offer has connected with a new lead. And they’ve gone through the work to fill out the form. And now, right before they can click the button to complete it… they have to count the motorcycles in a bunch of blurry pictures.&nbsp;</p>\n\n\n<p>Sounds like fun? It’s not. These little puzzles do nothing but annoy people. More importantly, they also <strong>reduce your conversion rate</strong>. People give up and abandon forms if they get tired of dealing with CAPTCHA&nbsp;puzzles.</p>\n\n\n<p>A far superior and seamless solution is to use Akismet. <a href=\"https://akismet.com/features/\">Akismet</a> has prevented hundreds of billions of spambots from filling out opt-in forms and other types of online forms. In the near future, we’ll surpass one trillion.&nbsp;</p>\n\n\n\n<img width=\"1600\" height=\"655\" src=\"https://akismet.com/wp-content/uploads/2024/12/image-1.png\" alt=\"Akismet homepage with the text \" />\n\n\n\n<p>Akismet uses AI data and other software tools to identify and block spammers from filling out your forms, but the human users of your website are not impacted by it at all. They don’t even know it’s busy protecting your site in the background. They just fill out the form, unimpeded, and go on with their day.&nbsp;</p>\n\n\n\n<p>And you get another new email lead.&nbsp;</p>\n\n\n<h3 id=\"6-build-credibility-with-social proof\" class=\"wp-block-heading\">6. Build credibility with social&nbsp;proof</h3>\n\n\n<p>Right below the CTA button, it’s a smart idea to insert a short testimonial lauding the benefits of subscribing to your emails or being a customer. You can even use a screenshot from a third-party review site to bolster the credibility.&nbsp;</p>\n\n\n<h3 id=\"7-give-a-clear-preview-of-the-next steps\" class=\"wp-block-heading\">7. Give a clear preview of the next&nbsp;steps</h3>\n\n<p>A short piece of text somewhere in the form can tell new leads what will happen after they click the button. This takes away another mild objection that keeps some people from following through with their desires to obtain the benefits of being on your email list. Examples of this sort of text might read this&nbsp;way:</p>\n\n\n<ul class=\"wp-block-list\"><li>Once you join, your coupon will be there in&nbsp;seconds</li>\n\n<li>Join today and gain access to the private&nbsp;group</li>\n\n<li>After you sign up, the report will be waiting in your&nbsp;inbox</li></ul>\n\n\n<p>You can insert this sentence right above or below the CTA button, or at the very bottom of the form. And it doesn’t need to be a large font. But this sort of language will reassure some leads by clarifying exactly what happens&nbsp;next.</p>\n\n\n<img width=\"1600\" height=\"780\" src=\"https://akismet.com/wp-content/uploads/2024/12/image-2.png\" alt=\"email capture with a receipe ebook exchange\" class=\"wp-image-284257\" />\n\n\n<h3 class=\"wp-block-heading\">8. Offer a one&#8209;time discount for new&nbsp;leads</h3>\n\n<p>You saw an example of this earlier. While you don’t want to be discounting all the time, offering a discount to new leads is a terrific strategy for turning a lead into a customer. The sooner you can convince them to buy, the sooner they will start developing a sense of belonging and loyalty. It’s that first purchase that always takes the most commitment. Once done, you can more quickly motivate a second&nbsp;purchase.</p>\n\n<p>So a one&#8209;time discount to new customers is a great marketing strategy for converting new leads into customers. That discount could come in several&nbsp;forms:</p>\n\n\n<ul class=\"wp-block-list\"><li>A percent off or dollars off&nbsp;discount</li>\n\n<li>Buy one, get one&nbsp;free</li>\n\n<li>A free&nbsp;gift</li>\n\n<li>A free gift with&nbsp;purchase</li>\n\n<li>Discounted setup&nbsp;fees</li>\n\n<li>Get the first month&nbsp;free</li></ul>\n\n\n<h3 id=\"9-host-a-live-event-that-requires-an-email-to register\" class=\"wp-block-heading\">9. Host a live event that requires an email to&nbsp;register</h3>\n\n<p>For some businesses, it might not be a product that attracts new email leads. Sometimes, a webinar, live online conference, or other event will be more enticing. They want to hear from an expert, a celebrity, a special guest, or the founder of the company talk about a particular topic that matters to&nbsp;them.</p>\n\n\n<p>If all they have to do to see the presentation is provide their email address, that’s a small price to pay, and your target audience will happily do so.&nbsp;</p>\n\n\n<h3 id=\"10-design-a-dedicated-lead-generation-landing page\" class=\"wp-block-heading\">10. Design a dedicated lead generation landing&nbsp;page</h3>\n\n\n<p>For almost all these examples, you’ll do better with a dedicated landing page in addition to a typical opt-in form. Forms can be placed in your website’s footer, sidebar, homepage, and within your content.&nbsp;</p>\n\n\n\n<p>But you should also have a separate webpage that goes into more detail about the benefits of joining your email list. Whatever incentive you’re offering in exchange for joining, this page gives you room to expand on the benefits and advantages it offers.&nbsp;</p>\n\n\n\n<p>A page like this also gives you something to link to if you’re trying to generate leads from other sites like social media pages. You might run an ad or create a post featuring your lead magnet, but it’s far more effective to link that ad to a special landing page than just your homepage.&nbsp;</p>\n\n\n\n<p>This will focus the attention of potential leads and keep them thinking only about the benefits of joining your list, and reducing distractions from the other content on your other pages.&nbsp;</p>\n\n\n<p>You can link to this landing page from all sorts of places,&nbsp;including:</p>\n\n\n<ul class=\"wp-block-list\"><li>Social media pages and&nbsp;ads</li>\n\n\n<li>PPC ads</li>\n\n\n\n<li>Display ads</li>\n\n\n\n<li>Partner websites</li>\n\n\n\n<li>Print marketing</li>\n\n\n<li>Marketing collateral at live events and&nbsp;booths</li>\n\n<li>Other pages and posts on your&nbsp;website</li></ul>\n\n\n<p>For the print marketing and live event situations, this is why you want to keep the URL for this landing page very simple. You want it to be easy to read, not too many characters, and easy to remember. For example, suppose you’re presenting to a live audience and your landing page URL is on one of your slides. The shorter it is, the easier it will be for people to&nbsp;respond.</p>\n\n<h3 id=\"11-implement-prominent-and-persuasive ctas\" class=\"wp-block-heading\">11. Implement prominent and persuasive&nbsp;CTAs</h3>\n\n\n<p>Both the main headline of your opt-in form and the text on your CTA button need to be persuasive and actionable. Don’t use generic language like “Join our list!,” “Sign up,” or the worst one of all — “Submit!”&nbsp;</p>\n\n\n<p>Instead, customize the CTA language to fit what you’re offering. Examples for good button CTA language&nbsp;include:</p>\n\n\n<ul class=\"wp-block-list\"><li>Grab your report&nbsp;today</li>\n\n<li>Claim your free&nbsp;coupon</li>\n\n<li>Reserve your&nbsp;spot</li>\n\n<li>Yes! Sign me&nbsp;up!</li></ul>\n\n\n\n<p>You should also use actionable language in your headlines — both for the form and the dedicated landing page.&nbsp;</p>\n\n\n\n<img width=\"1600\" height=\"588\" src=\"https://akismet.com/wp-content/uploads/2024/12/image-3.png\" alt=\"red email capture from Ladybird Education\" class=\"wp-image-284258\" />\n\n\n<h3 id=\"12-use-an-interactive-quiz-to-capture emails\" class=\"wp-block-heading\">12. Use an interactive quiz to capture&nbsp;emails</h3>\n\n\n<p>Sometimes, just having opt-in forms isn’t enough. And, how do you collect information about each lead that will help you follow up more effectively?&nbsp;</p>\n\n\n\n<p>With regular forms, you have to either lengthen the form, which can depress response rates, or you have to try to segment your list afterward with follow-up marketing and data collection.&nbsp;</p>\n\n\n\n<p>But online quizzes offer another great approach. With these, you can collect information and segment your leads from the start, and in a way they will enjoy. A good online quiz is fun to fill out, and there are some great quiz companies out there that make this easy.&nbsp;</p>\n\n\n<p>The best thing is, when they’ve finished filling out their quiz, they provide their email address at the end to see the results. And some quiz platforms will even personalize their results and give them an assessment of some sort. There’s a lot you can do with these. But they are a great way to attract email leads and grow your&nbsp;list.</p>\n\n\n<img width=\"1600\" height=\"1066\" src=\"https://akismet.com/wp-content/uploads/2024/12/image.jpeg\" alt=\"man explaining something to a camera\" class=\"wp-image-284259\" />\n\n\n<h3 id=\"13-create-a-talking-head-video-to-pitch-your offer\" class=\"wp-block-heading\">13. Create a talking head video to pitch your&nbsp;offer</h3>\n\n\n<p>Another advantage of having a landing page is that you can include a video. The owner of the company or some other key figure can make a quick 1-2 minute video promoting the benefits of subscribing to your email list. For people who respond to video, this is a great way to capture their attention and make sure they know all the reasons to join.&nbsp;</p>\n\n\n<h3 id=\"14-use-timed-popups-to-strategically-nudge users\" class=\"wp-block-heading\">14. Use timed popups to strategically nudge&nbsp;users</h3>\n\n\n<p>Popups got a bad name when they first came out because they were intrusive, annoying, and sometimes kept coming up even after the user closed them.&nbsp;</p>\n\n\n<p>But when used well, popups can be very effective. It’s not uncommon for websites to collect the majority of their email leads using popups forms. A good strategy is, instead of having it popup right when the visitor reaches your site, add a time delay so it pops up after about a&nbsp;minute.</p>\n\n\n<p>This way, it’s only being seen by people who have already engaged with your content to some degree. For those people, by the time they see the popup, they might have seen enough to respond to the lead generation offer more favorably.&nbsp;</p>\n\n\n\n<p>For example, offering a 20%-off discount to a new visitor the second they arrive might just annoy them. They’re not even sure they want to buy anything yet. But after a few minutes on your site, they might have found what they’re looking for, and that coupon will give them yet another reason to make the purchase and join your email list at the same time.&nbsp;</p>\n\n\n<h3 id=\"15-test-exit-popups-and overlays\" class=\"wp-block-heading\">15. Test exit popups and&nbsp;overlays</h3>\n\n<p>Another type of popup is the exit popup. Here, when a visitor moves to close your page or leave the site, the exit pop appears and makes an offer. It’s a last ditch attempt to let them consider one more time if they want to engage with your&nbsp;business.</p>\n\n<p>These work well because, even if the person didn’t feel ready to take any actions today, they might have a favorable impression of your company. The exit pop lets them join your email list and gives them an easy way to remain in your&nbsp;circle.</p>\n\n<h3 class=\"wp-block-heading\">16. Optimize your thank&#8209;you&nbsp;page</h3>\n\n\n<p>The last part of lead generation happens after a person has completed your opt-in form. What then? If you have promised them some type of lead magnet, be sure to deliver it as fast as possible. But there’s more you can do with this moment.&nbsp;</p>\n\n\n\n<p>When a person joins a new email list, they are feeling good, perhaps a little excited, and also a little unsure if this was a good decision. Do they want this company in their life?&nbsp;</p>\n\n\n\n<p>You want to capitalize on this moment by confirming they have made a great decision, and solidifying their positive feelings about what happens next.&nbsp;</p>\n\n\n\n<p>Creating a great thank-you page is the first thing to do.&nbsp;</p>\n\n\n<p>A good thank&#8209;you page does several&nbsp;things:</p>\n\n\n<ul class=\"wp-block-list\"><li>Communicates excitement about what they just&nbsp;did</li>\n\n<li>Reinforces the decision by restating key benefits they’ll soon&nbsp;realize</li>\n\n<li>Reminds them what happens next and what’s coming their&nbsp;way</li>\n\n<li>Gives them something to do right&nbsp;now</li></ul>\n\n\n<p>What should they&nbsp;do?</p>\n\n\n<p>It might be a blog post or other page of your site to visit. It could be a link to follow your social media page. It could be to watch a video.&nbsp;</p>\n\n\n\n<p>Or you could simply link to your online store, especially if you’re using a first-time coupon discount as your lead magnet.&nbsp;</p>\n\n\n\n<p>Find something for them to do, so they can stay engaged with your site a little longer.&nbsp;</p>\n\n\n<h3 id=\"17-build-an-email-series-to-nurture-new leads\" class=\"wp-block-heading\">17. Build an email series to nurture new&nbsp;leads</h3>\n\n<p>After the thank&#8209;you page, your other primary follow&#8209;up task for new leads is to create an email welcome series. Your new leads know you will email them. But they have no idea what you will say, or if they’ll regret joining your&nbsp;list.</p>\n\n\n<p>Create an email series to have the same effect as the thank-you page, but spread out over several days. With how busy and distracted everyone is, breaking into someone’s life in a positive way takes time and effort. A welcome series enables you to show up in their life several times, and will increase the chances they’ll remember you.&nbsp;</p>\n\n\n<p>A good series should be at least three emails, but you can also use five, seven, or even&nbsp;more.</p>\n\n<p>In your series, you can accomplish a number of things,&nbsp;including:</p>\n\n\n<ul class=\"wp-block-list\"><li>Reinforcing their decision to join&nbsp;(again)</li>\n\n<li>Delivering the content they asked for, if&nbsp;any</li>\n\n<li>Telling the story of your&nbsp;company</li>\n\n<li>Introducing the founder, owner, or other key&nbsp;personnel</li>\n\n<li>Telling them what they can look forward to and how exciting it&nbsp;is</li>\n\n<li>Sharing reviews and testimonials&nbsp;</li>\n\n<li>Introducing them to your community if you have&nbsp;one</li>\n\n<li>Making an offer to convert them into a paying&nbsp;customer</li></ul>\n\n\n<p>You don’t have to do all of that, but it certainly won’t hurt anything if you do. A good pace is to separate each of these emails by a day or two. And you can tell them up front how many emails they’ll be getting over the next few days so they won’t feel&nbsp;overwhelmed.</p>\n\n\n<p><strong>Reminder: </strong>Eliminating friction is key to getting the most from your hard work. <a href=\"https://akismet.com/features/\">Use Akismet</a> to reduce spam without annoying users. It’s a proven way to improve conversion rates.&nbsp;</p>\n\n\n<h2 id=\"the-lifecycle-of-an-email lead\" class=\"wp-block-heading\">The lifecycle of an email&nbsp;lead</h2>\n\n<p>To make sure you’re clear about all of this, let’s walk through the basic steps of lead generation and show you how each of the tactics we already discussed fits into the overall&nbsp;process.</p>\n\n\n<h3 id=\"acquisition\" class=\"wp-block-heading\">Acquisition</h3>\n\n\n<p>Acquisition happens when someone sees your offer to join your list, and then responds favorably. This could mean they saw an online ad or social media post. It could mean they visited your website and saw your opt&#8209;in form. They may have found your dedicated landing&nbsp;page.</p>\n\n\n<p>During this stage, the potential lead may know little to nothing about your company. You have to introduce yourself and give them enough value to make them want to stay engaged, and your email list offers the path for doing so.&nbsp;</p>\n\n\n\n<h3 id=\"nurturing\" class=\"wp-block-heading\">Nurturing</h3>\n\n\n<p>Once they’ve joined your email list, the next job is to nurture and deepen their relationship with your company. As you saw, this begins with the thank&#8209;you page and the email welcome series. Beyond that, you can continue sending emails and other marketing&nbsp;content.</p>\n\n<p>This could include social media, SMS, print marketing, and other&nbsp;channels.</p>\n\n<p>Nurturing means making the lead feel valued, helped, supported, or encouraged by the content you’re sending to them. The feelings you’re trying to produce depend on your industry and what your target audience&nbsp;wants.</p>\n\n\n<h3 id=\"conversion\" class=\"wp-block-heading\">Conversion</h3>\n\n\n\n<p>Conversion happens when they make their first purchase. Again, this is the reason to offer the first-time discount. For some leads, they will convert right away when they use this coupon. The job of the welcome series is to encourage them to use it soon.&nbsp;</p>\n\n\n\n<p>But even if you don’t have a first-time discount, somewhere in the welcome series, it’s a good idea to make an offer and give them a chance to buy. Once the welcome series concludes, they’ll be receiving whatever marketing you’re sending other people in their segment, so it will be a little less personalized, most likely.&nbsp;</p>\n\n\n<p>If you can get that first purchase before the welcome series concludes, that’s the best possible&nbsp;outcome.</p>\n\n\n<img width=\"1184\" height=\"754\" src=\"https://akismet.com/wp-content/uploads/2024/12/image-4.png\" alt=\"Magnga-Tiles thank you message\" class=\"wp-image-284260\" />\n\n\n<p>And by the way, we didn’t mention this before, but you can also go for a conversion right on the thank&#8209;you page. They just joined your email list. They’re feeling good. With the right offer, you can convert some of them right from that page. Give it a&nbsp;try!</p>\n\n\n<h3 id=\"retention\" class=\"wp-block-heading\">Retention</h3>\n\n\n\n<p>After conversion, your goal is to motivate repeat purchases. Retention looks similar to nurturing, except now you can offer additional products, new deals and specials, and other ways to buy from your website.&nbsp;</p>\n\n\n\n<p>After a customer makes a second purchase, they will now see your business as part of their lives, rather than a one-time thing. A second purchase greatly increases the potential for an ongoing relationship.&nbsp;</p>\n\n\n<h2 id=\"common-challenges-in-email-lead generation\" class=\"wp-block-heading\">Common challenges in email lead&nbsp;generation</h2>\n\n\n<p>Is it easy to attract email leads? The honest response from anyone not trying to sell you something is, nothing in marketing is “easy.” You will have to work at this. Getting attention is hard and takes ongoing effort. Connecting with your target audience takes time and effort, too.&nbsp;</p>\n\n\n<p>Here are a few other common email lead generation&nbsp;challenges:</p>\n\n<h3 id=\"low-conversion rates\" class=\"wp-block-heading\">Low conversion&nbsp;rates</h3>\n\n\n<p>The more steps in the chain, the harder it is to convert new leads. Imagine this funnel: You have a Facebook post, which links to your opt-in landing page. On that page is the opt-in form, which is followed by a thank you page and an email welcome series.&nbsp;</p>\n\n\n\n<p>If you’re measuring conversions as purchases, that’s at least five steps people have to walk through before buying anything.&nbsp;</p>\n\n\n\n<p>So, if 5% of people who see your Facebook post click on it, you’ve already lost 95% of potential leads, and they haven’t even read your landing page yet. Then, they have to follow through and fill out the form. From there, if you make a sales offer on the thank-you page, you might win your first conversion. Otherwise, it’s after your welcome series begins arriving.&nbsp;</p>\n\n\n\n<p>But the good news is, once you have these sorts of funnels up, they can just keep running. You can keep promoting that social media post over and over, and it may see a mostly new audience each time. With boosted posts and paid ads, you’ll spend a bit more, but you’ll also get more visibility. And if the content and message connects with enough people in your target audience, you can gain a lot of new email leads at a consistent pace.&nbsp;</p>\n\n\n\n<p>Work on improving each component of each page to improve conversions. That includes the offer, the copy, the CTA button, the imagery, the landing page headline, the form text, and all the other elements.&nbsp;</p>\n\n\n<h3 id=\"high-bounce rates\" class=\"wp-block-heading\">High bounce&nbsp;rates</h3>\n\n\n<p>A bounce happens when someone reaches your website and then leaves without doing anything. A high bounce rate means your landing page isn’t connecting with your potential leads. So if that’s your situation, now you know what to work on.&nbsp;</p>\n\n\n\n<p>Focus on the headline, the copy, the imagery, and the opt-in form.&nbsp;</p>\n\n\n<h3 id=\"dealing-with spam\" class=\"wp-block-heading\">Dealing with&nbsp;spam</h3>\n\n<p>Opt&#8209;in form spam is very annoying here because you keep thinking you’ve got a new lead, but really it’s just a bot or a scammer. It can demotivate a business owner from continuing to pursue&nbsp;leads.</p>\n\n<p>This is why <a href=\"https://akismet.com/features/\">Akismet</a> is so valuable. You’ll eliminate the psychological burden of dealing with all the spammers filling out your forms. And, your conversion rates will increase because your users won’t have a CAPTCHA or similar impediment making it harder to complete your form and join your email&nbsp;list.</p>\n\n<h2 id=\"frequently-asked questions\" class=\"wp-block-heading\">Frequently asked&nbsp;questions</h2>\n\n<h3 id=\"why-are-email-leads-important-for-my business\" class=\"wp-block-heading\">Why are email leads important for my&nbsp;business?</h3>\n\n<p>Without new input, output will decline. Businesses need a steady flow of new leads who will then convert into new customers because their existing customers will eventually go elsewhere. Businesses survive, grow, and thrive by consistently attracting new leads. It’s their&nbsp;lifeblood.</p>\n\n<h3 id=\"what-is-the-difference-between-cold-warm-and-hot leads\" class=\"wp-block-heading\">What is the difference between cold, warm, and hot&nbsp;leads?</h3>\n\n\n<p>Cold leads refer to leads who have become unresponsive. They’re still in your database and on your email list, but they don’t engage. Warm leads engage and respond to some degree, but haven’t followed through or responded to any of your offers. Hot leads are ones who have explicitly told you, either by word or action, that they are ready and interested in buying.&nbsp;</p>\n\n\n<h3 id=\"can-i-buy-email-leads-and-are-they effective\" class=\"wp-block-heading\">Can I buy email leads and are they&nbsp;effective?</h3>\n\n\n<p>Buying email leads has become increasingly less wise, and it is not recommended at all with current email technology and anti-spam laws. Sending marketing emails to people who have not opted in to your email list can get you in trouble if they complain to the authorities.&nbsp;</p>\n\n\n\n<p>Plus, since they didn’t opt in, if they mark you as spam it will hurt your sender reputation. That means your emails even to your happy subscribers may not get delivered to the inbox, but to the spam folder.&nbsp;</p>\n\n\n<h3 id=\"how-do-i-measure-the-success-of-my-email-lead-generation efforts\" class=\"wp-block-heading\">How do I measure the success of my email lead generation&nbsp;efforts?</h3>\n\n\n<p>You can measure each step of the process that features a call to action. How many people see your marketing promoting your lead magnet offer or email list subscription, and how many of those click on it? How many see your email opt-in form and how many click on it? How many view your thank-you page and how many of those respond to whatever it offers? How many receive your email welcome series, and how many convert based on what they receive?&nbsp;</p>\n\n\n<p>Each step can have its own conversion rate, which you can use to improve and optimize the whole&nbsp;process.</p>\n\n<h3 class=\"wp-block-heading\">How can I re&#8209;engage inactive email&nbsp;leads?</h3>\n\n\n<p>The first thing to do is send them a reactivation email campaign. This tells the recipients that they haven’t responded to any emails for a while, and if they want to remain on your list, they need to respond to this one. Reactivation emails often include a special offer to motivate your inactive leads to re-engage. It can be a single email or a short campaign.&nbsp;</p>\n\n\n\n<p>You can also try to engage with them on other marketing channels, as they may simply be more active on those as opposed to email.&nbsp;</p>\n\n\n<h3 id=\"should-i-use-captcha-to-protect-my-forms-from spam\" class=\"wp-block-heading\">Should I use CAPTCHA to protect my forms from&nbsp;spam?</h3>\n\n<p>No. CAPTCHA has been shown, in numerous studies, to depress conversion rates for opt&#8209;in forms. It is a needless barrier that makes it harder to complete the form. There are better ways to prevent opt&#8209;in form spam, with <a href=\"https://akismet.com/features/\">Akismet</a> being the most effective and seamless because website visitors don’t even know it’s&nbsp;there.</p>\n\n<h3 id=\"what-is-akismet-and-how-can-it-improve-my-lead-generation strategy\" class=\"wp-block-heading\">What is Akismet, and how can it improve my lead generation&nbsp;strategy?</h3>\n\n\n<p>Akismet is an anti-spam software service that prevents bots and spammers from filling out and submitting online forms. Akismet uses AI technology that analyzes behavior of the user, and detects when a bot or spammer is trying to engage with your form. It improves lead generation by removing one of the obstacles to completing and submitting an opt-in form.&nbsp;</p>\n\n\n<h3 id=\"what-types-of-companies-generally-use akismet\" class=\"wp-block-heading\">What types of companies generally use&nbsp;Akismet?</h3>\n\n<p>Over 100 million websites are currently using Akismet to prevent opt&#8209;in spam. That’s a lot — and it says something about how effective and widespread this solution is. Akismet also has an enterprise&#8209;level service used by some of the biggest brands in the world, including Microsoft, Bluehost, and<a href=\"https://akismet.com/blog/convertkit-customerstory/\">&nbsp;ConvertKit.</a></p>\n\n<h3 id=\"where-can-i-learn-more-about akismet\" class=\"wp-block-heading\">Where can I learn more about&nbsp;Akismet?</h3>\n\n<p>You can learn about Akismet and its primary features <a href=\"https://akismet.com/features/\">on our&nbsp;website</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Dec 2024 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jen Swisher\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"Gravatar: How to Enhance User Engagement with Gravatar on WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2462\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://blog.gravatar.com/2024/12/10/how-to-use-gravatar-in-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:12671:\"<p>Ever wondered why some WordPress comments display professional profile pictures while others show generic gray icons? The secret lies in Gravatar – a powerful yet surprisingly simple tool that&#8217;s transforming how people connect across the web.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>What is Gravatar, Anyway?</strong></h2>\n\n\n\n<img width=\"2492\" height=\"1298\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-new-homepage.png\" alt=\"Gravatar homepage\" class=\"wp-image-2391\" />\n\n\n\n<p>Gravatar, short for Globally Recognized Avatar, has evolved far beyond its origins as a simple avatar service. Today, it&#8217;s a comprehensive profile service that connects your email address to your digital identity, making it available wherever you interact online.</p>\n\n\n\n<p>Think of it as your digital business card that automatically follows you around the web. When you comment on a blog, join a new platform, or contribute to a project, Gravatar ensures your professional image is consistently represented. Major platforms like WordPress.org, Slack, GitHub, Mailchimp, and even OpenAI rely on Gravatar to enhance their user experience.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Why Gravatar Makes a Difference</h2>\n\n\n\n<p>Gravatar eliminates common frustrations in online interaction. Instead of repeatedly uploading profile pictures and filling out information across different sites, users enjoy:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Automatic profile synchronization across WordPress sites</li>\n\n\n\n<li>Consistent digital representation in comment sections</li>\n\n\n\n<li>Professional presence across multiple platforms</li>\n\n\n\n<li>Complete control over their shared information through granular privacy settings</li>\n\n\n\n<li>The ability to maintain separate professional and personal identities through different email addresses</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">For Site Owners and Developers</h3>\n\n\n\n<p>Implementing Gravatar brings substantial benefits to your WordPress site:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Streamlined user registration processes with auto-filled profile information</li>\n\n\n\n<li>Reduced server load since Gravatar hosts all profile images</li>\n\n\n\n<li>Enhanced compliance with data protection regulations</li>\n\n\n\n<li>Access to powerful developer tools through the REST API and SDK</li>\n\n\n\n<li>Built-in verification features to combat spam accounts</li>\n\n\n\n<li>The ability to create personalized user experiences based on imported profile data</li>\n</ul>\n\n\n\n<p>The real power shows up in community building. When users see their familiar profile picture and information automatically appear, they&#8217;re more likely to engage. This familiarity builds trust and encourages more interaction.</p>\n\n\n\n<p>And for sites targeting specific industries or niches, Gravatar helps create professional communities where members can easily recognize each other across different WordPress platforms.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>How to use Gravatar with WordPress.com</strong></h2>\n\n\n\n<p>Getting started with Gravatar on WordPress.com is straightforward since every WordPress.com account automatically includes Gravatar integration. Here&#8217;s everything you need to know about using it effectively.</p>\n\n\n\n<p>Your WordPress.com account creates a Gravatar profile automatically when you sign up. To manage your avatar:</p>\n\n\n\n<img width=\"1033\" height=\"448\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/wordpress-com-my-profile.png\" alt=\"Sign in to your WordPress.com dashboard and navigate to My Profile.\" class=\"wp-image-2469\" />\n\n\n\n<ol class=\"wp-block-list\">\n<li>Sign in to your WordPress.com dashboard </li>\n\n\n\n<li>Navigate to <em>My Profile</em>.</li>\n\n\n\n<li>Upload or modify your picture.</li>\n</ol>\n\n\n\n<img width=\"1220\" height=\"836\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/profile-settings-wordpress-com.png\" alt=\"Upload or modify your picture.\" class=\"wp-image-2470\" />\n\n\n\n<p>However, the settings you can adjust here are very limited and for a full list of things you can add, you need to edit your <a href=\"https://gravatar.com/profile\">Gravatar profile</a> directly.&nbsp;</p>\n\n\n\n<img width=\"1263\" height=\"756\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/edit-gravatar-profile.png\" alt=\"Gravatar profile settings\" class=\"wp-image-2471\" />\n\n\n\n<h3 class=\"wp-block-heading\">Advanced Features</h3>\n\n\n\n<p>Beyond basic avatars, WordPress.com includes several Gravatar-powered features to enhance your site.</p>\n\n\n\n<p><strong>Gravatar Widget</strong></p>\n\n\n\n<p>The Gravatar Widget adds a quick <em>About Me</em> section to your blog&#8217;s sidebar or footer. Add it by:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Going to <em>Appearance &gt; Customize &gt; Widgets.</em></li>\n</ol>\n\n\n\n<img width=\"1012\" height=\"642\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-widget.png\" alt=\"Gravatar widget\n\" class=\"wp-image-2489\" />\n\n\n\n<ol start=\"2\" class=\"wp-block-list\">\n<li>Selecting <em>Gravatar Widget</em>.</li>\n\n\n\n<li>Customizing the size, alignment, and text.</li>\n\n\n\n<li>Adding social media links if desired.</li>\n</ol>\n\n\n\n<p>For more detailed profiles, the Gravatar Profile Widget displays your complete bio, gravatar link, contact information, links, and recent activities.&nbsp;</p>\n\n\n\n<p>Need to add a Gravatar somewhere specific? Use the shortcode:</p>\n\n\n\n<pre class=\"wp-block-code\"><code>&#091;gravatar email=\"user@example.com\" size=\"96\"]</code></pre>\n\n\n\n<p>This works in posts, pages, and text widgets – perfect for team member profiles or guest author introductions.</p>\n\n\n\n<p><strong>Hovercards</strong></p>\n\n\n\n<p>And do you want to show more information when someone hovers over a profile picture, you can enable <a href=\"https://support.gravatar.com/profiles/hovercards/\">Gravatar Hovercards</a> to display mini-biographies, social media links, recent posts, and custom information.</p>\n\n\n\n<img width=\"1036\" height=\"569\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/hovercards-example.png\" alt=\"Gravatar hovercards\" class=\"wp-image-2474\" />\n\n\n\n<h2 class=\"wp-block-heading\"><strong>How to use Gravatar with WordPress.org</strong></h2>\n\n\n\n<p>Setting up Gravatar on a self-hosted WordPress site takes just a few extra steps but offers all the same benefits. Here&#8217;s how to get everything configured properly.</p>\n\n\n\n<p>Basic Setup:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Log into your WordPress dashboard and go to <em>Settings &gt; Discussion.&nbsp;</em></li>\n</ol>\n\n\n\n<img width=\"918\" height=\"612\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/settings-discussion.png\" alt=\"WordPress.org discussion settings\n\" class=\"wp-image-2475\" />\n\n\n\n<ol start=\"2\" class=\"wp-block-list\">\n<li>Scroll to <em>Avatars</em> and check <em>Show Avatars</em>.</li>\n</ol>\n\n\n\n<img width=\"1148\" height=\"259\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/show-avatara.png\" alt=\"Enabling avatars in WordPress.org\" class=\"wp-image-2476\" />\n\n\n\n<ol start=\"3\" class=\"wp-block-list\">\n<li>Choose your preferred rating level (G, PG, R, X)</li>\n</ol>\n\n\n\n<img width=\"1055\" height=\"223\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/avatar-rating-max.png\" alt=\"Setting the maximum rating for avatars in WordPress.org\" class=\"wp-image-2477\" />\n\n\n\n<ol start=\"4\" class=\"wp-block-list\">\n<li>Select a default avatar style.</li>\n</ol>\n\n\n\n<img width=\"1192\" height=\"687\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/default-avatar.png\" alt=\"Setting the default avatars in WordPress.org\" class=\"wp-image-2478\" />\n\n\n\n<ol start=\"5\" class=\"wp-block-list\">\n<li>Save changes</li>\n</ol>\n\n\n\n<p>After this setup, Gravatar automatically displays user avatars in comments, author bios, and other profile areas across your site.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Gravatar Enhanced Plugin&nbsp;</strong></h2>\n\n\n\n<img width=\"1217\" height=\"530\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-enhanced-plugin.png\" alt=\"Gravatar Enhanced plugin download page\" class=\"wp-image-2483\" />\n\n\n\n<p>The <a href=\"https://wordpress.org/plugins/gravatar-enhanced/\">Gravatar Enhanced plugin</a> is 100% free and takes functionality even further.&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>The Privacy Shield feature helps ensure Gravatar doesn&#8217;t log the avatars that you serve on your site, perfect for community sites where privacy matters.&nbsp;</li>\n</ul>\n\n\n\n<img width=\"5600\" height=\"3200\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-privacy-shield.png\" alt=\"Gravatar Enhanced Privacy Shield feature\" class=\"wp-image-2484\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>The Profile Block makes it simple to add beautiful author bios to posts – just insert the block, and it automatically pulls the author&#8217;s Gravatar profile data.&nbsp;</li>\n</ul>\n\n\n\n<img width=\"5600\" height=\"3200\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-profile-block.png\" alt=\"Gravatar Enhanced profile block\" class=\"wp-image-2485\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>Email notifications gently remind users to set up their Gravatar profiles, helping create a more engaging community.&nbsp;</li>\n</ul>\n\n\n\n<img width=\"1023\" height=\"357\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/plugin-email-notifications.png\" alt=\"Gravatar Enhanced email notifications\" class=\"wp-image-2486\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>Site owners particularly appreciate the Quick Editor, which lets them update avatars directly from the WordPress dashboard.</li>\n</ul>\n\n\n\n<img width=\"1023\" height=\"912\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/11/gravatar-quick-editor.png\" alt=\"Gravatar Quick Editor\" class=\"wp-image-2487\" />\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Gravatar API&nbsp;</strong></h2>\n\n\n\n<p>The Gravatar REST API is how WordPress.org users import their profile data, allowing website owners to build more intuitive and user-friendly sign-up processes, <a href=\"https://blog.gravatar.com/2024/09/06/onboarding-user-experience/\">customize customer onboarding</a>, and create a sense of community on the site.&nbsp;</p>\n\n\n\n<p>And for custom solutions, the Gravatar API opens up exciting possibilities. Pull in comprehensive user data to create dynamic author pages that showcase a writer&#8217;s latest posts, social media activity, and professional background. Build team pages that automatically update when members change their profiles. Or create custom comment systems that show different profile information based on user roles.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\">Building a Stronger Community</h2>\n\n\n\n<p>The true power of Gravatar lies in its ability to transform anonymous usernames into recognizable community members. Consider these strategies:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Add welcoming setup instructions near comment sections</li>\n\n\n\n<li>Include Gravatar guidance in welcome emails</li>\n\n\n\n<li>Create helpful documentation for new users</li>\n\n\n\n<li>Encourage profile completion through gentle reminders</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Privacy and Control</h2>\n\n\n\n<p>Gravatar stands out for its commitment to user privacy:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Users maintain complete control over shared information</li>\n\n\n\n<li>Multiple identity management through different email addresses</li>\n\n\n\n<li>Granular privacy settings for different contexts</li>\n\n\n\n<li>Easy profile updates that propagate across all connected platforms</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Taking Action</h2>\n\n\n\n<p>Ready to enhance your WordPress site with Gravatar? Start with these steps:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Review your current avatar settings</li>\n\n\n\n<li>Update your own Gravatar profile</li>\n\n\n\n<li>Consider adding enhanced features through plugins</li>\n\n\n\n<li>Create clear documentation for your users</li>\n\n\n\n<li>Monitor community engagement improvements</li>\n</ol>\n\n\n\n<p>Remember, building an engaged community requires more than just tools – but having the right tools makes it easier. Gravatar removes common friction points in user interactions, allowing your community to focus on what truly matters: creating meaningful connections and conversations.</p>\n\n\n\n<p>Want to learn more about implementing Gravatar in your WordPress site? Check out our <a href=\"https://support.gravatar.com/gravatar-enhanced-wordpress-plugin/\">comprehensive Gravatar Enhanced plugin documentation</a>. Let&#8217;s go!</p>\n\n\n\n<a href=\"https://wordpress.org/plugins/gravatar-enhanced/\"><img width=\"3243\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar_enhanced_cta.png\" alt=\"\" class=\"wp-image-2634\" /></a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Dec 2024 21:57:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WPTavern: Automattic Acquires AI Company ‘WPAI’\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=182018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wptavern.com/automattic-acquires-ai-company-wpai\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3075:\"<p>Automattic has announced that it has acquired <a href=\"https://wpai.co/\">WPAI</a>, a company specializing in AI-powered tools for WordPress. Founded two years ago, WPAI has developed innovative products like CodeWP (an AI IDE for WordPress developers), AgentWP (an AI agent for WordPress), and WP.Chat (a ChatGPT alternative for WordPress). No financial details of the deal have been disclosed.</p>\n\n\n\n<p>WPAI’s founding members James LePage, Greg Hunt, and Ovidiu “Ovi” Iulian Galatan will join Automattic. “Our entire WPAI team is making the move to Automattic, and we’ll be integrating our products, data, and tools into both new and existing offerings. We couldn’t be more excited about what’s ahead.”, James LePage shared on <a href=\"https://x.com/jameswlepage/status/1866208939680923694\">Twitter</a>.</p>\n\n\n\n<p>Automattic’s <a href=\"https://automattic.com/2024/12/09/automattic-welcomes-wpai/\">announcement post</a> revealed that the founding members will “lead the exploration of applied AI as an interaction paradigm for WordPress. They’ll be working on testing, building, and integrating innovative AI solutions into the core ecosystem to redefine how users and developers work with WordPress.”</p>\n\n\n\n<p>As part of the transition, CodeWP and AgentWP will be sunset in their current forms, the core technology powering these platforms will be reimagined and integrated into new offerings under the Automattic umbrella. </p>\n\n\n\n<p>“We expect that all products will be completely sunset by January 9th, but it is up to Automattic on the exact timeline now.”, shared James LePage in the WPAI <a href=\"https://www.facebook.com/groups/codewp\">facebook group</a>. “As we wind down our current products, monthly subscriptions will end without renewal, and annual subscribers will receive prorated refunds in the coming weeks.”, he continued.</p>\n\n\n\n<p>While many are optimistic about the acquisition, some customers have expressed concerns. Some are worried that it’s disastrous for the current customers and they are not happy with CodeWP and AgentWP being sunset. But James Lepage has assured that “This move allows us to gather more resources and build a much more robust solution. We were punching way above our weight class. The agent will be back!”&nbsp;</p>\n\n\n\n<p>Matt Mullenweg shared in his <a href=\"https://ma.tt/2024/12/wpai/\">personal blog</a>, “Very excited to share that <a href=\"https://automattic.com/2024/12/09/automattic-welcomes-wpai/\">we’ve acquired WPAI and the team is joining Automattic</a>. They have some very cool products including <a href=\"https://codewp.ai/\">CodeWP</a>, <a href=\"https://agentwp.com/\">AgentWP</a>, and <a href=\"https://wp.chat/\">WP.chat</a>.”</p>\n\n\n\n<p>The acquisition comes on the heels of Automattic’s recent purchase of <a href=\"https://wptavern.com/automattic-acquires-harper-founder-elijah-potter-joins-the-team-as-code-wrangler\">Harper</a>, a grammar-checking tool tailored for developers. Harper’s founder, Elijah Potter, also joined Automattic as a Code Wrangler.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Dec 2024 19:33:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: WPForms Plugin Patches Vulnerability Affecting Stripe Payments and Subscriptions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=182005\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://wptavern.com/wpforms-plugin-patches-vulnerability-affecting-stripe-payments-and-subscriptions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1799:\"<p>Awesome Motive’s <a href=\"https://wordpress.org/plugins/wpforms-lite/\">WP Forms</a> plugin has patched a Missing Authorization to Payment Refund and Subscription Cancellation vulnerability. This issue allowed authenticated attackers with Subscriber-level access or higher to refund Stripe payments and cancel subscriptions without proper authorization. </p>\n\n\n\n<p>Wordfence reports that “The WPForms plugin for WordPress is vulnerable to unauthorized modification of data due to a missing capability check on the ‘wpforms_is_admin_page’ function in versions starting from 1.8.4 up to, and including, 1.9.2.1. This makes it possible for authenticated attackers, with Subscriber-level access and above, to refund payments and cancel subscriptions.”</p>\n\n\n\n<p>Researchers have classified the vulnerability (CVE-2024-11205) as “High,” with a CVSS score of 8.5. The vulnerability researcher <a href=\"https://www.wordfence.com/blog/2024/12/6000000-wordpress-sites-protected-against-payment-refund-and-subscription-cancellation-vulnerability-in-wpforms-wordpress-plugin/\">István Márton’s post</a> has more technical details about the plugin’s vulnerability.</p>\n\n\n\n<p>Researcher <a href=\"https://www.wordfence.com/threat-intel/vulnerabilities/researchers/villu164\">Villu Orav</a>, who initially discovered and reported the vulnerability via the Wordfence Bug Bounty Program, earned recognition as Wordfence’s first recipient of the WordPress Superhero badge. Orav also received a $2,376 bounty for his discovery.</p>\n\n\n\n<p>WPForms is a widely used plugin with over 6 million active installations, making this patch particularly critical. Users are strongly advised to update to the patched version, 1.9.2.2, to safeguard against potential revenue loss and ensure site security.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Dec 2024 16:25:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"Do The Woo Community: Welcome Matthias Pfefferle as a New Host Talking About the Fediverse\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=87455\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/welcome-matthias-pfefferle-as-a-new-host-talking-about-the-fediverse/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:177:\"In a new episode, BobWP introduces Matthias Pfefferle as a host, discussing the upcoming show \"Open Web Conversations,\" with his focus on WordPress and broader Fediverse topics.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Dec 2024 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Matt: DrupalCon Singapore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=131618\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://ma.tt/2024/12/drupalcon-singapore/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2545:\"<p>This week, <a href=\"https://events.drupal.org/singapore2024\">DrupalCon Singapore</a> is bringing together an incredible community of Drupal platform creators, developers, and supporters.&nbsp;</p>\n\n\n\n<p><a href=\"https://ma.tt/2023/05/with-mike-little-and-dries-buytaert/\">Last year, I had the chance to share the stage with Dries Buytaert, the founder of Drupal</a>, and the conversation stuck with me. It highlighted the profound impact we can have when communities like ours come together to push the boundaries of Open Source and shape the future of the web.</p>\n\n\n\n<p>At Automattic, we believe that Open Source is more than a license—it’s a philosophy that drives innovation and makes publishing accessible to all, and we want to support fellow open source communities. Our team is at DrupalCon to share some of the tools we’ve built, including <a href=\"https://akismet.com/\">Akismet</a> (<a href=\"https://www.drupal.org/project/akismet\">check out the Drupal extension here</a>), <a href=\"https://magazine.atavist.com/\">The Atavist Magazine</a>, <a href=\"https://www.beeper.com/\">Beeper</a>, <a href=\"https://dayoneapp.com/\">Day One</a>, <a href=\"https://longreads.com/\">Longreads</a>, and <a href=\"https://pocketcasts.com/\">Pocket Casts</a>. These products, much like the web itself, thrive on connection and collaboration. (Basically all our non-WP stuff.)</p>\n\n\n\n<p>I’ve loved hearing about how people are engaging with our booth—whether exploring our tools, grabbing a local snack, or taking a moment to recharge. For those of you at the event, I encourage you to swing by the Automattic booth, meet our team, and share your thoughts. Together, we can continue to create an open web that’s full of possibilities.</p>\n\n\n\n\n<img width=\"604\" height=\"453\" src=\"https://i0.wp.com/ma.tt/files/2024/12/DrupalCon-1-1-1024x768.jpg?resize=604%2C453&ssl=1\" alt=\"\" class=\"wp-image-131632\" />\n\n\n\n<img width=\"604\" height=\"805\" src=\"https://i0.wp.com/ma.tt/files/2024/12/DrupalCon-2-1-768x1024.jpg?resize=604%2C805&ssl=1\" alt=\"\" class=\"wp-image-131628\" />\n\n\n\n<img width=\"604\" height=\"453\" src=\"https://i0.wp.com/ma.tt/files/2024/12/DrupalCon-3-1-1024x768.jpg?resize=604%2C453&ssl=1\" alt=\"\" class=\"wp-image-131631\" />\n\n\n\n<img width=\"604\" height=\"453\" src=\"https://i0.wp.com/ma.tt/files/2024/12/DrupalCon-4-1-1024x768.jpg?resize=604%2C453&ssl=1\" alt=\"\" class=\"wp-image-131629\" />\n\n\n\n<img width=\"604\" height=\"453\" src=\"https://i0.wp.com/ma.tt/files/2024/12/DrupalCon-5-1-1024x768.jpg?resize=604%2C453&ssl=1\" alt=\"\" class=\"wp-image-131630\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Dec 2024 03:56:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Matt: WPAI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=131612\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://ma.tt/2024/12/wpai/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:342:\"<p>Very excited to share that <a href=\"https://automattic.com/2024/12/09/automattic-welcomes-wpai/\">we&#8217;ve acquired WPAI and the team is joining Automattic</a>. They have some very cool products including <a href=\"https://codewp.ai/\">CodeWP</a>, <a href=\"https://agentwp.com/\">AgentWP</a>, and <a href=\"https://wp.chat/\">WP.chat</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Dec 2024 02:38:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"WPTavern: Jessica Lyschik Wins the WordPress Speed Build Challenge Against Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=181921\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://wptavern.com/jessica-lyschik-wins-the-wordpress-speed-build-challenge-against-matt-mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2916:\"<p>Jessica Lyschik, a WordPress Developer at GREYD, has won the highly anticipated WordPress Speed Build Challenge, defeating WordPress co-founder Matt Mullenweg. <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica</a> announced that she would donate her $5,000 prize money to Girls Who Code.</p>\n\n\n\n<p>The showdown was set following Jessica&#8217;s public challenge to Matt during WordCamp Europe. The challenge hosted by Jamie Marsland, required both participants to replicate the<a href=\"https://bobdylanart.com/\"> Bob Dylan</a> website within 30 minutes using any tools or techniques of their choice. Jessica utilized the GREYD theme and plugin, while Matt opted for the Twenty Twenty-Five theme and AI.</p>\n\n\n\n<p>Jessica, the Co-Lead for the Twenty Twenty-Four Default Theme, prioritized accessibility during the live event impressing the audience and prompting <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> to comment, “Jessica is so good at accessibility, I think the whole Greyd team is btw (and shoutout to Anne-Mieke as well).” </p>\n\n\n\n<p>While Jamie confirmed that using AI was not against the rules, the audience was divided about Matt&#8217;s use of it. Some appreciated using AI to speed up development, while others felt that “as the founder of Blocks, he should at least do it the core way.”</p>\n\n\n\n<p>The audience was amused to see Matt getting stuck and grow frustrated with alignment, padding, and borders. He accepted that he would have never found some options in a million years.</p>\n\n\n\n<p>Audience reactions included, “It&#8217;s good that WP leadership tries hands-on to use the Block Editor, that&#8217;s the only way of experiencing where we can improve. Thanks Matt for being here and maybe noting the issues.”, “Love that Matt is learning WordPress Live.”, “​​Wonder if he&#8217;ll now believe all the criticism of Gutenberg”, “Haha&#8230; Matt is saying that something is annoying about blocks?”, and “like watching a baby calf learn to walk.”</p>\n\n\n\n<p>But some defended Matt’s efforts: “He actually did alright imo. esp for one not building sites on the reg. Doesn’t mean there’s not improvements to be had by any means though.”</p>\n\n\n\n<p>Jessica was finally declared winner for a “more polished finish.” Before this event, she had competed against <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> and <a href=\"https://profiles.wordpress.org/francgrasso/\">Francesco Grasso</a>, while Matt was participating in the challenge for the very first time. Her next challenge will be against Nick Diego at the WordPress Speed Build Challenge during <a href=\"https://asia.wordcamp.org/2025/open-your-possibilities-by-learning-from-the-experts-wordpress-speed-build/\">WordCamp Asia</a>. </p>\n\n\n\n<p>You can watch the full challenge on <a href=\"https://www.youtube.com/live/BzduYKuZAIg\">YouTube</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Dec 2024 19:31:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: WordPress Core Team Proposes Adding WP Consent API to WordPress Core\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=181909\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wptavern.com/wordpress-core-team-proposes-adding-wp-consent-api-to-wordpress-core\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2559:\"<p>The WordPress Core team is gathering consensus around integrating the <a href=\"https://make.wordpress.org/core/2024/12/04/lets-reconsider-adopting-the-wp-consent-api/\">WP Consent API into Core</a>. The <a href=\"https://wordpress.org/plugins/wp-consent-api/\">WP Consent API feature plugin </a>was originally introduced in early <a href=\"https://wptavern.com/proposal-to-add-a-consent-api-to-wordpress-feature-plugin-available\">2020</a> to standardize the communication of accepted consent categories between plugins.</p>\n\n\n\n<p>Automattician Brian Alexander has placed two options before the community: add this feature to Core or make it canonical. In case of adding it to the Core, the existing API must be updated to meet the current Core merge expectations and the Core could introduce a default cookie “popup” or block that could be activated similar to the built-in Privacy Policy feature.</p>\n\n\n\n<p>Since the European Union’s Digital Markets Act (DMA) came into effect in March 2024, the WP Consent API plugin has seen a sharp rise in adoption, surpassing 100,000 active installations.</p>\n\n\n\n<p>Back in December 2020, the feature was removed from the active features list during a cleanup and marked as “Closed.” However, discussions in the #core-privacy channel in the months that followed overlooked this status change, causing confusion when efforts were made to transfer the plugin to the WordPress GitHub org.</p>\n\n\n\n<p>Rogier Lankhorst, the original developer, explained, “The most important aspect of the WP Consent API is its ability to bypass legal discussions entirely and delegate all such matters to CMPs. The WP Consent API should really be JUST an API, and not have any opinion about legal matters. While consent per service is not yet possible, one of the items on the WP Consent API roadmap is an extension that would enable this functionality. The current basic structure is easily extensible to accommodate this feature.”</p>\n\n\n\n<p>He also shared, &#8220;Extending the consent API to a cmp will most likely result in a project that will never finish, as it will result in endless discussions on legal details. The idea behind this proposal is that we sidestep these discussions and leave them with the vendors/services and cmp’s.&#8221;</p>\n\n\n\n<p>WordPress users can share their feedback on the proposal in the comments section of the <a href=\"https://make.wordpress.org/core/2024/12/04/lets-reconsider-adopting-the-wp-consent-api/\">announcement</a>. Most comments so far favor integrating the feature into Core.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Dec 2024 16:48:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"Do The Woo Community: New Do the Woo Show Coming in January, Open Web Conversations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=87444\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://dothewoo.io/blog/new-do-the-woo-show-coming-in-january-open-web-conversations/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"We have a new show starting in January 2025. Open Web Conversations where we talk about the Fediverse and Emerging Tech.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Dec 2024 15:05:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: State of the Word 2024 To Be Livestreamed From Tokyo Node Hall on December 16\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=181871\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://wptavern.com/state-of-the-word-2024-to-be-livestreamed-from-tokyo-node-hall-on-december-16\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2025:\"<p>WordPress co-founder Matt Mullenweg will deliver his annual <a href=\"https://wordpress.org/state-of-the-word/\">State of the Word </a>(SOTW) address on December 16 at 18:00 JST / 09:00 UTC, live from  <a href=\"https://tokyonode.jp/about/hall/index.html\">Tokyo Node Hall</a> in Tokyo, Japan. This marks only the second time the event will be held outside North America, following last year’s address in Madrid, Spain.</p>\n\n\n\n<p>A select group of 300 attendees will have the chance to experience the event in person, with <a href=\"https://wordcampcentral.survey.fm/2024-sotw-ticket-request\">ticket requests</a> now open. For global audiences, the address will be live-streamed on the official <a href=\"https://www.youtube.com/wordpress\">WordPress YouTube channel</a>. Community members are encouraged to host or join local watch parties to enjoy the event together.</p>\n\n\n\n<p>The address will feature Matt&#8217;s retrospective on 2024, demonstrations of the latest WordPress innovations, and insights into the future of the open-source project.</p>\n\n\n\n<p>Japan, known for its thriving WordPress community, is a fitting host for this year’s <a href=\"https://wptavern.com/matt-mullenweg-to-deliver-state-of-the-word-2024-from-tokyo-japan\">SOTW</a>. Matt shared his enthusiasm, stating, “It’s exciting for Japan to host a State of the Word and really showcase how vibrant their community is. I’m so impressed with all of the books about WordPress there, the market share we have in that country, and the warmth of the events they do throughout the year.”</p>\n\n\n\n<p>Shusei Toda, one of the organizers of WordCamp Asia highlighted the significance of the event, saying, “82.3% of Japanese websites are powered by WordPress, and this event holds immense importance to our local web developers, bloggers, and digital creatives. Hosting the State of the Word in Japan is not just a testament to our community and also in Asia but also a celebration of the pivotal role WordPress plays in our digital landscape.”</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Dec 2024 14:26:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"Do The Woo Community: Enhancing WooCommerce for Accessibility with Amber Hinds\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=87398\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://dothewoo.io/enhancing-woocommerce-for-accessibility-with-amber-hinds/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:225:\"Anne, Amber, and James discuss the significance of accessibility in web development for WooCommerce stores. They emphasize the Accessibility Checker plugin, upcoming audits, and compliance with the European Accessibility Act.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Dec 2024 10:35:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"Gutenberg Times: Gutenberg Changelog #112 Gutenberg 19.8, Create Block Theme Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=31209\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-112-gutenberg-19-8-create-block-theme-plugin/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:58247:\"<p>Birgit Pauli-Haack and Sarah Norris talked about Gutenberg 19.8, Create Block Theme Plugin, WordPress Day for Developers in Lisbon, Developer Hours, and so much more</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-112-gutenberg-19-8-create-block-theme-plugin/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-112-gutenberg-19-8-create-block-theme-plugin//#transcript\">Transcript</a></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Editor:&nbsp;<a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo:&nbsp;<a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production:&nbsp;<a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://events.wordpress.org/lisboa/2024/wordpress-day-developers-en/\">WordPress Day for Developers, Lisbon</a>, Portugal</li>\n\n\n\n<li><a href=\"https://events.wordpress.org/lisboa/2024/wordpress-day-developers-en/session/help-shape-gutenberg/\">Help Shape Gutenberg</a> w/ Sarah Norris</li>\n\n\n\n<li><a href=\"https://events.wordpress.org/rome/2024/coredays/\">Core Days, Rome,</a> Italy</li>\n\n\n\n<li><a href=\"https://events.wordpress.org/rome/2024/coredays/session/onboarding-gutenberg-development/\">Onboarding Gutenberg Development</a> w/ Birgit Pauli-Haack</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Announcements</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/304881623/\">Developer Hours: Everything you need to know about WordPress Playground</a></li>\n\n\n\n<li><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/304668126/\">Developer Hours: Improve your workflows with WordPress development tools</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Gutenberg Fun &amp; Games</h2>\n\n\n\n<p><strong>Code is Music</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Aki Hamano <a href=\"https://x.com/tetsuaki_hamano/status/1858914117987529004\"> “Code is Music” </a></li>\n\n\n\n<li><a href=\"https://wordpress.org/plugins/piano-block/\">Piano Block</a> </li>\n\n\n\n<li><a href=\"https://github.com/t-hamano/piano-block\">study the source code on GitHub</a></li>\n</ul>\n\n\n\n<p><strong>Play Snake</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Tom Rodes: <a href=\"https://tomrhodes.blog/2024/11/28/using-a-gutenberg-block-to-run-snake/\">Using a Gutenberg Block to run Snake</a>. </li>\n\n\n\n<li><a href=\"https://github.com/tommusrhodus/snake-gutenberg-block\">inspect the code on GitHub</a> or </li>\n\n\n\n<li>play the game <a href=\"https://playground.wordpress.net/?blueprint-url=https://raw.githubusercontent.com/tommusrhodus/snake-gutenberg-block/refs/heads/main/blueprint.json\">inside Playground</a>.</li>\n</ul>\n\n\n\n<p><strong>Play Dodge</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Jonathan Bossenger: <a href=\"https://jonathanbossenger.com/dodge-a-wordpress-game/\">a variation of Dodge game </a></li>\n\n\n\n<li> <a href=\"https://github.com/jonathanbossenger/interactive-game-standalone-demo\">The code is available on GitHub</a>.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Gutenberg 19.8</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/12/04/whats-new-in-gutenberg-19-8-4-december/\">What’s new in Gutenberg 19.8? (04 December)</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/60021\">Writing and contentOnly modes</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s in the works or discussed</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://wordpress.org/plugins/create-block-theme/#developers\">Create Block theme plugin / Changelog</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/recap-hallway-hangout-theme-building-with-playground-create-block-theme-plugin-and-github/\">Recap Hallway Hangout: Theme Building with Playground, Create-block-theme plugin, and GitHub</a></li>\n</ul>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<ul class=\"wp-block-list\">\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on X (formerly known as Twitter) or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> So, hello and welcome to our 112th episode of the Gutenberg Changelog Podcast. In today&#8217;s episode, we&#8217;ll talk about Gutenberg 19.8, the Create Block Theme Plugin, Lisbon Developer Hours, and so much more. I&#8217;m your host, Birgit Pauli-Haack, curator at the Gutenberg Times and a full-time core contributor for the WordPress Open Source Project, sponsored by Automattic, Five for the Future program.</p>\n\n\n\n<p>With me, the wonderful Gutenberg contributor, full-time core contributor Sarah Norris, also sponsored by Automattic, is today&#8217;s co-host and she brings updates to the Create Block Theme Plugin, as well as impressions from last week&#8217;s WordPress Day of Developers in Lisbon. Sarah is also the co-core team rep together with Joe McGill. If you have any questions about the core team and contributing, find her on WP Slack, Mikachan. That&#8217;s M-I-K-A C-H-A-N. Sarah, how are you today? Thanks for taking the time to join me, the last episode of the year.</p>\n\n\n\n<p><em>Sarah Norris:</em> Yeah, last episode of the year. Thank you for having me. Yeah, I&#8217;m good, thank you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Excellent, excellent. So yeah, tell me about the&#8230; What was the Developer Day like in Lisbon? And I can also contribute what the Rome Core Days was like in Rome a month before. So yeah. You&#8217;re just back?</p>\n\n\n\n<h3 class=\"wp-block-heading\">Lisbon Developer Hours</h3>\n\n\n\n<p><em>Sarah Norris: </em>Yeah, that&#8217;s right. Yeah, the Rome Core Days is very similar, wasn&#8217;t it? Yeah, so Lisbon WordPress Day for Developers, so it was all for developers, totally focused on tech talks and tech workshops. It was a relatively small event. I think there were about 60 people. As a speaker I think that&#8217;s better, but it&#8217;s really good as an attendee as well. It feels like you get to meet nearly everyone, if not everyone. Because it is about the right size to get around the room.</p>\n\n\n\n<p>We had two tracks. One was the talks and then the other was the workshops. And then I think I spent the majority of my time on the talk track because I was doing one of the talks, so I thought I wanted to stay in the room, not move too much. We had some great talks. We had Milana, Cyril, Miguel, Shadi, Mikael, and there was a lot of talk about, new features in WordPress, like the interactivity API and the HTML-type processor as well.</p>\n\n\n\n<p>So that was really, really cool to see. It&#8217;s great to see them being talked about and people asking questions about them and getting excited about them and using them on client sites and stuff. It&#8217;s so good to see. And my talk was about contributing to Gutenberg. So I always like to encourage more contributors to get on board. Because it&#8217;s so satisfying as a developer as well. I&#8217;m biased, I know, but I really think it&#8217;s a good repo to work in, so many lovely people to work with.</p>\n\n\n\n<p>I also talked through a few things that I&#8217;ve been working on recently as well. Because I find that often when I attend these events, people are really interested in what you&#8217;re working on, what&#8217;s coming up in Gutenberg and stuff. So yeah, I talked about some stuff I&#8217;ve been working on in the Query Loop Block and then some DataViews bits as well.</p>\n\n\n\n<p>So yeah, it was good. And also the food was amazing. You might be able to beat me, actually, because you were in Italy. The food at Lisbon, it was so good. Probably the best food I&#8217;ve had at an event like that. So good. Yeah. What was Rome Core Day like?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, Rome Core Day was similar. It was more about, was a lot about contribution, because there were three talks about it. One from Olga, one from me on Gutenberg, Olga Foucault. And then Stefano also talked about contributing to the accessibility team. And also had a talk track. Carlos was talking about the Block Bindings. The DataViews with Andre and Riyadh was very interesting. And then somebody talked about&#8230; Oh, Bernard Reiter talked about the HTML API and stuff.</p>\n\n\n\n<p>And then there was a second track and there was more a discussion panel kind of thing. And that was also very interesting, but the panel competed with the talks. So everybody left the room for the talks and went to the panel, because it was hot topics or something. And then the talk room&#8230; But it was also small, was really&#8230; I liked that, a small event. It was a little bigger than&#8230; Lisbon was a 100 people, about. And also had some sponsors there, that was cool.</p>\n\n\n\n<p>Well, the food was actually from a mall, so we were adjacent to the station, to the train station, and there was one food court there where you can go from all the different booths and then have a central place where you sit and talk. So everybody picked up their food, what they liked, and then joined the other ones, either on the second floor or the third floor to just have a big table there. And it was really nice. And it was good food, but I like Italian food. But I have found in Porto, when we were for work in Porto, that the Portuguese have really&#8230; It&#8217;s not hot food, but it&#8217;s very tasty. It has these explosions of flavors in their food and I know a few Italians that can do that, but yeah, it&#8217;s more likely tomato, meat, noodles, pizza kind of thing.</p>\n\n\n\n<p>And I figured from the description that you all talked about contributing and my talk about contributing, I think we would make a good kind of event that we could do virtually and put this all together. Because I think yours was more like the tips and tricks to get your hands dirty, so to speak, get your hands onto code. And mine was more like on the philosophical side, who should contribute or what&#8217;s it like to contribute, what are the steps to get to your first PR? And that was a little bit different. So I&#8217;ll see if we can get this on the schedule for the Developer Hours next year, to have a place where we can share with other people that want to know how is it when you contribute, to watch those two. So that would be really cool. Yeah.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah, that sounds good. Because I think a lot of the time when you&#8217;re reading documentation, you don&#8217;t really get a feel for what it is actually like to contribute. Well, and I don&#8217;t suppose you will until you actually contribute. But yeah, I was trying to&#8230; Some tips on finding reviewers and getting help if you need help, and have conversations or keep them going, those kinds of tips. But you do need to know all the other sides as well. You need to know if you can contribute. Of course you can. But maybe you need to know where. So you need all that information as well. So yeah, they sound very complimentary.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> So I read some of the surveys of why you contribute, how much you contribute, from the WordPress surveys that were done previous years. And I&#8217;ve found that many contributors that are freelancers or working with agencies, they have these feast and famine cycles on their business, but they like to contribute in the famine part, but they can&#8217;t keep it up when there&#8217;s actually really big work to be done.</p>\n\n\n\n<p>But they still would like to do those fly-by contributors, I call them, to say, &#8220;okay, I have two hours and I want to get my head clear, I do something else and let me see what&#8217;s up.&#8221; And it&#8217;s really hard to find those tasks where you can go and say, oh, I&#8217;ll do one of those 15 tasks, that are very well specced out, very contained, and could be busy work for core contributors. But it could be very gratifying for someone who just wants to do something for two hours or so.</p>\n\n\n\n<p>So I&#8217;m kind of thinking, would that work for Gutenberg or Core, or is it just something for documentation or for marketing or something like that? But yeah, that&#8217;s what&#8217;s going on in my head about that after the conversations that I had. Because someone asked me in the talk kind of, &#8220;oh, I just want to fix one little thing. Do I have to read it all?&#8221; And I said, well, you need to, at least some of it. Because somebody&#8217;s going to review your stuff, and if you are not following the guidelines, then you are wasting their time and yours too, because you have to redo it again. So I think it would be better to, but that kind of thing, &#8220;well, you&#8217;re doing it wrong.&#8221; Not very welcoming.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah. But then it&#8217;s important that we have at least some loose standards, so it&#8217;s just better for everyone involved with reviewing and writing. I think that&#8217;s some really good insight from people who want to contribute. I think there is a lot to read and obviously it&#8217;s important to know most of, all of the guidelines, but maybe there&#8217;s a big time sync at the start and then once you&#8217;ve got your head around it, or maybe you could make your own notes as well, like shorthand notes, and then hopefully after that point it&#8217;s much easier to jump in and just do an hour here or there. But easier said than done. And it can be quite intimidating as well.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, it can. And I try to like it with, when you start with a new company. So in a new company you get 30 days, but you are not going to touch code in that 30 days. You read all the handbooks and all that. So it&#8217;s kind of wanted and it&#8217;s necessary. So why would an open source project not require people to do that? Especially when they&#8217;re in there for the long haul. If you just want to badge, okay, fix some documentation and send to PR and then you&#8217;re done.</p>\n\n\n\n<p>But if you want to really make an impact, it&#8217;s important to know how the ins and outs are, because then you develop a shortcut with the other contributors.</p>\n\n\n\n<p><em>Sarah Norris:</em> Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, we have&#8230; I think the numbers are staggering, so every Gutenberg release has at least 6 to 13, so it&#8217;s first contributors every release. And 6.7 I think the numbers were really interesting. It was over 780 contributors and 230 were first contributors, so a third. Well, more than a third were new contributors. So yeah, there&#8217;s some great brave people out there who start with the open source project and come in and contribute. That&#8217;s really great.</p>\n\n\n\n<p><em>Sarah Norris:</em> Yeah, that&#8217;s amazing. That&#8217;s such a good number. See if we can be 6.8 or maybe 6.1.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> We&#8217;ll see. Yeah, 6.8 might even be more because, it&#8217;s such a long runway.</p>\n\n\n\n<p><em>Sarah Norris</em>: Right. Yeah.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Announcements</h3>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: So we&#8217;ll see, we&#8217;ll see what comes out of it. But now all about contributing. Let&#8217;s go a little bit further. We have some announcements for those who want to build on top of WordPress, and that&#8217;s the Developer Hours. And I made it a ritual that every podcast we&#8217;re kind of talking about the Developer Hours a bit.</p>\n\n\n\n<p>So there is one coming up on December the 17th and that&#8217;s the Developer Hours, Everything you need to know about WordPress Playground, and that&#8217;s on December 17th at 16:00 UTC, and it&#8217;s the final Developer Hours of 2024. But I don&#8217;t think an hour is enough to learn everything you need to know about WordPress Playground, so take it with a grain of salt.</p>\n\n\n\n<p>But Nick and Ryan will try their very best. They take a closer look at WordPress Playground. Because this tool lets you create fully functional WordPress instances directly in your browser with no installation on setup required beyond spinning up WordPress sites, Playground also offers powerful capabilities from testing plugins and themes to running demos, and even supporting app development. No matter how engaged you are with WordPress, Playground has something valuable to offer to you.</p>\n\n\n\n<p>Yeah, I&#8217;m a total fan of Playground and I have done some Footprints and also did some workshop. Oh, I&#8217;m actually doing a workshop at WordCamp Asia about creating a demo with Footprints for Playground. So you only give the people a link and then they can play around with your plugin or play around with your theme, and that&#8217;s such a cool tool to do.</p>\n\n\n\n<p><em>Sarah Norris:</em> Yeah, actually plugin, sorry, Playground itself is so helpful for if you&#8217;re doing talks like the WordCamps and events and stuff because can give people&#8230; You&#8217;re talking about a new feature you&#8217;ve built or you&#8217;re showing something off that&#8217;s just been released and then you can say, now visit this Playground link thing, or you can go and play with it immediately. You don&#8217;t have to go back and wait until you&#8217;re working on your own instance or&#8230;</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Right. Yeah, you can do it&#8230; You could even do it on your mobile phone. It&#8217;s a little slow if you have a slow connection. But yeah, I really love that. It&#8217;s for someone who grew technical in the age of the early internet where you had HTML, but you needed a server, you need FTP, you need kind of a hosting company and a database server, that you need to hack into with phpMyAdmin. And then of course the application server with PHP and there&#8217;s so many things that need to go into, to actually have a website that you want to play with. That Playground is just magic. It&#8217;s really something. How can that be, that the browsers are&#8230; the machines are so powerful to have it all in one browser, it&#8217;s amazing.</p>\n\n\n\n<p>Then this week&#8217;s Developer Hours recording is available. That was about improving your workflow with WordPress development tools, and Ryan Welcher, and Nick did that as well. And they took a deep dive in the advanced usage of the tools like Create Block Scaffolding or WP Scripts, along with a few others, and they focused on solving common challenges and showcasing techniques that go beyond the basics, even for developers already familiar with these tools. So that&#8217;s definitely one to watch for someone who has already got their feet wet halfway into Block Development and see how you can streamline your process and your debugging superpowers.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Community Contributions<strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</strong></h3>\n\n\n\n<p>All right, so next up I have three&#8230; Fun and Games was a headline that I did in the weekend edition of last week, and today is December 6th that I record this with Sarah Norris, and I found three things that are very fun to do, no commercial value at all, but it shows the fun that you can make with Good Mood. And Aki Hamano demoed on X how code is music and shared a video on how he used his Piano Block to create music and record that. I have not yet found out how he recorded it, but you can actually study the source of the Piano Block on GitHub.</p>\n\n\n\n<p>And of course I share all the links with you in the show notes, so you can follow up on that. But that was really cool. It kind of has the Block Editor and then a piano kind of keyboard with a few additional dials and then it has continuing music in there. That was really fantastic, yeah.</p>\n\n\n\n<p><em>Sarah Norris:</em> It&#8217;s such a good idea. I really like the code is music line as well. It&#8217;s so good.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, it comes from code&#8217;s poetry, right?</p>\n\n\n\n<p><em>Sarah Norris</em>: Yeah, yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And then Tom Rodes used the Gutenberg Block to run a snake game. There&#8217;s a snake coming in and you need to navigate it so it eats the block. There&#8217;s a square on the canvas and your snake needs to eat the block and you need to navigate it with the keys WASD with up and down and left and right. That&#8217;s kind of in-between when you have a Block on your creativity or a Block on a bug that you need to solve, play that for a moment. It&#8217;s really cool. And he also got it inside a playground, so really love that. Yeah, Tom Rodes is on the engineering team of Automattic, and he just shared those on his private personal blog, and he used React to run it in the Gutenberg Editor.</p>\n\n\n\n<p>And the last one is from Jonathan Bossenger who created a variation of the dodge game, and you can play it on his site, and he used it to dive into the interactivity API directives. And his code is also available on GitHub, but that is a game where the logos of Wix and Squarespace and Weebly kind of chase the WordPress one, and you need to get out of the way. You&#8217;re the WordPress one, and you need to get out of the way with the arrow keys. So it&#8217;s kind of interesting. I don&#8217;t think he&#8217;s finished yet. He wants to display the&#8230; What is it? The highest scores as well. But it&#8217;s not there yet. But yeah, maybe you can do some tournaments or so with those two games.</p>\n\n\n\n<p><em>Sarah Norris:</em> Yeah, that&#8217;s a fun one.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, it&#8217;s very fun. So that&#8217;s kind of coming after Matt Mullenweg asked to bring more fun to Gutenberg. So here we are, first three examples.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s Released &#8211; Gutenberg 19.8</h3>\n\n\n\n<p>And that brings us to the Gutenberg 19.8 Plugin release. It has 149 PRs by 52 contributors, 6 of them first-timers. And there were 34 enhancements and 48 bug fixes.</p>\n\n\n\n<p>The enhancements were mostly nice quality of life improvements to make users much more confident about what just happened, kind of what did I do or what didn&#8217;t I do. So let&#8217;s dive in. Do you want to start?</p>\n\n\n\n<h3 class=\"wp-block-heading\">Enhancements</h3>\n\n\n\n<p><em>Sarah Norris</em>: Yeah, let&#8217;s see. What have we got first? We&#8217;ve got this one about making the Social Block Icon navigation&#8230; Well, improving it with keyboard navigation. So previously I think it required two taps of enter, if you&#8217;re navigating by keyboard, which I don&#8217;t think was intentional and was just the side effects of where we used the markup basically. But now the markup has been improved and it only requires one hit of enter to navigate through the icons.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Sarah Norris:</em> Like I say, it feels like just a small quality of life improvement, but it&#8217;s one of these tiny details that really makes things just feel much better.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Right. And when you use the Social Icon Block often you halve your time that it takes to build it out. So yeah, it&#8217;s streamlined.</p>\n\n\n\n<p><em>Sarah Norris:</em> Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And the next one is the page list has now Border and Spacing Support, that&#8217;s in line with all the other efforts to bring Border and Spacing Support to as many Core Blocks as possible. And so in 6.7, there were a ton of Blocks getting new border support and this one is now coming for 6.8.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah, it&#8217;s so good to have those controls. It just feels&#8230; Yeah, they&#8217;re visual controls, so having them on as many Blocks as possible is great. The next one we have is another&#8230; Well, it&#8217;s a Social link Block, it&#8217;s related to Social, adding the content-only editing support. So I think previously when you&#8217;re in content-only editing mode with the Social link Block, you couldn&#8217;t edit the URLs of the links, but now that the Content Support has been added, you can edit that link. It just makes sense, as you&#8217;re going through the links that you can edit the link itself rather than just staring at the block thinking, there&#8217;s something…</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Well, how do I get there? Yeah. Especially when the link is wrong. You can use the Social links for so many things. So if you have a team or author list where you want to put the Social links in or for the website, how to get the people that build the website on the social website, it&#8217;s such a versatile block that it definitely needed some more attention. Yeah, absolutely. Yeah.</p>\n\n\n\n<p>So part of DataViews, there were two improvements amongst, or the many improvements that came in with that release, and one of them, it&#8217;s called the density option of a Table layout, but what it really does is actually have three levels of how much white space or between the rows in a table. Sometimes you want to have it really dense, because you want 60 or 70 pieces on the screen, and sometimes you just want to have four or five on it, and then more white space makes a better layout, but there is now, as a user, you can change those density options. So it&#8217;s really cool. It&#8217;s between comfortable, compact and default or something like that, that has a line that you just tip on it and see how that works.</p>\n\n\n\n<p>The second one is for the extensibility or for plugin developers, and of course also for core that you can register and unregister fields that are in display. So if you don&#8217;t want the post layout to show the date of the publishing date, you can unregister that field for the layout. And that is something, because the data use will have such a broad application, so every plugin, every custom post types, any additional features that come into WordPress might want to use that. So the use cases are so vast that extensibility is one of the first things that they look at now when they build that out.</p>\n\n\n\n<p>And with the custom fields kind of being part of the&#8230; It&#8217;s not only custom fields, it&#8217;s also fields from the meta places, meta table or Post Meta that you can unregister there as well.</p>\n\n\n\n<p><em>Sarah Norris:</em> Yeah. Yeah, that&#8217;s really cool. It&#8217;s off of that level of flexibility. It&#8217;s really good. Our next section is the global styles changes. Well, a couple of things that were experimental marked as experimental in Gutenberg, but they&#8217;ve now been stabilized, so they&#8217;re not experimental anymore. It&#8217;s probably something that we&#8217;re not always that quick to change in Gutenberg. There&#8217;s so many things going on, but yeah, it&#8217;s always great to see when the experimental flag has been removed. So it&#8217;s been removed from the Block. Which one? Which block is it? It&#8217;s for borders, is it Block Supports?</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. And it&#8217;s also text, the borders and also the default content. No, it&#8217;s not default content, hang on.</p>\n\n\n\n<p><em>Sarah Norris:</em> Default controls.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Default controls, yeah.</p>\n\n\n\n<p><em>Sarah Norris:</em> Yeah. And skip serialization and the border controls as well.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah.</p>\n\n\n\n<p><em>Sarah Norris:</em> Developing Gutenberg, you&#8217;ll probably know about these things and that you&#8217;ve been needing to add experimental, so you don&#8217;t need to add that anymore, because it&#8217;s…</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Right. And they are really heavily working on backwards compatibility, because there are multiple levels where these Block styles come in, and then one is core, one is a plugin and one is a theme. If either one of them uses experimental, what wins? So that&#8217;s kind of a little bit of a tricky approach. And I am fairly sure that although that&#8217;s merged now and released that there will be some adjustments to be done. But this early release is really important for those who have been using the experimental flags or methods and settings to test the code and see what happens with the code or what needs to be changed, especially plugins and themes.</p>\n\n\n\n<p>It also, and I&#8217;m really happy about that, as soon as they are stabilized and from this day on forward, the blockers to adjust or adopt Block Development or Block Themes are getting less and less, because that is for a lot of developers, a blocker says, &#8220;well, this is experimental. If I base my code on it, I never know what&#8217;s happening, because experimental is not documented.&#8221; There&#8217;s no promise of backwards compatibility and it can change at any moment. So I need to be really watching for that and I don&#8217;t have time for that. Or I don&#8217;t want to waste time to redo it over and over again because things change. So they held off in adopting some of the features that are now coming out of experiments. So that&#8217;s a good sign, to increase adoption of things.</p>\n\n\n\n<p><em>Sarah Norris</em>: Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> So the next thing I really like, that&#8217;s what I referred to when I said at the beginning, what actually happened, if the quality of life, when the user knows exactly what happened, the Block editor now has notices after actions that are coming from the image editing. So it will show you, okay, cropping done, or do you want to undo in a little notification settings where you also see view post and these, it&#8217;s on the bottom right of your screen once you&#8217;re done with either cropping or replacing or something like that on the image editing features, now you know what happened and that it was a success. Yay. Before it was really, did it work? Did it not work? Or let me look at it, how it looks at the front end. Yeah.</p>\n\n\n\n<p><em>Sarah Norris:</em> Yeah, yeah. Left you guessing. Really good. The next section we got is for the REST API. So we have a new feature for allowing setting the editor rendering mode by post type. So this allows the user to define the default rendering mode for the editor with a post-type. So it adds a filterable default rendering mode property to the post-type object, allows you to easily switch between the template view and the post-only view, allows you to change the default. Because the template view makes it easier to see what the content will look like on the front end. And there&#8217;s a few things that are only available in template view, because it&#8217;s more for the design editing, but then the post-only view is for editing content. So for decorations, you&#8217;re going to want the different views and this lets you control the view.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, there are quite a few developers who like that. That is coming now. And then the next one is in the Zoom Out View. So the Zoom Out View helps you when you add patterns to, or it automatically goes in&#8230; Your canvas goes automatically into Zoom Out mode when you try to add a pattern to it and then you can drop and drag it and drop it into a section on that. But then if that pattern has a section styles attached, no, it&#8217;s not attached, but if it&#8217;s a Group Block and there is section styles for group, then you can navigate through just a little button through the color settings of that particular section and you see how it looks in blue or in dark mode or in black and white.</p>\n\n\n\n<p>So that&#8217;s really nice to easily organize, see how the page&#8230; You don&#8217;t have to go to the sidebar and find the switch. You just kind of loop through the button. It&#8217;s really cool. There&#8217;s also a button next to it that says change design button or change design, and I have not yet found how it&#8217;s triggered, but sometimes it&#8217;s there and something it&#8217;s not. It&#8217;s probably that you have a same category for the Call for Action, and then you can change the design for the Call for Action and loop through all the available patterns for that particular task. So that&#8217;s also very cool to see.</p>\n\n\n\n<p>You don&#8217;t have to go back-and-forth and back-and-forth to figure that out. You just use those two buttons to see how it changes, and how it changes in the context of your page. So this is a really great feature. It sounds so, oh, we add a button to that, but it&#8217;s just a powerful superpower.</p>\n\n\n\n<p><em>Sarah Norris:</em> Yeah. I think anything like this, especially in Zoom Out mode, it really takes the cognitive load away for designing a site and it makes it so much quicker. You can just cycle through all these available styles immediately. So within five minutes you have a design that you probably would&#8217;ve taken you hours previously.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Just to see what the theme offers and what you want to use and kind of&#8230; So it&#8217;s a really powerful thing. Yeah.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah. The next thing we have is, so in the site editor, again in the Blocks, adding a check for the parent before converting a block to a pattern. So I think previously you could select child blocks and convert those to a reusable pattern, which usually doesn&#8217;t make sense, or it&#8217;s not ideal. So now there&#8217;s an additional check to check that the block is the parent before converting it to a reusable pattern.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> No, I think that&#8217;s a good there, because sometimes people didn&#8217;t know that it was only part of the pattern and yeah, it&#8217;s kind of&#8230;</p>\n\n\n\n<p><em>Sarah Norris:</em> Right. Yeah, put it on a Group Block or whatever. If you select the next InnerBlock, because sometimes that&#8217;s going to be the more obvious block to select as well, and then you make that reusable, you&#8217;re going to miss the block out of the reusable pattern, and that&#8217;s going to be holding everything together.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. And where all the section styles are applied to, yeah.</p>\n\n\n\n<p><em>Sarah Norris:</em> Right. Yeah, exactly. Yeah, you&#8217;re going to miss all these styles.</p>\n\n\n\n<p>Birgit Pauli-Haack: Yeah. The next thing is&#8230; I also like that, and it&#8217;s really, it&#8217;s the font family preview in the font family picker. So on the right-hand side, when you open up the taxonomy font family, it not only lists the name of the fonts, but also how it&#8217;s actually rendering that. So you see more closely what the font would look like when you&#8217;re selected for your header or for your paragraph or even for all the blocks. So that&#8217;s another take the guesswork out of it and let me see what I&#8217;m doing feature.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah. It&#8217;s really cool that it&#8217;s in a drop-down as well. It&#8217;s cool that we have a component in Gutenberg that allows you to show all these different font families.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah.</p>\n\n\n\n<p><em>Sarah Norris:</em> It looks so&#8230;</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> That you can style them, yeah.</p>\n\n\n\n<p><em>Sarah Norris:</em> Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>The font family. Yeah. Yeah. So that was actually all the things&#8230; No, that wasn&#8217;t all the things that I wanted to talk about.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bus Fix</h3>\n\n\n\n<p>But I also wanted to, there&#8217;s a bug fix for Zoom Out, but it&#8217;s actually a feature, it&#8217;s kind of disabling Zoom Out when in distraction-free mode is activated. And of course, you don&#8217;t want to all of a sudden kind of look at the whole thing when you say, I only want to do distraction-free mode, get away from me, all the block stuff and all the features, and all of a sudden you find yourself in a Zoom Out mode. That&#8217;s definitely a little bit disconcerting there.</p>\n\n\n\n<p><em>Sarah Norris</em>: Yeah, because Zoom Out is more for designing. You can use it for whatever you want, but I&#8217;d definitely say you&#8217;re probably going to be designing the whole site if you&#8217;re in Zoom Out mode, whereas it&#8217;s for free. It&#8217;s in the name, isn&#8217;t it? You don&#8217;t want any control. Don&#8217;t show me any tool list or anything.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah.</p>\n\n\n\n<p><em>Sarah Norris</em>: So Zoom Out, but it&#8217;s a bit of an odd experience. So yeah, good to see that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, I&#8217;m writing here, not there. I&#8217;m writing here, get out of my way.</p>\n\n\n\n<p><em>Sarah Norris:</em> I need to see the words, don&#8217;t make them smaller.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Experiments</h3>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah. Right. Yeah. What happened? And I wanted to point out also, in the Changelog there&#8217;s always an experiment section. One of the experiments is the Inline Commenting and it just updates the placement of the reply. So Inline Commenting is when you can add for each block on a canvas a comment, and then there can be a conversation about that with a reply.</p>\n\n\n\n<p>And also it shows the author info and all that, and it updates just a placement where the reply is going to be put. If you want to try that out, you need to enable that Inline Commenting on the experiments page of the Gutenberg plugin. And it would be really helpful if you dive in there and add your comments to, there&#8217;s a tracking issue, I will share that tracking issue for Inline Commenting in the show notes, where you can leave comments about your experience. Because of course it&#8217;s called experiment for that reason. They don&#8217;t know yet what&#8217;s their final version is of it.</p>\n\n\n\n<p>But sometimes you don&#8217;t know what you get until&#8230; You don&#8217;t know what you want until you see what you get, and that&#8217;s kind of that part of it. This is what we have now, what you like and what you don&#8217;t like.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah, exactly. Yeah. It&#8217;s so important, even though they&#8217;re experimental, I guess kind of related to stabilizing the block supports as well, until they&#8217;ve actually been in use and you&#8217;ve tested them out and used them in lots of different situations, you don&#8217;t really know when they&#8217;re not experimental anymore until you know. You&#8217;re like, &#8220;okay, what happened?&#8221;</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah. So in the next one, experiment means that the right mode functionality that the team has been working on for quite a while is now a functionality behind the Good Mood experiment. Also, because of the reason that there is so many opinions about how it&#8217;s going to work or should work or part of it, but one does not really know what good it does for the whole experience. So yeah, you find that on the experiments page as well.</p>\n\n\n\n<p><em>Sarah Norris:</em> If anyone&#8217;s interested in that. There is a very good issue linked to this PR that we&#8217;re looking at, and it&#8217;s got a well organized to-do list for stabilizing that whole experience. So if anyone&#8217;s interested in helping out there, there&#8217;s a very easy to use to-do list, which is always the nicest thing if you&#8217;re into to-do lists and what checking things up.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So I&#8217;m going to share that also outside the changelog there. All right.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Documentation</h3>\n\n\n\n<p>I wanted to point out in the documentation section of the Changelog, all the changes that are made to the Storybook. So the Storybook is a way to see components outside of the WordPress content, but also see what are the attributes and design tools that are available for that particular component.</p>\n\n\n\n<p>So for developers, it&#8217;s really a great way to explore components that you might use in your app or in your blocks. And it has gotten a lot of reorganization because it was just one long list of components and now they&#8217;re categorized. So there&#8217;s a layout category, a section layout category and fonts category and all that. So it&#8217;s really more organized because it also will house all the design standards that are coming out of the design team with the color settings and some of the other standards as well from settings as well. We all are working from the same interface standards, and it needed a little bit more organization there.</p>\n\n\n\n<p>So it&#8217;s also differentiating between the stable components and the experiment components. Both of them have all the categories in there and then the block mover story. So they&#8217;re called stories when you want to have that interface, be interactive, and some of them are now updated with the Readme files, and there&#8217;s an ongoing process to update the documentation for the stories.</p>\n\n\n\n<p><em>Sarah Norris</em>: I think contributing to the Storybook is a really nice intersection between writing documentation and coding, especially if you&#8217;re learning to build with Gutenberg. Because as you&#8217;re learning and you&#8217;re like, oh, this is missing from the docs, then you can go and write a story and fill in the docs. That might be a good area for contributions. I&#8217;ve never really thought about it until we were just talking about it here.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Right. Yeah, yeah, no, I get it. Yeah. But you need to know a little bit about the Storybook library for that, and of course of the React library. But yeah, maybe we can do a pre-beginner&#8217;s show about how to contribute to Storybook or something like that.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Like that.</p>\n\n\n\n<p><em>Sarah Norris:</em> You can get really stuck into the stories and it&#8217;s kind of therapeutic, because they&#8217;re all the same, so you&#8217;re doing the same pattern over and over, and it&#8217;s very satisfying to complete stories for each component. So it&#8217;s a good area for first-timers.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So is there anything else, things that you found that you wanted to talk about or that you want to point out for our listeners?</p>\n\n\n\n<p><em>Sarah Norris:</em> I don&#8217;t think there was anything else in this.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, it&#8217;s all code quality and ESLinting and all components, the other components changes, but they were all just code quality changes, that changed the button size or deprecate some size values. All right, so this is the end of the 19.8 Good Mood Changelog.</p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s in active development or discussed</h3>\n\n\n\n<h4 class=\"wp-block-heading alignwide\">Create-Block Theme<strong>                                                  </strong></h4>\n\n\n\n<p>So we&#8217;re coming to the section of what&#8217;s an active development or discuss. I wanted to take the opportunity to talking to Sarah, to talk also about the Create Block Theme Plugin and see what&#8217;s in the works. And there was a release a couple of months ago, but there are also things that you are working on, so why don&#8217;t you take us through it?</p>\n\n\n\n<p><em>Sarah Norris:</em> Yeah. Yeah. So it hasn&#8217;t really been prioritized that much recently. I think we kind of go in waves and it really depends what&#8217;s happening in the Gutenberg repo as well. Because we don&#8217;t want to be competing. We want to either complement each other or if something&#8217;s taken a while to come into Gutenberg, then maybe we can get it into the plugin first. So it&#8217;s always a little bit tricky trying to decide what to work on. And then if there&#8217;s nothing happening in that plugin, it&#8217;s probably because we&#8217;re like, oh, patterns seem to be getting quite a lot of work in Gutenberg. Let&#8217;s just cool it a little bit in the plugin and see what happens. And then we&#8217;ll come back to plugin.</p>\n\n\n\n<p>So I think we&#8217;re kind of in one of those flows at the moment, but my feeling is that probably in the new year we&#8217;re going to pick up work again. And we already have a few things in flight from a lot of different contributors as well. There&#8217;s some improvements to pattern management. Bug fixes with the way that Theme JSON is passed. And there&#8217;s a fix for localizing the background image URL on the Cover Block as well. So there&#8217;s a few specific fixes and then some pattern management improvements.</p>\n\n\n\n<p>But then we also have so many issues in there. It&#8217;s getting a mini version of Gutenberg really. So yeah, we have got a project board actually, if anyone&#8217;s interested in helping out. There&#8217;s definitely some triage work that could be done, but we do have an existing list of things that we think are good things to work on next. We definitely welcome more contributors. I think it&#8217;s a really good place to work if you&#8217;re interested in Block Theming and you like working on Gutenberg as well, but you maybe don&#8217;t want to dive too deeply into the Gutenberg repo. It&#8217;s a very specific smaller repo, but with basically all the same guidelines and stuff.</p>\n\n\n\n<p>So yeah, I don&#8217;t have any specific news, but I do think work is going to pick up in the next month or so. And I&#8217;m looking forward to getting another release out as well.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. So from the conversations that I had on Core Days and also Word Games recently is that a lot of people really like the Create Block Theme plugin just to get easily out the user changes that are in the Block Editor, in the Site Editor, specifically changing Block Styles or having new headers, changing templates. There&#8217;s a lot of things that can go on a site and agencies really like it, that they can get everything else in the file directory style again, and then in the GitHub for version control.</p>\n\n\n\n<p>So that&#8217;s a really good plugin to use for that, especially when you&#8217;re theme developer. Or the site builders are actually no coders that use the site editor to build it out and then you can in one swoosh kind of put it back into the final.</p>\n\n\n\n<p><em>Sarah Norris:</em> Yeah. Yeah, that&#8217;s essentially what the plugin is, it&#8217;s a good way to sum it up. It&#8217;s basically from database to file system.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Right.</p>\n\n\n\n<p><em>Sarah Norris:</em> The whole site edits the stuff. Yeah, that&#8217;s what we see so often, so many people want&#8230; Because of course you want a version control, the new way of theming, but everything tends to go&#8230; Because, again, obviously it goes into the database because it&#8217;s all changes on that side. So yeah, it just gives you a way to easily pull that out into the files. But yeah, I think we have the same problem as everyone else as well. It&#8217;s tough to keep up with Gutenberg.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. That&#8217;s what I figured. Yeah. Especially with the section styles that came in 6.7, 6.6, and then I&#8217;ll find a nice one in 6.7, with a new theming, the default theme as well. And it&#8217;s not settled yet there. There are some quirks with the section style, so I think waiting for them to resolve would really be helpful before you add them to the Create Block Theme plugin.</p>\n\n\n\n<p>And the pattern export, that&#8217;s pretty much the one that&#8217;s missing, what people feel missing, but there is no way around it. Through the pattern page you can actually mark the patterns that you want to export and put it all in one JSON file, and then add it to your&#8230; You obviously need to massage those files to get into your theme, but you definitely can at least get them out the database and into a file system, even if it&#8217;s just JSON.</p>\n\n\n\n<p><em>Sarah Norris:</em> With the Create Block Theme at the moment you can export patterns. So we do have the starting of pattern management so you can export sync patterns.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh, cool.</p>\n\n\n\n<p><em>Sarah Norris: </em>Yeah. Yeah. It&#8217;d be great to get more feedback on that, because I think ideally you want to export any pattern.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah.</p>\n\n\n\n<p><em>Sarah Norris:</em> Well, in my mind, we probably need to add UI to the patterns page, because at the moment, all the controls are on the Create Block Theme panel, and it&#8217;s getting a bit full. So I think, yeah, we maybe need to add another panel that&#8217;s specific to patterns and then we can do some more fine-grained control on the patterns page. And then when you go to export, then maybe you could open the original panel and then you&#8217;ve already set up way off, for what patterns to be exported. But yeah, there&#8217;s some initial work there, so you can export some patterns.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yes. Excellent. Yes, but not others. Yeah, I think what a lot of theme developers are really waiting for is the Synced Pattern overrides for Themes, that they can offer some patterns. Half the content kind of singled out, but you can&#8217;t change them anymore, only change them with&#8230; And change them then side-wide. Something that the theme developers are really waiting for. A lot of us have had hoped that it would be in 6.7, but yeah, we will see if it makes it into 6.8.</p>\n\n\n\n<p><em>Sarah Norris:</em> That was partly why we added the Synced Patterns to Create Block Theme, because it&#8217;s like halfway to the Synced Pattern overrides that&#8217;s coming in Gutenberg. But yeah, we were the same. We were kind of waiting and just like, oh, we won&#8217;t work. Because we both, the primary contributors who work on both the plugin, and we work on Gutenberg as well. So it&#8217;s kind of like, do I work in this? Do I put all my time into Gutenberg or do I put a bit of time into Create Block Theme? So yeah, because we thought that was coming. But yeah, it is coming. It&#8217;s just&#8230;</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> It&#8217;s coming, but it&#8217;s tied to the Block Bindings API. And the block bindings API is definitely not finished and it&#8217;s only for four blocks, and before they want to add it to other blocks, they still need to figure something out. There are a few technical hurdles there, and as long as the Block Bindings isn&#8217;t finalized I think the Synced Patterns overrides won&#8217;t make it for themes. Because all of a sudden you also have backwards compatibility issues there with themes. But good things to come for Twenty Twenty Five. Are you looking forward to a special thing that might come in 2025? Well, we don&#8217;t have a roadmap yet, but yeah, we all have hopes and dreams.</p>\n\n\n\n<p><em>Sarah Norris</em>: I guess the roadmap probably coming soon though as well. There&#8217;s so many things going on. I&#8217;m really looking forward to seeing where all the stylebook changes end up. That&#8217;s feeling really good and I&#8217;m looking forward to seeing where that evolves. And I&#8217;m really enjoying working with DataViews as well. I really like all the stuff that&#8217;s foundational. Because it feels like that&#8217;s going to be like a 10 times or a 100 times in quality or experience. Yeah, I&#8217;m enjoying seeing those at the moment, so I&#8217;m looking forward to what&#8217;s coming next year with both of those.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, I have the same thing. It&#8217;s kind of the DataViews are really exciting when you kind of think, I don&#8217;t know if we get to that in Twenty twenty five, that it will take over WP admin, but I think we get a good look at how it could be. There&#8217;s a lot of extensibility issues that need to be worked out because that has been around for so many, many years and people have built on it. And the backwards compatibility piece is really something that you don&#8217;t want to mess up too much. So I think there&#8217;s a lot of conversations and back-and-forth, and also testing to be done from the plugin developers community that need to come around and figure out what they need and what they don&#8217;t need.</p>\n\n\n\n<p><em>Sarah Norris:</em> I&#8217;d also like to see some more fun blocks as well, encouraging people to build more pianos and snake games.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Well we are also waiting for accordions and tabs.</p>\n\n\n\n<p><em>Sarah Norris:</em> Yeah, that&#8217;s exciting. But probably more important, yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> But yeah, I like the fun part. And also, I saw some great patterns, visual patterns that I want to see if we can do this with blocks, kind of Group Blocks, InnerBlocks, and have some fun with that on a visual part of it and maybe expand the Block Museum again, that has been around for two years now, or even longer, I don&#8217;t know. Yeah.</p>\n\n\n\n<p>So yeah, I&#8217;m looking forward to the State of the Word. I think there&#8217;s some great stuff that&#8217;s coming in there that we know of, on what the outlook is. State of the Word, if you haven&#8217;t seen it yet, is on December 16th at 9:00 AM UTC, though that&#8217;s middle of the night for the Americans. But it will be live-streamed and it&#8217;ll be recorded and it&#8217;ll be available probably within two or three hours of the event ending.</p>\n\n\n\n<p>It will be in Tokyo. It&#8217;s a wave at the large Japanese community that has pushed WordPress forward very early on. And I think the market share of WordPress is about 80% in Japan of websites. I remember the story that Matt told at one of the town halls or AMAs throughout the years, that Japanese was the first language it was translated to, and they did a complete copy of WordPress and translated every string and then released the new copy.</p>\n\n\n\n<p>There was no Holly Glots team. There was no tools to do all that and with the PO files and all that. So that was kind of the start of having WordPress in a different language and Japanese was the first language that it was introduced to. So there&#8217;s a big tip to the hat making the State of the Word taking place in Tokyo. And there will be&#8230; Yeah, of course the keynote of Matt, but there will also be&#8230; We&#8217;ll see Mary Hubbard, the new executive director for the open source project and so much more.</p>\n\n\n\n<p>Matias is going to be doing some demos I think. So there&#8217;s some great stuff coming down. That&#8217;s kind of the save the date thing, and that&#8217;s the end of the show. Oh, as always, the show notes will be published on Gutenbergtimes.com/podcasts. This is episode 112, a hundred and twelve, and if you have questions, suggestions, or news you want us to talk about, send them to <a href=\"mailto:Changelog@gutenbergtimes.com\">Changelog@gutenbergtimes.com</a>. That&#8217;s <a href=\"http://gutenbergtimes.com\">Changelog@ gutenbergtimes.com</a>. And the Gutenberg Times is now also on Mastodon and on Bluesky.</p>\n\n\n\n<p>So if you have left Twitter and all of a sudden in search of information, you can get them from Gutenberg Times as well as from myself. Are you on any of the new kids on the block, Sarah?</p>\n\n\n\n<p><em>Sarah Norris</em>: Yes. Yeah, I&#8217;ve been trying to use Bluesky much more and yeah, I&#8217;m really enjoying it. I&#8217;m finding more and more WordPress news coming out over on Bluesky too. Yeah. Yeah, I&#8217;m loving it. Trying to be a bit more mindful about using it as well. I&#8217;m not great at social stuff. But yeah, it&#8217;s the thing at the moment, I&#8217;m going to try and ride that wave and be a bit better at social media.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. It feels like less noise, more signal, but I think the more people are coming, that kind of changes again. But yeah, it&#8217;s really an interesting small community there. A little smaller than on Twitter, but that&#8217;s changing rapidly. I saw in the last two weeks probably they&#8217;ve got 100s of followers more, that are coming over. So it&#8217;s a really good place.</p>\n\n\n\n<p>I&#8217;m also diving into the Mastodon ActivityPub, Fediverse kind of thing. And I need to watch Matias Pfefferle&#8217;s videos that he did with DocPop on the Fediverse. That&#8217;s probably something I&#8217;d do for a holiday vacation, because it&#8217;s not part of my normal job and I really wanted to dive in and see what&#8217;s happening there.&nbsp;</p>\n\n\n\n<p>All right, well thank you so much, Sarah. This was wonderful and lovely to have you.</p>\n\n\n\n<p>And dear listeners, we will be back in the second week of January with episode 113 and see what&#8217;s happening there. We might even push it until Gutenberg 20.0 comes out and see what&#8217;s in there, because it&#8217;s going to be&#8230; Maybe there are some Easter eggs in there. Who knows? All right, get us out of here. Take care. Happy holidays for everyone and a happy and healthy New Year, and I&#8217;ll see you on the other side.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 08 Dec 2024 09:38:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: Bezos at Dealbook\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=131422\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://ma.tt/2024/12/bezos-at-dealbook/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:221:\"<p>It looks like the Dealbook Summit had a number of great interviews this year, major props to Andrew Ross Sorkin, but this one with Jeff Bezos was particularly good. </p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Dec 2024 19:33:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: WordCamp Asia 2025 Unveils Official Wapuu Mascot Tahopuu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=181698\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wptavern.com/wordcamp-asia-2025-unveils-official-wapuu-mascot-tahopuu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2672:\"<p>WordCamp Asia has unveiled its official Wapuu mascot for the 2025 edition: <a href=\"https://asia.wordcamp.org/2025/meet-the-wordcamp-asia-2025-wapuu/\">Tahopuu</a>. Designed by Andrew dela Serna, a talented graphic designer from the Philippines, the mascot was chosen from 10 submissions by designers from India, Malaysia, Nepal, Lithuania, the Philippines, and Ukraine.</p>\n\n\n\n<img width=\"500\" height=\"492\" src=\"https://wptavern.com/wp-content/uploads/2024/12/tahopuu-1-500x492.png\" alt=\"\" class=\"wp-image-181719\" />\n\n\n\n<p>Tahopuu pays homage to Filipino street culture, drawing inspiration from the iconic Taho vendor. Taho is a beloved snack in the Philippines, made from silken tofu, arnibal (caramelized sugar syrup), and sago pearls.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>“This year’s Wapuu selection was a true testament to the bayanihan spirit — a Filipino value that embodies community, collaboration, and coming together to achieve something greater.”</p>\n\n\n\n<p>-WordCamp Asia Organizers</p>\n</blockquote>\n\n\n\n<p><a href=\"https://asia.wordcamp.org/2025/\">WordCamp Asia 2025</a> is scheduled from February 20th to 22nd at the Philippine International Convention Center (PICC) in Manila. The organizers have already announced 5 rounds of <a href=\"https://asia.wordcamp.org/2025/speakers/\">speakers</a> and three invited speakers &#8211; <a href=\"https://asia.wordcamp.org/2025/first-invited-speaker-matt-mullenweg/\">Matt Mullenweg</a>, <a href=\"https://asia.wordcamp.org/2025/second-invited-speaker-matias-ventura/\">Matías Ventura</a> and <a href=\"https://asia.wordcamp.org/2025/third-invited-speaker-christy-nyiri/\">Christy Nyiri</a>. They are also scouting for the <a href=\"https://wptavern.com/wordcamp-asia-seeks-host-city-applications-for-2026\">next host city</a> for the 2026 edition.</p>\n\n\n\n<p>The detailed schedule of the event is yet to be released. But the event will kick off with <a href=\"https://asia.wordcamp.org/2025/contributor-day/\">Contributor Day</a> on February 20 and there will be a special <a href=\"https://asia.wordcamp.org/2025/igniting-the-future-youthcamp-at-wordcamp-asia-2025/\">Youth Camp</a> for children aged 8-17 on February 22. Jamie Marsland’s popular <a href=\"https://asia.wordcamp.org/2025/open-your-possibilities-by-learning-from-the-experts-wordpress-speed-build/\">WordPress Speed Build Challenge</a> is also scheduled where Jessica Lyschik and Nick Diego will attempt to recreate a famous website in just 30 minutes using only Gutenberg blocks.</p>\n\n\n\n<p><a href=\"https://asia.wordcamp.org/2025/tickets/\">Tickets</a> are still available for the 2025 event.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Dec 2024 18:57:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: Gravatar Introduces Free Domains and Bluesky Integration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=181613\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wptavern.com/gravatar-introduces-free-domains-and-bluesky-integration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2102:\"<p>Gravatar, or &#8220;Globally Recognized Avatar,&#8221; now <a href=\"https://blog.gravatar.com/2024/12/03/new-free-domains-and-bluesky-integration/\">offers its users</a> more free domain options and Bluesky integration for a limited time. These domains, featuring extensions like .bio, .link, .social or .contact, can be used across the Gravatar profile, email signature, or business cards and seamlessly integrate with Bluesky, the decentralized social network that&#8217;s gaining traction.</p>\n\n\n\n<img width=\"2188\" height=\"982\" src=\"https://wptavern.com/wp-content/uploads/2024/12/image.png\" alt=\"\" class=\"wp-image-181621\" />\n\n\n\n<p>Bluesky uses domains as handles instead of traditional @usernames giving users more control over their online identity and Gravatar users can use their custom domains as their Bluesky handles. Custom domains build trust and credibility, ensuring a unique and professional online presence.</p>\n\n\n\n<p>Users can claim their domain directly from their dashboard, connect it to their Bluesky account, and start using the domain as their Bluesky handle. No need to worry about complex DNS configurations or technical know-how. </p>\n\n\n\n<p>Gravatar is offering the first year of domain ownership completely free. But this offer is only available for a limited time. For more information, check out the <a href=\"https://support.gravatar.com/bluesky-custom-domain-handle/\">guide</a> on using Gravatar with Bluesky.&nbsp;</p>\n\n\n\n<p>The Gravatar team shared that “This integration reinforces our belief that everyone should have full ownership of their digital identity.”</p>\n\n\n\n<p>The Gravatar team became active again in 2023 after a long hiatus, launching new payment features for profiles. Then they released a new <a href=\"https://blog.gravatar.com/2024/06/03/profiles-as-a-service/\">REST API</a>, native integrations for <a href=\"https://blog.gravatar.com/2024/10/30/introducing-native-integrations-for-gravatar-mobile-sdk/\">Gravatar Mobile SDK</a> and<a href=\"https://blog.gravatar.com/2024/09/11/gravatar-enhanced/\"> Gravatar Enhanced plugin</a> for WordPress.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Dec 2024 17:29:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: BuddyPress Lead Developer Mathieu Viet Leaves WordPress Ecosystem\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=181533\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wptavern.com/buddypress-lead-developer-mathieu-viet-leaves-wordpress-ecosystem\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3106:\"<p>BuddyPress Lead Developer Mathieu Viet has <a href=\"https://imathi.eu/\">announced</a> his departure from the WordPress community, marking the end of a long-standing association that began with BuddyPress 2.0.</p>\n\n\n\n<p>In a statement shared on his<a href=\"https://profiles.wordpress.org/imath/\"> WordPress profile</a>, he said, “I’ve decided to stop involving into the #WordPress community following the way WordPress leadership decided to prevent some users to benefit from WordPress.org API services just because they were customers of a specific hosting company.”</p>\n\n\n\n<p>Viet has also chosen to stop using WordPress for his <a href=\"https://imathi.eu/\">personal website</a>. He wrote, “While Mr. Mullenweg&#8217;s first attacks pushed me to leave this community and stop contributing to WordPress® open source projects (including BuddyPress®), the latest one (making the premium code of a plugin marketed by the attacked competitor available for free ) convinced me that disapproving and condemning them as a former contributor was not enough. Indeed, I have also decided to stop using WordPress® to manage this website.”</p>\n\n\n\n<p>In October this year, WordPress.org took over WP Engine’s <a href=\"https://wptavern.com/acf-plugin-forked-to-secure-custom-fields-plugin\">ACF plugin</a>, citing security issues, and renamed it Secure Custom Fields (<a href=\"https://wordpress.org/plugins/advanced-custom-fields/\">https://wordpress.org/plugins/advanced-custom-fields/</a>) and then  released the <a href=\"https://wptavern.com/wordpress-org-releases-new-secure-custom-fields-plugin-with-acf-pro-features\">‘Secure Custom Fields’ Plugin</a> (<a href=\"https://wordpress.org/plugins/secure-custom-fields/\">https://wordpress.org/plugins/secure-custom-fields/</a>) with ACF Pro features last month. </p>\n\n\n\n<p>The news of Viet leaving sparked discussions across the WordPress community. One user on <a href=\"https://www.reddit.com/r/Wordpress/comments/1h4ek6j/buddypress_lead_developer_quits_wp_blackout/\">Reddit</a> commented, “I don&#8217;t blame Mr Mathieu, but honestly, I hope as a community, we can bring this madness to an end, A lot of damage has been done, but I am hopeful we can forget the past at one point, make amends and move forward and come back with a fucking vengeance. Not asking for Peace in the World, just asking for Peace in the WordPress ecosystem.”  Others expressed curiosity about which platform Viet would migrate to next.</p>\n\n\n\n<p>Since the Automattic -WP Engine dispute started, several prominent contributors, including <a href=\"https://bjornjohansen.com/farewell-to-wp/\">Bjørn Johansen</a>, <a href=\"https://x.com/cdils/status/1851045517901357510\">Carrie Dils</a>, <a href=\"https://thefragens.com/wordpress-on-hiatus/\">Andy Fragen</a>, and <a href=\"https://chriswiegman.com/2024/10/so-long-wordpress/\">Chris Wiegman</a>, have ceased their involvement with WordPress. Some have <a href=\"https://wptavern.com/developers-remove-plugins-from-wordpress-org-repository-after-acf-controversy\">removed their plugins</a> from the WordPress Repository.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Dec 2024 14:55:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Gutenberg Times: State of the Word, Speed Build Challenge,  Woo Starter Theme and more — Weekend Edition #313\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=31099\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"https://gutenbergtimes.com/state-of-the-word-speed-build-challenge-woo-starter-theme-and-more-weekend-edition-313/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:24021:\"<p>Hi there, </p>\n\n\n\n<p>In 2015, YouTube reported that every minute, 500 hours of videos are uploaded. One of the most important skills of the 21st century is to locate trusted sources of relevant news and use critical thinking to separate the wheat from the chuff. </p>\n\n\n\n<p>And then, Artificial Intelligence (Short AI) entered the stage from the left. It has almost replaced my Googling habit. More often than not, I use <a href=\"https://www.perplexity.ai/\">Perplexity.ai</a> to get real answers to my many questions on the Internet. What AI <s>crutches</s> tools do you use in your daily work? Please reach out to me and hit reply or leave a comment.</p>\n\n\n\n<p>This week a lot happened on video: Developer Hours, Hallway Hangouts, Speed Building Challenge, and Live-coding streams. And there is more to come. If you want to just watch one Livestream, put this year&#8217;s<a href=\"https://wordpress.org/state-of-the-word/\"> State of the Word on Dec. 16 at 9 am UTC</a> on your calendar.</p>\n\n\n\n<p>Now, without further ado, this week&#8217;s updates. </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/state-of-the-word-speed-build-challenge-woo-starter-theme-and-more-weekend-edition-313/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/state-of-the-word-speed-build-challenge-woo-starter-theme-and-more-weekend-edition-313/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/state-of-the-word-speed-build-challenge-woo-starter-theme-and-more-weekend-edition-313/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/state-of-the-word-speed-build-challenge-woo-starter-theme-and-more-weekend-edition-313/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/state-of-the-word-speed-build-challenge-woo-starter-theme-and-more-weekend-edition-313/#this-week-in-playground\">This week in Playground</a></li></ol>\n</div></div>\n\n\n\n<p>📣 <strong>Save the date! </strong>The annual <strong>State of the Word, Matt Mullenweg</strong>&#8216;s keynote presentation of the year, will take place on <strong>December 16, 2024</strong>, in Tokyo, Japan. The <a href=\"https://www.youtube.com/@WordPress/streams\">livestream</a> will start at<strong> 9 am UTC</strong> on WordPress YouTube channel. You&#8217;ll learn more about WordPress space in 2024 and an outlook on priorities for 2025. The topics might resolve around WordPress Meetups and WordCamps, Gutenberg Phase 3 collaboration, Playground, Data Liberation and Data Views.</p>\n\n\n\n<a href=\"https://wordpress.org/state-of-the-word/\"><img width=\"652\" height=\"192\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/12/Screenshot-2024-12-03-at-11.57.48.png?resize=652%2C192&ssl=1\" alt=\"State of the Word 2024 logo\" class=\"wp-image-31123\" /></a>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>This week, I managed the release of the Gutenberg plugin version 19.8, with 149 PRs by 52 contributors, 6 of them first timers.&nbsp; There were 34 Enhancements, mostly nice Quality of Life UX improvements, to make user more confident about what just happened, and 48 Bug fixes.&nbsp;<br />In the release post, <a href=\"https://make.wordpress.org/core/2024/12/04/whats-new-in-gutenberg-19-8-4-december/\"><strong>What’s new in Gutenberg 19.8? (04 December)</strong></a>, I highlighted</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/12/04/whats-new-in-gutenberg-19-8-4-december/#section-styles-selector-in-toolbar\">Section styles selector in toolbar&nbsp;</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/12/04/whats-new-in-gutenberg-19-8-4-december/#font-family-preview-in-dropdown\">Font family preview in dropdown</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/12/04/whats-new-in-gutenberg-19-8-4-december/#success-notices-for-image-editing-with-undo-link\">Success notices for image editing with Undo link</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/12/04/whats-new-in-gutenberg-19-8-4-december/#other-notable-highlights\">Other Notable Highlights</a>\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/12/04/whats-new-in-gutenberg-19-8-4-december/#dataviews-improvements\">DataViews improvements</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/12/04/whats-new-in-gutenberg-19-8-4-december/#block-supports-from-experimental-to-stable\">Block supports from experimental to stable.</a></li>\n</ul>\n</li>\n</ul>\n\n\n\n<a href=\"https://make.wordpress.org/core/2024/12/04/whats-new-in-gutenberg-19-8-4-december/\"><img width=\"652\" height=\"326\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/12/gb-19-8-change-design.png?resize=652%2C326&ssl=1\" alt=\"\" class=\"wp-image-31177\" /></a>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>It was a wonderful delight to have <strong>Sarah Norris</strong>, core contributor and co-core team rep, recording <a href=\"https://gutenbergtimes.com/podcast/\"><strong>Gutenberg Changelog 112</strong> </a>with me. We discussed Gutenberg 19.8, the Create Block theme plugin, Lisbon WordPress Developer Day, Developer hours and so much more. This is also the last episode of 2024, and we will be back in the second week of January 2025. As always, the episode will arrive at your favorite podcast app over the weekend. If you <a href=\"https://spoti.fi/3B03k9W\">listen to it on Spotify</a>, you can also leave a comment directly from your mobile app. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p>🎙️ Latest episode: <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-112-gutenberg-19-8-create-block-theme-plugin/\">Gutenberg Changelog #112 Gutenberg 19.8, Create Block Theme Plugin</a> with Sarah Norris</p>\n\n\n\n<img width=\"652\" height=\"183\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/12/Screenshot-2024-12-07-at-12.04.50.png?resize=652%2C183&ssl=1\" alt=\"\" class=\"wp-image-31178\" />\n</div></div>\n\n\n\n<p>In <a href=\"https://make.wordpress.org/design/2024/12/02/design-share-69-nov-18-nov-29/\">Design Share #69 (Nov 18-Nov 29)</a>, Joan Asmussen highlights the work on the WordPress design team of the last two weeks.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Adjust appearance of&nbsp;sidebar&nbsp;active menu item</li>\n\n\n\n<li>Menu editing flow</li>\n\n\n\n<li>System icon and dark mode announcement for Openverse</li>\n\n\n\n<li>Design system updates</li>\n\n\n\n<li>DataViews: Table layout density</li>\n\n\n\n<li>Button: Update appearance of&nbsp;<code>secondary</code>&nbsp;variant</li>\n\n\n\n<li>New Component: Badge</li>\n</ul>\n\n\n\n<a href=\"https://make.wordpress.org/design/2024/12/02/design-share-69-nov-18-nov-29/\"><img width=\"652\" height=\"436\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/12/Dataviews-density-options.webp?resize=652%2C436&ssl=1\" alt=\"\" class=\"wp-image-31180\" /></a>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p>In the episode <a href=\"https://dothewoo.io/wordpress-6-7-insights-with-birgit-pauli-haack-and-joe-mcgill/\"><strong>WordPress 6.7 Insights with Birgit Pauli Haack and Joe McGill</strong></a> of&nbsp;<strong><em>the WordPress Way</em></strong>&nbsp;host<strong>&nbsp;Abha Thakor</strong>,&nbsp;<strong>Joe McGill&nbsp;</strong>and I had a conversation around the highlights of WordPress 6.7. We discussed the impact of tools like the Plugin Checker, Create Block Theme plugin, and WordPress Playground on developers and end users. They also share insights into the evolution of features such as data views, interactivity API, and advancements in site performance and user experience. Listen in! </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Since WordCamp EU in June, I waited for this: <a href=\"https://www.youtube.com/watch?v=BzduYKuZAIg\"><strong>WordPress Speed Build: Matt Mullenweg versus Jessica Lyschik</strong></a>. It finally happened. Hosted by Jamie Marsland, Mullenweg and Lyschik had to match the design of the homepage of <a href=\"https://BobDylanArt.com\">BobDylanArt.com</a> inside 30 minutes. It was a fun site to build, and both contestant finished it. No spoilers here, you need to see for yourself.</p>\n\n\n<div width=\"100%\" class=\"wp-block-newsletterglue-showhide ng-block\">\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"toolbelt-video-wrapper\"></div>\n</div>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his post on OllieWP, <strong>Richard Goodwin</strong>, tries to answer the question: <a href=\"https://olliewp.com/gutenberg-editor-vs-full-site-editing-fse/\"><strong>Gutenberg editor vs. Full Site Editing (FSE): what’s the difference?</strong></a> I know that you know the difference, but maybe you need a resource to point to explain the difference, fast. It&#8217;s also not entirely correct to as both are part of the Gutenberg project. Content editing was Phase 1 and Site editing Phase 2. The block editor powers both, content creation and site creation. As a user, you wouldn&#8217;t need to learn two different methods and once you are familiar with the interface of the block editor, the additional concepts of templates, template parts, template hierarchy and global styles are much easier to learn and to master. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Shout-out to my friend <strong><a href=\"https://x.com/ackids\">Hans-Gerd Gerhards</a></strong>, who just landed his first theme in the WordPress repository, called <a href=\"https://wordpress.org/themes/circles-wp/\"><strong>Circles WP</strong></a> It is quite opinionated with interesting color combination and a big background circle as a design element. Sometimes it&#8217;s quite dominant and sometimes is stays in the background. The theme comes with ten Style variations and over 15 Patterns with cards, landing pages, banners, headers, and footer.&nbsp;</p>\n\n\n\n<a href=\"https://wordpress.org/themes/circles-wp/\"><img width=\"652\" height=\"411\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/12/Screenshot-2024-12-05-at-17.53.14.png?resize=652%2C411&ssl=1\" alt=\"\" class=\"wp-image-31157\" /></a>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Did you notice the updated Theme directory?  My favorite feature is that you can test all patterns with any of the style variations and see how the various color work with the sections. </p>\n\n\n\n<p>Other new block themes: </p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://wordpress.org/themes/streamer/\">Streamer</a> by Automattic, with some appealing font styles.</li>\n\n\n\n<li><a href=\"https://wordpress.org/themes/anastasi/\">Anastasi</a> by Roman Fink, his fourth block theme. </li>\n\n\n\n<li><a href=\"https://wordpress.org/themes/toothwise/\">Toothwise</a> by Fly Themes</li>\n\n\n\n<li><a href=\"https://wordpress.org/themes/advantura-trails/\">Advantura Trails</a> by WPTravel</li>\n\n\n\n<li><a href=\"https://wordpress.org/themes/the-free-blogger/\">The Free Blogger</a> by Suberb Addons with six Style variations and 14 patterns. </li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ryan Welcher</strong> updated his plugin <a href=\"https://wordpress.org/plugins/advanced-query-loop/\"><strong>Advanced Query Loop.</strong></a> The latest version 4.0 comes with a new Taxonomy Query Builder and gives you fine grain control over your taxonomy queries. The <a href=\"https://github.com/ryanwelcher/advanced-query-loop\">source code is availabl</a>e on GitHub. In his latest live streams he built the additional UI in public. You can follow along in these three videos.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://www.youtube.com/watch?v=4dGq88qLgf8\">What&#8217;s the PERFECT UI Component for My WordPress Plugin Settings?</a></li>\n\n\n\n<li><a href=\"https://www.youtube.com/watch?v=Aaghy90L39o\">Creating an advanced UI for plugins</a></li>\n\n\n\n<li><a href=\"https://www.youtube.com/watch?v=ctqCNWCOglk\">The biggest feature for my Advanced Query Loop plugin ever!</a></li>\n</ul>\n\n\n\n<img width=\"652\" height=\"436\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/12/Screenshot-2024-12-06-at-18.47.35.png?resize=652%2C436&ssl=1\" alt=\"\" class=\"wp-image-31169\" />\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Nathan Wrigley</strong> interviewed <strong>Stephen Dumba</strong> on <a href=\"https://wptavern.com/podcast/148-stephen-dumba-on-empowering-uganda-with-wordpress-education-and-community-initiatives\"><strong>Empowering Uganda With WordPress Education and Community Initiatives</strong></a> for the WPTavern Jukebox. The topic is not entirely focused on the block editor, however well worth reporting. &#8220;Stephen has been a high school teacher in Uganda since 2007. He specializes in WordPress, computer repair, and teaching IT skills. As the National Coordinator of the ICT Teachers’ Association of Uganda, he mentors both students and teachers in ICT.&#8221; Wrigley wrote in the introduction. <br /><br />At WordCamp Europe, I had the pleasure of introducing <strong>Abraham Waita</strong> who also spoke about Diverse and sustainable future: <a href=\"https://wordpress.tv/2024/07/03/diverse-and-sustainable-future-how-high-school-teachers-in-uganda-are-nurturing-a-young-wordpress-community/\">How high school teachers in Uganda are nurturing a young WordPress community</a>. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p><strong>Ellen Bauer</strong> and WooCommerce hosted a meeting titled Let’s Talk Themes. <strong>Brent MacKinnon</strong> published <a href=\"https://developer.woocommerce.com/2024/12/04/event-recap-lets-talk-themes-with-ellen-bauer/\"><strong>Event recap: “Let’s Talk Themes with Ellen Bauer”</strong></a> and shared the recording and what&#8217;s next. The big announcement is that WooCommerce, with the help from the Community theme builders, will be working on a new starter theme for ecommerce. The preliminary target date for a release is mid-2025.  MacKinnon also announced more events like this in the future and plans one already for January. If you are interested, sign up for the <a href=\"https://join.slack.com/t/woocommercecommunity/shared_invite/zt-2w4svp9r4-JvNvACWvAg~r5~OnX6PTew\">WooCommerce Community Slack</a> space and <a href=\"https://developer.woocommerce.com/newsletter/\">subscribe to the newsletter</a>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Troy Chaplin</strong> wrote a tutorial on the WordPress Developer Blog on <a href=\"https://developer.wordpress.org/news/2024/12/03/bridging-the-gap-hybrid-themes/\"><strong>Bridging the gap: Hybrid themes</strong></a> and helps you discover the key differences between two common WordPress theme types. You&#8217;ll learn how to seamlessly integrate modern block theme features into a classic theme. This approach allows for a smooth, gradual transition to block-based functionality while retaining the flexibility and familiarity of traditional development.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2024&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a>&nbsp;|&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p><strong>Ryan Welcher</strong> presented on the WordPress YouTube Livestream <a href=\"https://www.youtube.com/watch?v=i9vWaWG02nI\"><strong>&#8220;Building Your First WordPress Gutenberg Block: Beginner&#8217;s Guide!&#8221;</strong></a> He covered how to set up your local development environment, how to use the create-block scaffolding tool, understanding the block structure and customizing your new block. Welcher also shared some testing and debugging tips. </p>\n\n\n<div width=\"100%\" class=\"wp-block-newsletterglue-showhide ng-block\">\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"toolbelt-video-wrapper\"></div>\n</div>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>This week&#8217;s  Developer Hours was all about <a href=\"https://www.youtube.com/watch?v=WibXCMaG8J0\"><strong>Improving your workflows with WordPress development tools</strong></a>.  <strong>Ryan Welcher and Nick Diego</strong> took a deep dive into the advanced usage of tools like create-block and wp-scripts, along with a few others. Their focus was on solving common challenges and showcasing techniques that go beyond the basics, even for developers already familiar with these tools.</p>\n\n\n<div width=\"100%\" class=\"wp-block-newsletterglue-showhide ng-block\">\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"toolbelt-video-wrapper\"></div>\n</div>\n</div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"this-week-in-playground\">This week in Playground</h2>\n\n\n\n<p>In the <strong>Hallway Hangout on Blueprint Block Editor</strong>, <strong>Ajit Bohra</strong>, <strong>Adam Zielinski</strong> and <strong>Dawid Urbansk</strong>i discussed on how to integrate the stand-alone Blueprint builder into Playground platform. Ajit Bohra demonstrated how to create blueprints with the block editor like interface. He also touched on plans for the app. You can watch the recording and follow additional resources on this Make Playground blog post: <strong><a href=\"https://make.wordpress.org/playground/2024/12/02/recap-of-hallway-hangout-blueprint-block-editor/\">Recap of Hallway Hangout: Blueprint Block Editor</a></strong></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Adam Zielinski</strong>, <strong>Tammie Lister</strong> and other agency developers discussed in this week&#8217;s <strong>Hallway Hangout Playground for agencies. </strong> how playground can help agencies and product builders. <a href=\"https://youtu.be/Yg4iRAYOlNc\">The recording is available on YouTube</a>. The recap post follows on <a href=\"https://make.wordpress.org/playground\">make.wordpress.org/playground</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In the upcoming <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/304881623/\"><strong>Developer Hours: Everything you need to know about WordPress Playground</strong></a> will take place on <strong>December 17th at 16:00 UTC. </strong>In the final Developer Hours session of 2024, <strong>Nick Diego</strong> and <strong>Ryan Welcher</strong> take a closer look at <a href=\"https://wordpress.org/playground/\">WordPress Playground</a>. This tool lets you create fully functional WordPress instances directly in your browser, with no installation or setup required. Beyond spinning up WordPress sites, Playground offers powerful capabilities, from testing plugins and themes to running demos and even supporting app development. No matter how you engage with WordPress, Playground has something valuable to offer.</p>\n\n\n\n<img width=\"600\" height=\"338\" src=\"https://gutenbergtimes.com/wp-content/uploads/2024/12/Dev-Hours-Playground.avif\" alt=\"\" class=\"wp-image-31191\" />\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Featured Image:</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Dec 2024 13:15:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"Do The Woo Community: Friday Shares: What You May Have Missed v7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=87358\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://dothewoo.io/blog/friday-shares-what-you-may-have-missed-v7/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:214:\"A curated weekly collection featuring community-driven content, podcasts, news on WordPress developments, digital identity innovations, event recaps, and resources for developers and entrepreneurs in the ecosystem.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Dec 2024 10:20:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Do The Woo Community: Welcome Our New Host, Mark Westguard from WS Form\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=87341\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://dothewoo.io/welcome-our-new-host-mark-westguard-from-ws-form/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:191:\"BobWP introduces Mark Westguard as a new host. They will launch a monthly show where Mark chats with small businesses in WordPress, sharing their stories and challenges starting January 2025.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Dec 2024 15:19:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"WordCamp Central: WP Campus Connect Recap: A Journey of Empowering Students and Building Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"https://central.wordcamp.org/?p=8788569\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:122:\"https://central.wordcamp.org/news/2024/12/wp-campus-connect-recap-a-journey-of-empowering-students-and-building-community/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11970:\"<h2 class=\"wp-block-heading\">The Idea Behind WP Campus Connect</h2>\n\n\n\n<p>The journey of WP Campus Connect has been nothing short of extraordinary for us. This first-of-its-kind initiative was born out of a desire to bridge the gap between students and the WordPress ecosystem and also to grow the local community. As an active member of the WordPress community, I often noticed the need to introduce fresh talent to the platform and create a space where students could learn, grow, and connect with the global WordPress community.</p>\n\n\n\n<p>I shared this idea with our local community members, and we decided to design an event tailored specifically for students, providing them with hands-on exposure to WordPress and opening doors to potential career opportunities. Over the course of 23 days in October 2024, we conducted a WordPress workshop in four colleges in Ajmer, India, to bring this vision to life through engaging seminars and workshops.</p>\n\n\n\n<p>What began as an experimental event has now set a foundation for nurturing the next generation of WordPress enthusiasts and contributors. In this blog post, we’ll discuss WP Campus Connect&#8217;s highlights, achievements, and incredible journey.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Event Format</h2>\n\n\n\n<p>When we decided to organize a WordPress event exclusively for students, the big question was: How do we gather interested students, and where? Instead of asking them to come to us, we chose to meet them where they are—on their campuses. That’s how the event got its name: WP Campus Connect. We also decided that unlike other WordPress events, where attendees had to purchase the ticket, we removed this barrier and kept it free for all.&nbsp;</p>\n\n\n\n<p>We decided to partner with four colleges, making it a multi-day event planned across four Saturdays in October. Though we had to adjust the schedule along the way (more on that later!), the concept remained the same.</p>\n\n\n\n<p>Once our proposal was approved by the WordCamp Central, we started pitching the idea to colleges. The plan was to conduct 5-6 hour workshops in each college to introduce students to WordPress and career opportunities in web development. However, WordPress awareness in our region was low, and convincing colleges wasn’t easy. Out of six colleges we approached, four partnered with us after seeing the potential impact of the event.</p>\n\n\n\n<p>Feedback from our partner colleges added another layer to our format. Most students had never heard of WordPress, so jumping straight into workshops might not have been effective. To address this, we introduced a pre-event seminar in each college. These 90-minute sessions aimed to familiarize students with WordPress, its global impact, career opportunities, and the upcoming workshops—ensuring they were motivated and prepared.</p>\n\n\n\n<p>To maintain quality, we capped participation at 100 students per college, considering the infrastructure provided and our capacity to deliver a meaningful experience.</p>\n\n\n\n<p>In the end, our final format became:<br /><strong>4 Colleges, 4 Seminars, 4 Workshops, and introducing WordPress to 400 students.</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">Event Planning &amp; Execution</h2>\n\n\n\n<h3 class=\"wp-block-heading\">The Team</h3>\n\n\n\n<p>Once the event format was finalized and approved, it was time to turn the vision into reality. Organizing WP Campus Connect required meticulous planning, dedicated teamwork, and the support of our vibrant community. With a clear roadmap ahead, the next step was to form a team and assign responsibilities to ensure everything was executed smoothly.</p>\n\n\n\n<p>We built a 10-member organizing team, with each member taking on a specific role based on their expertise. Here’s how we divided the tasks:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Program Team:</strong> Crafted the workshop flow, deciding what to teach, how to teach it, and ensuring the sessions were engaging and impactful.</li>\n\n\n\n<li><strong>College Coordinator:</strong> Liaised with our partner colleges to ensure we had the necessary infrastructure for the seminars and workshops, from projectors to seating arrangements.</li>\n\n\n\n<li><strong>Design Team:</strong> Created promotional materials, session slides, certificates, and other visual assets that gave the event a polished and professional feel.</li>\n\n\n\n<li><strong>Sponsorship Team:</strong> Focused on securing funds by reaching out to sponsors, ensuring we had the financial backing needed to organize the event seamlessly.</li>\n\n\n\n<li><strong>Social Media and Content Team:</strong> Managed promotions across platforms, kept the community engaged, and shared regular updates about the event. They were also responsible for creating engaging content, such as announcements, blog posts, and updates, to amplify excitement and spread awareness.</li>\n</ul>\n\n\n\n<p>Every aspect, from logistics to content creation and online engagement, was managed collaboratively, with frequent check-ins to track progress and address challenges. With each team member playing their part, we turned the concept of WP Campus Connect into a well-coordinated, impactful event.</p>\n\n\n\n<p>This teamwork not only made the event possible but also strengthened the bonds within our community, showcasing the power of collaboration in achieving ambitious goals.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Student Selection: Ensuring the Right Participants</h3>\n\n\n\n<p>With participation capped at 100 students per college, the respective colleges were responsible for selecting attendees. To ensure a fair and effective process, all colleges followed a similar pattern.</p>\n\n\n\n<p>Each pre-event seminar was conducted for a larger audience, introducing students to WordPress, its career potential, and the workshop objectives. Following the seminar, the college faculty invited students to express their interest in joining the workshop. This allowed students who were genuinely motivated and eager to learn to step forward.</p>\n\n\n\n<p>Based on these expressions of interest, the final list of workshop attendees was prepared. This approach ensured that the workshops were filled with enthusiastic participants who were ready to make the most of the learning opportunity.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Event Days: Bringing WP Campus Connect to Life</h3>\n\n\n\n<p>The event days were the highlight of WP Campus Connect, with seminars and workshops conducted at all four partner colleges. Each session was tailored to inspire and engage students, introducing them to the power of WordPress and its vast career opportunities.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Seminars: Setting the Stage</strong></h4>\n\n\n\n<p>The 90-minute seminars introduced WordPress, its global presence, and its potential as a career path. While engaging a large audience within this short timeframe was challenging, we managed to keep the sessions interactive and enjoyable, ensuring students left motivated and curious.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Workshops: Hands-On Learning</strong></h4>\n\n\n\n<p>While the seminars only required two team members, the workshops were a full team effort. Each workshop was approximately 5-6 hours long and designed to provide students with hands-on experience building their first WordPress website.</p>\n\n\n\n<p>The college infrastructure varied, adding a layer of complexity. At one college, a single large computer lab accommodated all participants, allowing one lead facilitator to guide the session while others assisted. In other colleges, the workshops were split across multiple rooms. To maintain consistency, we conducted an internal team session before the event to ensure every facilitator was aligned on the workshop structure and delivery.</p>\n\n\n\n<p>We helped students build their first WordPress websites, set up WordPress, understand themes and plugins, manage pages and posts, and more. In this hands-on workshop, they built a website home page, set up a blog, and added a contact form to the site.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Breaks and Activities</strong></h4>\n\n\n\n<p>Workshops included a small break where we provided refreshments and set up fun activities like photo booths. These activities added a lively touch and allowed students to interact and capture memories of their day.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>The Closing Moments</strong></h4>\n\n\n\n<p>Each workshop concluded with a feedback session, during which we interacted with students, learned about their experiences, and encouraged them to join our Meetup group to continue their learning journey with the WordPress community. Participation certificates and swag were distributed to all attendees, leaving them with a token of their experience.</p>\n\n\n\n<p>The events wrapped up with group photos, which captured the energy and excitement of the day—a perfect end to a successful event.</p>\n\n\n\n<a href=\"https://central.wordcamp.org/files/2024/12/image-3.jpeg\"><img width=\"1024\" height=\"682\" tabindex=\"0\" src=\"https://central.wordcamp.org/files/2024/12/image-3-1024x682.jpeg\" alt=\"\" class=\"wp-image-8797843\" /></a>\n\n\n\n<a href=\"https://central.wordcamp.org/files/2024/12/image-2.jpeg\"><img width=\"1024\" height=\"682\" tabindex=\"0\" src=\"https://central.wordcamp.org/files/2024/12/image-2-1024x682.jpeg\" alt=\"\" class=\"wp-image-8797842\" /></a>\n\n\n\n<a href=\"https://central.wordcamp.org/files/2024/12/image-1.jpeg\"><img width=\"1024\" height=\"682\" tabindex=\"0\" src=\"https://central.wordcamp.org/files/2024/12/image-1-1024x682.jpeg\" alt=\"\" class=\"wp-image-8797841\" /></a>\n\n\n\n<a href=\"https://central.wordcamp.org/files/2024/12/image.jpeg\"><img width=\"1024\" height=\"682\" tabindex=\"0\" src=\"https://central.wordcamp.org/files/2024/12/image-1024x682.jpeg\" alt=\"\" class=\"wp-image-8797840\" /></a>\n\n\n\n<h3 class=\"wp-block-heading\">Challenges Faced</h3>\n\n\n\n<p>One major challenge was ensuring the required infrastructure at partner colleges. While students were encouraged to bring their own laptops, many relied on college computer labs. At some colleges, outdated systems and missing configurations made it difficult to install the necessary software.</p>\n\n\n\n<p>To overcome this, we used <strong>InstaWP</strong> to spin up temporary WordPress sites, allowing students to work seamlessly without delays. This quick solution ensured the workshops ran smoothly and introduced students to an innovative way of using WordPress.</p>\n\n\n\n<h3 class=\"wp-block-heading\">The Final Impact</h3>\n\n\n\n<p>Through WP Campus Connect, we introduced WordPress to over 370 students, sparking a newfound enthusiasm among many of them. The impact became evident at our next meetup, which saw a record-breaking attendance of over 50 participants—most of whom were new members. What stood out was their active involvement. They were not just attending but also contributing ideas for future meetups, showcasing their eagerness to engage further.</p>\n\n\n\n<p>With the growing number of attendees, we recognized the need for a larger venue. One of our partner colleges stepped forward and is now a venue sponsor for our meetups, solidifying their support for the community.</p>\n\n\n\n<p>Another exciting outcome was the suggestion to establish <strong>Student WP Clubs</strong> within colleges. These clubs can help sustain in-campus activities and introduce WordPress to students who missed the WP Campus Connect event. It can be a critical step toward ensuring the long-term growth and sustainability of the local WordPress community.</p>\n\n\n\n<p>Looking ahead, we’re in talks with stakeholders and exploring possibilities to integrate WordPress into the college curriculum soon. This initiative has the potential to embed WordPress knowledge at an academic level, equipping students with a competitive edge by the time they graduate.</p>\n\n\n\n<p>The momentum from WP Campus Connect has strengthened our local community and set a strong foundation for continued growth, innovation, and collaboration.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Dec 2024 06:25:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Anand Upadhyay\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: ClikIT Acquires UglyRobot’s Infinite Uploads and Big File Uploads Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=181425\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wptavern.com/clikit-acquires-uglyrobots-infinite-uploads-and-big-file-uploads-plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2618:\"<p>ClikIT has <a href=\"https://clikitnow.com/clikit-acquires-infinite-uploads-big-file-uploads/\">announced</a> its acquisition of the Infinite Uploads and Big File Uploads plugins from UglyRobot, LLC, owned by Aaron Edwards, the former CTO of WPMU DEV. The financial details of the deal have not been disclosed.</p>\n\n\n\n<p><a href=\"https://infiniteuploads.com/\">Infinite Uploads</a> is a versatile WordPress plugin offering cloud storage, video hosting, and CDN delivery to enhance media management and site performance.<a href=\"https://wordpress.org/plugins/tuxedo-big-file-uploads/\"> Big File Uploads</a>, on the other hand, simplifies the process of uploading large media files directly to the WordPress media library without requiring FTP or SFTP.</p>\n\n\n\n<p>Blake Whittle, owner of ClikIT, shared that his team had been seeking an acquisition opportunity since December 2023. Discussions with Aaron Edwards had been ongoing for several months before finalizing the deal.</p>\n\n\n\n<p>About the acquisition, Blake said, &#8220;“As websites become more complex and WordPress developers continue to innovate, we aim to solve the challenges of storing large amounts of media, such as images and PDFs, while making video streaming effortless with Infinite Uploads. We’re also leveraging Big File Uploads, used by over 100,000 websites, to simplify the process of uploading large files and bypassing web host limits. Our goal is to make managing WordPress websites as seamless as possible, and these plugins move us closer to that goal.”&#8221;</p>\n\n\n\n<p>“Existing customers will not notice any changes in billing, their portal, support emails, or even the description on their credit card statements. Much of the Infinite Uploads infrastructure was separate from UglyRobot’s other assets, meaning we didn’t need to decouple or migrate any data. The only noticeable change will be that support responses will now come from our team—and we’re dedicated to providing support that goes above and beyond.”, Blake promised.</p>\n\n\n\n<p>ClikIT plans to relaunch Infinite Uploads’ affiliate program, improve support response times, optimize CDN caching, and further integrate the plugin into the ClikIT brand.</p>\n\n\n\n<p>When <a href=\"https://x.com/jeffr0/status/1863629551353430019\">asked</a> on X if he was stepping away from WordPress, Aaron Edwards <a href=\"https://x.com/UglyRobotDev/status/1863633075873157401\">responded</a>, “Pretty much! I still have small Imajinn AI plugin. Excited to see what @BlakeWhittle7 and team do with @infiniteuploads now. It’s in good hands and has so much potential!”</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Dec 2024 18:23:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"WPTavern: #148 – Stephen Dumba on Empowering Uganda With WordPress Education and Community Initiatives\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=181298\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"https://wptavern.com/podcast/148-stephen-dumba-on-empowering-uganda-with-wordpress-education-and-community-initiatives\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:41141:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, how school educators are bringing WordPress to the people of Uganda.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Stephen Dumba.</p>\n\n\n\n<p>Stephen has been a high school teacher in Uganda since 2007. He specializes in WordPress, computer repair, and teaching IT skills. As the National Coordinator of the ICT Teachers Association of Uganda, he mentors, both students and teachers in ICT.</p>\n\n\n\n<p>An active WordPress community members since 2019, Stephen organizes WordCamps and conducts online, and in-person, WordPress training across Uganda. Initiatives like Each One Teach One, and 1000 WordPress Ninjas aim to promote the use of WordPress nationwide.</p>\n\n\n\n<p>Stephen regularly speaks at WordPress events, and focuses on integrating WordPress into education and community building.</p>\n\n\n\n<p>I suspect many listeners might not know about the landscape of WordPress and ICT education in Uganda. Stephen is here to correct that today.</p>\n\n\n\n<p>We start off talking about the ICT curriculum in Uganda, the initiatives to equip schools with computer labs, and the surge in student interest for ICT education.</p>\n\n\n\n<p>We then discuss how WordPress is beginning to see adoption in Ugandan educational circles and Meetup communities. Stephen talks about how investing in WordPress turned his business around, and the larger impact it has had on education and employment opportunities.</p>\n\n\n\n<p>But why is WordPress so embraced in Uganda? Stephen emphasizes its simplicity, extensive plugin options, and community support. He also describes the vibrant WordPress community initiatives, including regular Meetups, and the goal to host a thousand attendee WordPress event in the future.</p>\n\n\n\n<p>Towards the end of the podcast, we discussed Stephen&#8217;s vision for building future WordPress leaders in Uganda, and the significance of sponsorships, and financial support, to sustain and grow these initiatives.</p>\n\n\n\n<p>If you&#8217;re curious about how WordPress is shaping communities and education in Uganda, and the broader implications of ICT education in different regions, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Stephen Dumba.</p>\n\n\n\n<p>I am joined on the podcast today by Stephen Dumba. Hello Stephen.</p>\n\n\n\n<p>[00:03:44] <strong>Stephen Dumba:</strong> Hi Nathan.</p>\n\n\n\n<p>[00:03:46] <strong>Nathan Wrigley:</strong> This is going to be a really interesting episode for me. There&#8217;s going to be an awful lot in here that I do not know about. We&#8217;re not going to be talking about WordPress, the code. We&#8217;re going to be talking about WordPress, the community, and how it&#8217;s grown up in the country where Stephen lives, which is Uganda.</p>\n\n\n\n<p>And before we begin that, Stephen, I just want to give you the opportunity to tell us a little bit about yourself, your history with WordPress, the job that you do, and then we can unpack all of the wonderful things that you are involved with in Uganda. So over to you, your little potted bio.</p>\n\n\n\n<p>[00:04:23] <strong>Stephen Dumba:</strong> Thank you, Nathan. I am Stephen Dumba. By profession I&#8217;m a teacher, but many times when I tell people that I&#8217;m a teacher, the next question is, where do you teach? Unfortunately, I&#8217;m not stationed in a particular school where I&#8217;m teaching, but I&#8217;m a teacher by profession.</p>\n\n\n\n<p>But I&#8217;ve been, for the past 15 years, interested in computer repair. And then of recent, around 2018, I got invited to WordCamp Kampala. So that&#8217;s where my WordPress journey started.</p>\n\n\n\n<p>I attended a WordPress event in 2018, at the close of 2018, and then I got an opportunity to speak at WordCamp Entebbe three months later. That was in 2019. And then from then on, I discovered that, yeah, I think this is a field that I can put all my energy on.</p>\n\n\n\n<p>So I started developing websites in WordPress. But most importantly, I found that many of my fellow teachers were not well versed with web design and WordPress. So because of my role as the National Coordinator of the ICT Teachers Association of Uganda here, I took on the role of mentorship, a voluntary mentor. So I&#8217;ve trained many teachers in Uganda on how to use WordPress, and that&#8217;s how we are growing as a community.</p>\n\n\n\n<p>[00:05:44] <strong>Nathan Wrigley:</strong> Thank you for that. That was really enlightening. So just to reiterate, you began your journey in 2017, having not used WordPress before. But also at the same time as that, a history of teaching, and with a current role of the National Coordinator of the ICT Association of Uganda, which sounds like a fairly influential role.</p>\n\n\n\n<p>What I mean by that is I&#8217;m guessing that if you make some decisions about what CMS may be on offer to the school children in Uganda, your decisions count for something because of the role that you have. Would that be fair to say, your decisions matter?</p>\n\n\n\n<p>[00:06:23] <strong>Stephen Dumba:</strong> I wouldn&#8217;t say it&#8217;s a personal decision, but it is a decision of a couple of us as teachers. You see, what we call the ICT Teachers Association of Uganda is a congregation of teachers who teach ICT as a subject here in Uganda, across the entire country. So basing on the conversations we have on our platforms, majorly WhatsApp, you come up with a decision even when no one mentions it. You find that it is easier to build websites with WordPress. And all the reasons are there for us to see.</p>\n\n\n\n<p>Previously when I was still teaching, we used to teach web design as one of the topics in our subject, but we were using very rudimentary tools. We would even use stuff like Office to come up with something like a website.</p>\n\n\n\n<p>When I got to know about WordPress, shared it with a few teachers, and by the way, I was introduced to WordPress by a fellow teacher, and by then he was the national coordinator of the ICT Teachers Association. He&#8217;s called Rogers Mukalele.</p>\n\n\n\n<p>So he invites us to a group of WordPress users because he wanted us to improve on our skills, our web development skills. And then when it came that there was a WordCamp in 2018, I remember it was December, either November or December, WordCamp Kampala. We all went there just to see how are these people making websites, because they&#8217;re telling us in just a day you can come up with something so beautiful.</p>\n\n\n\n<p>And when we went there and, true to his words, people had at least a homepage in just one or two hour session. So from there on, everyone was convinced.</p>\n\n\n\n<p>So for us who had gone, we started sharing with those who hadn&#8217;t gone to this event. And so when Arthur organised WordCamp Entebbe in 2019, many teachers were like, we also want to go to WordCamp and learn how to use WordPress.</p>\n\n\n\n<p>So that&#8217;s how I came up with the idea, wow, so I can speak at this event to the teachers. Because usually they take people, the way they communicate with teachers, it may not be as straightforward or as simple as us teachers understand ourselves.</p>\n\n\n\n<p>So I thought I&#8217;d give this talk, and good enough this talk is even on, my very first is on WordPress TV. Things went on, and so people started seeing us as the go-to people for WordPress. And because of that, we had to keep on improving our skills. And so all other WordPress events that were organised in Uganda, I struggled hard to make sure that at least I catered for that particular audience.</p>\n\n\n\n<p>So finally, Rogers goes out of this role of national coordinator and everyone was like, I think Steve, you can do this. Steve, be our national coordinator, please. Who&#8217;s going to teach us WordPress? Who&#8217;s going to mentor us in this field? And because of our association, people believe in what we say.</p>\n\n\n\n<p>So when we tell them it&#8217;s good to have WordPress, we give them the figures of course, 43% of the web. And then when you come to government agencies here, I even wrote an article about 10 common websites in Uganda that are using WordPress, of which we have State House, that&#8217;s the President&#8217;s official home. He&#8217;s using WordPress. Then we have the tax body in Uganda, switched to WordPress. We have universities in Uganda are using WordPress.</p>\n\n\n\n<p>So we were giving just those big, big, big agencies as examples. And then when we tell you that you can do something in a day, you can come up with an idea and build something in WordPress, and maybe improve that later, everyone would like this.</p>\n\n\n\n<p>First of all, not many of our schools in Uganda have websites. So teachers had space where they could practice their WordPress skills. They would go to the head teacher, tell them, I developed some WordPress skills. Can I volunteer to build a school website? And so the teacher would volunteer, and then ask us some questions, we would guide them. And where we fail, we would also go to the more advanced community, the WordPress community of Uganda. And they&#8217;re also very helpful.</p>\n\n\n\n<p>[00:10:27] <strong>Nathan Wrigley:</strong> Can I ask, where I live in the UK, we have an education system called the National Curriculum, and what that means is that basically every child receives, certainly when they&#8217;re very young, the same subjects. So if you&#8217;re a child in an entirely different part of the country, you&#8217;ll still be having basically the same palette of subjects, you&#8217;ll be doing maths, and history, and what we call ICT. And the ICT, in our case, stands for Information Communication Technology.</p>\n\n\n\n<p>Is that the same in Uganda? Do you have one sort of curriculum which covers the whole country, or can different areas and different schools pursue whatever they like?</p>\n\n\n\n<p>[00:11:08] <strong>Stephen Dumba:</strong> In Uganda we also have a curriculum developed by the National Curriculum Development Center, and it is across the country.</p>\n\n\n\n<p>[00:11:15] <strong>Nathan Wrigley:</strong> Okay, thank you. And also, what is the current state of technology like in Uganda? So where I live there&#8217;s lots of desktop computers. There&#8217;s lots of mobile phones. I&#8217;m curious as to how people are consuming the internet. Is it generally a keyboard with a screen, or does it tend to be more like a mobile phone?</p>\n\n\n\n<p>[00:11:37] <strong>Stephen Dumba:</strong> The adoption of technologies in Uganda is still very, very, very low. Although, since the lockdown, there has been some improvement. However, I also like to mention, what we call the Uganda Communications Commission. They have been instrumental in making sure that secondary schools, that is for students from 13 to 18 years, they&#8217;ve ensured that all secondary schools at least have a computer lab of at least 30 users, 30 user stations.</p>\n\n\n\n<p>But this is something that came around more seriously in 2013, because then ICT as a subject was introduced to advanced level. That is for the, 17, 18 year olds. It came as a compulsory subject.</p>\n\n\n\n<p>By the way, in Uganda, students start learning ICT at 13. Below that, the curriculum doesn&#8217;t cater for that. So the curriculum starts it as an option at 13 years onwards. But in 2013, the government thought it wise to introduce this as a compulsory subject for the 17 and 18 year olds, what we call A Level here.</p>\n\n\n\n<p>And because not all schools would afford to have computer labs, our communications agency, the Uganda Communications Commission, through their project which is now called UCUSAF, they came up with an idea and stocked computer labs across the entire country. So the chances of finding a computer lab in a secondary school are almost I think 90, I&#8217;ll give a figure of 90%.</p>\n\n\n\n<p>[00:13:13] <strong>Nathan Wrigley:</strong> And would it be fair to say that home ownership of computers is not particularly widespread? Or would it be that most people going home would have access to a computer or a mobile phone, once they&#8217;re outside of the boundaries of the school?</p>\n\n\n\n<p>[00:13:28] <strong>Stephen Dumba:</strong> It is not widespread. It&#8217;s not at all widespread. Computers will only be found in offices, and that is big offices. Computers only be found now in secondary schools, apart from a very few privileged schools that will have maybe a hundred computers.</p>\n\n\n\n<p>[00:13:47] <strong>Nathan Wrigley:</strong> So young people, their exposure to computers is typically going to be in their educational institute, their school, or the college that they go to. And is the interest in ICT, well, is ICT as a subject popular in the same way that it is in my country? I mean, it&#8217;s almost the most exciting thing you can do to a child where I live, to put them in front of computers.</p>\n\n\n\n<p>It seems that there&#8217;s just something about that interaction of the keyboard, the mouse, the computer, and all of the myriad things that it can do that is tremendously exciting. And also it&#8217;s a conduit to learning almost every other subject as well.</p>\n\n\n\n<p>But is it something that the children themselves are excited about, learning how to work with computers? Or is it more that, a bit like maybe something like maths is here, you&#8217;re just kind of told you&#8217;ve got to do it because you&#8217;ve got to do it. Like I say, is it popular?</p>\n\n\n\n<p>[00:14:45] <strong>Stephen Dumba:</strong> ICT is a very popular subject here in my country. I&#8217;ve even given the numbers. I remember, the last school where I taught, you would have a class of 80 learners and you had only 30 computers. And the kids had to struggle into the lab just to be the first on the computer. You just have to come out with ways of grouping them, and making sure that each of these learners has a chance to touch and use the computer.</p>\n\n\n\n<p>For example, because of this demand where I was, I was often asked to come to school earlier than the official reporting time. For example, being at school at around seven so the kids can use the time between seven and nine, for those who did not have the chance to practice, to use the lab. And then even after work, after five, you&#8217;ll be obliged to stay at school up to around eight, so that you give chance to other learners, because the interest is just too much, just like the UK.</p>\n\n\n\n<p>[00:15:46] <strong>Nathan Wrigley:</strong> So there&#8217;s loads of demand, but not enough places to put that demand. At the moment there simply aren&#8217;t enough devices for the amount of children, in this case, who wish to learn.</p>\n\n\n\n<p>It&#8217;s an exciting thing to be involved in then I guess, because I think a lot of teachers, certainly in the UK, face the problem of disinterested children. Children who don&#8217;t wish to study a particular subject, and yet they&#8217;re being made to teach it.</p>\n\n\n\n<p>Whereas it sounds like you&#8217;ve got the opposite problem. You&#8217;ve got children who are extremely interested to learn, but aren&#8217;t able to because, well, there&#8217;s a big queue to get into the ICT lab, and you&#8217;ve got to take your turn. Come before school begins, or wait after school has finished in order to give it a go. Okay, that&#8217;s really interesting.</p>\n\n\n\n<p>[00:16:31] <strong>Stephen Dumba:</strong> If I can add, it&#8217;s for that reason that at a certain point we take these kids through a test to decide who will stay with us in the computer lab at a certain level. So when you have a class of 80 students, where as a teacher you could imagine, the African way, the problem is when it comes to time for assessment exams, are you going to spend two days in the computer lab examining in just one subject? No.</p>\n\n\n\n<p>So what we do, if there are 80 students in your class, they&#8217;ll have to go through a test that will determine, and unfortunately we usually choose the best performers. And so we could say we need only 40 students. And so you leave out 40. Not that they don&#8217;t want, they are really interested, everyone is interested, but you don&#8217;t have just enough equipment to serve them.</p>\n\n\n\n<p>[00:17:21] <strong>Nathan Wrigley:</strong> Again, linking back to the UK because it&#8217;s basically what I know. In the UK the ICT curriculum covers a lot of ground, it isn&#8217;t just about the web. And I wondered if that was the case as well.</p>\n\n\n\n<p>Obviously the WordPress component is about building something which could go online ultimately, perhaps a website or something like that. But also they learn about programming languages, and how to write things in code on their local development environment, and what have you.</p>\n\n\n\n<p>Do you cover any of that as well, or is it mainly to do with the internet, websites, WordPress, that kind of thing?</p>\n\n\n\n<p>[00:17:55] <strong>Stephen Dumba:</strong> Not at all. In fact, websites is just part of the curriculum. They learn, of course, the obvious stuff, it&#8217;s basically learning Microsoft Office programs, and then web, and then there is security, a little bit of that.</p>\n\n\n\n<p>In our new curriculum, right now we don&#8217;t have coding, we don&#8217;t have programming. What we have is a bit of HTML and CSS before we involve them in WordPress.</p>\n\n\n\n<p>[00:18:21] <strong>Nathan Wrigley:</strong> Do the students have career opportunities outside of school, once school has finished? Is that maybe why it&#8217;s so popular? Apart from the fact that it&#8217;s obviously quite interesting sitting in front of a computer, you know, it opens up a whole world of possibilities. Is there also a credible career path with that as well?</p>\n\n\n\n<p>Because I can imagine that if you were successful, let&#8217;s say you were incredibly good at building websites with WordPress, I can imagine that the career, the opportunities, would allow you to step outside your own town, your own region, your own country. And so I just wondered if there was a career path that the children could understand and conceive. That it would allow the world to be more available to them.</p>\n\n\n\n<p>[00:19:04] <strong>Stephen Dumba:</strong> As teachers, we have shown them some career paths, like the standard web developer, stuff like that. But given that, in our country, the chances of getting employed are really so minimal. So most of these kids are learning it, first for the interest, but then they are also looking at the opportunities. They look at people like us that, yes, he has his own web development agency, that is Steve. You look at Rogers, he&#8217;s also surviving his way because of that skill.</p>\n\n\n\n<p>So even when we are going in our mentorship talks with them, we show them that, learn this skill and you&#8217;ll be self-reliant after school. You&#8217;re not going to depend on someone who&#8217;s going to ask for your CV, someone who&#8217;s going to ask for your experience when you&#8217;re just fresh out of school. Many of them are learning it right now because they want to make a buck by themselves.</p>\n\n\n\n<p>[00:19:58] <strong>Nathan Wrigley:</strong> Okay, that&#8217;s brilliant. Thank you. And can I just ask, why WordPress? Given all of the different bits and pieces out there. I mean, obviously you attended the event in 2017, and that turned your head towards WordPress, but I&#8217;ve got to imagine there&#8217;s more to it than that.</p>\n\n\n\n<p>Is it just that it is a tool which is, well, I mean for a start it&#8217;s freely available? You just go to a website and there it is, and you can download it, and there&#8217;s loads of software available that allows you to install it on a local environment, so you don&#8217;t need to pay for a hosting company or anything like that. What were the reasons that WordPress was the CMS of choice, the software of choice?</p>\n\n\n\n<p>[00:20:35] <strong>Stephen Dumba:</strong> First of all is the ease with which you create this website. So I&#8217;ll give my personal example. And by the way, the teachers and learners follow my story so much, and it&#8217;s an inspiring one.</p>\n\n\n\n<p>Around 2015, I hired a friend of mine to create a website for me. And we went through ping pong for some months, and then even after all those months, the website wasn&#8217;t really what I wanted. And then they told me that it&#8217;s because you&#8217;re using a friend to do it. You&#8217;re doing it cheaply. So you have to get some good money and hire another web developer.</p>\n\n\n\n<p>So I got my, I think it was three months salary, I gave it to a person to develop a website who did not come up with a website even after a, you get it, yeah. Now look at, after a whole year you don&#8217;t have a website, some sketchy. And then in school we were teaching using Publisher. I don&#8217;t know if you heard about Microsoft Publisher, we were using it to create websites. And the websites are so sketchy versus the websites we see on the web.</p>\n\n\n\n<p>So here you go to an event in the morning. You arrive at nine, get breakfast at 10, go into a session at 11, and at 2 you have a website. Who wouldn&#8217;t want to use that tool? And in fact, all my interests right now, like I told you before, I repair computers. So the only people who knew that I repair computers are the people in my community.</p>\n\n\n\n<p>Now that I learned WordPress, I came up with a website, a website using WordPress. I think I used maybe two nights and it&#8217;s out there. And now because of this website, I&#8217;m traveling across the country. Now the people who are following my story will also want to do their own websites because of the ease with which you can use it to come up with a deserving website. A website that a client will look at and say, wow, this is what I wanted.</p>\n\n\n\n<p>And it is even easier, even if you looked at another website for inspiration, it is easier to come out with a similar website in WordPress, as opposed to the other hard coding, that is one.</p>\n\n\n\n<p>And then the other thing is, there&#8217;s one thing that I really look at, WordPress has a community in Uganda. You&#8217;ll simply call David, hi, I have a problem here. David will help you. Then you say, who can help me with this? And then they&#8217;ll lead you to another person.</p>\n\n\n\n<p>Then look at the problems like when you want to monetise your website, when you want to add payment gateways to your website. All the other options that are available, it&#8217;ll take you a lot of effort to get them working. Whereas in WordPress, you&#8217;ll just dream of something, oh, I need this, then go to the plugin repository and the plugin is there. Even the free ones are working.</p>\n\n\n\n<p>Just for example, as teachers, during the lockdown we wanted students to be able to access lessons when they are at home, while we were also in our homes. On WordPress, you&#8217;ll just go and look one LMS, and it creates a very perfect learning solution for you, just within no time. So I think there are very many reasons why you should love WordPress.</p>\n\n\n\n<p>And let me tell you what, even the big agencies here, they were using other technologies. But we have been following them in the last maybe four years. All the big ones are getting to WordPress. So if we don&#8217;t know the reason why we want WordPress, perhaps they know the reason why they want WordPress. You get it, eh?</p>\n\n\n\n<p>So even those, the naysayers who are still doubting WordPress, when they look at State House going for WordPress. When they look at our revenue agency going for WordPress. When they look at our Business Registration Bureau going for WordPress. When they look at our universities going for WordPress, then who are you? You have to give us a very big reason to choose any other.</p>\n\n\n\n<p>[00:24:18] <strong>Nathan Wrigley:</strong> I guess modern WordPress with things like built-in patterns, so the ability to just basically click a button and have a pre-designed page, or row, or selection of blocks, really leans into that real ease of putting something on a page immediately.</p>\n\n\n\n<p>So in the olden days, you would probably still have to have a variety of different plugins to wrangle to get things the way that you wanted it to look, but you&#8217;d also have to have a degree of HTML knowledge. And it sounds like, you know, especially for the people who are just beginning with WordPress, those kind of features are really key for getting that excitement going. Look, log in, click that button, and then that one, you&#8217;ve got a page, look at that. And you get something almost immediately.</p>\n\n\n\n<p>How do you disseminate, or how do you communicate with all the other staff where you want to share your experience about WordPress? How do you communicate with all the other teachers throughout the country to coordinate what you&#8217;re doing?</p>\n\n\n\n<p>[00:25:21] <strong>Stephen Dumba:</strong> Like I said earlier, I am the National Coordinator of the ICT Teachers Association of Uganda. The ICT Teachers Association of Uganda brings all teachers of ICT in Uganda together.</p>\n\n\n\n<p>So one of the ways, yes, we have a website, ictteachersug.net, but for easier communication we use our WhatsApp platform. Right now we are using WhatsApp majorly. So when we are there, sometimes someone will ask a question, and someone will say, can you ask Stephen? He has been there, he has done that. And when they ask you, you tell them the whole story.</p>\n\n\n\n<p>What we did, we came up with a few initiatives. For example, every Tuesday evenings 8:00 to 9:00 PM East African time, we have what we call Each One, Teach One. We believe no one has the monopoly over knowledge. There is something I know that Nathan doesn&#8217;t know. There is something that Nathan knows that I don&#8217;t know, and a hundred others don&#8217;t know.</p>\n\n\n\n<p>So what we do in this session, Each One, Teach One, we get a topic that is on everyone&#8217;s mouth. And then we get one person to come and facilitate, and then you take them through an hour. They&#8217;ll ask you questions and stuff like that. And these topics are diverse. Sometimes it&#8217;s just motivation. Sometimes it&#8217;s really, how do I get started with WordPress? And then, how do I deal with SEO? The topics are very diverse, but we come together because we are a fraternity, and we have that objective of bettering ourselves inside and outside our profession.</p>\n\n\n\n<p>[00:27:01] <strong>Nathan Wrigley:</strong> So that&#8217;s an online event, you do that via the internet. But you also mentioned that there&#8217;s a fairly vibrant WordCamp community that goes on with a variety of events across Uganda each year. Did I get that right?</p>\n\n\n\n<p>[00:27:14] <strong>Stephen Dumba:</strong> Yeah. Now look at this, the story goes, Rogers comes and invites us to join the WordPress community of Uganda, which was based in Kampala then. And then three months later, we have an event in Entebbe, under WordPress Entebbe Meetup. So from there, the teachers who had traveled miles to come and attend this event are like, can&#8217;t we have such events nearer our places?</p>\n\n\n\n<p>So Rogers comes up with the idea, I think I can start a WordPress Meetup in Jinja, that is 80 kilometers away from Kampala. And then in collaboration with existing meetups, we ask that these events should also include sessions for teachers and learners, not only the advanced topics. Also get to the basics, the beginners, the absolute beginners. So Rogers initiates WordPress Jinja Meetup.</p>\n\n\n\n<p>After the lockdown, Moses initiates the WordPress Masaka Meetup. This is another teacher. And then in Lira we have another WordPress also initiated by a fellow teacher.</p>\n\n\n\n<p>All these are done in collaboration with the existing meetups, and it is one community. But because of these distances, Stephen cannot come from here and travel 400 kilometers to attend a meetup. So it is better if a meetup group is started in that town. So even of recent, we have another Moses who started another meetup just outside Kampala, but Lira was started by Emmanuel Angoda. And more meetups are coming up by the way, because many teachers are interested.</p>\n\n\n\n<p>[00:28:52] <strong>Nathan Wrigley:</strong> It does sound like the teachers are the backbone of the whole thing. The WordPress community is largely being driven by the teachers because, you know, they attend this one thing, and then go and start another little satellite meetup, which then is sprouting another meetup and so on. But it does sound like the teaching network is the thing which is really driving the community over there, which is interesting.</p>\n\n\n\n<p>[00:29:17] <strong>Stephen Dumba:</strong> That would be a lot of pride on our side so that the teachers are the backbone of the WordPress community. Like I said, teachers work hand in hand with existing meetups because we engage with these people every other day.</p>\n\n\n\n<p>Our request was that we work hand in hand to have more inclusive WordCamps, or more inclusive meetups. While the previous meetups were for advanced users, that is in our own thinking. Things were too advanced for us. You go to an event and people are speaking APIs.</p>\n\n\n\n<p>So we were like, how about we had a meetup, we had a WordCamp where even an absolute beginner, a person who only knows how to click, can come up with a website on that day. And this was a welcome idea, so we are working hand in hand. The thing is that, with teachers, at least they have places where they can put these events, as in the schools. They have somewhere to start. It is easier for them.</p>\n\n\n\n<p>[00:30:16] <strong>Nathan Wrigley:</strong> Yeah, I was going to ask about exactly that, about the location, because that can be quite a thing where we are, finding a location can be really hard. But I guess that&#8217;s a good short circuit, isn&#8217;t it? Because the teachers have access to a building. They have access to a computer lab, which they can use for the evening. Okay, I see. That all hangs together perfectly, doesn&#8217;t it? The school is, in a sense, the central place where it all happens, and the teachers are the people who make it happen in those locations. That&#8217;s fascinating.</p>\n\n\n\n<p>That&#8217;s really interesting because here in the UK,, the WordPress community is usually not really the school, there&#8217;s no part of the educational system which is involved in it. It&#8217;s typically business owners, people building websites, people who&#8217;ve got companies where they&#8217;re selling something into the WordPress space, those kind of things. And they&#8217;re typically done in, I don&#8217;t know, venues of an evening, but schools don&#8217;t appear to be part of it. So there is quite a difference there.</p>\n\n\n\n<p>Is there anything, Stephen, that you would say, if you could stare into the future, sort of five years or something like that, is there anything that you would like to happen? Now that could be as straightforward as, well, it would be great if we had more computers, or more members in our communities. I&#8217;m just thinking, five years, what would you like to be different in five years than is now with the Uganda community?</p>\n\n\n\n<p>[00:31:42] <strong>Stephen Dumba:</strong> One thing we want with the community, in five years one of our dreams is to have an event with a thousand attendees. An event with a thousand attendees is testament of the years of efforts that we are put into building this. It&#8217;ll be really heartbreaking if after all those years of pushing WordPress, you still have an event with 50, 80, 200 attendees.</p>\n\n\n\n<p>I want to see my students as speakers. I want to see them as organisers at events. I want them to come up and say, that&#8217;s our teacher. That is the person who introduced me to WordPress. And I want to see many of them.</p>\n\n\n\n<p>Indirectly, this is good market for those who are in the business of web design, like I intend to be. The more people that we know who are interested in WordPress, it&#8217;ll be easier for us to mobilise people for events.</p>\n\n\n\n<p>There&#8217;s things that really pain us, sometimes we have an event and all you have is international sponsors. You don&#8217;t have any local sponsor for this event. It shows you that the people who are in charge don&#8217;t know about WordPress yet. So let us train these young ones, and when they are in charge they&#8217;ll be very willing to support, to give back to the community, even if they don&#8217;t attend.</p>\n\n\n\n<p>[00:33:02] <strong>Nathan Wrigley:</strong> What a fabulous, fabulous thought. The idea of an event of that magnitude with homegrown talent, if you know what I mean. The people that over the last many years you have been teaching, who are themselves the speakers, and presumably would themselves be now the teachers of the next generation as well.</p>\n\n\n\n<p>So you&#8217;re kind of describing a thing which self perpetuates itself into the future. It just keeps going, and you&#8217;ve got the older generation who&#8217;ve been doing it for a while, the ones who are currently working inside of WordPress. And at the same time you&#8217;ve got the people who are coming up through the education system. That is such a fabulous, fabulous, idea.</p>\n\n\n\n<p>Another question around that then, Stephen, is the financial thing I suppose, talking about how we get these events to work. Now, you mentioned that events are in schools and things like that,</p>\n\n\n\n<p>but I&#8217;m just wondering if there&#8217;s something that you</p>\n\n\n\n<p>would like to say regarding, I don&#8217;t know, sponsorship, or</p>\n\n\n\n<p>people reaching out to assist in some way or</p>\n\n\n\n<p>other.</p>\n\n\n\n<p>[00:33:59] <strong>Stephen Dumba:</strong> one thing is. our community is entirely, we work entirely on our own resources, personal resources. It&#8217;s voluntary, but the demand for WordPress lessons is so high. And of recent, we started, an initiative called 1000 WordPress Ninjas. and our target was with three friends of mine.</p>\n\n\n\n<p>There is a teacher called Noeline and another teacher called Simon. So we came up with the idea, let us at least give ourselves a target of training a thousand youth and teens in WordPress, especially those who are finding it hard to continue with school. is, easier to get those in school.</p>\n\n\n\n<p>But there are many others who are there that we interact with. They are struggling with school. So you want to teach them, stuff like WordPress and life skills, indirectly life skills, but majorly WordPress.</p>\n\n\n\n<p>But then they really want to associate with us. So they ask, but what really shows that I&#8217;m a WordPress Ninja. Then we ask them, what do you want? Then they say, don&#8217;t you have a T-shirt? But they cannot even afford this T-shirt. So while I can offer the lessons free, I don&#8217;t have enough money on me to buy T-shirts for a thousand learners. So there are those small things that any other person can come up and any idea and say, perhaps I will get a thousand T-shirts for these a thousand WordPress.</p>\n\n\n\n<p>Ninjas Anything in anyway. And then sometimes there are places that are far remote that would also be interested, but we go there only when we can afford. So even if they ask me to go for this session this weekend, they ask for a session this weekend. As long as I don&#8217;t have enough money on me, I tell them maybe next month.</p>\n\n\n\n<p>And sometimes I can push it to two, three, even six months. But if. There is a way that we can come up with something small. It can facilitate one of us to go to that place maybe 600 kilometers away, stay a night, have a day or two with them, and then come back. But otherwise, everything is voluntary by using our own pockets But any assistance would be Very welcome.</p>\n\n\n\n<p>[00:36:10] <strong>Nathan Wrigley:</strong> I think it&#8217;s the perfect place to end it, Stephen. Before we do end it, I&#8217;m just going to ask, where could people reach out to you? Either personally or perhaps that&#8217;s a website for the institute that you are in charge of? The National Coordinator of the ICT Teachers Association of Uganda. Anywhere that we can find you, email, social media, whatever you like.</p>\n\n\n\n<p>[00:36:31] <strong>Stephen Dumba:</strong> Yeah. So I&#8217;m on X, people can find me on X and my handle is SteveUG. Our website of the ICT Teacher Association is ictteachersug.net.</p>\n\n\n\n<p>[00:36:47] <strong>Nathan Wrigley:</strong> All of these links will head into the show notes, so if you go to wptavern.com and search for this episode with Stephen, you&#8217;ll be able to find all of the links there. All I can say is thank you so much for all of the hard work that you&#8217;ve put in so far. It sounds like you&#8217;ve got a really interesting, growing community over there, and also good luck for the future. I hope that in the next five years you do indeed put on a WordCamp with a thousand people. That would be absolutely marvelous. Thank you for talking to me today.</p>\n</div>\n\n\n\n<p>On the podcast today, we have <a href=\"https://x.com/SteveUG\">Stephen Dumba</a>. </p>\n\n\n\n<p>Stephen has been a high school teacher in Uganda since 2007. He specialises in WordPress, computer repair, and teaching IT skills. As the National Coordinator of the ICT Teachers’ Association of Uganda, he mentors both students and teachers in ICT.</p>\n\n\n\n<p>An active WordPress community member since 2019, Stephen organises WordCamps and conducts online and in-person WordPress training across Uganda. Initiatives like Each One Teach One and 1000 WordPress Ninjas, aim to promote the use of WordPress nationwide.</p>\n\n\n\n<p>Stephen regularly speaks at WordPress events, and focuses on integrating WordPress into education and community-building.</p>\n\n\n\n<p>I suspect many listeners might not know about the landscape of WordPress and ICT education in Uganda. Stephen is here to correct that today.</p>\n\n\n\n<p>We start off talking about the ICT curriculum in Uganda, the initiatives to equip schools with computer labs, and the surge in student interest for ICT education.</p>\n\n\n\n<p>We then discuss how WordPress is beginning to see adoption in Ugandan educational circles and Meetup communities. Stephen talks about how investing in WordPress turned his business around, and the larger impact it has had on education and employment opportunities.</p>\n\n\n\n<p>But, why is WordPress so embraced in Uganda? Stephen emphasises its simplicity, extensive plugin options, and community support. He also describes the vibrant WordPress community initiatives, including regular meetups and the goal to host a thousand-attendee WordPress event in the future.</p>\n\n\n\n<p>Towards the end of the podcast, we discuss Stephen’s vision for building future WordPress leaders in Uganda and the significance of sponsorships and financial support to sustain and grow these initiatives.</p>\n\n\n\n<p>If you’re curious about how WordPress is shaping communities and education in Uganda, and the broader implications of ICT education in different regions, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://kampala.wordcamp.org/2023/\">WordCamp Kampala</a></p>\n\n\n\n<p><a href=\"https://entebbe.wordcamp.org/2023/\">WordCamp Entebbe</a></p>\n\n\n\n<p><a href=\"https://www.meetup.com/Entebbe-WordPress-Meetup/\">WordPress Entebbe Meetup</a></p>\n\n\n\n<p><a href=\"https://www.meetup.com/Jinja-WordPress-Meetup/\">Jinja WordPress Meetup</a></p>\n\n\n\n<p><a href=\"https://www.meetup.com/masaka-wordpress-meetup/\">Masaka WordPress Meetup</a></p>\n\n\n\n<p><a href=\"https://www.meetup.com/lira-wordpress-meetup/\">Lira WordPress Meetup</a></p>\n\n\n\n<p><a href=\"https://ictteachersug.net/\">ICT Teachers Association of Uganda</a></p>\n\n\n\n<p><a href=\"https://statehouse.go.ug/\">State House of Uganda website</a></p>\n\n\n\n<p><a href=\"https://ncdc.go.ug/\">National Curriculum Development Center</a></p>\n\n\n\n<p><a href=\"https://www.ucc.co.ug/\">Uganda Communications Commission</a></p>\n\n\n\n<p><a href=\"https://www.ucc.co.ug/ucusaf/\">Uganda Communications Universal Service Access and Fund</a> &#8211; UCUSAF</p>\n\n\n\n<p><a href=\"https://www.ursb.go.ug/\">Business Registration Services Bureau</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Dec 2024 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"Do The Woo Community: Join Our Community Friends at Do the Woo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=87314\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://dothewoo.io/join-our-community-friends-at-do-the-woo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:136:\"BobWP requests year-end support for the podcast through Community Friends, offering benefits while acknowledging listener contributions.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Dec 2024 13:23:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"Do The Woo Community: Talking Demos, Onboarding, Pricing and Social Media with Katie Keith and Marcus Burnette\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=87306\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://dothewoo.io/talking-demos-onboarding-pricing-and-social-media-with-katie-keith-and-marcus-burnette/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:170:\"Hosts Katie and Marcus about their highlights and strategies for 2025, focusing on plugin optimization, agency transitions, onboarding, pricing, and marketing challenges.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Dec 2024 10:48:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"Gravatar: Own Your Name With New Free Domains And Bluesky Integration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://blog.gravatar.com/2024/12/03/new-free-domains-and-bluesky-integration/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4430:\"<p>Your free Gravatar profile is your digital identity hub. Today we&#8217;re making it even better with more free domain options and seamless Bluesky integration.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Own Your Name</h2>\n\n\n\n<p>Owning your domain name is like having your own piece of digital real estate – it gives you control over your online identity and helps people find the real you across different platforms and networks. When you&#8217;re &#8216;domain verified&#8217;, you signal to others that you&#8217;re invested in your online presence, which builds trust and makes it easier for people to connect with the genuine you rather than potential impersonators.</p>\n\n\n\n<h2 class=\"wp-block-heading\">More Ways to Make Your Mark</h2>\n\n\n\n<p>We&#8217;re expanding our domain offerings to give you more ways to express yourself online. For a limited time, grab your free domain with any of these extensions:</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-1 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column has-base-color has-text-color has-link-color has-open-sans-font-family wp-elements-ae52d8d5dc336e777914180cf1bf9052 is-layout-flow wp-block-column-is-layout-flow\">\n<p><code>.bio</code> <br /><code>.fyi</code>  <br /><code>.life</code> <br /><code>.ninja</code> <br /><code>.rocks</code></p>\n</div>\n\n\n\n<div class=\"wp-block-column has-base-color has-text-color has-link-color has-open-sans-font-family wp-elements-b7b18e677a16d85cd1a26a16d671055a is-layout-flow wp-block-column-is-layout-flow\">\n<p><code>.contact</code> <br /><code>.guru</code> <br /><code>.link</code> <br /><code>.place</code> <br /><code>.social</code></p>\n</div>\n\n\n\n<div class=\"wp-block-column has-base-color has-text-color has-link-color has-open-sans-font-family wp-elements-20d01e2c2515e7e931fe5e740ca60988 is-layout-flow wp-block-column-is-layout-flow\">\n<p><code>.cool</code> <br /><code>.info</code>  <br /><code>.live</code> <br /><code>.pro</code> <br /><code>.world</code></p>\n</div>\n</div>\n\n\n\n<p>Your domain isn&#8217;t just a URL — it&#8217;s your identity on the open web. Use it for your Gravatar profile, email signature, business cards, and now&#8230;your Bluesky handle.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Level Up Your Bluesky Game</h2>\n\n\n\n<p><a href=\"https://bsky.social/about\" target=\"_blank\" rel=\"noreferrer noopener\">Bluesky</a> is growing in popularity, and it&#8217;s doing usernames differently. Instead of traditional @usernames, Bluesky uses domains as handles. This means your Gravatar domain can be your Bluesky identity too.</p>\n\n\n\n<p>By default, new Bluesky users get a generic <em>yourname.bsky.social</em> domain. But to verify ownership of your account, you can use any domain you own, like <em>yourname.link</em> or <em>yourname.social</em>.</p>\n\n\n\n<p>With Gravatar, we&#8217;ve made it super simple:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Claim your free domain on Gravatar</li>\n\n\n\n<li>Connect your Bluesky account</li>\n\n\n\n<li>Use your domain as your Bluesky handle</li>\n</ol>\n\n\n\n<p>No DNS configuration needed. No technical hassles. Just a sleek, professional identity that&#8217;s truly yours.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Why This Matters</h2>\n\n\n\n<p>Your online identity should be in your control. With a custom domain, you&#8217;re not tied to any platform&#8217;s naming rules. You own it. You control it. You can use it anywhere.</p>\n\n\n\n<p>Custom domains build trust and recognition. When people see your own domain instead of a generic link, they&#8217;re more likely to remember and engage with your content. It&#8217;s a simple way to make your online presence more professional and credible.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Get Started Now</h2>\n\n\n\n<p>Ready to claim your piece of the web? Head to your <a href=\"https://gravatar.com/profile\">Gravatar dashboard</a> and look for the claim a domain option at the top of your profile.</p>\n\n\n\n<p>Remember — these domains are free for the first year, but only for a limited time. Claim yours before someone else does!</p>\n\n\n\n<p>Already have a Gravatar domain? Check out our quick guide on <a href=\"https://support.gravatar.com/bluesky-custom-domain-handle/\">using it with Bluesky</a>.</p>\n\n\n\n<a href=\"https://gravatar.com/connect/?gravatar_from=blog\"><img width=\"3243\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/free_profile_cta.png\" alt=\"\" class=\"wp-image-2616\" /></a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Dec 2024 14:50:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"Do The Woo Community: Support Over Price? What Matters Most When Choosing a Hosting Company\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=87131\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://dothewoo.io/blog/support-over-price-what-matters-most-when-choosing-a-hosting-company/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:175:\"A recent poll revealed that quality support is the most important factor for choosing a hosting company, far outweighing specifications and price considerations for customers.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Dec 2024 12:12:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Marcus Burnette\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"Do The Woo Community: WordPress 6.7 Insights with Birgit Pauli Haack and Joe McGill\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=87247\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://dothewoo.io/wordpress-6-7-insights-with-birgit-pauli-haack-and-joe-mcgill/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:212:\"In this episode, hosts explore WordPress 6.7\'s highlights, including performance enhancements, the Site Editor\'s progression, advancements like the Interactivity API, and future developments anticipated for 2025.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Dec 2024 10:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: WordCamp Europe 2025 is Looking for Speakers and Sponsors\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=181250\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/wordcamp-europe-2025-is-looking-for-speakers-and-sponsors\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2564:\"<p><a href=\"https://europe.wordcamp.org/2025/\">WordCamp Europe 2025</a> will take place in the vibrant city of Basel, Switzerland, from 5 to 7 June 2025. This will be the 13th edition of this flagship event, and the organizers are currently seeking both sponsors and speakers to make this event the best one yet.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Call for Speakers</h2>\n\n\n\n<p>WordCamp Europe 2025 is currently inviting <a href=\"https://europe.wordcamp.org/2025/call-for-speakers/\">speakers</a> to share their knowledge, experiences, and innovative ideas with the WordPress community. The event will feature two full days of engaging talks and interactive workshops. There are three presentation formats available: Lightning talks (10 minutes) for concise insights, Long talks (30 minutes) for in-depth exploration of topics, and Workshops (60–90 minutes) for hands-on learning experiences.</p>\n\n\n\n<p>The call for speakers is open to everyone, regardless of prior speaking experience. You can share technical expertise, an inspiring personal story, or an innovative use case for WordPress. To encourage diversity and inclusion, underrepresented speakers are strongly encouraged to apply.&nbsp;</p>\n\n\n\n<p>Each applicant can submit up to two proposals. The deadline to submit your <a href=\"https://wceurope.survey.fm/wceu2025-speaker-application-form\">application</a> is 31 January 2025.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Call for Sponsors</h2>\n\n\n\n<p>Organizations looking to connect with the WordPress ecosystem can participate as <a href=\"https://europe.wordcamp.org/2025/call-for-sponsors/\">sponsors</a>. Sponsorship opportunities for WordCamp Europe 2025 range from €1,000 to €90,000, with add-on packages to suit varying levels of engagement and budgets. Sponsors can benefit from brand visibility, networking opportunities, and recognition as a vital part of the WordPress community.</p>\n\n\n\n<p>All sponsors must comply with the 100% GPL requirements and pass a vetting process to ensure alignment with the community’s values. A detailed breakdown of sponsorship options is available on the event’s <a href=\"https://europe.wordcamp.org/2025/call-for-sponsors/#packages\">Sponsorship Packages</a> page, and the Sponsors Team is ready to assist with any queries.</p>\n\n\n\n<p>The 2024 edition of WordCamp Europe was a huge success, with nearly 3,000 attendees from 96 countries, 86 sponsors, and 52 speakers. For 2025, the organizers are anticipating even bigger numbers, with an estimated 3,500 to 4,500 attendees expected to join in the excitement.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Dec 2024 18:10:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: DreamHost Removed from WordPress.org’s Recommended Hosting Page\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=181255\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wptavern.com/dreamhost-removed-from-wordpress-orgs-recommended-hosting-page\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1389:\"<p>DreamHost has been <a href=\"https://meta.trac.wordpress.org/changeset/14210\">removed</a> from WordPress.org&#8217;s recommended hosting page. The update was made by Samuel Wood (Otto), &#8220;Tech Ninja&#8221; for Audrey Capital, and the page now exclusively lists Pressable, Bluehost, and Hostinger as recommended hosting providers.</p>\n\n\n\n<p>The removal came without any explanation, with the associated changeset message simply stating, “Hosting: rm dreamhost, per matt.” DreamHost was previously <a href=\"https://meta.trac.wordpress.org/changeset/13120\">removed temporarily</a> from the page earlier this year, on January 17, 2024, only to be reinstated later.</p>\n\n\n\n<p>The Hosting page has been a point of contention within the community for years. The lack of clarity surrounding the criteria for being listed or delisted on this influential page has often sparked debates.</p>\n\n\n\n<p>Last year, when SiteGround was removed from the recommended list, the WordPress community responded with <a href=\"https://wptavern.com/wordpress-contributors-demand-transparency-and-objective-guidelines-for-listings-on-recommended-hosting-page\">demands for greater transparency</a>. Contributors called for clear and objective guidelines to determine who qualifies for inclusion on the page. </p>\n\n\n\n<p>Interestingly, the page doesnot include WordPress.com in the recommended list.&nbsp;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Dec 2024 17:44:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"Gravatar: 12 Effective Strategies for Managing Your Digital Footprint\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2286\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://blog.gravatar.com/2024/12/02/how-can-you-manage-your-digital-footprint/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:18220:\"<p>Your online presence is more extensive than you might think. A <a href=\"https://www.ghostery.com/blog/privacy-report-advertisers-and-adblockers\">2023 report by Ghostery</a>, a provider of privacy-focused software, found that the average website contains 32 tracking scripts, silently collecting data on your browsing behavior. This highlights a crucial fact: <strong>a significant portion of your digital footprint forms without your direct input</strong>.</p>\n\n\n\n<p>So, despite what many people think, managing your digital footprint goes beyond obsessing over your online privacy – it&#8217;s also about protecting your reputation, future opportunities, and personal safety. For example, your online content can <a href=\"https://fama.io/post/social-media-posts-employee-termination\">affect your employment</a> and relationships; it could even make you vulnerable to cybercrime.</p>\n\n\n\n<p>If you’re looking to go beyond basic management strategies, this article offers advanced techniques to take control of your online presence. We&#8217;ll explore the potential consequences of an unmanaged digital footprint and provide you with powerful tools and strategies – including <a href=\"https://gravatar.com/\">Gravatar</a> – to help you shape and protect your online identity.</p>\n\n\n\n<p>Whether you&#8217;re a professional concerned about your online reputation, a privacy-conscious user, or a parent worried about your child&#8217;s digital presence, these strategies will give you the skillset to navigate the Internet with confidence.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>7 important steps to manage your digital footprint</strong></h2>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>1. Assess your current digital footprint&nbsp;</strong></h3>\n\n\n\n<p>Start by conducting a thorough digital footprint audit. Search for your name on various search engines and take note of what information appears. Check all your social media profiles, blogs, and websites where you have an account. Pay special attention to old, inactive accounts and consider deleting or deactivating them if you don’t need them anymore. One way to find accounts you might have forgotten about is to search your email inbox for words/derivatives of words like &#8220;Verification&#8221;, &#8220;Activation&#8221;, &#8220;Login&#8221;, etc., things they send when you create a new account</p>\n\n\n\n<p>Next, evaluate the content you&#8217;ve shared. Does it align with your current personal and professional goals? Look for any outdated or potentially harmful information. This process helps you identify areas for improvement.</p>\n\n\n\n<p>As you review, note any discrepancies or negative information that could impact your reputation. Make a plan to update, correct, or remove such content. Remember, your digital footprint is dynamic, so we recommend making regular assessments on a monthly or quarterly routine.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>2. Adjust privacy settings on social media and other online platforms</strong></h3>\n\n\n\n<p>Take control of your online presence by regularly reviewing and updating privacy settings on all your social media platforms. Ensure that only necessary information is visible to the public.</p>\n\n\n\n<p>Limit data sharing by disabling location services and restricting the amount of personal information you share online. Use privacy settings to control who can see your posts and personal information.</p>\n\n\n\n<p>And don&#8217;t forget to utilize platform-specific tools. For example, <a href=\"https://www.facebook.com/\">Facebook</a> offers a <a href=\"https://www.facebook.com/help/443357099140264\">Privacy Checkup feature</a>, while <a href=\"https://twitter.com/\">X (formerly Twitter)</a> provides detailed <a href=\"https://help.x.com/en/safety-and-security\">Privacy and Safety settings</a>. These tools can help you manage your privacy more effectively.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>3. Be mindful of what you share online</strong></h3>\n\n\n\n<p>Before hitting that &#8216;post&#8217; button, pause and consider the long-term impact of sharing personal details or sensitive information online. Remember, once something is posted, it can be challenging to remove it completely.</p>\n\n\n\n<p>Understanding your audience is crucial. Be aware of who can see your posts and adjust your sharing settings accordingly. You might want to use different privacy settings for different audiences – friends, public, or custom lists.</p>\n\n\n\n<p>Oversharing can lead to serious consequences. It increases your risk of identity theft, unwanted solicitations, and even professional repercussions. A good rule of thumb: <strong>if you wouldn&#8217;t want it on a billboard, don&#8217;t put it online.</strong></p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>4. Regularly update software and applications</strong></h3>\n\n\n\n<p>Ensure all your devices and applications are running the latest versions to protect against security threats. This is important because security updates prevent attacks that lead to data leaks and breaches, and it’s always recommended that you update to the latest privacy policies.</p>\n\n\n\n<p>Where possible, enable automatic updates to stay protected without extra effort.</p>\n\n\n\n<p>Don&#8217;t stop at updates – use security tools to bolster your defenses. Install and regularly update antivirus and anti-malware software. Firewalls and VPNs can add extra layers of security, helping to keep your online activities private.</p>\n\n\n\n<p>Lastly, don&#8217;t forget about data backups. Regularly back up important data to prevent loss in case of a security breach. This practice not only protects your information but also gives you peace of mind.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>5. Monitor your online presence and reputation</strong></h3>\n\n\n\n<p>Stay on top of what&#8217;s being said about you online by setting up alerts. Tools like <a href=\"https://www.google.com/alerts?hl=en\">Google Alerts</a> can notify you when <a href=\"https://blog.gravatar.com/2024/04/10/personal-branding-tools/\">your name or brand</a> is mentioned online. This allows you to respond quickly to any mentions, whether positive or negative.</p>\n\n\n\n<p>Make it a habit to periodically search for your name on search engines. This practice gives you a clear picture of what information is publicly available about you.</p>\n\n\n\n<p>If you come across negative or inaccurate information, address it promptly and professionally. In some cases, you might need to contact website administrators to remove harmful content.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>6. Showcase your skills and accomplishments</strong></h3>\n\n\n\n<p>Your digital footprint isn&#8217;t just about minimizing risks – it&#8217;s also an opportunity to showcase your best self. Create a professional profile on platforms like <a href=\"https://www.linkedin.com/\">LinkedIn</a> to highlight your skills, experience, and accomplishments.</p>\n\n\n\n<p>Regularly share relevant content that showcases your expertise and interests. This could be articles you&#8217;ve written, projects you&#8217;ve completed, or industry news you find interesting. By doing so, you&#8217;re actively shaping your online presence in a positive way.</p>\n\n\n\n<p>Don&#8217;t forget to engage with your network. Comment on and share posts from others in your field so you can increase your visibility and build valuable professional relationships.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>7. Create a centralized online presence with Gravatar</strong></h3>\n\n\n\n<img width=\"1395\" height=\"852\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/gravatar-homepage-1.png\" alt=\"Gravatar homepage\" class=\"wp-image-2290\" />\n\n\n\n<p>Gravatar offers a strategic solution for creating a <a href=\"https://blog.gravatar.com/2024/02/21/securing-cyber-space-role-of-digital-identity-verification/\">centralized online identity</a> that’s more consistent with your preferred brand and, crucially, completely in your control. It&#8217;s a service that allows you to create and manage a single profile that can be used across multiple websites and platforms.</p>\n\n\n\n<p>Here&#8217;s how it works: You create a profile on Gravatar, storing your information securely. When you interact with Gravatar-enabled websites, they import your data from your Gravatar profile rather than storing it themselves. This approach is highly beneficial for alleviating data privacy concerns.</p>\n\n\n\n<img width=\"1032\" height=\"776\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/ronnie-gravatar-profile-1.png\" alt=\"Example of a Gravatar profile\" class=\"wp-image-2291\" />\n\n\n\n<p>To get started with Gravatar:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Visit <a href=\"http://gravatar.com\">Gravatar.com</a> and sign up for an account.</li>\n</ol>\n\n\n\n<img width=\"1287\" height=\"720\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/gravatar-profile-creation.png\" alt=\"Gravatar sing-up process\" class=\"wp-image-2292\" />\n\n\n\n<ol start=\"2\" class=\"wp-block-list\">\n<li>Upload an avatar image.</li>\n</ol>\n\n\n\n<img width=\"1635\" height=\"893\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/gravatar-uploading-profile-picture.png\" alt=\"Uploading a profile picture to Gravatar\" class=\"wp-image-2294\" />\n\n\n\n<ol start=\"3\" class=\"wp-block-list\">\n<li>Fill out your profile information.</li>\n</ol>\n\n\n\n<img width=\"1628\" height=\"1158\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/gravatar-personal-information.png\" alt=\"Filling out profile information with Gravatar\" class=\"wp-image-2295\" />\n\n\n\n<ol start=\"4\" class=\"wp-block-list\">\n<li>Choose your privacy settings.</li>\n</ol>\n\n\n\n<img width=\"974\" height=\"733\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/gravatar-privacy-settings-1.png\" alt=\"Adjusting the privacy settings in Gravatar\" class=\"wp-image-2296\" />\n\n\n\n<ol start=\"5\" class=\"wp-block-list\">\n<li>Add more relevant information, such as links, images, interests, and more!&nbsp;</li>\n</ol>\n\n\n\n<img width=\"1613\" height=\"919\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/gravatar-profile-edit-page.png\" alt=\"Gravatar profile editing\" class=\"wp-image-2298\" />\n\n\n\n<h2 class=\"wp-block-heading\"><strong>How to remove unwanted content from the internet</strong></h2>\n\n\n\n<p>Prevention is the best way to go, but you can’t protect yourself from absolutely everything, and chances are there will be some content that ends up somewhere you wished it didn’t. But how do you deal with this issue if you don’t own the website?&nbsp;</p>\n\n\n\n<p>Let’s take a look.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>1. Contact the website owner or content creator</strong></h3>\n\n\n\n<p>The most direct approach to removing unwanted content is to reach out to the website owner or content creator. When drafting your request, be polite and persuasive. Explain why the content should be removed and how it affects you personally or professionally.</p>\n\n\n\n<p>Here&#8217;s a template you can use or adapt:</p>\n\n\n\n<table class=\"has-fixed-layout\"><tbody><tr><td><strong>Subject: </strong>Request for Content Removal<br /><br />Dear [Website Owner/Content Creator],I hope this email finds you well. <br /><br />I&#8217;m writing to request the removal of [specific content] from your website, which can be found at [URL].This content [explain how it affects you, e.g., &#8220;contains outdated information about me&#8221; or &#8220;is causing harm to my professional reputation&#8221;]. I would greatly appreciate if you could remove or update this information.If you need any additional information from me, please don&#8217;t hesitate to ask. I&#8217;m happy to provide any necessary documentation to support this request.Thank you for your time and consideration.<br /><br />Best regards,[Your Name]</td></tr></tbody></table>\n\n\n\n<p>If you don&#8217;t receive a response, follow up after a week or two. Be persistent but remain courteous throughout the process.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>2. Use Google&#8217;s removal tools</strong></h3>\n\n\n\n<p>If the content appears in Google search results, you can request its removal using <a href=\"https://support.google.com/websearch/contact/content_removal_form?hl=en\">Google&#8217;s Search Removal Request</a>. While this doesn&#8217;t remove the content from the original website, it can significantly reduce its visibility.</p>\n\n\n\n<p>To use Google&#8217;s removal request form:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Go to <a href=\"https://support.google.com/websearch/answer/9673730\">Google&#8217;s Search Console Help</a> page.</li>\n</ol>\n\n\n\n<img width=\"660\" height=\"423\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/google-search-removal-page.png?w=660\" alt=\"Google\'s Search Console Help page\" class=\"wp-image-2299\" />\n\n\n\n<ol start=\"2\" class=\"wp-block-list\">\n<li>Click on &#8220;Start removal request.&#8221;</li>\n</ol>\n\n\n\n<img width=\"660\" height=\"216\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/start-removal-request-button.png?w=660\" alt=\"Request to remove content from Google\" class=\"wp-image-2300\" />\n\n\n\n<ol start=\"3\" class=\"wp-block-list\">\n<li>Fill out the form with the URL of the page you want removed and explain why.</li>\n</ol>\n\n\n\n<img width=\"660\" height=\"462\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/10/search-removal-form-google.png?w=660\" alt=\"Content removal request form\" class=\"wp-image-2301\" />\n\n\n\n<ol start=\"4\" class=\"wp-block-list\">\n<li>Submit the form and wait for Google&#8217;s response.</li>\n</ol>\n\n\n\n<p>This method is particularly effective for removing explicit images, fake pornography, or personally identifiable information. However, keep in mind that Google&#8217;s removal process has limitations, and not all requests are granted.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>3. Request de-indexing from search engines</strong></h3>\n\n\n\n<p>De-indexing is the process of removing a webpage from search engine results. While the content remains on the original website, it becomes much harder to find.</p>\n\n\n\n<p>To request de-indexing:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Contact the website owner and ask them to add a &#8220;noindex&#8221; tag to the specific page.</li>\n\n\n\n<li>If the website owner agrees, they&#8217;ll add a line of code to the page&#8217;s HTML that tells search engines not to include it in search results.</li>\n</ol>\n\n\n\n<p>This method can be particularly effective for news websites or blogs that may be willing to de-index older articles without removing them entirely.</p>\n\n\n\n<p>You can also do this to your own website by adding &lt;meta name=&#8221;robots&#8221; content=&#8221;noindex&#8221;&gt; to the &lt;head&gt; of the page you don&#8217;t want indexed.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>4. Legal options and pre-trial claims</strong></h3>\n\n\n\n<p>If the content is defamatory or violates your rights, you may need to consider legal options. Always consult with a legal professional before taking this route.</p>\n\n\n\n<p>A pre-trial claim is a formal request for content removal that can be made before taking legal action. The process varies by jurisdiction but generally involves:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Drafting a formal letter outlining the legal basis for your claim.</li>\n\n\n\n<li>Sending the letter to the content publisher via certified mail.</li>\n\n\n\n<li>Providing a reasonable timeframe for response (usually 14-30 days).</li>\n\n\n\n<li>If there&#8217;s no response, consider further legal action.</li>\n</ol>\n\n\n\n<p>Make sure to research the specific requirements for your country and state if you’re from the US because they will be different. Just to give you a general idea, here’s an <a href=\"https://ilcourtsaudio.blob.core.windows.net/antilles-resources/resources/02189433-b0f5-45cb-8ba7-72bc30289048/Privacy_Act.pdf\">example from the state of Illinois</a>.&nbsp;</p>\n\n\n\n<p>And for the people in the EU, remember that under the GDPR law, individuals have <a href=\"https://gdpr.eu/what-is-gdpr/?cn-reloaded=1#:~:text=People%E2%80%99s%20privacy%20rights,making%20and%20profiling.\">the right to request their data be deleted</a> from institutions and websites at any time, even if they previously agreed to its presence.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>5. Leverage online reputation management services</strong></h3>\n\n\n\n<p>For particularly challenging cases, consider using Online Reputation Management (ORM) services. These professionals specialize in improving and protecting your online image.</p>\n\n\n\n<p>Reputable ORM services can:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Implement strategies to push negative content down in search results.</li>\n\n\n\n<li>Create and promote positive content about you.</li>\n\n\n\n<li>Monitor your online presence continuously.</li>\n\n\n\n<li>Provide expert advice on managing your digital footprint.</li>\n</ul>\n\n\n\n<p>While these services can be effective, they often come with a significant cost. Research thoroughly and read reviews before engaging in any ORM service.</p>\n\n\n\n<p>Remember, managing your online presence is an ongoing process. Regular monitoring and proactive management are key to maintaining a positive digital footprint.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Take control of your digital identity today</strong></h2>\n\n\n\n<p>The consequences of neglecting your digital footprint can be severe and long-lasting. From missed job opportunities to identity theft, the risks are real and growing. But armed with the strategies we&#8217;ve discussed, you&#8217;re now equipped to take charge of your online presence.</p>\n\n\n\n<p>Remember, managing your digital footprint is an ongoing process. Start today by conducting a thorough audit of your online presence. Adjust your privacy settings, be mindful of what you share, and regularly monitor your reputation online.</p>\n\n\n\n<p>Don&#8217;t forget the power of a centralized profile. Gravatar offers a simple yet effective way to manage your online identity across multiple platforms and build a more controlled and cohesive online presence.</p>\n\n\n\n<p>Your digital identity is yours to shape. Take control now – <a href=\"https://gravatar.com/\">create your free Gravatar profile today</a> and start managing your digital footprint more effectively.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Dec 2024 16:27:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"Do The Woo Community: Driving the WordPress Economy at PressConf 2025 with Raquel Manriquez\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=87206\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://dothewoo.io/driving-the-wordpress-economy-at-pressconf-2025-with-raquel-manriquez/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:224:\"PressConf, reviving the essence of Pressnomics, is an upcoming business-centric WordPress event from April 23-26, 2024. It focuses on networking, curated speakers, and compensating organizers, fostering community innovation.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Dec 2024 13:38:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WPTavern: WordCamp Asia Seeks Host City Applications for 2026\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=181146\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wptavern.com/wordcamp-asia-seeks-host-city-applications-for-2026\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1624:\"<p>WordCamp Asia, one of WordPress&#8217;s premier flagship events, is seeking a host city for its 2026 edition. Previous editions were held in <a href=\"https://asia.wordcamp.org/2023/\">Bangkok </a>and <a href=\"https://asia.wordcamp.org/2024/\">Taipei</a>, with <a href=\"https://asia.wordcamp.org/2025/\">Manila </a>set to host in 2025.</p>\n\n\n\n<p>Local WordPress communities meeting the following criteria are encouraged to <a href=\"https://docs.google.com/forms/d/e/1FAIpQLScUkuVp02XXYDq2Ym_hjniPdE5L3TV-lU_EhY7aMW5gGJbT_w/viewform\">apply</a> by <strong>December 31, 2024</strong>:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>The city has an active local community that regularly organizes WordCamps, Meetups, or similar events.</li>\n\n\n\n<li>At least one WordCamp has been successfully organized in the city within the past four years.</li>\n\n\n\n<li>A committed team of at least eight active organizers is ready to collaborate and contribute.</li>\n\n\n\n<li>The city has a suitable venue that can accommodate 1,500 attendees, along with space for workshops, multiple tracks, and support functions.</li>\n</ul>\n\n\n\n<p>The global organizing leads will review applications, and the selected host city will be announced during the closing remarks of WordCamp Asia 2025.</p>\n\n\n\n<p>Organizing a flagship event is a significant undertaking, but a global team of experienced organizers from across Asia will collaborate closely with the local team for over eight months to ensure its success. </p>\n\n\n\n<p>Check out the call for host cities <a href=\"https://asia.wordcamp.org/2025/call-for-next-host-city/\">announcement</a> for more information.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Nov 2024 17:23:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"Gutenberg Times: Playground for agencies, Query Loop Filters, Gutenberg Fun and Games — Weekend Edition 312\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=31052\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"https://gutenbergtimes.com/playground-for-agencies-query-loop-filters-gutenberg-fun-and-games-weekend-edition-112/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:18601:\"<p>Hi there, </p>\n\n\n\n<p>I hope you had a wonderful Thanksgiving and spend some time offline with friends and family. And if you don&#8217;t live in the US or don&#8217;t celebrate Thanksgiving, you might still have had a quiet time, with US business owners and leaders offline. </p>\n\n\n\n<p>This time of the year there is a lot of planning going on. The first in-person event of 2025 will be <strong>WordCamp Asia</strong>. The Gutenberg Times is a media partner and I will hold a workshop on how to create a demo with Playground. If you&#8217;d like to connect for a meeting in Manila, use <a href=\"https://calendly.com/pauli-haack/wcasia\">the self-schedule app</a>. </p>\n\n\n\n<p>For now, I wish you a incredible rest of the weekend!</p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n<div width=\"100%\" class=\"wp-block-newsletterglue-showhide ng-block\">\n<p>&nbsp;🔖 The publishing calendar for the Holidays:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Dec 7th, 2024 Weekend Edition 313 </li>\n\n\n\n<li>Dec 8th, 2024 Gutenberg Changelog 112 </li>\n\n\n\n<li>Dec 14th, 2024 Weekend Edition 314</li>\n\n\n\n<li>Jan  11th, 2024 Weekend Edition 315</li>\n\n\n\n<li>Jan 12th, 2024 Gutenberg Changelog 113</li>\n</ul>\n\n\n\n<p>I&#8217;ll be back from year-end vacation on January 6th, if you want to send me information for the Jan 11th edition. And we will resume our regular programming after that until WordCamp Asia in mid-February. </p>\n</div>\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/playground-for-agencies-query-loop-filters-gutenberg-fun-and-games-weekend-edition-112/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/playground-for-agencies-query-loop-filters-gutenberg-fun-and-games-weekend-edition-112/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/playground-for-agencies-query-loop-filters-gutenberg-fun-and-games-weekend-edition-112/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/playground-for-agencies-query-loop-filters-gutenberg-fun-and-games-weekend-edition-112/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/playground-for-agencies-query-loop-filters-gutenberg-fun-and-games-weekend-edition-112/#gutenberg-fun-games\">Gutenberg Fun &amp; Games</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://gutenbergtimes.com/playground-for-agencies-query-loop-filters-gutenberg-fun-and-games-weekend-edition-112/#this-week-in-playground\">This week in Playground</a></li></ol>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>The <a href=\"https://github.com/WordPress/gutenberg/releases/tag/v19.8.0-rc.1\">Gutenberg 19.8 RC1</a> is available for testing. With the final release, a few experimental settings and functions will be stabilized. You&#8217;ll find many quality-of-life improvements for blocks and editors. You will learn from the release post of the final release on December 4th, 2024. Sarah Norris, JavaScript developer and core contributor will join me as my special guest on the Gutenberg changelog episode 112, and we will cover all important changes, then, too. You can use the <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">Gutenberg Nightly via Playground</a> to start testing. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background\"><div class=\"wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained\">\n<p>🎙️ Latest episode: <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-112-gutenberg-19-8-create-block-theme-plugin/\">Gutenberg Changelog #112 Gutenberg 19.8, Create Block Theme Plugin</a> with Sarah Norris</p>\n\n\n\n<img width=\"652\" height=\"183\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/12/Screenshot-2024-12-07-at-12.04.50.png?resize=652%2C183&ssl=1\" alt=\"\" class=\"wp-image-31178\" />\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p>In his latest video, <a href=\"https://www.youtube.com/watch?v=oUEsKR2J450\"><strong>INCREDIBLE WordPress layout in 250 seconds</strong></a>, <strong>Jamie Marsland</strong>, teaches you how to create a stunning card layout in WordPress using core blocks and the new negative margin feature.</p>\n\n\n\n<a href=\"https://www.youtube.com/watch?v=oUEsKR2J450\"><img width=\"492\" height=\"313\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/11/Screenshot-2024-11-29-at-18.16.06.png?resize=492%2C313&ssl=1\" alt=\"\" class=\"wp-image-31076\" /></a>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://x.com/robertorourke\"><strong>Rob O’Rourke</strong></a>, principal engineer at the enterprise agency Human Made,  was <a href=\"https://humanmade.com/engineering/introducing-the-wordpress-query-loop-filter/\"><strong>Introducing the WordPress Query Loop Filters</strong></a> plugin. This plugin provides filter controls for the query loop block, using the interactivity API and a powerful way to bring dynamic filtering to your WordPress site. In this article and accompanying video, O&#8217;Rourke leads you on a walk-through on how to add a taxonomy filter, create a dynamic Search or add a Post Type filter. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>For your more complex table needs in the Block editor, <strong><a href=\"https://wordpress.org/plugins/tableberg/\">Table Block by Tableberg</a> </strong>might be the right plugin for you. The description reads: &#8220;From pricing tables to product tables, you can build any types of tables using Tableberg. The plugin is designed for both novices and experienced users. It offers advanced functionalities like responsive controls, alignment adjustments, and cell merging, ensuring that tables look great on all devices without the need for coding skills.&#8221; </p>\n\n\n\n<img width=\"652\" height=\"367\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/11/Tableberg-edited.png?resize=652%2C367&ssl=1\" alt=\"\" class=\"wp-image-31085\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p><strong>Justin Tadlock</strong> published a Snippet on the Developer Blog on <a href=\"https://developer.wordpress.org/news/snippets/how-to-disable-the-font-library/\">How to disable the Font Library</a>. With a few lines of code you and remove Font library tools for the users of your theme. </p>\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2024&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2024 on. Updated by yours truly. The previous years are also available: <strong><strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\">2020</a>&nbsp;|&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2021/\">2021</a></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2022/\">2022</a></strong></strong>&nbsp;|&nbsp;<strong><a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/gutenberg-index-2023\">2023</a></strong></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p><strong>Mark Howells-Mead</strong> shared in his post <a href=\"https://permanenttourist.ch/2024/11/getting-preset-aspect-ratios-in-the-wordpress-block-editor/\"><strong>how to get preset aspect ratios in the WordPress Block Editor</strong></a>. He sets them via theme.json and then with the help of the useSettings function, he retrieves the value for a SelectControl component. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Join <strong>Ryan Welcher</strong> and <strong>Nick Diego</strong> in the upcoming <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/304668126/\"><strong>Developer Hours: Improve your workflows with WordPress development tools</strong></a>. They will take a deep dive into the advanced usage of tools like create-block and wp-scripts, along with a few others. Their focus will be on solving common challenges and showcasing techniques that go beyond the basics, even for developers already familiar with these tools.</p>\n\n\n\n<p>This session will feature practical examples and insights to help you work more efficiently, especially when building blocks, block themes, and Editor extensions. While the discussion will cover more advanced implementations, it will remain accessible to developers of all experience levels, with plenty of resources provided. There will also be time for questions and a preview of enhancements coming in future WordPress releases.</p>\n\n\n\n<a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/304668126/\"><img width=\"600\" height=\"338\" src=\"https://gutenbergtimes.com/wp-content/uploads/2024/11/DevHours-2024-12-03.avif\" alt=\"\" class=\"wp-image-31074\" /></a>\n\n\n\n<p><strong>Steve Bonisteel</strong>, technical editor at Kinsta, discusses in his recent post <a href=\"https://kinsta.com/blog/wp-scripts-development/\"><strong>Advanced WordPress development: how to build your next project with wp-scripts</strong></a> a set of tools for WordPress development. He highlights how wp-scripts makes the build process easier with a zero-configuration setup, support for modern JavaScript, CSS processing, code quality tools, and testing utilities. This package helps agencies manage multiple WordPress projects by standardizing the environment and centralizing tool dependencies. </p>\n\n\n\n<p>The article includes guidance on setting up a development environment with wp-scripts, using webpack, and utilizing features like advanced compilation, intelligent bundling, and integrated testing, along with examples for handling JSX, modern JavaScript, and linting for code quality checks.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"gutenberg-fun-games\">Gutenberg Fun &amp; Games</h3>\n\n\n\n<p><strong>Aki Hamano</strong> <a href=\"https://x.com/tetsuaki_hamano/status/1858914117987529004\">demo&#8217;d on X that &#8220;Code is Music&#8221; </a>and share a video on how his <strong><a href=\"https://wordpress.org/plugins/piano-block/\">Piano Block</a></strong> can be used to interrupt your content creation flow with some music. You can also <a href=\"https://github.com/t-hamano/piano-block\">study the source code on GitHub</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Tom Rodes</strong> is <a href=\"https://tomrhodes.blog/2024/11/28/using-a-gutenberg-block-to-run-snake/\"><strong>Using a Gutenberg Block to run&nbsp;Snake</strong></a>. He built it in React and runs it in the Gutenberg editor. It&#8217;s a fabulous way to procrastinate on your content creation tasks.  You can <a href=\"https://github.com/tommusrhodus/snake-gutenberg-block\">inspect the code on GitHub</a> or play the game <a href=\"https://playground.wordpress.net/?blueprint-url=https://raw.githubusercontent.com/tommusrhodus/snake-gutenberg-block/refs/heads/main/blueprint.json\">inside Playground</a>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jonathan Bossenger</strong> built <a href=\"https://jonathanbossenger.com/dodge-a-wordpress-game/\"> a variation of Dodge game </a>you can play on his site. It&#8217;s outside the block editor but used the Interactivity API directives, actions, and stores. <a href=\"https://github.com/jonathanbossenger/interactive-game-standalone-demo\">The code is available on GitHub</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><em>Do you know other fun way to use WordPress and the block editor for a fun projects? I want to know about it. Email me <a href=\"mailto:pauli@gutenbergtimes.com\">pauli@gutenbergtimes.com</a></em></p>\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. </p>\n\n\n\n<p>Now also available via <a href=\"https://playground.wordpress.net/?blueprint-url=https://gutenbergtimes.com/wp-content/uploads/2020/11/playnightly.json\">WordPress Playground</a>. There is no need for a test site locally or on a server. Have you been using it? <a href=\"mailto:pauli@gutenbergtimes.com\">Email me </a>with your experience</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"this-week-in-playground\">This week in Playground</h2>\n\n\n\n<p>Save the date! Next week, Dec 6th, 2024 at 14:00 UTC, <strong>Adam Zielinski</strong> will meet with T<strong>ammie Lister</strong> and others for a Hallway Hangout to discuss <a href=\"https://make.wordpress.org/playground/2024/11/29/hallway-hangout-playground-for-agencies-dec-6-2024/\">Playground for agencies</a>; how agencies and product builders could use WordPress Playground for client work and showcase their products.&nbsp;</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>You can create Playground configuration files called blueprints written in JSON (<a href=\"https://wordpress.github.io/wordpress-playground/blueprints/\" target=\"_blank\" rel=\"noreferrer noopener\">see docs</a>). With the help of Blueprints you can build demos or test environments and share with clients, users or co-workers. You can also view a list of example blueprints in the Blueprint Gallery. You can access directly from the&nbsp;<strong><a href=\"https://playground.wordpress.net/\" target=\"_blank\" rel=\"noreferrer noopener\">https://playground.wordpress.net/</a>&nbsp;&gt; Blueprint Gallery.</strong></p>\n\n\n\n<p>Not everyone is comfortable writing JSON, so&nbsp;Ajit Bohra&nbsp;and his team created a Blueprint builder in the block editor.  On Friday. <strong>Adam Zielinski</strong> and <strong>Dawid Urbansk</strong>i met with <strong>Ajit Bohra</strong> for an informal discussion about this tool and how it can be integrated into the Playground platform.  <a href=\"https://youtu.be/xFjwsC40O7Q\">The recording is now available on YouTube</a>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Two new blueprints in the Gallery: </strong>ImportStarter Content</p>\n\n\n\n<p>Since <a href=\"https://make.wordpress.org/core/2016/11/30/starter-content-for-themes-in-4-7/\">WordPress 4.7</a>, Theme builders could add Starter Content to their themes, to showcase how the theme could shine or to give  users  a head start on building their new site.  Playground offers two methods to import Starter Content: via an <a href=\"https://wordpress.github.io/wordpress-playground/blueprints/steps#InstallThemeStep\">option on the installTheme step</a> or as a separate <code>importStarterContent</code> step. The two new examples in the <a href=\"https://github.com/WordPress/blueprints/blob/trunk/GALLERY.md\">Blueprint Gallery </a>show how to use both of them. </p>\n\n\n\n<a href=\"https://github.com/WordPress/blueprints/blob/trunk/GALLERY.md\"><img width=\"652\" height=\"202\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2024/11/Screenshot-2024-11-30-at-10.45.10.png?resize=652%2C202&ssl=1\" alt=\"\" class=\"wp-image-31082\" /></a>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? </em><br /><em>Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or</em><br /><em> send me a message on WordPress Slack or Twitter @bph</em>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, <br />send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Featured Image: Wynwood Walls, Miami Florida, photo by Birgit Pauli-Haack</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too, and won&#8217;t give your email address to anyone <br />except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Nov 2024 11:13:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"BuddyPress: BuddyPress 14.3.3 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=335769\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://buddypress.org/2024/11/buddypress-14-3-3-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2543:\"<p id=\"block-35e8c6a5-dc8c-4b4a-b459-aa739313f8ca\"><a href=\"https://downloads.wordpress.org/plugin/buddypress.14.3.3.zip\">BuddyPress 14.3.3</a> is now available. This is a maintenance release.</p>\n\n\n\n<p id=\"block-80a9aeaa-f502-4d3b-972e-0f6995994f31\">14.3.3 fixes a mistake made in the build process for 14.3.1 (and 14.3.2 attempted to fix, but didn&#8217;t completely fix the issue, so was never released).  </p>\n\n\n\n<p id=\"block-80a9aeaa-f502-4d3b-972e-0f6995994f31\">14.3.1 fixed two bugs:</p>\n\n\n\n<ul id=\"block-bb57f61f-d125-49f4-9fa1-955d2dab822f\" class=\"wp-block-list\">\n<li>WordPress 6.7 compatibility: WP 6.7 will throw notices for plugins that load their textdomain before &#8216;init&#8217; (see <a href=\"https://buddypress.trac.wordpress.org/ticket/9247\">#9247</a>).</li>\n\n\n\n<li>BP Legacy Theme Pack: Make sure the <code>bp_heartbeat</code> property is included in the WP Heartbeat data object (see <a href=\"https://buddypress.trac.wordpress.org/ticket/9248\">#9248</a>).</li>\n</ul>\n\n\n\n<p id=\"block-d8121097-c1de-4e92-9710-1673a94d4c59\">For complete details, visit the&nbsp;<a href=\"https://codex.buddypress.org/releases/version-14-3-1/\">14.3.1 changelog</a>.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-1 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button is-style-outline is-style-outline--1\"><a class=\"wp-block-button__link has-white-background-color has-text-color has-background no-border-radius wp-element-button\" href=\"https://downloads.wordpress.org/plugin/buddypress.14.3.3.zip\">Get BuddyPress 14.3.3</a></div>\n</div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p id=\"block-aa9a1610-e591-4dea-966f-0de3f7ded87c\">You can get the latest version by clicking on the above button, downloading it from the&nbsp;<a href=\"https://wordpress.org/plugins/buddypress/\">WordPress.org plugin directory</a>&nbsp;or checking it out from our&nbsp;<a href=\"https://buddypress.trac.wordpress.org/browser/branches/14.0\">Subversion repository.</a></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"block-8935e1e5-ef63-42ee-8c08-67fad827159a\">Many thanks to our 14.3.3 contributors </h2>\n\n\n\n<p id=\"block-a8b36bfc-7855-4e99-ba54-508a3776b715\"><a href=\"https://profiles.wordpress.org/dreampixel\">dreampixel</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">boonebgorges</a>, <a href=\"https://profiles.wordpress.org/emaralive\">emaralive</a> &amp;&nbsp;<a href=\"https://profiles.wordpress.org/imath/\">imath</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 29 Nov 2024 19:33:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"David Cavins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Matt: Age-gating\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=131176\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://ma.tt/2024/11/age-gating/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:538:\"<p>I&#8217;m not opposed to age-gating at all, I think it&#8217;s appropriate in many situations and useful, and democratic societies can decide their own rules there. But it should be handled and authenticated as low-level as possible, at the operating system layer.</p>\n\n\n\n<p>See also: <a href=\"https://www.techmeme.com/241128/p19#a241128p19\">Australia&#8217;s Senate bans social media for kids under 16</a>. But there are lots of other less controversial examples, like adult websites, or ordering alcohol online or through an app.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 29 Nov 2024 19:09:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Do The Woo Community: Friday Shares: Sharing is the Way v6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=87217\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://dothewoo.io/blog/friday-shares-sharing-is-the-way-v6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:236:\"BobWP\'s weekly list features community insights, projects, transition discussions, security advice, multimedia accessibility tips, WordCamp updates, resource guides, and a variety of WordPress-related content to enhance user experience.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 29 Nov 2024 12:54:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"Do The Woo Community: Our First Q &amp; A with James Kemp, Core Product Manager for WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=87183\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://dothewoo.io/our-first-q-a-with-james-kemp-core-product-manager-for-woocommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:258:\"In this episode of Woo ProductChat, BobWP has a Q &#038; A with James Kemp talking about WooCommerce. Community questions included plugin integration, product editor updates, roadmap transparency, and future plans for WooConf, emphasizing community feedback.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Nov 2024 11:22:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WPTavern: WP Engine v. Automattic: Judge Inclined to Grant Injunction, Orders Status Quo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=180855\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://wptavern.com/wp-engine-v-automattic-judge-inclined-to-grant-injunction-orders-status-quo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3642:\"<p>The highly anticipated <a href=\"https://wptavern.com/wp-engine-files-injunction-hearing-set-for-november-26-2024\">preliminary injunction hearing</a> in the WP Engine v. Automattic case took place yesterday at the Northern California District Court. Presiding Judge Araceli Martínez-Olguín made it clear that while she was “inclined to grant some sort of injunction,” WP Engine’s proposed version was “exceedingly vague” and “not particularly narrowly tailored.”</p>\n\n\n\n<p>The judge emphasized that she could not enforce WP Engine’s proposed injunction due to its lack of specificity. In the meantime, both parties have been ordered to maintain the status quo until December 2, giving them time to submit revised proposals for the injunction.</p>\n\n\n\n<p>Automattic and Matt Mullenweg were represented by Anna Shaw and her team from Hogan Lovells, while WP Engine was represented by Rachel Herrick Kassabian and her team from Quinn Emanuel.&nbsp;</p>\n\n\n\n<p>WP Engine’s counsel <a href=\"https://www.delta.blog/transcript-of-the-preliminary-injunction-hearing/\">asserted</a> their client’s right to operate without the looming threat of a &#8220;nuclear war&#8221; and to remain an integral part of the WordPress community, which they have contributed to for over 15 years. They highlighted the abruptness of Automattic’s actions, pointing out the sudden issuance of a trademark license agreement on September 20—an unprecedented move after years of peaceful coexistence.</p>\n\n\n\n<p>They told the court, “That&#8217;s not how trademark owners operate. That is not how you protect and enforce your mark. You don&#8217;t wait 15 years and then drop a demand for thirty two million dollars on the recipient.”&nbsp;</p>\n\n\n\n<p>One of the key issues discussed was Automattic’s demand for 8% of WP Engine’s gross revenue, a sum amounting to $32 million. When questioned, Matt Mullenweg allegedly admitted that this figure was based on WP Engine’s financial capacity, stating, “It’s what I thought they could pay. We did an analysis to figure out what the free cash flow was. That’s how we set that number.” WP Engine’s legal team compared this approach to setting a ransom rather than calculating a reasonable royalty.</p>\n\n\n\n<p>WP Engine also claimed Automattic’s actions, including their ban from WordPress.org, have caused significant harm—loss of customers, market share, reputation, and goodwill.&nbsp;</p>\n\n\n\n<p>Anna Shaw, representing Automattic, countered that WP Engine still has access to WordPress software and plugins. What has been restricted, however, is their ability to use enhanced services provided by WordPress.org, such as hosting, managing, and distributing plugins via the platform. Shaw further stated that WP Engine circumvented this restriction by creating a “mirror” to restore customer functionality.</p>\n\n\n\n<p>WP Engine’s Attorney Brian Mack said the mirror was only a temporary and partial workaround they had to put in place to satisfy their customers. He added that “The WordPress core software, the software that defendants make available on their website, is intimately linked with WordPress.org. There&#8217;s 1500 references in the code. They&#8217;re hard coded references that you cannot change… Every single WordPress installation relies on WordPress.org.”</p>\n\n\n\n<p>He also shared about the huge security vulnerability for all of their clients and Automattic releasing the paid features of ACF pro on WordPress.org under a new URL. But Shaw accused them of wanting to avoid the costs associated with paying for or building an alternative solution.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Nov 2024 18:34:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: #147 – Steve Burge on Transitioning WordPress to the SaaS Market\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=180493\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wptavern.com/podcast/147-steve-burge-on-transitioning-wordpress-to-the-saas-market\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:38077:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, transitioning WordPress to the SaaS market.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Steve Burge.</p>\n\n\n\n<p>Steve is behind several popular WordPress plugins, such as PublishPress, MetaSlider, and TaxoPress. And today he&#8217;s here to share his journey, especially his recent ventures into the SaaS, or Software as a Service, landscape with his latest project Logtivity.</p>\n\n\n\n<p>Steve is experienced in building and marketing WordPress plugins, but Logtivity is different. It&#8217;s a SaaS product aimed at offloading and managing activity logs for WordPress sites, ensuring that the site&#8217;s performance isn&#8217;t bogged down by massive data logs.</p>\n\n\n\n<p>We talk about how Logtivity started, somewhat serendipitously, through discussions with a UK based developer. Steve recounts how this partnership evolved from a side project into a full-time commitment. He emphasizes the often under appreciated requirements of dedicating undivided attention to a SaaS product, highlighting the challenges and setbacks spaced when juggling other responsibilities.</p>\n\n\n\n<p>One of the key takeaways from Steve&#8217;s journey is the importance of identifying and pivoting to the right niche. Initially targeting large websites with massive data needs, Steve and his team discovered that agencies and maintenance services provided a more stable customer base for Logtivity. This pivot not only helped them understand their market better, but also influence them marketing strategies and pricing models.</p>\n\n\n\n<p>Speaking of pricing, steve touches on the substantial difference between monetizing plugins and SaaS products. A plugin might be a one-time or annual purchase. SaaS services often require higher, recurring monthly fees. This price shift is essential for covering the more considerable operational costs, including uptime guarantees, server maintenance, and robust data handling practices, all of which are critical for a reliable SaaS offering.</p>\n\n\n\n<p>Steve also discusses the less glamorous side of SaaS development, managing uptime server administration intricacies, and the constant need for vigilance. Unlike plugin development, where a failure might only inconvenience users until they download a fix, SaaS downtime can be catastrophic, especially for services as crucial as those monitoring site activity logs.</p>\n\n\n\n<p>As someone who&#8217;s navigated this challenging, yet rewarding, path, Steve offers good advice for anyone looking to make a similar transition.</p>\n\n\n\n<p>If you&#8217;re a WordPress plugin developer eyeing the SaaS space, or simply curious about the differences between plugin and SaaS development, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Steve Burge.</p>\n\n\n\n<p>I am joined on the podcast today by Steve Burge. Hello, Steve.</p>\n\n\n\n<p>[00:04:07] <strong>Steve Burge:</strong> Hey Nathan.</p>\n\n\n\n<p>[00:04:07] <strong>Nathan Wrigley:</strong> Nice to have you with us today. I&#8217;ve spoken with Steve on a number of occasions on different podcasts before. Today we&#8217;re going to be talking about, well, an interesting journey that Steve has had in the WordPress space, and also in the SaaS space. We&#8217;ll find out a little bit about that in a moment.</p>\n\n\n\n<p>Before then, Steve, would you mind just giving us your intro? Tell us a little bit about your experiences with WordPress in the past. And maybe you want to just drop some information about this new SaaS thing that you&#8217;ve been wrangling as well.</p>\n\n\n\n<p>[00:04:36] <strong>Steve Burge:</strong> Sure thing. So the most relevant part of my background for this podcast is that we&#8217;re very heavily involved in plugin development. The one we&#8217;re best known for is PublishPress, which tries to solve all sorts of publishing problems with WordPress. But we&#8217;ve got another couple, including MetaSlider, which is a popular slideshow plugin. One called TaxoPress, which organises taxonomy terms.</p>\n\n\n\n<p>So that&#8217;s been our background over the last few years. And how that loops into this podcast is we&#8217;ve recently launched a SaaS product called Logtivity, which is basically an activity log for WordPress. It takes all the activity logs, which can get really massive, can accumulate enormous amounts of data, and we&#8217;ll host them for you. So your site isn&#8217;t slowed down, and your database isn&#8217;t plugged up with all this data. And, well, it&#8217;s not been easy, and that&#8217;s kind of the topic of this podcast.</p>\n\n\n\n<p>[00:05:30] <strong>Nathan Wrigley:</strong> Thank you, that&#8217;s brilliant. So the idea of Logtivity is that it offloads and puts all of that information onto hardware under your control. Because typically WordPress could, if you left everything switched on, presumably it&#8217;s tracking all sorts of information and that could add up to megabytes, and megabytes, and megabytes, and finally gigabytes and terabytes, I guess. Ultimately, if you leave it all there, and you don&#8217;t exactly know what you want to record, or for how long, and what have you. So that&#8217;s what this, product does. We&#8217;ll link to it in the show notes.</p>\n\n\n\n<p>But as you said, this podcast is going to be about that journey, that move towards SaaS, and the interesting steps that you would, I guess, possibly do differently. The successes and the failures during that. And you&#8217;ve written down a series of bullet points on the paper near you, and we&#8217;re going to go through those. So this&#8217;ll be fascinating. So firstly, let&#8217;s just go through how it got started. How did you decide that you wanted to create a SaaS?</p>\n\n\n\n<p>[00:06:26] <strong>Steve Burge:</strong> We&#8217;ve acquired some plugins over the years, and during one of the conversations we ended up talking with a developer out of the UK who had an activity log plugin he was looking to sell.</p>\n\n\n\n<p>It had become a SaaS service and he was working on it slowly by himself, but not really making too much progress. And so it kind of spun out of an acquisition talks with him. And we ended up partnering with him, and both of us were doing it kind of part-time. He had a day job and was putting in a few hours in the evening, and we had our main plugin business and we&#8217;re helping him out a few hours a week.</p>\n\n\n\n<p>Slowly we kind of worked together, almost like a 50 50 partnership. He was doing those few hours on the development, and we were doing a few hours on the documentation and the marketing.</p>\n\n\n\n<p>[00:07:12] <strong>Nathan Wrigley:</strong> And so you strayed into the idea of doing a SaaS product, contacted this developer in the UK. I&#8217;m guessing from the little bit at the top of the show that everything didn&#8217;t necessarily work out. I don&#8217;t know if it was a collision between you and that developer, or just a whole bunch of other things.</p>\n\n\n\n<p>Let&#8217;s embark on your list of things, and they may be a list of ways to do things better in the future. But let&#8217;s go through that with the idea of what it would be like if you were a WordPress plugin developer, or theme developer, or what have you, and you were looking to transition into the SaaS space. Some lessons learned basically from Steve and his team. So go for it. Let&#8217;s start at number one.</p>\n\n\n\n<p>[00:07:49] <strong>Steve Burge:</strong> Our number one is probably inspired by quite a few conversations we&#8217;ve had. In fact, this whole list is inspired by conversations we&#8217;ve had by people recently, have been interested in adding a SaaS version of their plugin, or launching a whole new SaaS product, looking to expand their WordPress plugin lines.</p>\n\n\n\n<p>And I&#8217;ve seen some of the demos, I&#8217;ve sat down at WordCamp US, I saw three demos at least, of people with their SaaS products that they&#8217;re working on. And then I&#8217;ve had conversations since then, people trying to spin out an idea. And my first advice to them has been, don&#8217;t do this part-time. It&#8217;s really difficult to make this work as a side hustle.</p>\n\n\n\n<p>It&#8217;s possible with a plugin. With a WordPress plugin you can put something on wordpress.org, do some marketing, add some features, and it&#8217;s possible to get some traction. Not easy, but possible.</p>\n\n\n\n<p>It&#8217;s almost impossible with a SaaS service. It requires commitment we&#8217;ve found. We went through a couple of years with this partnership with the UK developer, who became a friend, and I enjoyed working with him, but it didn&#8217;t work with each of us chipping in a few hours a week.</p>\n\n\n\n<p>[00:08:54] <strong>Nathan Wrigley:</strong> Is that because of the problems that you&#8217;ve got to try and solve? So obviously with the WordPress plugin, a lot of the bits and pieces that might make up a SaaS are taken care of. So authentication, user management, and all of that, and permissions and those kind of things, they&#8217;re all taken care of and so the plugin just builds off the base of WordPress, which provides a lot of that.</p>\n\n\n\n<p>Whereas I&#8217;m imagining, maybe there are libraries and ways of doing it in a more refined and quick way, but they might not align. Is it something to do with that? Is it the fact that you&#8217;ve taken on a load of work, which you might not have foreseen you need to do?</p>\n\n\n\n<p>[00:09:27] <strong>Steve Burge:</strong> Yes, absolutely. You have to build your own payment gateway, your own authentication, and there are some libraries available. We built Logtivity in Laravel, and there are some drop-in libraries, but it&#8217;s never quite that easy. There are big chunks that you do need to build yourself. You may see some SaaS frameworks out there, but none of them are ever quite as easy as they promise.</p>\n\n\n\n<p>And so you are starting from a lower level. There&#8217;s not the ability to suddenly drop in a WooCommerce and have the ability to sell the product. There&#8217;s probably not a licensing system like Easy Digital Downloads, which is ready to drop in and go from the start.</p>\n\n\n\n<p>And so earlier this year we moved to acquire the whole of the plugin finally from our UK partner. And we put a full-time developer on Logtivity, and that&#8217;s when we&#8217;ve really started to see some progress because we underestimated the workload involved.</p>\n\n\n\n<p>[00:10:17] <strong>Nathan Wrigley:</strong> Okay, so it&#8217;s basically a measurement of the amount of work involved, and also an understanding that there&#8217;s a load of extra work, which you take for granted in a sense, in WordPress.</p>\n\n\n\n<p>I guess also with WordPress, the end user is fairly well-defined in that they&#8217;re website builder, and they&#8217;re going to have a WordPress website. And you&#8217;ve got the constraints of the system that that brings and all of the different bits and pieces there. So the scope is a little less large.</p>\n\n\n\n<p>Your audience is defined, they&#8217;re WordPress website owners who are willing to extend the boundaries of WordPress. Whereas I guess with a SaaS, at the beginning at least, from a marketing point of view, you&#8217;re also just sort of shouting into a void. Nobody has heard of you. You might have to start frequenting other social networks, and building some sort of reputation outside of the WordPress space. You can&#8217;t use that marketing channel as well. Yeah, okay, so there&#8217;s a load there. So that&#8217;s number one. Take us through the next few then.</p>\n\n\n\n<p>[00:11:13] <strong>Steve Burge:</strong> Oh, you kind of hit on number 2 there. The niche is hard to find. In our particular use case, we imagined that the main customers would be, well, very big websites that needed to offload enormous amounts of data. That&#8217;s kind of the origin story of Logtivity, is that there was a customer just like that who had activity logs that were so big they just couldn&#8217;t possibly be downloaded from their own website. They needed to offload it somewhere. And so we thought there were lots more customers out there like that. No, it turned out we&#8217;re probably solving a problem that maybe dozens of people had.</p>\n\n\n\n<p>[00:11:44] <strong>Nathan Wrigley:</strong> So the assumption being that there&#8217;d be loads of end users with this problem, and I guess that&#8217;s one of market research and asking the question, is there anybody out there who would use this thing? I mean, you&#8217;re obviously pursuing the solution, Logtivity continues. Have you pivoted who the target audience is? Maybe you&#8217;re addressing, I don&#8217;t know, the hosting space or something like that instead.</p>\n\n\n\n<p>[00:12:05] <strong>Steve Burge:</strong> We&#8217;ve pivoted more towards agencies. Our biggest users are agencies who have hundreds of customers, and they need an easy way to track what&#8217;s happening on all those sites. Agencies and maintenance services.</p>\n\n\n\n<p>The niche problem has come up with quite a few of the people I&#8217;ve talked to who have been kicking around SaaS ideas. They put up a site with AI content marketing, or one particular WordPress plugin niche, and it&#8217;s tricky to hit that niche, not only a niche that people will pay for initially, but also one that gives you room to grow into the future.</p>\n\n\n\n<p>[00:12:36] <strong>Nathan Wrigley:</strong> Yeah, it&#8217;s interesting isn&#8217;t it, because you&#8217;re separating people from an amount of money, which a typical WordPress plugin can manage is one thing, but SaaS products seem to, over the course of a year at least anyway, my intuition is that they&#8217;re more expensive. And trying to get people to open up their wallet and pay for something like that, yeah, you&#8217;ve got to know who those people are.</p>\n\n\n\n<p>And you&#8217;re right, if in the beginning it was an end user who was building a website, it&#8217;s probably the least interesting thing in their day thinking about activity logs and what have you. Whereas it really does solve a problem for a development agency who&#8217;s trying to track down a problem on a WordPress website that they have access to, and that they are in charge of.</p>\n\n\n\n<p>So pivoting that, and learning that was probably extremely important. It makes you wonder at the beginning, imagine the amount of time you could save if you&#8217;d just been able to draw that conclusion, and figure out who the actual perfect target market was. So that&#8217;s an important thing to mention. Thank you for that. What came next?</p>\n\n\n\n<p>[00:13:39] <strong>Steve Burge:</strong> Oh, well, you&#8217;re picking my brain. Number three, again, which is, the prices are higher. You are working with a substantially different pricing segment. If you&#8217;re selling a plugin, you&#8217;re probably, even something big like Gravity Forms, the initial pricing option is about $50 a year, and not unusual tool for SaaS services to be that per month.</p>\n\n\n\n<p>With Logtivity, I actually have a list of all our products on the whiteboard behind me, and one of the details is how much people are paying us each month on average. With our plugins, the average is between $5 and $10 a month, which would be hard to make a SaaS service work.</p>\n\n\n\n<p>Logtivity, the average is closer to $20. So we&#8217;re already at a pricing segment which is twice where we are with our plugins. We hope to keep growing that because to run a successful SaaS, you probably need to be aiming at a pricing level that is three, four times what you&#8217;re charging for your plugins. And to do that, you need to add a lot more value.</p>\n\n\n\n<p>[00:14:38] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s interesting. I&#8217;ve never really heard anybody encapsulate that as that fraction, you know, or that multiple, three or four times is what you need to be at, in ballpark figures to make it profitable.</p>\n\n\n\n<p>I guess that comes down to the requirements of a SaaS product. You&#8217;ve got actual hardware that you&#8217;ve got to manage, you&#8217;ve got servers that need to be up. Whereas a WordPress plugin, you have a zip file that you need to put somewhere. And that typically could be on some extremely inexpensive hosting option. Very typical hosting option out in the WordPress space.</p>\n\n\n\n<p>With a SaaS option, you need to have a much more complicated, robust setup. And also, I guess, you&#8217;re into the realms of sort of GDPR, and data handling, and maintaining all of that as well. Okay, that&#8217;s interesting. So I think that was three. Let&#8217;s move over to four.</p>\n\n\n\n<p>[00:15:27] <strong>Steve Burge:</strong> Those last couple of minutes, you basically knocked off all the rest of the items on my list. I&#8217;ll go through them in more detail. I put this on Twitter, slash X, as a question last week, and the very first response I got was from one of the founders of GiveWP. And his was basically one word reply, it was uptime. That is all your responsibility now.</p>\n\n\n\n<p>As a plugin developer, like you say, you give them the plugin package and then it&#8217;s all in the customer&#8217;s hands. But when you&#8217;re running a SaaS service, that uptime is all on you. You need to be there 99.9% of the time. And if that happens on a Sunday morning, you have downtime, Saturday night when you&#8217;re out with your family and you had a drink or two, and you have downtime problems, it&#8217;s a whole different experience from running a plugin where you can offload almost all of that worry.</p>\n\n\n\n<p>[00:16:12] <strong>Nathan Wrigley:</strong> Yeah, I guess the nature of the data that you are gathering in particular means that downtime is really not an option. You can be kind of forgiving of some SaaS apps if they go down, because the nature of the work that you are doing in there is not really that crucial or time sensitive.</p>\n\n\n\n<p>And if your consumption of log data stalls, then you&#8217;ll just have this big black hole. And then people come because their site, they want to track something down that happened at the exact coincidental moment that your hardware failed, you&#8217;re in a bit of bother, aren&#8217;t you? And you&#8217;ve got to promise something like 99.9, or even potentially higher, given the nature of the data that you are gathering. So yeah, that&#8217;s really interesting. Uptime suddenly becomes a really important thing.</p>\n\n\n\n<p>[00:17:00] <strong>Steve Burge:</strong> I&#8217;ve been thinking about some of these successful SaaS&#8217; that we&#8217;ve had out of the WordPress community. You have Metorik, the WooCommerce product that Bryce from Australia developed. He&#8217;s taking in WooCommerce data and suddenly, you have downtime, you miss a couple of sales. Suddenly your key WooCommerce revenue data is off.</p>\n\n\n\n<p>Or perhaps the most popular niche has been backup services. Backup slash maintenance services like ManageWP or BlogVault. You&#8217;re dealing with critical information there when it comes to people&#8217;s site backups.</p>\n\n\n\n<p>So, yes, uptime is a whole new headache that you have to learn to deal with, when you&#8217;re dealing with SaaS as opposed to plugin development.</p>\n\n\n\n<p>[00:17:37] <strong>Nathan Wrigley:</strong> Yeah, so the typical plugin developer can happily go out, as you described it, on a Saturday night, and have a few drinks, knowing that if something goes wrong with the website, at the very most, people are going to be unable to access the latest version of the software, possibly the support forums, or whatever that may be. You can be fairly forgiving of that.</p>\n\n\n\n<p>But if your SaaS goes down on Saturday night and you&#8217;ve had a few drinks, suddenly you are faced with this bit of a dilemma really, isn&#8217;t it? Do you try to fix it? You&#8217;re just miles away from a telephone, or an internet connection, or whatever it may be. You&#8217;re out in the back of beyond, camping with your family or something like that, and suddenly all the bets are off.</p>\n\n\n\n<p>So I presume it&#8217;s incumbent upon you to set up a much more robust structure of people who are managing that. So it can&#8217;t just be Steve. It&#8217;s got to be Steve plus one other who is available when Steve is not.</p>\n\n\n\n<p>[00:18:34] <strong>Steve Burge:</strong> Yes, whenever I&#8217;ve talked to someone about this, it&#8217;s been a relief for them to get that first hire down so it&#8217;s not just them. They can occasionally take some time off, but you need a different skillset that you either need to learn yourself, or you need to hire, which is server admin.</p>\n\n\n\n<p>The knock on effect of worrying about uptime is you need to get familiar with diving into Google Cloud consoles, or Amazon S3 consoles. Poking around into at least moderate level server admin skills to be able to get your SaaS up and running. As Laravel users, there are some nice options. We use Laravel Vapor, which is a pretty robust option that takes quite a bit of the server admin headache away from us, but definitely not all of it.</p>\n\n\n\n<p>[00:19:16] <strong>Nathan Wrigley:</strong> Yeah, and I guess the key thing that I got out of what you just said there was the first hire is the bit where you suddenly feel a sense of relief, because it&#8217;s no longer just on your shoulders. Not just in terms of server management and the technicalities of learning how to do that, but just that on 24 hours a day, the nature of just never being able to entirely switch off.</p>\n\n\n\n<p>And I mean, it&#8217;s just ordinary things like planning a regular weekend and going out, and knowing that at some point the telephone could ring and you need to be within earshot of that telephone. You&#8217;ve got to make sure that you are on the internet somewhere.</p>\n\n\n\n<p>And then I guess also you need to set up sort of standard SOP things. So, okay, if our uptime monitoring software alerts to the fact that our SaaS is down, what do we do? Who&#8217;s taking it? Where does the chain of command go? What&#8217;s the pre-written email that we&#8217;re going to send out to our customers, and all of those kind of things?</p>\n\n\n\n<p>[00:20:12] <strong>Steve Burge:</strong> More than one time ourselves, or our UK partner, was tapping away frantically on our phones trying to reboot a server, or get things working when we weren&#8217;t in the office. These things happen.</p>\n\n\n\n<p>We&#8217;ve tried to have people with a variety of skills help out with Logtivity because when it comes to hiring a WordPress plugin developer, it&#8217;s normally been fairly straightforward. If you&#8217;re a good PHP developer, or even if you&#8217;re adjacent to PHP, our last hire with our plugin shop was someone with JavaScript experience, and they&#8217;ve really had no problem adjusting to be a WordPress plugin developer.</p>\n\n\n\n<p>But with a SaaS service, you&#8217;re looking for someone who knows WordPress, because if you are interacting between your SaaS and WordPress, they need to know the normal WordPress standards. Plus, it helps in a big way, obviously, to know the platform you&#8217;re working with. It could be Node.js, it could be Laravel. And then you have the server admin on top.</p>\n\n\n\n<p>And so it&#8217;s not surprising to me that some of the people who have successfully started SaaS&#8217;, they 10 X developers, incredibly talented people. I think we discussed Bryce Adams from Metorik. There&#8217;s another guy doing well, Aaron Edwards, who has an AI documentation service called DocsBot. And it requires, certainly as the founder or the initial developer, to really be able to have a good understanding, across multiple areas, from your own SaaS platform, to WordPress, to server admin, and whatever else might be needed to keep your SaaS service going.</p>\n\n\n\n<p>[00:21:39] <strong>Nathan Wrigley:</strong> Okay, great. Really interesting stuff coming out of this. And it&#8217;s really sparking my thought process because each time you describe the next bullet point, it definitely leads me into a thought process that I hadn&#8217;t had before. And so this is really interesting. So where do we go next? What&#8217;s the next one?</p>\n\n\n\n<p>[00:21:54] <strong>Steve Burge:</strong> To wrap up what we&#8217;ve done, we said that uptime is a major issue, it&#8217;s on you.</p>\n\n\n\n<p>Server admin is a key skill that you&#8217;re going to need to learn.</p>\n\n\n\n<p>The technical challenge is wide ranging, that. You may have to deal with several new areas, not just your own SaaS stack, but also the server admin.</p>\n\n\n\n<p>And the technical challenge itself is different coming from a very defined framework like WordPress. People joke that as a WordPress developer you basically make it up and do it your own way. When they start looking at other people&#8217;s plugin code and think, what kind of weird non-standard thing have you done here?</p>\n\n\n\n<p>But the truth is, most people working in WordPress are working in a pretty closely defined framework. A lot is given to you including the authentication, for example, a lot of the database structure. If you are building a SaaS service, either for good or bad, that&#8217;s on you.</p>\n\n\n\n<p>We kind of touched on that point earlier, but I didn&#8217;t mention the one, I put this question on Twitter, this was probably the most common response I got, that you&#8217;re on your own. I got responses from people who had used Node. People who&#8217;d used Rails. People who had used Laravel, all sorts of different products.</p>\n\n\n\n<p>They all said that adjusting to that freedom was perhaps the most interesting challenge for them. I&#8217;ve been quite big on mentioning the difficulties so far, but in terms of being a learning experience, in terms of being something completely new, it&#8217;s a whole different mindset moving from working in WordPress to working inside one of these SaaS frameworks.</p>\n\n\n\n<p>[00:23:23] <strong>Nathan Wrigley:</strong> You mentioned the sort of, I think you described it as, it&#8217;s all on you. I wonder if basically you&#8217;re saying it&#8217;s quite a lonely thing to do. Because the WordPress community is kind of famously large, and famously accommodating, let&#8217;s put it that way. People who have really competing products do manage to be able to just put their differences to one side, and the profit motive to one side when they gather at things like WordCamps.</p>\n\n\n\n<p>I&#8217;m just guessing, but I&#8217;m guessing that the SaaS space is probably a little bit less, and I would imagine there&#8217;s a little bit more of a cutthroat mentality. I don&#8217;t know if that&#8217;s true or not.</p>\n\n\n\n<p>[00:24:01] <strong>Steve Burge:</strong> It&#8217;s certainly, you&#8217;re coming across more unique problems. Problems that are unique to your build. Problems that are unique to what you are trying to do. Which maybe only a handful of people have experienced, and if they have, they probably haven&#8217;t put it onto a forum, onto Stack Overflow or somewhere for other people to find.</p>\n\n\n\n<p>But I can guarantee 99%, if I run across a WordPress problem, I&#8217;ll be able to Google it and find the answer because the problems are probably fairly limited. It&#8217;s a clearly defined product, a clearly defined framework.</p>\n\n\n\n<p>Just before coming on the show, a customer had a problem with uploading images. They couldn&#8217;t upload an image that was larger than like 2,500 pixels. I hadn&#8217;t heard of that as a problem before. A quick Google search. Oh, it was something that was introduced in WordPress in 5.3. We come across similar problems in our SaaS service, there&#8217;s no Google results, there&#8217;s no search results. For good or bad, we are figuring it out by ourselves.</p>\n\n\n\n<p>[00:24:51] <strong>Nathan Wrigley:</strong> So yeah, every time there&#8217;s a support request that you don&#8217;t fully understand, Google is your friend in the WordPress space, because it&#8217;s very likely that somebody has had that exact same problem before. A perfect example with the image uploads, and it was just, it had never come across your door before. But then it did, and you were able to find the answer in fairly short measure, I would&#8217;ve thought.</p>\n\n\n\n<p>But the notion that if that&#8217;s a problem on your own hardware, in your own SaaS, well, you&#8217;re on your own. Go and figure that out. And I guess there is a bit of that, you&#8217;ve got to figure out all of the different bits and pieces, and be fairly self-reliant. And in the back at the same time, being able to manage the stress that causes. And obviously if you&#8217;re in the process of building, and it&#8217;s not yet profitable, or if you&#8217;ve built it, shipped it, and it&#8217;s not yet, every one of those is one of the death by a thousand paper cuts kind of thing.</p>\n\n\n\n<p>[00:25:37] <strong>Steve Burge:</strong> Oh, for sure. There&#8217;s a learning curve to this, and it takes time. In the blog post that I put together, putting all these lessons together, I dug into the success stories of a couple of people that have really made a success of their WordPress connected SaaS.</p>\n\n\n\n<p>One of them, the two founders took a couple of years without pay to get it started. Bryce with Metorik took about a year to leave his job from Automattic and get to a comfortable level.</p>\n\n\n\n<p>It&#8217;s a big change from having a comfortable job, or running an existing business to get some things like this up and running. It&#8217;s probably a fulltime commitment for at least a year, if you&#8217;re lucky.</p>\n\n\n\n<p>[00:26:12] <strong>Nathan Wrigley:</strong> And you&#8217;ve got to be able to bankroll that. And there&#8217;s going to be some expenses that you hadn&#8217;t foreseen. And it&#8217;s not just a case of giving people a zip file. There&#8217;s a whole lot more going on.</p>\n\n\n\n<p>Gosh, that&#8217;s really fascinating. I suppose the one question that I want to ask is, if you had your time again, would you even embark upon a SaaS at this point, combined with WordPress? Would Logtivity be something that you&#8217;d examine and think, you know what, maybe not?</p>\n\n\n\n<p>[00:26:38] <strong>Steve Burge:</strong> We were kicking around this question after having these conversations recently. It may be that we have some extra features coming soon. We&#8217;re going to see how those go, and it may be time for another pivot, including perhaps wrapping it into one of our existing products with an existing customer base. Some of our successful plugins have thousands and thousands of users. It may be that something like this is better picked up, is better sold, to an existing customer base.</p>\n\n\n\n<p>[00:27:06] <strong>Nathan Wrigley:</strong> I guess that&#8217;s an interesting point as well in that WordPress, the sky is set at a certain height maybe with WordPress. And if you have an absolute barnstormer of a SaaS product, and we can all imagine ones which we&#8217;ve all used before, Slack may be a good example, something like Notion or something like that. Ones that lots of people have heard of but didn&#8217;t necessarily exist all that long ago. I guess in the case of Slack, it probably has.</p>\n\n\n\n<p>But really the sky is miles away. There is no limit. So if you were to be successful, it has a greater opportunity to turn it into something truly inspirational, groundbreaking. You can do whatever you like. You&#8217;re not constrained, in air quotes, by the WordPress backbone of it all. So, yeah, you would do it again, I&#8217;m taking it from that. But you maybe would&#8217;ve done things slightly differently, and pivoted it, and changed the direction of it a little bit.</p>\n\n\n\n<p>[00:28:00] <strong>Steve Burge:</strong> Oh yeah. Just as a learning experience. You&#8217;re in this business to make money obviously, but to learn as well and try new challenges. And out of the 20 odd years that I&#8217;ve been doing things in this industry, I would put launching a SaaS product right up there with the very toughest. I&#8217;ve learned more doing this than just about anything else I&#8217;ve done in those last 20 years.</p>\n\n\n\n<p>[00:28:22] <strong>Nathan Wrigley:</strong> That seems like a perfect place to end it. Steve Burge, thank you so much for chatting to me today. Really appreciate it. Just before we go, where can people find you, apart from Logtivity? We&#8217;ll link to that in the show notes on wptavern.com. Where else might we find you? Do you hang out on any socials, or anything like that?</p>\n\n\n\n<p>[00:28:42] <strong>Steve Burge:</strong> Yeah, I am stevejburge on most of those, Twitter / Threads / Bluesky platforms.</p>\n\n\n\n<p>[00:28:52] <strong>Nathan Wrigley:</strong> Well, thank you very much, Steve. Really appreciate that. And hopefully people will reach out if they&#8217;ve got some interesting conversations to have with you about turning WordPress into SaaS. Thank you very much.</p>\n\n\n\n<p>[00:29:03] <strong>Steve Burge:</strong> Thanks Nathan. I don&#8217;t want to discourage anyone. We&#8217;ve had lots of conversations about people launching their own SaaS, and I&#8217;ve tried to be encouraging. It&#8217;s a difficult path, but a worthwhile path. And hopefully anyone who reads our blog post will get some good advice from the WordPress community. And I hope they have good luck in launching their product.</p>\n\n\n\n<p>[00:29:23] <strong>Nathan Wrigley:</strong> As I said, we will put all of the links in the show notes. Head to wptaven.com and search for the episode with Steve Burge. We&#8217;ll link to the blog post there. But once again, Steve, thank you so much for chatting to me today. I really appreciate it.</p>\n\n\n\n<p>[00:29:36] <strong>Steve Burge:</strong> Cheers Nathan.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://x.com/stevejburge\">Steve Burge</a>.</p>\n\n\n\n<p>Steve is behind several popular WordPress plugins such as PublishPress, MetaSlider, and TaxoPress, and today, he’s here to share his journey, especially his recent ventures into the SaaS (Software as a Service) landscape with his latest project, Logtivity.</p>\n\n\n\n<p>Steve is experienced in building and marketing WordPress plugins, but Logtivity is different. It’s a SaaS product aimed at offloading and managing activity logs for WordPress sites, ensuring that the site’s performance isn&#8217;t bogged down by massive data logs.</p>\n\n\n\n<p>We talk about how Logtivity started, somewhat serendipitously, through discussions with a UK-based developer. Steve recounts how this partnership evolved from a side project into a full-time commitment. He emphasises the often underappreciated requirement of dedicating undivided attention to a SaaS product, highlighting the challenges and setbacks faced when juggling other responsibilities.</p>\n\n\n\n<p>One of the key takeaways from Steve’s journey is the importance of identifying and pivoting to the right niche. Initially targeting large websites with massive data needs, Steve and his team discovered that agencies and maintenance services provided a more stable customer base for Logtivity. This pivot not only helped them understand their market better, but also influenced their marketing strategies and pricing models.</p>\n\n\n\n<p>Speaking of pricing, Steve touches on the substantial difference between monetising plugins and SaaS products. A plugin might be a one-time or annual purchase, SaaS services often require higher, recurring monthly fees. This price shift is essential for covering the more considerable operational costs, including uptime guarantees, server maintenance, and robust data handling practices, all of which are critical for a reliable SaaS offering.</p>\n\n\n\n<p>Steve also discusses the less glamorous side of SaaS development, managing uptime, server administration intricacies, and the constant need for vigilance. Unlike plugin development, where a failure might only inconvenience users until they download a fix, SaaS downtime can be catastrophic, especially for services as crucial as those monitoring site activity logs.</p>\n\n\n\n<p>As someone who&#8217;s navigated this challenging, yet rewarding, path, Steve offers good advice for anyone looking to make a similar transition.&nbsp;</p>\n\n\n\n<p>If you’re a WordPress developer eyeing the SaaS space, or simply curious about the differences between plugin and SaaS development, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://logtivity.io/lessons-wordpress-plugin-developers-starting-a-saas/\">Lessons for WordPress Plugin Developers Starting a SaaS</a></p>\n\n\n\n<p><a href=\"https://publishpress.com/\">PublishPress</a></p>\n\n\n\n<p><a href=\"https://www.metaslider.com/\">MetaSlider</a></p>\n\n\n\n<p><a href=\"https://taxopress.com/\">TaxoPress</a></p>\n\n\n\n<p><a href=\"https://metorik.com/\">Metorik</a></p>\n\n\n\n<p><a href=\"https://managewp.com/\">ManageWP</a></p>\n\n\n\n<p><a href=\"https://blogvault.net/\">BlogVault</a></p>\n\n\n\n<p><a href=\"https://vapor.laravel.com/\">Laravel Vapor</a></p>\n\n\n\n<p><a href=\"https://docsbot.ai/\">DocsBot</a></p>\n\n\n\n<p><a href=\"https://x.com/stevejburge\">Steve on X</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Nov 2024 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"Do The Woo Community: WP Campus Connect with Pooja Derashri and Anand Upadhyay\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=87151\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://dothewoo.io/wp-campus-connect-with-pooja-derashri-and-anand-upadhyay/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:183:\"Devin hosts Pooja and Anand to chat about WP Campus Connect, a successful initiative boosting Ajmer\'s WordPress community by targeting college students through workshops and seminars.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Nov 2024 10:07:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Do The Woo Community: Host Marcus Burnette Shifts Focus to Agency Strategy at Bluehost\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=87071\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://dothewoo.io/blog/host-marcus-burnette-shifts-focus-to-agency-strategy-at-bluehost/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:222:\"Marcus, a well-respected leader in the WordPress community, and host here at Do theWoo, transitions from GoDaddy to Bluehost as Sr. Manager for Agency Strategy, continuing to influence and support agencies in the industry.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Nov 2024 09:01:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: WordCamp Asia 2025 Announces Two Scholarships for Attendees\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=180542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/wordcamp-asia-2025-announces-two-scholarships-for-attendees\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2168:\"<p>WordCamp Asia 2025, in partnership with The WordPress Foundation and WordCamp Central, has announced <a href=\"https://asia.wordcamp.org/2025/announcing-scholarships/\">two scholarship</a> opportunities for the upcoming event in Manila, Philippines. These scholarships aim to support community members by covering essential expenses such as flights, accommodation, and event tickets. A team of program managers from WordCamp Central and the WordPress Global Community Team will oversee the selection process.</p>\n\n\n\n<p>The<strong> </strong><a href=\"https://wordcampcentral.survey.fm/wcasia-2025-kim-parsell-scholarship-application\"><strong>Kim Parsell Memorial Scholarship</strong></a> is being <a href=\"https://wptavern.com/wordcamp-asia-and-wordcamp-europe-added-to-kim-parsell-memorial-scholarship-program\">extended to WordCamp Asia</a> for the very first time. Previously, this scholarship was exclusively available for WordCamp US attendees. It is designed to support women who are active contributors to the WordPress project, have never attended WordCamp Asia, and require financial assistance to participate in the 2025 event.</p>\n\n\n\n<p>The <a href=\"https://docs.google.com/forms/d/e/1FAIpQLScEV6LyCaNTAaTNKQvDZqv0XOPzrzWZXWEUaNeSWp7HbWO3IA/viewform\"><strong>Diversity Fund Scholarship</strong></a> reflects WordCamp Asia&#8217;s commitment to inclusivity and accessibility. This scholarship supports active WordPress contributors who have never attended flagship WordCamps (Asia, US, or Europe) and require financial assistance. It prioritizes individuals from underrepresented demographics who are eager to use their WordCamp experience to strengthen their local WordPress communities in Asia.</p>\n\n\n\n<p>Applications for both scholarships are now open and will remain so until <strong>December 6, 2024</strong>.  If you meet the criteria, don’t miss the chance to apply. All applicants will be notified of their selection status by December 20, 2024.</p>\n\n\n\n<p> Also mark your calendars—the <a href=\"https://asia.wordcamp.org/2025/third-batch-of-ticket-drop-for-wordcamp-asia-2025/\">third batch of tickets </a>will drop on November 28 and 29, 2024.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 26 Nov 2024 17:58:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: WordPress.org Releases New ‘Secure Custom Fields’ Plugin With ACF Pro Features\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=180643\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://wptavern.com/wordpress-org-releases-new-secure-custom-fields-plugin-with-acf-pro-features\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4628:\"<p>In the latest chapter of the ongoing dispute between Automattic and WP Engine, a new plugin “Secure Custom Fields” (<a href=\"https://wordpress.org/plugins/secure-custom-fields/\">https://wordpress.org/plugins/secure-custom-fields/</a>) has been added to the Plugin Repository by WordPress.org. This plugin has 90+ active installations and exhibits the features of ACF Pro plugin like repeater, flexible content, clone fields gallery, options pages, and ACF Blocks.</p>\n\n\n\n<p>Last month, WordPress.org took over WP Engine’s <a href=\"https://wptavern.com/acf-plugin-forked-to-secure-custom-fields-plugin\">ACF plugin</a>, citing security issues, and renamed it Secure Custom Fields (<a href=\"https://wordpress.org/plugins/advanced-custom-fields/\">https://wordpress.org/plugins/advanced-custom-fields/</a>)&nbsp;</p>\n\n\n\n<a href=\"https://profiles.wordpress.org/wordpressdotorg/#content-plugins\"><img src=\"https://lh7-rt.googleusercontent.com/docsz/AD_4nXdG5ci3dsl4eq2juxOPWSbe9sSpIu5BDegGunmxwkFHIs5gwsp7gxgDuyXaSkuNbfHsNTSLmQDpn3pDJ0jrP0sy9oZg06gtCOEIrR5MVz1ihTUnmVTAu5YoKmVt0qJWhSAuixgK2A?key=8Nc8VCiXWQM5XY5o8QO15iVY\" alt=\"\" /></a>\n\n\n\n<p>David McCan from WebTNG, has a detailed <a href=\"https://www.youtube.com/watch?v=nYHKSpfhrRE\">video</a> analyzing the new plugin. He shares that the update check and license check functionality from ACF Pro has been removed. He remarked “This seems like a classic case of a null plugin which is now being hosted in the WordPress plug-in directory. So I&#8217;m wondering if this is even a legal Fork. I&#8217;m not an expert in software licensing law but my understanding is you need to preserve the original copyright notices when you fork a plugin. it&#8217;s one of the requirements.”</p>\n\n\n\n<p>Prominent voices have weighed in on the controversy. Gergely Orosz of The Pragmatic Engineer newsletter <a href=\"https://x.com/GergelyOrosz/status/1860965378123239921\">tweeted</a>, “Automattic &#8211; the creator of WordPress, a company raising $950M in VC funding &#8211; took a paid WordPress plugin built and owned by another dev and re-published it, making it free. If you have a business selling a paid WP plugin: Automattic can null it, anytime. Another new low.”</p>\n\n\n\n<p>Duane Storey <a href=\"https://x.com/DuaneStorey/status/1861069617294172572\">shared</a> in X that ACF is now “an officially registered trademark of WP Engine.” He also <a href=\"https://x.com/DuaneStorey/status/1860443216367219060\">said</a>, &#8220;Sounds like what&#8217;s being put into the WordPress repository is basically a nulled version of ACF Pro without some of the copyrights.&nbsp; It&#8217;s clear Matt&#8217;s no longer a champion of any of the things he once said he was.&nbsp; I left a review. “</p>\n\n\n\n<p>Tim Brugman, a Full-Stack Developer, <a href=\"https://x.com/Brugman/status/1860672554966393291\">pointed out</a>, “A8c&#8217;s _new_ SCF plugin deactivates Advanced Custom Fields PRO when it is activated. An action that is not allowed by the dot org Plugin Handbook.”</p>\n\n\n\n<p>Automattician Brandon Kraft, who submitted the plugin, addressed the issue on <a href=\"https://religious.social/@kraft/113539565935870350\">Mastodon</a>, “The decisions on forking ACF or ACF Pro, etc., are above my paygrade, so to speak, but I didn&#8217;t refuse to work on it because I wanted to try to do it right/better.” He also shared, “I wasn&#8217;t involved in the forking the Pro code, but I just don&#8217;t see a notice. One item on my list is create a proper LICENSE.md that includes the GPL and ack past copyright…acknowledging it is built on existing work. If I missed the copyright already in the code, that&#8217;s an oversight on my part and not intentional.”</p>\n\n\n\n<p>The Repository <a href=\"https://www.therepository.email/wordpress-org-forks-acf-pro-in-unprecedented-move-against-wp-engine\">reported</a> that a member of the WordPress Plugin Review Team, speaking on the condition of anonymity, confirmed that after Kraft submitted the ACF Pro fork, it was approved by another Automattic employee, bypassing the Plugin Review Team’s usual processes and checks.</p>\n\n\n\n<p>The incident has sparked heated discussions on <a href=\"https://www.reddit.com/r/Wordpress/comments/1gy8bud/wordpressorg_has_apparently_released_secure/\">Reddit</a> too. While the majority is against WordPress.org’s action, some <a href=\"https://www.reddit.com/r/Wordpress/comments/1h05vfy/why_i_will_be_using_scf_instead_of_acf/\">support</a> getting the pro features for free.</p>\n\n\n\n<p>The preliminary injunction hearing for WP Engine vs Automattic is scheduled for later today. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 26 Nov 2024 17:32:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Jyolsna\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"BuddyPress: BuddyPress 14.3.1 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=335742\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://buddypress.org/2024/11/buddypress-14-3-1-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2341:\"<p id=\"block-35e8c6a5-dc8c-4b4a-b459-aa739313f8ca\"><a href=\"https://downloads.wordpress.org/plugin/buddypress.14.3.1.zip\">BuddyPress 14.3.1</a> is now available. This is a maintenance release.</p>\n\n\n\n<p id=\"block-80a9aeaa-f502-4d3b-972e-0f6995994f31\">14.3.1 fixes two bugs:</p>\n\n\n\n<ul id=\"block-bb57f61f-d125-49f4-9fa1-955d2dab822f\" class=\"wp-block-list\">\n<li>WordPress 6.7 compatibility: WP 6.7 will throw notices for plugins that load their textdomain before &#8216;init&#8217; (see <a href=\"https://buddypress.trac.wordpress.org/ticket/9247\">#9247</a>).</li>\n\n\n\n<li>BP Legacy Theme Pack: Make sure the <code>bp_heartbeat</code> property is included in the WP Heartbeat data object (see <a href=\"https://buddypress.trac.wordpress.org/ticket/9248\">#9248</a>).</li>\n</ul>\n\n\n\n<p id=\"block-d8121097-c1de-4e92-9710-1673a94d4c59\">For complete details, visit the&nbsp;<a href=\"https://codex.buddypress.org/releases/version-14-3-1/\">14.3.1 changelog</a>.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-2 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button is-style-outline is-style-outline--2\"><a class=\"wp-block-button__link has-white-background-color has-text-color has-background no-border-radius wp-element-button\" href=\"https://downloads.wordpress.org/plugin/buddypress.14.3.1.zip\">Get BuddyPress 14.3.1</a></div>\n</div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<p id=\"block-aa9a1610-e591-4dea-966f-0de3f7ded87c\">You can get the latest version by clicking on the above button, downloading it from the&nbsp;<a href=\"https://wordpress.org/plugins/buddypress/\">WordPress.org plugin directory</a>&nbsp;or checking it out from our&nbsp;<a href=\"https://buddypress.trac.wordpress.org/browser/branches/14.0\">Subversion repository.</a></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"block-8935e1e5-ef63-42ee-8c08-67fad827159a\">Many thanks to our 14.3.1 contributors&nbsp;</h2>\n\n\n\n<p id=\"block-a8b36bfc-7855-4e99-ba54-508a3776b715\"><a href=\"https://profiles.wordpress.org/dreampixel\">dreampixel</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">boonebgorges</a>, <a href=\"https://profiles.wordpress.org/emaralive\">emaralive</a> &amp;&nbsp;<a href=\"https://profiles.wordpress.org/imath/\">imath</a>.</p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 26 Nov 2024 17:09:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"David Cavins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Matt: Carmack &amp; Rogan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=131088\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://ma.tt/2024/11/carmack-rogan/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:801:\"<p>I guess something has changed with the Joe Rogan / Spotify deal and now all the old episodes are on YouTube again, which means the gems from the archives can now pop up. I <a href=\"https://x.com/id_aa_carmack/status/1861171748659515900?s=46\">was alerted</a> to this conversation between Joe Rogan and John Carmack, and it&#8217;s pure gold. I know I&#8217;m five years late in watching this, but that makes it even better because it&#8217;s so prescient. Joe asks amazing, in-depth questions that reveal deep domain knowledge, and it sparks John Carmack to make observations that are quite wise. No filler. Now, with the benefit of hindsight, we can see both Joe and John being absolutely right. This is one of my favorite podcast episodes ever.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 26 Nov 2024 12:17:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"Gutenberg Times: Gutenberg Changelog #111 – Gutenberg 19.6 and 19.7, Developer Hours, Playground, and Collaborative Editing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=31002\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-111-developer-hours-playground-and-collaborative-editing/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:67184:\"<p>In this episode, Birgit Pauli-Haack and Anne McCarthy discuss Gutenberg 19.6 and 19.7, Developer Hours, Playground, and Collaborative Editing</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-111-developer-hours-playground-and-collaborative-editing/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-111-developer-hours-playground-and-collaborative-editing/#transcript\">Transcript</a></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Editor:&nbsp;<a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo:&nbsp;<a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production:&nbsp;<a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">Announcements</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/11/21/wordpress-6-8-call-for-volunteers/\">WordPress 6.8 Call for Volunteers</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/11/19/proposal-major-releases-for-2025/\">Proposal: Major releases for 2025</a></li>\n\n\n\n<li><a href=\"https://youtu.be/fs-aawt3eNc\">Exploring the Block Bindings API in WordPress 6.7</a></li>\n\n\n\n<li>December 3rd 16:00 UTC&nbsp; <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/304668126\">Improve your workflows with WordPress development tools</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Community Contributions</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://developer.wordpress.org/news/2024/11/10/whats-new-for-developers-november-2024/\">What’s new for developers? (November 2024)</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/snippets/how-to-disable-heading-levels-in-the-editor/\">Snippet: How to disable heading levels in the Editor</a> by Nick Diego</li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/snippets/conditionally-unregister-patterns/\">Snippet: Conditionally unregister patterns</a> by Justin Tadlock</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress 6.7 and 6.7.1</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://wordpress.org/news/2024/11/rollins/\">WordPress 6.7 “Rollins”</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2024/11/wordpress-6-7-1-maintenance-release/\">WordPress 6.7.1 Maintenance Release</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/10/23/wordpress-6-7-field-guide/\">Field guide 6.7</a></li>\n\n\n\n<li><a href=\"https://gutenbergtimes.com/6-7-source-of-truth/\">WordPress 6.7 Source of Truth</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Gutenberg plugin releases</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/11/06/whats-new-in-gutenberg-15-9-31-may-2-2/\">What’s new in Gutenberg 19.6? (6 Nov)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/11/20/whats-new-in-gutenberg-19-7-20-november/\">What’s new in Gutenberg 19.7? (20 November)</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s discussed and in the works</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/11/21/update-on-phase-3-collaboration-efforts/\">Update on Phase 3: Collaboration efforts</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/discussions/65012#discussioncomment-11075617\">Real time collaboration Update</a> (GitHub)</li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/60622\">First and experimental version for inline commenting</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/66377\">Inline Commenting: Next iteration</a></li>\n</ul>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<ul class=\"wp-block-list\">\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on X (formerly known as Twitter) or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Hello, and welcome to our 111th episode of the Gutenberg Changelog podcast. In today&#8217;s episode we&#8217;ll talk about Gutenberg 19.6, 19.7, developer hours, playground and collaborative editing. I&#8217;m your host, Birgit Pauli-Haack, curator at the Gutenberg Times and full-time core contributor for the WordPress Open Source project sponsored by Automattic. With me today is the brilliant Anne McCarthy, product manager for WordPress and author of the Source of Truth posts that she&#8217;s keeping for almost over a year. No, two years maybe. Forgot. Yeah.</p>\n\n\n\n<p><em>Anne McCarthy</em>: Might be almost.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Hi, Anne.</p>\n\n\n\n<p><em>Anne McCarthy</em>: It&#8217;s been a long time. Yeah. Hello. Thank you so much for having me. And also I feel like it&#8217;s like a lucky, I don&#8217;t know, 1, 1, 1, 1. I&#8217;m like, I&#8217;m into that 111. That feels good.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Yeah. I can&#8217;t believe it&#8217;s over 100 episodes, yeah.</p>\n\n\n\n<p><em>Anne McCarthy: </em>That&#8217;s amazing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, it&#8217;s amazing. All the co-hosts that I had and special guests, it was really, it&#8217;s quite a trip. And I&#8217;m still excited and people are listening to it even more. And so, this is my shout-out for all the new listeners on the podcast. And if you want to, please, please leave a review, whatever you feel about the show, it definitely helps with the distributions. Anne, while 6.7 came out, you did a masterwork of Source of Truth. Can you pick up two features that you are most excited about from this release?</p>\n\n\n\n<p><em>Anne McCarthy</em>: Oh, yeah, that&#8217;s tough. Yeah, two features. I am very biased by the things that improve the experience and the feedback that we heard back when I was running the FSC outreach program. That&#8217;s something that I&#8217;m always thinking about. And so for me, I would pull out, zoom out. I think zooming out and being able to build with patterns, one of the big issues that we used to have back in the day was that it was hard to find the discoverability of patterns and to work with pattern&#8217;s a lot easier.</p>\n\n\n\n<p>And I think the potential of zoom out, I think there&#8217;s a lot of things that we need to figure out still. But I think the potential of zoom out and the ability to zoom out and focus on the sections of your site, to get out the granular details is a huge win and something that can be built upon and used contextually right at the moment when you need it. I think that&#8217;s the part that we need to start sorting through is do we now expose this when it comes to adding a new page or adding a new template? Because I know some folks really don&#8217;t like that pop up of starter patterns.</p>\n\n\n\n<p>But I&#8217;m always fascinated by how we can make the pattern experience easier and make the site building experience for folks who need it a bit more approachable and more section by section. I&#8217;m really, really excited about it. I just built a site for someone recently, a podcast I really like. And that&#8217;s one of the things I was most excited to show her is like, &#8220;Hey, if you want to add future stuff, look, you can just, boom, sections. Add this in, you can just add these patterns.&#8221; And I think it makes the user experience a lot better.</p>\n\n\n\n<p>The other one I&#8217;ll mention is more technical, but something that also has been a long-standing point of feedback back. Back when I was doing developer relations, developer advocacy, the template registration API, I remember early on so many plugin authors being like, &#8220;How do we adopt block templates? How does this work? How do we register things?&#8221;</p>\n\n\n\n<p>And I would send very niche GitHub links to how other folks had done it. And this registration API just eases all of that. And I&#8217;m really excited for folks to increase the adoption of using block themes and block templates and embracing a block world. And I am thrilled that that has landed in 6.7. And I hope more and more folks can take advantage of it. Those are the two very different, but I would say those are the two that make me excited.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Announcements</h3>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Excellent. Excellent. Yeah, we talked about 6.7 with other hosts here before because it&#8217;s an eight to nine weeks release cycle. In between we had our episodes and we looked at that. But we are looking to the future. We have right now on the Make Core blog, we have two posts. One is the release schedule proposal by Héctor Prieto for next year and I can&#8217;t believe we are going to have a 7.0 release in 2025.</p>\n\n\n\n<p>6.8 is proposed to be scheduled for April 15th, 6.9 for August 5th and 7.0 for November 11. And it&#8217;s all around the flagship word camps, around some holidays and way before Black Friday the new version is out. Even those who experienced a lot of traffic for the last two months of the year, they can do it with a new version.</p>\n\n\n\n<p>Also for WordPress 6.8, the call for volunteers is out, so if you want to contribute to a release, it is definitely a certain advanced level of contributing. But what you can do, even if you don&#8217;t have experience, you can shadow people that are on the release. To maybe do that and then start working in the release squad for 6.9. Definitely try and figure that out if you want to contribute.</p>\n\n\n\n<p>Otherwise, there are multiple other ways to contribute to WordPress course. We all have done it. We all did some documentation changes, we did some reports on the Gutenberg and the track tickets we tested with that. And testing has become really fun now with Playground. Yeah, it&#8217;s really interesting to see how that sped up so much. Any thoughts about that?</p>\n\n\n\n<h3 class=\"wp-block-heading\">Playground</h3>\n\n\n\n<p><em>Anne McCarthy:</em> Yeah, I am super&#8230; It&#8217;s so interesting when I had a call this week with some of the WordPress YouTubers, an AMA with Matías Ventura, the project architects of Gutenberg. And Playground is something I&#8217;m so fascinated by because it really does make it immediately accessible. You immediately can have your hands on it and it works well.</p>\n\n\n\n<p>And Playground, one of the things I love about the Playground team, and this is something I think that&#8217;s really important when you&#8217;re using a new tech like that, they want to hear what would make your experience better, easier, if you run into a bug, all that sort of stuff. You&#8217;re getting&#8230; We report stuff all the time. I feel like that&#8217;s one of the things that I really love about these efforts right now in the WordPress project is there&#8217;s so much momentum and so much care and thought being put into those tools.</p>\n\n\n\n<p>And so if you haven&#8217;t given it a try, please give it a try. If you&#8217;ve run into an issue, please, there&#8217;s a GitHub repo where you can open issues. But I&#8217;m really hoping we can get more educators and influencers using it to help bring WordPress to more people. If you haven&#8217;t been paying attention to WordPress Playground, I definitely encourage you to do so. And it&#8217;s a great way to test things early. As Birgit was saying, testing is a lot easier and more approachable thanks to a lot of the stuff that&#8217;s being done there.</p>\n\n\n\n<p>I always find it a great way to, whenever I&#8217;m doing the Source of Truth, I&#8217;m spinning up WordPress Playground constantly. I think there&#8217;s some stat where I think 700,000 people have used WordPress Playground. I&#8217;m probably 50,000 of those. Because I feel like I&#8217;m using it probably on a daily basis, so if that&#8217;s helpful insight for&#8230; I truly probably use it on a daily basis. If you aren&#8217;t, it&#8217;s definitely something to add to your list of tools.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Definitely. Yeah. If you want to learn more about Playground, we are planning some Hallway Hangouts. Hallway Hangouts are informal discussions with contributors on their new features and what they&#8217;re working on to give a little bit feedback but also to show off a few things to trigger some creativity.</p>\n\n\n\n<p>And there&#8217;s Ajit Bohra who is a early adopter of Gutenberg as well as a Gutenberg contributor, has built a blueprint builder. Blueprints are the configuration files for Playground. And he made this into a block editor feature and had been working on it. And so next week, February&#8230; February, how did this come in? No, it&#8217;s Friday, not February, it&#8217;s Friday, November 29th at 14:00 UTC we are in a Playground Hallway Hangout with Ajit Bohra. And he shows off what he has done, what his vision is, what the team is going to think about. Adam Zielinski who was the sole developer for a year now has the whole team behind Playground will also be there.</p>\n\n\n\n<p>And the second event is with Tammie Lister and discussing how agencies can use Playground for their product, in their client work and all that. That&#8217;s December 6th, also 14:00. These are save the date for you right now. We are publishing that on the Make Blog on Playground before with all the Zoom links, but that&#8217;s just to get it out before that happens. And you know about it.</p>\n\n\n\n<p>There&#8217;s also a developer hour coming up on December 17th that&#8217;s also on Playground and watch the announcement on meetup.com. It is not quite clear what the topic is about, but it&#8217;s definitely on the roster. December 17th for 16:00 UTC. And this week was a developer hangout. No, next week, I&#8217;m sorry. I&#8217;m getting my weeks mixed up.&nbsp;</p>\n\n\n\n<p><em>Anne McCarthy:</em> So much is happening. I don&#8217;t blame you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. December 3rd there is a 16:00 at 16:00 UTC. Ryan Welcher will talk about improving your workflows with WordPress development tools. It&#8217;s about extensions, it&#8217;s about create block, it&#8217;s about create block theme, it&#8217;s about webpack and all the different things that can make your life easier. That&#8217;s also sniffers for coding standards and all that. You will learn how to use them and how to make it easier for you to develop things.</p>\n\n\n\n<p>This week what I wanted to say was the recording of the developer hours is available on Exploring the Block Bindings API from WordPress 6.7 with Justin Tadlock and Nick Diego. They just had the block bindings actually my favorite thing for 6.7 that it&#8217;s in the UI and you can connect your custom fields with the blocks and have an automatic display on the front end that&#8217;s just phenomenal and is really magic for me. But that&#8217;s what you can see in that recording.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Community Contributions<strong> </strong>and Developer Hours<strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</strong></h3>\n\n\n\n<p>All right. Now the announcements. The developer blog has some new things there since we last talked about it. Of course, the What&#8217;s New for Developers comes out every 10th of the month. And that covers a lot of things from 6.7 but also from the 19.6 release that we are going to talk about today. And we have a new post format on the developer blog called Snippet, which is a small explanation of a problem solution for one task and then the code snippet with it.</p>\n\n\n\n<p>There are two snippets there right now. One is how to disable heading levels in the editor. That&#8217;s about a feature that came with 6.7 as well is different heading levels and how you can control that. When you have your editors and they are not supposed to use H1s, you can disable that from the drop-down list. And you can also say, &#8220;Okay, we don&#8217;t do H5 and we don&#8217;t do H6,&#8221; and disable that. And the snippet shows you how to do that very easily with BHP.</p>\n\n\n\n<p>The other one is to conditionally unregistered patterns. That&#8217;s important for theme developers who have patterns for plugins that might not be installed yet. You don&#8217;t want to show the pattern because it runs into a problem. Now you know how to conditionally unregister those patterns and both by Justin Tadlock. All right. That&#8217;s from the developer hours to developer news. And from the upcoming events, the Hallway Hangouts and developer hours.</p>\n\n\n\n<p><em>Anne McCarthy:</em> I love all the formats that are happening. There&#8217;s so many learning opportunities and I really liked the new snippet approach. I saw that coming up and I think that&#8217;s a really neat way for folks to get bite-size&#8230; The tutorials are so cool. I followed some of them to learn. And the snippets I think really round it out. Kudos all around. I think it&#8217;s just awesome how much&#8230; I&#8217;ve never&#8230; In my opinion years ago, I think this is the dream. If we had to be able to see how much stuff was going on, it&#8217;s just amazing how many resources there are and ways to either watch live or watch later and learn with other people. It&#8217;s really cool.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. And we will also bring the developer hours recordings into the developer blog.</p>\n\n\n\n<p><em>Anne McCarthy:</em> Nice.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> That&#8217;s on my list for the last thing that I&#8217;m going to do this year is to create the custom post type and figure out how we lay it out and what additional information is going to be around the embedded videos. But yeah, it&#8217;s such a great tool. And we are all working towards the extenders who try to use the new APIs, be it interactivity API, the block bindings or even the block hooks that came out in 6.6 and 6.5. There&#8217;s always something&#8230; And especially also using block themes with the style variations. And so the developer blog is now a&#8230; It&#8217;s been around two years this month.</p>\n\n\n\n<p><em>Anne McCarthy:</em> Wow.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And we have about 50 posts. And this definitely enriches it because not everybody has time to read 3,000-word tutorials when they&#8217;re looking for something. Yeah. Yeah. And if you have any ideas, dear listeners, about what should be written about, you can always come in into the core-dev-blog channel in WP Slack and the Make Slack and figure out how that is. There&#8217;s on the website there&#8217;s also how to contribute, how you go from idea to post if you want to write for it. Yeah, definitely. You can also subscribe to it so you never miss a post again with <a href=\"http://developer.wordpress.org/news/subscribe\">developer.wordpress.org/news/subscribe</a> and put in your email address and you get notification.</p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s Released &#8211; WordPress 6.7 and 6.7.1<strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</strong></h3>\n\n\n\n<p>That brings us to what&#8217;s released. And we talked about WordPress 6.7. We have in the show notes for you the field guide 6.7 and also Anne McCarthy&#8217;s WordPress 6.7 Source of Truth published on the Gutenberg Times. But I mention it also because this week WordPress 6.7.1 was released and it fixed a few bugs that okay, those needed to be really done fast because there was a fatal error or the editor didn&#8217;t work right when you had uncategorized pattern browsing or there was a TypeScript error on the categories for theme patterns.&nbsp;</p>\n\n\n\n<p><em>Anne McCarthy</em>: Was an auto-size issue with lazy loading and that was a big one that we saw. I saw a lot of reports of across many different areas. And so that will be fixed and yeah, I&#8217;m excited. I&#8217;m really kudos to everyone who worked on that. It&#8217;s a huge&#8230; It&#8217;s one thing you race to the finish line to get the big major release out and then to do another point release. It&#8217;s just really impressive and a lot of effort from a lot of folks in the community.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. And that&#8217;s just nine days after the release of 6.7, so that&#8217;s really kudos to the release leads. There was Jonathan Desrosiers and Carlos Bravo who pushed this all over the finish line with the contributors that actually fixed the bugs. But now some of them is in the upcoming Gutenberg releases we&#8217;re going to talk about.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Gutenberg 19.6</h3>\n\n\n\n<p>Which brings us to Gutenberg 19.6. 194 PRs with 57 contributors, eight were first timers. Kudos to them getting their badges for core contributing there as well. It has 37 enhancement, 65 bug fixes was the one that was released right before release candidate to get all the bugs in. And the rest is always on documentation, tooling, code, quality and components. Let&#8217;s dive in. What&#8217;s first on the list?&nbsp;</p>\n\n\n\n<p>Oh, yeah, there are two things that I want to talk about for the developers. The great block scaffolding tool has a new flag. It&#8217;s called Dash dash target dir, to allow the tool to also target where the scaffold should be placed.</p>\n\n\n\n<p>There were some conventions that you had to call the command line outside the plugins in the plugins repo to get a next folder into the repo to where your blocks are created. And now you are in more control of where you can place the new block or a new series of blocks with a scaffolding tool. That was a major request from developers that that might be added.</p>\n\n\n\n<p>And the other one is with wp-scripts, you can now also do a root folder argument for the plugin zip command, so you get your plugins packaged. And that&#8217;s in the right folder or from the right folder. That&#8217;s better there. I want to point that out for the developers on the show using the tools that are built into Gutenberg. Do you want to take the Block Libraries B list?</p>\n\n\n\n<h3 class=\"wp-block-heading\">Enhancements</h3>\n\n\n\n<p><em>Anne McCarthy</em>: Yeah, let&#8217;s run through that. I love block library updates because it&#8217;s amazing how just slowly chipping away at stuff, whenever I&#8217;m doing a Source of Truth, I always find there&#8217;s a beautiful set of things that have just big and small tools like 6.7 had shadow support for the group block, which folks really wanted. And it&#8217;s just amazing how the improvements continue to come.</p>\n\n\n\n<p>We have a transformation from separator to spacer blocks. And that just allows whenever you&#8217;re using the transform menu to easily switch between things. I think that&#8217;s a great one. I think it makes a lot of sense. I actually am really&#8230; Whenever I was looking for the changelog for this, I was excited to see it. I ran into that maybe three weeks ago and so it&#8217;s like, &#8220;Oh, yeah, this is an obvious one to have.</p>\n\n\n\n<p>But adding the lightbox option in the gallery block link control. I actually used this. When did I write a blog post? Three days ago? Whenever you add a gallery block before you had to individually select each image block within it to add that lightbox and the lightbox is when the image takes over the screen. And now there&#8217;s just a control at the top level. When you&#8217;re selecting the gallery block, go into the block toolbar, hit the link, and you can easily just have it applied to all the images. Which yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Such a relief.</p>\n\n\n\n<p><em>Anne McCarthy</em>: Yes, it&#8217;s a relief that it&#8217;s perfect&#8230; Yeah, it&#8217;s like, &#8220;Oh, this makes perfect sense. Why didn&#8217;t we have this before? I love when that sort of stuff comes out.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Not everyone has just three pictures in the gallery. Some people have 20 pictures in the gallery. And then it&#8217;s really…</p>\n\n\n\n<p><em>Anne McCarthy:</em> And it&#8217;s funny. Yeah, I was like, &#8220;When did we add this?&#8221; Because I literally&#8230; Yeah, that&#8217;s something I cannot tell you how many times I have gone through and manually added that. Or I&#8217;ll miss one image by accident and not realize it. This just makes it so much easier for the archives. There is now border block support, which is great for block theme authors. Border support is also added to comments. Just again, more styling options.</p>\n\n\n\n<p>The cover block has image resolution options now, which is just again, more control to more having commonality between every image block. And this is something I think about a lot whenever you&#8217;re working with blocks that interact with media is like, how can we make it as similar as possible When you&#8217;re working with image things? Because that is an inconsistency that it wears on you when you&#8217;re using a block and it&#8217;s similar, you&#8217;re like, &#8220;I&#8217;m just using an image. Why is it different if I&#8217;m using the cover block or the image or the gallery block?&#8221; We should have a lot of congruence there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Totally.</p>\n\n\n\n<p><em>Anne McCarthy:</em> And so it&#8217;s neat to see that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, yeah. Love it.</p>\n\n\n\n<p><em>Anne McCarthy:</em> And then the HTML block forces the HTML preview when you&#8217;re in view mode, which I actually need to look at this and make sure I&#8217;m going to get this right.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> The view and design view, yeah, the edit view, that changes. I think there&#8217;s a writing, write mode coming that I have to dive into because the change was edit and view and now it&#8217;s write and design. And I need to figure out what the differences are.</p>\n\n\n\n<p><em>Anne McCarthy:</em> Oh yeah, if you ever offline, want to talk about that, I can do a deep dive about write mode. I&#8217;ve been up in there opening a lot of issues around that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Hallway hangout about it.&nbsp;</p>\n\n\n\n<p><em>Anne McCarthy:</em> Yes, I think that&#8217;d be really smart mode for any folks who have blocks bundled in their plugins, something to pay attention to. And there&#8217;s a great tutorial that I think Nick Diego just did around adopting your blocks to content only that you can find the developer blog. I&#8217;m pretty sure that&#8217;s live. I saw a draft and now I&#8217;m like, I&#8217;m pretty sure I saw it live.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: It&#8217;s live. It&#8217;s live on the developer blog.</p>\n\n\n\n<p><em>Anne McCarthy:</em> Okay. Cool.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Oh. And I&#8217;ll share the link then in the show notes. Yeah.</p>\n\n\n\n<p><em>Anne McCarthy:</em> Cool.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> The next one is that we have a&#8230; Oh, your favorite feature. The zoom out note now has a keyboard shortcut to open up the editor of being available in the editor. You can zoom out per keyboard and you don&#8217;t have to look for that little icon there. And there&#8217;s an iterated zoom out shuffle into a more visual control. What does that entail?</p>\n\n\n\n<p><em>Anne McCarthy:</em> It&#8217;s cool. I can talk about that a little bit.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, please.</p>\n\n\n\n<p><em>Anne McCarthy:</em> Before whenever you were zoomed out and looking at the patterns, there was this shuffle option. And while it was nice to just quickly switch through it, it shuffles through patterns of the same category. The issue is you&#8217;re not seeing visually what&#8217;s coming next and you can&#8217;t get at a glance, &#8220;I want to switch to this.&#8221; And so it changes it from this shuffle option to this change design option. You&#8217;re also a bit clearer on what it&#8217;s doing.</p>\n\n\n\n<p>And it gives you this nice little preview of, okay, change design, and then look at a list of the patterns related to this. And then you can visually select what you want to change it to rather than just a full blown shuffle, like what&#8217;s going to happen when I click this? It allows a bit more control and predictability to the experience. I was really excited to see this.</p>\n\n\n\n<p>I have noticed I need to test this more as part of the fun of things when I was working on a site yesterday, that there&#8217;s a little bit of lag. Definitely keep&#8230; This is one of those areas that when we talk about zoom out is a great initial feature. I&#8217;m really excited to keep iterating to make it more useful. No, feedback is very much welcome there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> The data views is the way how you in the site editor, you can navigate all through all the templates and all the pages and patterns. And it&#8217;s also the predecessor for the new admin design. But that has now in the templates, it hides the media field in the list view, which makes it a little bit more dense and more streamlined. Yeah. The next one is, I really love that, the style book now has a color tab where you can see all the color variations. This additional stuff, we&#8217;re going to talk about it in 19.7. But the style book is coming really to its better use now that we have all the different features like the style variations, block variations and that. Do you want to do the next one?</p>\n\n\n\n<p><em>Anne McCarthy:</em> Yeah. Real time collaboration, this is relating to inline commenting specifically. There was a lot of work being done around inline commenting that I think we&#8217;ll get into later. But basically comments were disabled for published posts for now. You can imagine this is basically to narrow the scope.</p>\n\n\n\n<p>While we&#8217;re trying to get this feature in place to have it be ready for future release and maybe a bit beta form, there&#8217;s some just hard decisions that be made to narrow the scope so we&#8217;re not just completely exploding the scope and then something doesn&#8217;t work super well. The decision was made for post after they&#8217;ve been published to not have the ability to add comments.</p>\n\n\n\n<p>And we actually got great feedback from some folks in the enterprise space who there&#8217;s a channel for real time collaboration. I posted it about online commenting. And some of the enterprise folks are hanging out there and it was great. One of them actually chimed in on the main iteration issue for what&#8217;s coming next with online commenting and mentioned, &#8220;Hey, that thing you just disabled, we actually want that.&#8221; I think that&#8217;s part of the beauty of keeping folks up to date and having that tight feedback loop.</p>\n\n\n\n<p>The second that was disabled, someone was like, &#8220;Can you revert that? I actually want that.&#8221; And it&#8217;s like, &#8220;Yes, yes, yes. Eventually we will revert. This is just for now narrowing scope.&#8221; That&#8217;s what you can get from that release. But that&#8217;s part of the beauty. I wanted to mention the feedback there because I think it&#8217;s really cool that folks are paying such close attention.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah.</p>\n\n\n\n<p><em>Anne McCarthy:</em> Behind the scenes stuff.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> I think I was one of the people who said, &#8220;I want this back.&#8221;</p>\n\n\n\n<p><em>Anne McCarthy:</em> Yes. Yeah, yeah, you comment on it too. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. But the inline commenting when you get&#8230; It&#8217;s an experiment still in Gutenberg, so you need to enable it so you can see it. But then it&#8217;s really good to have the&#8230; Because you can comment on each block and you can have replies. And it&#8217;s a great way to collaborate on things and have one editor there and have everybody else comment on a picture or on a block or on a quote or on a design. If you use the design tools and to just have it right there.</p>\n\n\n\n<p>And when you open up a post, you see the comments there, you can open it up, you can even pin it to your sidebar. It&#8217;s a great feature to test out and comment on. And when you have a few minutes in the afternoon or something like that, I really enjoyed it. And to see what&#8217;s coming next in the experiments, there are a lot of experiments in Gutenberg.</p>\n\n\n\n<p><em>Anne McCarthy:</em> Yeah. I know we need to groom that list. I&#8217;m trying to wait for the right time to do a make test post asking for feedback. If you want to wait for more curated specific, &#8220;I can look at this post and follow these instructions and click on this link and I&#8217;ll open a WordPress Playground,&#8221; you can wait for that too. Because that is something&#8230; I just am trying to wait for us to fix some of the obvious stuff before asking people for their time. That&#8217;s something I&#8217;m always mindful of is the right time to bring folks in where it&#8217;s the most impactful for bringing feedback.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> I have to tell you, I love your test instructions. Every time something comes out, it&#8217;s such a great way to explore a new feature guided. But then all of a sudden, now that you know how it works, you can create an opinion and I always have an opinion. I travel with it, but then you also can pinpoint it to a certain instruction as well. It&#8217;s a guided testing instruction. And also exploring new features. You do fantastic work with that and I&#8217;m looking forward to some of the new ones that come out.</p>\n\n\n\n<p><em>Anne McCarthy:</em> Thank you. Yeah, that&#8217;s helpful to hear. Because I want it to be that. I want it to be both exploration and feedback. We need to be veering people into what&#8217;s coming next so they can have that opinion that you just described. Yeah, that&#8217;s really cool to hear.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. The next one was on a backport that actually made it into 6.7. It was an improvement to get the post format in the query loop. And that is something that if your theme supports post formats, there is a way to do archive pages and all that. It&#8217;s not 100% seamless. There is some thinking through it from the developer part when you build a theme, but having that is definitely helpful so you don&#8217;t have to write the query yourself. There is a&#8230; I am a little bit&#8230; I don&#8217;t remember.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">New APIs</h3>\n\n\n\n<p><em>Anne McCarthy:</em> I know this preview, I was like, &#8220;I can talk about this a little bit.&#8221; But yeah, basically, there&#8217;s, yeah, a new API is preview mode flag. And this is something that it looks like it&#8217;s been three years looking at the PR since this flag was there to basically allow, to indicate if a block is rendered as part of a blocks list, a block preview, a pattern preview, et cetera. And it&#8217;s a way, at this point we need to make it stable. And this came in again from feedback. What I really like to call out whenever this is influenced by feedback.</p>\n\n\n\n<p>And this came up with in Jetpack where Riad was helping someone on the Jetpack team when they were asking questions. And he was like, &#8220;We should probably stabilize this. It&#8217;s been three years now. This isn&#8217;t actually unstable, but if we can render a placeholder for this, let&#8217;s do it.&#8221; And so this is really helpful and it&#8217;s just another signal. We do want to be careful about what we list is stabilized. And so this is one of those examples where it&#8217;s good to have just another tool in the toolbox to stabilize it for plugin authors.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Absolutely, because a lot of plugin authors are a little hesitant to use marked unstable or marked experimental flags features. And so adoption is really slow, although the things have been used in core or with other plugins quite a bit already and are stable, but they haven&#8217;t been made stable. And I know for the next release of 6.8, there&#8217;s a huge push on that for some of the design tools like the fonts and border controls and all that to make that what&#8217;s experimental to be stable and move that forward. It&#8217;s really cool.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Bug Fixes<strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</strong></h3>\n\n\n\n<p>I think we are through the enhancement on 19.6, but there are a few bug fixes I wanted to point out. The first one is the self-nesting and circular nesting block fix. Up until that fix, it was really possible to have a block that has inner blocks to make it an inner block of itself. It&#8217;s like an Inception, if you ever saw that movie. It really confused the block and what to do with it. And you could also nest blocks that are the same nesting in multiple times. It&#8217;s like the infinite mirror when you go in zoom and you share a screen and everybody can&#8230; You see yourself multiple times, but that is definitely fixed. Or well, if it&#8217;s not, please let us know.</p>\n\n\n\n<p>And the other part that I wanted to shout out is that there is the link shortcut only to be triggered when there is a text selection. And that has to do with the two features that are triggered by the same shortcut. And depending on which context you are, it gives you the right tool. Control K opens up the command palette where you can then just look for a new open site editor or create a new page. You can do this in the command palette, but it also lets you add a link to the canvas if you&#8217;re in there.</p>\n\n\n\n<p>And if you are having a text selected, you could trigger that, creating a link with control K, but you wouldn&#8217;t be able to trigger the command palette. And if nothing is selected, that&#8217;s what you probably wanted. There were a few people, there&#8217;s a whole discussion about it in that PR about maybe changing the shortcut, but it&#8217;s the internet and the software developers have used the same shortcut for multiple things.</p>\n\n\n\n<p>It&#8217;s, yeah, exercise. People know about it, and here it comes together quite interestingly enough. But, well, I don&#8217;t know about you, but if I have a text selected, I don&#8217;t use Control K. And I just do copy-paste and have the link underneath my text selection. It doesn&#8217;t bother me, but it would&#8217;ve bothered me if Control K gives me the control panel, it doesn&#8217;t give me the command palette and rather opens the link feature there. I think it was a good decision. Riad made the pragmatic decision.</p>\n\n\n\n<p><em>Anne McCarthy:</em> I think it was a really good call because this is definitely, I have found it to be incredibly frustrating with the command pilot. And I think it has impacted the experience of using that and the likelihood of people using it in a way that it&#8217;s just not predictable. I think this will&#8230; I really hope it&#8217;s a meaningful improvement and it seems like it is based on&#8230; I actually helped test this at one point and just forgot to leave feedback. But yeah, I&#8217;m excited to see this in place and hope it helps.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, it definitely does.</p>\n\n\n\n<p><em>Anne McCarthy:</em> It&#8217;s a great call out. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. I wanted to let everybody know that command palette, control K is a shortcut to get to you fast. And I think that&#8217;s it. Yeah, that&#8217;s pretty much what I wanted to talk about in Gutenberg 19.6. And we go right into 19.7.</p>\n\n\n\n<p><em>Anne McCarthy</em>: Let&#8217;s do it.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Gutenberg 19.7</h3>\n\n\n\n<p>Birgit Pauli-Haack: Let&#8217;s do it. It&#8217;s 148 PR. Is not as much as 19.6, but that was with 46 contributors and six of them were first timers. The release had 26 enhancements and 49 bug fixes. Bug fixes are a big, big piece of every release. And of course, I have in the show notes both the release posts and we can go into the enhancement. Do you want to start us out?</p>\n\n\n\n<h3 class=\"wp-block-heading\">Enhancements</h3>\n\n\n\n<p><em>Anne McCarthy:</em> Yeah, I would love to. Now in the preview dropdown, the device preview dropdown, there is an option to show template. And before this was available in the setting sidebar, but it wasn&#8217;t super discoverable. And so this is just adding it there as well. Whenever you want to actually see a template preview, this option is now there whenever you&#8217;re trying to review your content.</p>\n\n\n\n<p>And I think this is one of those things that again, I am very curious to see how the feedback lands and how folks feel about it. If it ends up making sense to folks. We&#8217;ve added various things into that device preview dropdown. Including zoom out originally was thought of as being in the device preview and that was eventually moved. And I think this makes more sense conceptually. I was against zoom out being there, but I think having a template preview is a neat way to have a what you see is what you get. You may not need to go see the post in a new tab if you can just toggle this on and off to show or hide template.</p>\n\n\n\n<p>And I don&#8217;t know, for me personally, whenever I&#8217;m writing or creating stuff, I often start with having the template gone. I don&#8217;t want to see it. It&#8217;s a distraction. And then whenever I&#8217;m ready to see, &#8220;Okay, how does this actually look in context?&#8221; You can toggle that on for show template. And I think it&#8217;s a great small enhancement that can help with usability and curious to see how people like it and use it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Absolutely. Yeah, and I&#8217;m really curious what people are going to do with the&#8230; Because the preview dropdown has been opened. There&#8217;s an API now for plugin developers to put it in. And I saw people put in view this in your newsletter because they use the block editor for the newsletter. And I also have seen it in I think blog visibility, what&#8217;s it on the front end when you have&#8230; The plugin block visibility by Nick Diego has an option to see it what is it that I showed. Where you can show and hide things. And he was able to manage the canvas to actually show and hide things quite easily. Yeah. It was really interesting what plugin developers are going to do.</p>\n\n\n\n<p><em>Anne McCarthy: </em>Yeah, I agree. I think it&#8217;s the preview options API, I just was looking it up to make sure I had the name and was available in 6.7. I think it&#8217;s a pretty cool&#8230; The accessibility there feels pretty powerful.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Absolutely. Yeah. And this is, the next thing is more like a PSA so to speak, that the view external link that is in the toolbar on top is actually now at the end of the editor header controls. It got moved, so don&#8217;t be confused. It&#8217;s now on its final place for now until we move it again. But yeah, I think the zoom out button or link made us think a little bit more about what is the order of those things. And it would really help to get some feedback on it. What do you think about it? Yeah, just don&#8217;t miss it. It&#8217;s there. You just need to look a little left on it. And the next one is, can you talk about that?</p>\n\n\n\n<p><em>Anne McCarthy:</em> Oh, yeah, I would love to. There&#8217;s situations where there&#8217;s a post, you&#8217;re writing a post, you have a number of images in the post. And let&#8217;s say you want a quicker way to just set a featured image. There&#8217;s now an option where if no featured image is set, you can set any image to be the featured image.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> That&#8217;s cool.</p>\n\n\n\n<p><em>Anne McCarthy: </em>Yeah, it&#8217;s really cool and it comes from this desire to make it easier for folks whenever they&#8217;re in the flow of writing things. And as we know, images are really powerful. If you switch themes and you don&#8217;t have a bunch of featured images set, it can be a pain. There&#8217;s a lot of broader thinking around this. This is just an initial iteration to make it really easy to make sure to just set an image as a featured image.</p>\n\n\n\n<p>And so, I definitely plan on using this. Because I always am reusing&#8230; I&#8217;ll post a blog post, I have a gallery of images, I love taking photos. And then I have to go again and select the featured image and go through the media library and all sorts of stuff. And now instead I can just be like that one, I want that one as a featured image. Through that, set as featured image. And so it just uses the same set as featured image property as it&#8217;s used elsewhere in the system. It&#8217;s also really cool use case with that. I&#8217;m excited to see it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>I have two questions about it. One is if I set it as a featured image, then I can take it out of the post because it&#8217;s a different storage? Yes. Okay.</p>\n\n\n\n<p><em>Anne McCarthy:</em> I think so. Yeah. I think it&#8217;s basically it&#8217;s an attribute that&#8217;s set. And so, if it doesn&#8217;t have a featured image, it&#8217;ll be set as a featured image of the post. And you can also, if you override that and set the featured image, I&#8217;m pretty sure then that will be the priority is whatever is set as a featured image in that flow.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Most of the time or sometimes the theme supports featured image in a blog post. Then if you take an image that&#8217;s in the canvas as a featured image and it still stays in the post, then all of a sudden you have a double in there. It depends on how the theme works or how you set up your templates for the single post. If that&#8217;s a trained method now for you, yeah, you probably want to switch off the display of the featured image on the single post.</p>\n\n\n\n<p><em>Anne McCarthy: </em>Yeah. Because that is such a&#8230; I right now have a theme that has&#8230; It does duplicate and I just decide to accept it. And I often, because block themes are so powerful, I&#8217;ll just go on a site editor and make sure that it looks good or looks separate and doesn&#8217;t feel too, I don&#8217;t know, annoying, where it&#8217;s like the images are just right after each other. And that&#8217;s one of the cool things with block themes is you can always just edit it or straight up remove it from your template if you want.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, it&#8217;s fascinating what you can do, what you couldn&#8217;t do before. Yeah, yeah. The next two are other ones of getting more support for blocks. That&#8217;s the post content. Block now has border support and spacing support. And the details block also got anchor support. You could have the header of the details block be an anchor so you can link to it, which is very powerful.&nbsp;</p>\n\n\n\n<p><em>Anne McCarthy:</em> Oh, this is a big one.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Anne McCarthy</em>: Yeah. Can I talk about it? I&#8217;m obsessed with.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>Yeah, talk about it.</p>\n\n\n\n<p><em>Anne McCarthy:</em> Okay. I&#8217;m going to tell the story of the background of this. When the site editor first was launched and people would drop into the editor, the site editor and start building, they would stumble on this style section. And a lot of folks thought that they were just styling their template. Whatever they were looking at, it was like, &#8220;Oh, cool, I&#8217;m styling just what I&#8217;m seeing.&#8221; And it&#8217;s actually styling everything.</p>\n\n\n\n<p>The style section when you&#8217;re in the editor is styling everything, whether you can see it or not. And so this was almost like an information architecture problem, a UX problem. And to help start to alleviate this and to communicate the global nature, the same styles experience you get when you&#8217;re in the editor is being moved to the top level in that dark sidebar. Designers call that the frame. The frame of the experience or that dark sidebar before you get into the canvas and the editor.</p>\n\n\n\n<p>It&#8217;s being moved to the top level. Whenever you first enter the site editor, you&#8217;ll see those same sections that you&#8217;re used to seeing. And when you hit styles, it&#8217;ll actually bring you in using data views. This great view of all your styles experience that you would expect whenever you&#8217;re actually in the editing experience. And the hope is that this will allow folks to understand that it&#8217;s like you&#8217;re editing everything. And in line with the other changes were done to allow you to toggle between the style book and previewing your site. And so, I think it&#8217;s a really exciting way to see when you first are landing there. I&#8217;m pretty sure it&#8217;s in 19.7. There&#8217;s basically a new landing section that&#8217;s added to the style book. I&#8217;m 99% sure I&#8217;ve tested this a ton.</p>\n\n\n\n<p>And there&#8217;s also in line with this, there&#8217;s some upgrades to the style book. The style book is a bit better laid out. And then there&#8217;s also this landing section that basically pulls the most important information from your theme related to styles so that when you get there you get this sense of like, &#8220;Okay, this is the styling of my site, these are the colors, this is the typography.&#8221; And it just is meant to be a clear, easier to understand experience that you&#8217;re impacting the entire site.</p>\n\n\n\n<p>And with that said, you will still have access to styles when you&#8217;re in the editor, so it duplicates it. And I am really curious to get feedback from folks because I think this is going to be confusing. I think folks are going to see the same thing and think, &#8220;What&#8217;s the difference? Is this the same? I&#8217;m not really sure. Is this for the entire site and this is for the template.&#8221; And so that&#8217;s one of the things that&#8217;s part of the beauty of iterating in Gutenberg before a major release is to get that feedback.</p>\n\n\n\n<p>And part of the reason to keep it in the editor is for block themers who will want to be making changes while they&#8217;re editing templates and not just necessarily at the high level. There were a couple of different use cases to have to accommodate there. And part of the issue that we can figure out is what does the user experience look like between the two? How do we connect the two experiences?</p>\n\n\n\n<p>Maybe when you open styles in the editor, it automatically brings you to that view. I&#8217;m not really sure, but there&#8217;s ways that design thinking can be applied to this. I&#8217;m really excited about this. This helps to solve, it starts to solve a long-standing issue around communicating styles as global styles, styles as impacting your entire site. And it just brings that sidebar at the top level to be a bit more useful. And so I&#8217;m obviously way too excited about this.</p>\n\n\n\n<p><em>Birgit Pauli-Haack: </em>No, no, no, no. I&#8217;m really glad that you explained it. Also, the whole genesis of it because I remember those feedback from the FSC program here that people are&#8230; And I always attributed to that there&#8217;s another level of abstraction and another level of design coming with the templates where users never had access to it so they didn&#8217;t have to learn that new concept. That stumbles them, but there is a way to actually alleviate that from the user experience. That&#8217;s brilliant. And I&#8217;m really happy that it also ties the style book of it.</p>\n\n\n\n<p>What I saw was if you go through the styles in the middle section and you change the color palette in the style book, then in the right hand side, you can then see how that affects every single block or every single&#8230; Yeah. You can actually really make decisions about if you wanted that or do you need to do some additional adjustments there. The style book gives you a whole good overview. And it was always a little bit off site if you&#8230; It was hard to discover and now it&#8217;s right there for you to see. Yeah, so I&#8217;m really happy about that.</p>\n\n\n\n<p><em>Anne McCarthy:</em> I&#8217;ll share a little sneak peek. I was talking with some of the developers yesterday about this. But some of the work also to bring this to the top level, have it be like that is to then expose it for classic themes. Can you imagine a style book for classic themes and this landing section for classic themes?</p>\n\n\n\n<p>The benefit, and this again goes back to phase two and gradual adoption and how important it is that we have these on ramps and ways of bringing some of these new features to everyone who&#8217;s using WordPress. And so that&#8217;s a PR in progress expected on a future Gutenberg Times episode. And all block themers out there and all themers in general out there, this is a great area to give feedback and to see how it works with your theme.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Yeah, the style book. When I was implementing some Gutenberg sites in the early days, 2018, I would create a post with all the blocks in there so we could, together with a client, look at how everything&#8217;s going to look from the theme point of view and where adjustments need to be made. But that was a major effort to put all the blocks in there. The style book is such a great tool. And bringing that to the classic theme is definitely a great way to foster adoption. Also to make the life of a classic theme developer a little bit easier doing that.</p>\n\n\n\n<p><em>Anne McCarthy:</em> Yeah. We got a lot of good feedback from folks being like, &#8220;I want this. Why can&#8217;t I use this yet? How can I use this?&#8221;</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> It&#8217;s the best thing that comes with Gutenberg and, &#8220;I need it.&#8221; I can totally.</p>\n\n\n\n<p><em>Anne McCarthy:</em> And I love that feedback loop. And then one of the things, the next thing to think about is what does that look like to expose it in the appearance menu? We have patterns, do we have a style? And then what about the font library? Where&#8217;s the order of things? These are things that are on my mind. It&#8217;s like, &#8220;Okay, do we have them all separate? When do we bring them together? What does that experience look like for exposing these things?&#8221;</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, the holistic approach to design is so important. Yeah. But that&#8217;s the whole story about Gutenberg. You need to first do the small things so you can do it in context with the big things. And it&#8217;s really a little slow to go from the small things to the big things when you do something new. The iteration and the feedback loop is really, really important.</p>\n\n\n\n<p>Yeah. Here&#8217;s your landing section for the style book is the next one. Next item on the style book tab. Then the next one is something that surprised me a bit, that we have now an exposed filter in the drop down for the individual image on select or upload media that says, &#8220;Okay, filter the medium about uploaded in this post or unattached pictures or to show me just my pictures.&#8221; Yeah. It&#8217;s filtering down to something that we were never exposed to before and it&#8217;s really an enhancement of the media library for this Gutenberg section. Yeah.</p>\n\n\n\n<p><em>Anne McCarthy:</em> Yeah. And I&#8217;ll note that this actually really nicely ties into phase three. I know it doesn&#8217;t seem like it at first, but one of the things that whenever I talk to enterprise folks, imagine you are writing 50 articles a day. And you have photographers, you have media teams, you have all this sort of stuff. And you&#8217;re trying to add content, you&#8217;re trying to add media to a post.</p>\n\n\n\n<p>One of the biggest things is, is this file in the doc already and is it attached to this post in any way? They need quick ways to identify very fast, is this already in here? If not, can I add it in? And because it helps prevent people from uploading the same image five times. This is something that starts down that path of thinking about media library improvements, the workflow related to it. And whenever you&#8217;re creating content in mass with lots of different people, how can you make it clearer and easier to quickly filter?</p>\n\n\n\n<p>I&#8217;m so glad you called this out. I actually totally missed this. It seems like a smaller thing, but it actually directly ties into feedback that&#8217;s come into the project. I think it&#8217;s a cool quality of life improvement.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah, I can see that. Then especially the net has become so much more visible, visual that you need the pictures or the videos or the audio a little bit more sorted so that&#8217;s wonderful. Yeah, so I think we&#8217;re through the enhancements and I haven&#8217;t seen…</p>\n\n\n\n<p><em>Anne McCarthy:</em> Oh, I can point out one thing that I think could be good.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yes, please.</p>\n\n\n\n<p><em>Anne McCarthy:</em> We were talking about this write mode, and this relates to this. This is like a bug fix. Write mode is exposed currently. And the plugin, it&#8217;s actually as of&#8230; I just checked the issue today that I opened. Between user testing and feedback, it&#8217;s pretty clear that it needs to be behind an experiment.</p>\n\n\n\n<p>It&#8217;s actually going to be moved behind an experiment, but that will happen in 19.8. I&#8217;m pretty sure not 19.7. But in the meantime, to help reduce some of the confusion that we saw some folks running into, it basically makes it so that the tool selector between write and design is not exposed in the post editor. You&#8217;re only in design mode. And design mode, it shows all the tools. You can see everything, which is what you&#8217;re used to. Write mode offers that content only experience. It really just focuses on the content. It really&#8230; There&#8217;s a lot to figure out there, but I think of it as it contains the experience just to the purity of writing. It just is focused on the words. You can&#8217;t add a block, you can&#8217;t remove a block. It&#8217;s a very simplified editing experience.</p>\n\n\n\n<p>And so, this basically has it so it&#8217;s only available in this write mode whenever you&#8217;re in the site editor. Which makes sense where you get that overwhelm and that&#8217;s where someone might just want to focus on the content of their template. But in the post editor, it doesn&#8217;t make as much sense. If you&#8217;re writing content, you don&#8217;t necessarily need to have these two different options. For 19.7, this is with landing. And then in the future, this will be put behind an experiment.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Okay. Yeah, I think we should do a separate podcast episode about all the 15 experiments in Gutenberg.</p>\n\n\n\n<p><em>Anne McCarthy:</em> Yes, that would actually be a really cool episode. I would love that. I would be game for that. For sure.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> We definitely would need to do this on video because we&#8217;re going to demo things and all that. Yeah. Yeah. I will keep it in the back of my mind for next year.</p>\n\n\n\n<p><em>Anne McCarthy:</em> Do it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> And we can do that. Yeah. Because we have until April until the new version comes out so there&#8217;s a lot of experiments that come up. yeah. The listeners, this was 16. 16. Yeah. 6.7 or 19.7. It&#8217;s 16.7. Yeah. Right?</p>\n\n\n\n<p><em>Anne McCarthy:</em> Yes. When you said it, it made perfect sense to me. I&#8217;m not going to lie. I was like, &#8220;Yep, that&#8217;s right. That&#8217;s true.&#8221;</p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s in Active Development or Discussed</h3>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: This was Gutenberg 19.7. And so we are at the section of what&#8217;s in active development or discussed. And we mentioned it before, there is these inline commenting that actually was almost entirely done by a group of contributors from a sponsored company called Multidots. And Pooja Bhimani, I hope I pronounced that right, is the lead on that. And they released the first and experimental version of inline commenting for the block editor. I think you were involved in that a little bit more heavily. Do you want to talk about this a bit more?</p>\n\n\n\n<p><em>Anne McCarthy: </em>Yeah, I would love to talk about it. I think it&#8217;s a great example of a wonderful contribution story for a really big feature. And the team over at Multidots reached out and they built a number of collaboration tools within their plugin and naturally wanted to help Core. And so this was where they decided to jump in. And right now they have shipped an initial version of 19.5, I think is what it got into, for inline comments.</p>\n\n\n\n<p>And what it does is block level inline comments. You can comment on an entire block and you cannot comment on a sentence within that block. It&#8217;s an initial prototype to get some of the kinks out. And Ella, one of them, EllaTrips I think is her GitHub username.&nbsp;</p>\n\n\n\n<p>Yeah, long, long, long time WordPress contributor and Core contributor has been really helping there as well as Riad and Joen and design. There&#8217;s just been a lot of beautiful coming together to move this feature forward. And it&#8217;s basically in a state where they&#8217;re both starting to chip away at some of the minor bugs, like, &#8220;Okay, these are obvious things to fix.&#8221; And then they&#8217;re going to work on implementing a new design.</p>\n\n\n\n<p>And so there&#8217;s some really cool designs on there, both for the short term and thinking really long term. I actually have a post I&#8217;m hoping to share today, sharing an update about all these different phase three areas. And this is just one of those big areas to keep in mind and to follow. There&#8217;s a lot of momentum and there&#8217;s a lot of work being done there. And Multidots has done a great job.</p>\n\n\n\n<p>This is a huge thing to jump into as a first contribution. And so huge kudos to them. This is not an easy task. I think they&#8217;ve been working on this since April of this last year. It&#8217;s been a huge effort to come together. And it&#8217;s been really fun to work with them and to watch them develop directly in the Gutenberg plugin and land something and iterate.</p>\n\n\n\n<p>And that&#8217;s part of the cool thing with the Gutenberg plugin and with the&#8230; It&#8217;s an experiment right now, so you have to turn it on under Gutenberg experiments. But expect to see more to come there and test, a call for testing from yours truly eventually. I&#8217;m hoping next week. That&#8217;s one of my top priorities for next week and this week is to get that announced update post out about the different areas of phase three.</p>\n\n\n\n<p>But yeah, I&#8217;m really excited about it. I think it&#8217;s a cool thing if you&#8217;re a small editorial team to try it out. If you&#8217;re a plugin author, think about how you might want to extend it. All that workflow collaboration head space, this is one of the first meteor things, or probably the second meteor thing that&#8217;s land other than data use, which is a huge thing. I just completely&#8230; Data views is the first, this is the second. And so, I&#8217;m really excited to see some of these phase three features that are really tangible begin to get out into the open.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. Well, I&#8217;m glad you bring this all to us. And I think we are all&#8230; Yeah, test it all out. Did you say you want to post it today or tomorrow?</p>\n\n\n\n<p><em>Anne McCarthy:</em> The update for phase three will be today. I want it out today.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> I will bring it into the show notes.</p>\n\n\n\n<p><em>Anne McCarthy: </em>Perfect.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> &#8230; because we are not going to publish that until Sunday. Today is Thursday, so it&#8217;s really good. I&#8217;m going to share it in the show notes. I think that&#8217;s an update on the real collaboration on commenting and interviews. I&#8217;m very much looking forward to reading that as a whole.&nbsp;</p>\n\n\n\n<p>All right. This is, we are at the end of the show today, although with two plugins and Anne here, we have a great show. And next show would be in two weeks with Sarah Norris and it will be the last of 2024. And then I&#8217;ll go on vacation. Yes.</p>\n\n\n\n<p><em>Anne McCarthy:</em> Good. Good. Love to hear it. You got to rest. Congrats on over 100. I cannot believe you have over a hundred episodes of this. That&#8217;s really incredible. I keep thinking about that at the beginning of the show. I think that&#8217;s so cool.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Well, thank you. Yeah. I couldn&#8217;t have done it without you and all the other guests that are here that bring their brilliance to here. Because I only see one side of things and having other aspects of it makes it so much richer. Dear listeners, as always, the show notes will be published on <a href=\"http://gutenbergtimes.com/podcast\">gutenbergtimes.com/podcast</a>. This is episode 111.</p>\n\n\n\n<p>And if you have questions or suggestions or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. That&#8217;s <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. And I want to thank you, Anne, for taking the time tonight to be with me and walk me through things and share your insights with everybody. Thank you all for listening. Goodbye.</p>\n\n\n\n<p><em>Anne McCarthy: </em>Goodbye. Thank you for having me.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 24 Nov 2024 09:52:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 11 Dec 2024 21:55:42 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:13:\"last-modified\";s:29:\"Wed, 11 Dec 2024 21:30:29 GMT\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";i:1731463280;s:21:\"cache_expiration_time\";i:1733997342;s:23:\"__cache_expiration_time\";i:1733997342;}", "off");
INSERT INTO `wp_options` VALUES("40856", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1733997343", "off");
INSERT INTO `wp_options` VALUES("40857", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1733954143", "off");
INSERT INTO `wp_options` VALUES("40858", "_transient_timeout_dash_v2_01e18dead815ce736e3b9cccfbd773a5", "1733997343", "off");
INSERT INTO `wp_options` VALUES("40859", "_transient_dash_v2_01e18dead815ce736e3b9cccfbd773a5", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://br.wordpress.org/2024/11/21/wordpress-6-7-1-atualizacao-de-manutencao/\'>WordPress 6.7.1 – Atualização de manutenção</a></li><li><a class=\'rsswidget\' href=\'https://br.wordpress.org/2024/11/12/wordpress-6-7-rollins/\'>WordPress 6.7 “Rollins”</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/court-grants-wp-engine-preliminary-injunction-against-automattic\'>WPTavern: Court Grants WP Engine Preliminary Injunction Against Automattic</a></li><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2024/12/openverse-org-a-sight-for-sore-eyes/\'>WordPress.org blog: Openverse.org: A Sight for Sore Eyes</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/podcast/149-corey-maass-on-optimising-wordpress-images\'>WPTavern: #149 – Corey Maass on Optimising WordPress Images</a></li></ul></div>", "off");
INSERT INTO `wp_options` VALUES("40860", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("40875", "duplicate_page_options", "a:4:{s:21:\"duplicate_post_status\";s:5:\"draft\";s:23:\"duplicate_post_redirect\";s:7:\"to_list\";s:21:\"duplicate_post_suffix\";s:0:\"\";s:21:\"duplicate_post_editor\";s:7:\"classic\";}", "auto");
INSERT INTO `wp_options` VALUES("40948", "_transient_timeout_acf_plugin_info_pro", "1734103010", "off");
INSERT INTO `wp_options` VALUES("40949", "_transient_acf_plugin_info_pro", "a:19:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:7:\"version\";s:6:\"6.3.11\";s:8:\"homepage\";s:36:\"https://www.advancedcustomfields.com\";s:6:\"author\";s:155:\"<a href=\"https://wpengine.com/?utm_source=wordpress.org&utm_medium=referral&utm_campaign=plugin_directory&utm_content=advanced_custom_fields\">WP Engine</a>\";s:12:\"contributors\";a:9:{s:15:\"deliciousbrains\";a:3:{s:7:\"profile\";s:47:\"https://profiles.wordpress.org/deliciousbrains/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/c55b6dfd266f44f127170d402922e485?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"Delicious Brains\";}s:8:\"wpengine\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/wpengine/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/6d44461b684d2f3d8f6fcf3d657cb889?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:9:\"WP Engine\";}s:12:\"elliotcondon\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/elliotcondon/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/533079e82e526367047100d8019cb9a7?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Elliot Condon\";}s:8:\"mattshaw\";a:3:{s:7:\"profile\";s:40:\"https://profiles.wordpress.org/mattshaw/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/c0ec3df5b2d5cf25ca1ab1fc3fdbe270?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:9:\"Matt Shaw\";}s:7:\"lgladdy\";a:3:{s:7:\"profile\";s:39:\"https://profiles.wordpress.org/lgladdy/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/1c126b5df1afc631b50bae0dda8094d7?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:11:\"Liam Gladdy\";}s:5:\"antpb\";a:3:{s:7:\"profile\";s:37:\"https://profiles.wordpress.org/antpb/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/9fe91e0d637984c9d4bb6d2f27cd7eb4?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:16:\"Anthony Burchell\";}s:14:\"johnstonphilip\";a:3:{s:7:\"profile\";s:46:\"https://profiles.wordpress.org/johnstonphilip/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/459d1a78b2c7c46729a175c372a9be4f?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Phil Johnston\";}s:12:\"dalewilliams\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/dalewilliams/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/c0528da391a7f8b5a403404224347421?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:13:\"Dale Williams\";}s:12:\"polevaultweb\";a:3:{s:7:\"profile\";s:44:\"https://profiles.wordpress.org/polevaultweb/\";s:6:\"avatar\";s:88:\"https://secure.gravatar.com/avatar/920dd5ed3b01d7185cc421e15e75ef07?s=96&d=monsterid&r=g\";s:12:\"display_name\";s:12:\"Iain Poulson\";}}s:8:\"requires\";s:3:\"6.0\";s:12:\"requires_php\";s:3:\"7.4\";s:6:\"tested\";s:5:\"6.7.1\";s:5:\"added\";s:10:\"2024-11-12\";s:12:\"last_updated\";s:10:\"2024-11-12\";s:11:\"description\";s:5268:\"<p>Advanced Custom Fields (ACF) turns WordPress sites into a fully-fledged content management system by giving you all the tools to do more with your data.</p>\n\n<p>Use the ACF plugin to take full control of your WordPress edit screens, custom field data, and more.</p>\n\n<p>https://www.youtube.com/watch?v=9C6_roqghZQ&rel=0</p>\n\n<p><strong>Add fields on demand.</strong></p>\n<p>The ACF field builder allows you to quickly and easily add fields to WP edit screens with only the click of a few buttons! Whether it\'s something simple like adding an “author” field to a book review post, or something more complex like the structured data needs of an ecommerce site or marketplace, ACF makes adding fields to your content model easy.</p>\n\n<p><strong>Add them anywhere.</strong></p>\n<p>Fields can be added all over WordPress including posts, pages, users, taxonomy terms, media, comments and even custom options pages! It couldn\'t be simpler to bring structure to the WordPress content creation experience.</p>\n\n<p><strong>Show them everywhere.</strong></p>\n<p>Load and display your custom field values in any theme template file with our hassle-free, developer friendly functions! Whether you need to display a single value or generate content based on a more complex query, the out-of-the-box functions of ACF make templating a dream for developers of all levels of experience.</p>\n\n<p><strong>Any Content, Fast.</strong></p>\n<p>Turning WordPress into a true content management system is not just about custom fields. Creating new custom post types and taxonomies is an essential part of building custom WordPress sites. Registering post types and taxonomies is now possible right in the ACF UI, speeding up the content modeling workflow without the need to touch code or use another plugin.</p>\n\n<p><strong>Simply beautiful and intentionally accessible.</strong></p>\n<p>For content creators and those tasked with data entry, the field user experience is as intuitive as they could desire while fitting neatly into the native WordPress experience. Accessibility standards are regularly reviewed and applied, ensuring ACF is able to empower as close to anyone as possible.</p>\n\n<p><strong>Documentation and developer guides.</strong></p>\n<p>Over 10 plus years of vibrant community contribution alongside an ongoing commitment to clear documentation means that you\'ll be able to find the guidance you need to build what you want.</p>\n\n<h4>Features</h4>\n<ul>\n<li>Simple & Intuitive</li>\n<li>Powerful Functions</li>\n<li>Over 30 Field Types</li>\n<li>Extensive Documentation</li>\n<li>Millions of Users</li>\n</ul>\n\n<h4>Links</h4>\n<ul>\n<li><a href=\"https://www.advancedcustomfields.com/?utm_source=wordpress.org&utm_medium=free%20plugin%20listing&utm_campaign=ACF%20Website\">Website</a></li>\n<li><a href=\"https://www.advancedcustomfields.com/resources/?utm_source=wordpress.org&utm_medium=free%20plugin%20listing&utm_campaign=ACF%20Website\">Documentation</a></li>\n<li><a href=\"https://support.advancedcustomfields.com\">Support</a></li>\n<li><a href=\"https://www.advancedcustomfields.com/pro/?utm_source=wordpress.org&utm_medium=free%20plugin%20listing&utm_campaign=ACF%20Pro%20Upgrade\">ACF PRO</a></li>\n</ul>\n\n<h4>PRO</h4>\n<p>The Advanced Custom Fields plugin is also available in a professional version which includes more fields, more functionality, and more flexibility. The ACF PRO plugin features:</p>\n\n<ul>\n<li>The <a href=\"https://www.advancedcustomfields.com/resources/repeater/?utm_source=wordpress.org&utm_medium=free%20plugin%20listing&utm_campaign=ACF%20Pro%20Upgrade\">Repeater Field</a> allows you to create a set of sub fields which can be repeated again, and again, and again.</li>\n<li><a href=\"https://www.advancedcustomfields.com/resources/blocks/?utm_source=wordpress.org&utm_medium=free%20plugin%20listing&utm_campaign=ACF%20Pro%20Upgrade\">ACF Blocks</a>, a powerful PHP-based framework for developing custom block types for the WordPress Block Editor (aka Gutenberg).</li>\n<li>Define, create, and manage content with the <a href=\"https://www.advancedcustomfields.com/resources/flexible-content/?utm_source=wordpress.org&utm_medium=free%20plugin%20listing&utm_campaign=ACF%20Pro%20Upgrade\">Flexible Content Field</a>, which provides for multiple layout and sub field options.</li>\n<li>Use the <a href=\"https://www.advancedcustomfields.com/resources/options-page/?utm_source=wordpress.org&utm_medium=free%20plugin%20listing&utm_campaign=ACF%20Pro%20Upgrade\">Options Page</a> feature to add custom admin pages to edit ACF fields.</li>\n<li>Build fully customisable image galleries with the <a href=\"https://www.advancedcustomfields.com/resources/gallery/?utm_source=wordpress.org&utm_medium=free%20plugin%20listing&utm_campaign=ACF%20Pro%20Upgrade\">Gallery Field</a>.</li>\n<li>Unlock a more efficient workflow for managing field settings by reusing existing fields and field groups on demand with the <a href=\"https://www.advancedcustomfields.com/resources/clone/?utm_source=wordpress.org&utm_medium=free%20plugin%20listing&utm_campaign=ACF%20Pro%20Upgrade\">Clone Field</a>.</li>\n</ul>\n\n<p><a href=\"https://www.advancedcustomfields.com/pro/?utm_source=wordpress.org&utm_medium=free%20plugin%20listing&utm_campaign=ACF%20Pro%20Upgrade\">Upgrade to ACF PRO</a></p>\";s:12:\"installation\";s:649:\"<p>From your WordPress dashboard</p>\n\n<ol>\n<li><strong>Visit</strong> Plugins > Add New</li>\n<li><strong>Search</strong> for \"Advanced Custom Fields\" or “ACF”</li>\n<li><strong>Install and Activate</strong> Advanced Custom Fields from your Plugins page</li>\n<li><strong>Click</strong> on the new menu item \"ACF\" and create your first custom field group, or register a custom post type or taxonomy.</li>\n<li><strong>Read</strong> the documentation to <a href=\"https://www.advancedcustomfields.com/resources/getting-started-with-acf/?utm_source=wordpress.org&utm_medium=free%20plugin%20listing&utm_campaign=ACF%20Website\">get started</a></li>\n</ol>\";s:9:\"changelog\";s:949:\"<h4>6.3.11</h4>\n<p><em>Release Date 12th November 2024</em></p>\n\n<ul>\n<li>Enhancement - Field Group keys are now copyable on click</li>\n<li>Fix - Repeater tables with fields hidden by conditional logic now render correctly</li>\n<li>Fix - ACF Blocks now behave correctly in React StrictMode</li>\n<li>Fix - Edit mode is no longer available to ACF Blocks with an WordPress Block API version of 3 as field editing is not supported in the iframe</li>\n</ul>\n\n<h4>6.3.10.2</h4>\n<p><em>Release Date 29th October 2024</em></p>\n<p><em>Free Only Release</em></p>\n\n<ul>\n<li>Fix - ACF Free no longer causes a fatal error when any unsupported legacy ACF addons are active</li>\n</ul>\n\n<h4>6.3.10.1</h4>\n<p><em>Release Date 29th October 2024</em></p>\n<p><em>Free Only Release</em></p>\n\n<ul>\n<li>Fix - ACF Free no longer causes a fatal error when WPML is active</li>\n</ul>\n\n<p><a href=\"https://www.advancedcustomfields.com/changelog/\">View the full changelog</a></p>\";s:14:\"upgrade_notice\";s:0:\"\";s:5:\"icons\";a:1:{s:7:\"default\";s:64:\"https://connect.advancedcustomfields.com/assets/icon-256x256.png\";}s:7:\"banners\";a:2:{s:3:\"low\";s:66:\"https://connect.advancedcustomfields.com/assets/banner-772x250.jpg\";s:4:\"high\";s:67:\"https://connect.advancedcustomfields.com/assets/banner-1544x500.jpg\";}s:8:\"versions\";a:141:{i:0;s:6:\"6.3.10\";i:1;s:5:\"6.3.9\";i:2;s:5:\"6.3.8\";i:3;s:5:\"6.3.7\";i:4;s:5:\"6.3.6\";i:5;s:5:\"6.3.5\";i:6;s:5:\"6.3.4\";i:7;s:5:\"6.3.3\";i:8;s:7:\"6.3.2.1\";i:9;s:5:\"6.3.2\";i:10;s:7:\"6.3.1.2\";i:11;s:7:\"6.3.1.1\";i:12;s:5:\"6.3.1\";i:13;s:7:\"6.3.0.1\";i:14;s:5:\"6.3.0\";i:15;s:11:\"6.3.0-beta1\";i:16;s:6:\"6.2.10\";i:17;s:5:\"6.2.9\";i:18;s:5:\"6.2.8\";i:19;s:9:\"6.2.8-RC1\";i:20;s:5:\"6.2.7\";i:21;s:7:\"6.2.6.1\";i:22;s:5:\"6.2.6\";i:23;s:5:\"6.2.5\";i:24;s:5:\"6.2.4\";i:25;s:5:\"6.2.3\";i:26;s:5:\"6.2.2\";i:27;s:7:\"6.2.1.1\";i:28;s:5:\"6.2.1\";i:29;s:5:\"6.2.0\";i:30;s:9:\"6.2.0-RC1\";i:31;s:11:\"6.2.0-beta1\";i:32;s:5:\"6.1.8\";i:33;s:5:\"6.1.7\";i:34;s:5:\"6.1.6\";i:35;s:5:\"6.1.5\";i:36;s:5:\"6.1.4\";i:37;s:5:\"6.1.3\";i:38;s:5:\"6.1.2\";i:39;s:5:\"6.1.1\";i:40;s:5:\"6.1.0\";i:41;s:11:\"6.1.0-beta1\";i:42;s:12:\"6.1.0-alpha1\";i:43;s:5:\"6.0.7\";i:44;s:5:\"6.0.6\";i:45;s:5:\"6.0.5\";i:46;s:5:\"6.0.4\";i:47;s:5:\"6.0.3\";i:48;s:5:\"6.0.2\";i:49;s:5:\"6.0.1\";i:50;s:5:\"6.0.0\";i:51;s:9:\"6.0.0-RC3\";i:52;s:9:\"6.0.0-RC2\";i:53;s:9:\"6.0.0-RC1\";i:54;s:11:\"6.0.0-beta1\";i:55;s:12:\"6.0.0-alpha4\";i:56;s:12:\"6.0.0-alpha3\";i:57;s:12:\"6.0.0-alpha2\";i:58;s:12:\"6.0.0-alpha1\";i:59;s:6:\"5.12.6\";i:60;s:6:\"5.12.5\";i:61;s:6:\"5.12.4\";i:62;s:6:\"5.12.3\";i:63;s:6:\"5.12.2\";i:64;s:6:\"5.12.1\";i:65;s:4:\"5.12\";i:66;s:8:\"5.12-RC1\";i:67;s:10:\"5.12-beta2\";i:68;s:10:\"5.12-beta1\";i:69;s:6:\"5.11.4\";i:70;s:6:\"5.11.3\";i:71;s:6:\"5.11.2\";i:72;s:6:\"5.11.1\";i:73;s:4:\"5.11\";i:74;s:8:\"5.11-RC1\";i:75;s:6:\"5.10.2\";i:76;s:6:\"5.10.1\";i:77;s:10:\"5.10.0-RC2\";i:78;s:10:\"5.10.0-RC1\";i:79;s:4:\"5.10\";i:80;s:5:\"5.9.9\";i:81;s:5:\"5.9.8\";i:82;s:5:\"5.9.7\";i:83;s:5:\"5.9.6\";i:84;s:5:\"5.9.5\";i:85;s:5:\"5.9.4\";i:86;s:5:\"5.9.3\";i:87;s:5:\"5.9.2\";i:88;s:5:\"5.9.1\";i:89;s:5:\"5.9.0\";i:90;s:9:\"5.9.0-RC1\";i:91;s:11:\"5.9.0-beta5\";i:92;s:11:\"5.9.0-beta4\";i:93;s:11:\"5.9.0-beta3\";i:94;s:11:\"5.9.0-beta2\";i:95;s:11:\"5.9.0-beta1\";i:96;s:6:\"5.8.14\";i:97;s:6:\"5.8.13\";i:98;s:6:\"5.8.12\";i:99;s:6:\"5.8.11\";i:100;s:5:\"5.8.9\";i:101;s:5:\"5.8.8\";i:102;s:5:\"5.8.7\";i:103;s:5:\"5.8.6\";i:104;s:5:\"5.8.5\";i:105;s:5:\"5.8.4\";i:106;s:5:\"5.8.3\";i:107;s:5:\"5.8.2\";i:108;s:5:\"5.8.1\";i:109;s:5:\"5.8.0\";i:110;s:9:\"5.8.0-RC2\";i:111;s:9:\"5.8.0-RC1\";i:112;s:13:\"5.8.0-beta4.1\";i:113;s:11:\"5.8.0-beta4\";i:114;s:11:\"5.8.0-beta3\";i:115;s:11:\"5.8.0-beta2\";i:116;s:11:\"5.8.0-beta1\";i:117;s:6:\"5.7.13\";i:118;s:6:\"5.7.12\";i:119;s:6:\"5.7.10\";i:120;s:5:\"5.7.9\";i:121;s:5:\"5.7.8\";i:122;s:5:\"5.7.7\";i:123;s:5:\"5.7.6\";i:124;s:5:\"5.7.5\";i:125;s:5:\"5.7.4\";i:126;s:5:\"5.7.3\";i:127;s:5:\"5.7.2\";i:128;s:5:\"5.7.1\";i:129;s:5:\"5.7.0\";i:130;s:6:\"5.6.10\";i:131;s:5:\"5.6.9\";i:132;s:5:\"5.6.8\";i:133;s:5:\"5.6.7\";i:134;s:5:\"5.6.6\";i:135;s:5:\"5.6.5\";i:136;s:5:\"5.6.4\";i:137;s:5:\"5.6.3\";i:138;s:5:\"5.6.2\";i:139;s:5:\"5.6.1\";i:140;s:5:\"5.6.0\";}s:13:\"release_dates\";a:96:{s:6:\"6.3.11\";s:8:\"20241112\";s:8:\"6.3.10.2\";s:8:\"20241029\";s:8:\"6.3.10.1\";s:8:\"20241029\";s:6:\"6.3.10\";s:8:\"20241029\";s:5:\"6.3.9\";s:8:\"20241015\";s:5:\"6.3.8\";s:8:\"20241007\";s:5:\"6.3.7\";s:8:\"20241002\";s:5:\"6.3.6\";s:8:\"20240828\";s:5:\"6.3.5\";s:8:\"20240801\";s:5:\"6.3.4\";s:8:\"20240718\";s:5:\"6.3.3\";s:8:\"20240627\";s:7:\"6.3.2.1\";s:8:\"20240624\";s:5:\"6.3.2\";s:8:\"20240624\";s:7:\"6.3.1.2\";s:8:\"20240606\";s:7:\"6.3.1.1\";s:8:\"20240606\";s:5:\"6.3.1\";s:8:\"20240604\";s:7:\"6.3.0.1\";s:8:\"20240522\";s:5:\"6.3.0\";s:8:\"20240522\";s:6:\"6.2.10\";s:8:\"20240515\";s:5:\"6.2.9\";s:8:\"20240408\";s:5:\"6.2.8\";s:8:\"20240402\";s:5:\"6.2.7\";s:8:\"20240227\";s:7:\"6.2.6.1\";s:8:\"20240207\";s:5:\"6.2.6\";s:8:\"20240206\";s:5:\"6.2.5\";s:8:\"20240116\";s:5:\"6.2.4\";s:8:\"20231128\";s:5:\"6.2.3\";s:8:\"20231115\";s:5:\"6.2.2\";s:8:\"20231025\";s:7:\"6.2.1.1\";s:8:\"20230908\";s:5:\"6.2.1\";s:8:\"20230907\";s:5:\"6.2.0\";s:8:\"20230809\";s:5:\"6.1.8\";s:8:\"20230803\";s:5:\"6.1.7\";s:8:\"20230627\";s:5:\"6.1.6\";s:8:\"20230504\";s:5:\"6.1.5\";s:8:\"20230502\";s:5:\"6.1.4\";s:8:\"20230412\";s:5:\"6.1.3\";s:8:\"20230405\";s:5:\"6.1.2\";s:8:\"20230404\";s:5:\"6.1.1\";s:8:\"20230403\";s:5:\"6.1.0\";s:8:\"20230403\";s:5:\"6.0.7\";s:8:\"20230118\";s:5:\"6.0.6\";s:8:\"20221213\";s:5:\"6.0.5\";s:8:\"20221118\";s:5:\"6.0.4\";s:8:\"20221108\";s:5:\"6.0.3\";s:8:\"20221018\";s:5:\"6.0.2\";s:8:\"20220929\";s:5:\"6.0.1\";s:8:\"20220928\";s:5:\"6.0.0\";s:8:\"20220921\";s:6:\"5.12.6\";s:8:\"20230504\";s:6:\"5.12.5\";s:8:\"20230403\";s:6:\"5.12.4\";s:8:\"20221018\";s:6:\"5.12.3\";s:8:\"20220714\";s:6:\"5.12.2\";s:8:\"20220406\";s:6:\"5.12.1\";s:8:\"20220323\";s:4:\"5.12\";s:8:\"20220223\";s:6:\"5.11.4\";s:8:\"20211202\";s:6:\"5.11.3\";s:8:\"20211124\";s:6:\"5.11.2\";s:8:\"20211124\";s:6:\"5.11.1\";s:8:\"20211118\";s:4:\"5.11\";s:8:\"20211110\";s:6:\"5.10.2\";s:8:\"20210831\";s:6:\"5.10.1\";s:8:\"20210826\";s:4:\"5.10\";s:8:\"20210825\";s:5:\"5.9.9\";s:8:\"20210720\";s:5:\"5.9.8\";s:8:\"20210708\";s:5:\"5.9.7\";s:8:\"20210622\";s:5:\"5.9.6\";s:8:\"20210520\";s:5:\"5.9.5\";s:8:\"20210211\";s:5:\"5.9.4\";s:8:\"20210114\";s:5:\"5.9.3\";s:8:\"20201103\";s:5:\"5.9.2\";s:8:\"20201029\";s:5:\"5.9.1\";s:8:\"20200908\";s:5:\"5.9.0\";s:8:\"20200817\";s:6:\"5.8.14\";s:8:\"20200813\";s:6:\"5.8.13\";s:8:\"20200810\";s:6:\"5.8.12\";s:8:\"20200610\";s:6:\"5.8.11\";s:8:\"20200512\";s:6:\"5.8.10\";s:8:\"20200512\";s:5:\"5.8.9\";s:8:\"20200326\";s:5:\"5.8.8\";s:8:\"20200304\";s:5:\"5.8.7\";s:8:\"20191112\";s:5:\"5.8.6\";s:8:\"20191024\";s:5:\"5.8.5\";s:8:\"20191008\";s:5:\"5.8.4\";s:8:\"20190903\";s:5:\"5.8.3\";s:8:\"20190807\";s:5:\"5.8.2\";s:8:\"20190715\";s:5:\"5.8.1\";s:8:\"20190603\";s:5:\"5.8.0\";s:8:\"20190508\";s:6:\"5.7.13\";s:8:\"20190306\";s:6:\"5.7.12\";s:8:\"20190215\";s:6:\"5.7.11\";s:8:\"20190211\";s:6:\"5.7.10\";s:8:\"20190116\";s:5:\"5.7.9\";s:8:\"20181217\";s:5:\"5.7.8\";s:8:\"20181207\";s:5:\"5.7.7\";s:8:\"20181001\";s:5:\"5.7.6\";s:8:\"20180912\";}}", "off");
INSERT INTO `wp_options` VALUES("40977", "_site_transient_timeout_theme_roots", "1734036601", "off");
INSERT INTO `wp_options` VALUES("40978", "_site_transient_theme_roots", "a:4:{s:20:\"institutoalbertsabin\";s:7:\"/themes\";s:16:\"twentytwentyfive\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("40985", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1734045632", "off");
INSERT INTO `wp_options` VALUES("40986", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:6669;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4858;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2791;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2682;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2093;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1990;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1929;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1788;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1590;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1587;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1562;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1547;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1511;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1504;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1442;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1315;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1314;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1188;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1170;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1161;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1161;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:1032;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:1023;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:996;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:993;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:954;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:945;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:929;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:907;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:901;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:900;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:899;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:895;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:855;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:844;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:819;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:808;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:784;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:779;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:759;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:759;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:754;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:738;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:718;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:702;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:701;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:674;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:662;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:657;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:637;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:635;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:633;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:614;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:613;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:607;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:607;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:605;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:604;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:602;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:601;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:592;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:585;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:581;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:577;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:574;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:574;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:572;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:572;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:559;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:554;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:543;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:542;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:539;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:528;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:527;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:518;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:517;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:503;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:502;}s:8:\"payments\";a:3:{s:4:\"name\";s:8:\"payments\";s:4:\"slug\";s:8:\"payments\";s:5:\"count\";i:497;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:493;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:465;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:461;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:457;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:453;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:452;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:450;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:449;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:448;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:446;}s:8:\"checkout\";a:3:{s:4:\"name\";s:8:\"checkout\";s:4:\"slug\";s:8:\"checkout\";s:5:\"count\";i:444;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:439;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:431;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:430;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:418;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:418;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:417;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:405;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:399;}s:16:\"google-analytics\";a:3:{s:4:\"name\";s:16:\"google analytics\";s:4:\"slug\";s:16:\"google-analytics\";s:5:\"count\";i:394;}}", "off");
INSERT INTO `wp_options` VALUES("40999", "_site_transient_timeout_wp_theme_files_patterns-bf780200d2337ac62080125139562ab0", "1734036869", "off");
INSERT INTO `wp_options` VALUES("41000", "_site_transient_wp_theme_files_patterns-bf780200d2337ac62080125139562ab0", "a:2:{s:7:\"version\";s:3:\"1.0\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("41001", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/pt_BR/wordpress-6.7.1.zip\";s:6:\"locale\";s:5:\"pt_BR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/pt_BR/wordpress-6.7.1.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.7.1\";s:7:\"version\";s:5:\"6.7.1\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1734035096;s:15:\"version_checked\";s:5:\"6.7.1\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("41003", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1734035102;s:7:\"checked\";a:4:{s:20:\"institutoalbertsabin\";s:3:\"1.0\";s:16:\"twentytwentyfive\";s:3:\"1.0\";s:16:\"twentytwentyfour\";s:3:\"1.0\";s:17:\"twentytwentythree\";s:3:\"1.0\";}s:8:\"response\";a:2:{s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.3.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}}s:9:\"no_update\";a:1:{s:16:\"twentytwentyfive\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfive\";s:11:\"new_version\";s:3:\"1.0\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfive/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfive.1.0.zip\";s:8:\"requires\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.2\";}}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("41005", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1734035308;s:8:\"response\";a:1:{s:34:\"advanced-custom-fields-pro/acf.php\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:6:\"plugin\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"new_version\";s:6:\"6.3.11\";s:3:\"url\";s:36:\"https://www.advancedcustomfields.com\";s:6:\"tested\";s:5:\"6.7.1\";s:7:\"package\";s:0:\"\";s:5:\"icons\";a:1:{s:7:\"default\";s:64:\"https://connect.advancedcustomfields.com/assets/icon-256x256.png\";}s:7:\"banners\";a:2:{s:3:\"low\";s:66:\"https://connect.advancedcustomfields.com/assets/banner-772x250.jpg\";s:4:\"high\";s:67:\"https://connect.advancedcustomfields.com/assets/banner-1544x500.jpg\";}s:8:\"requires\";s:3:\"6.0\";s:12:\"requires_php\";s:3:\"7.4\";s:12:\"release_date\";s:8:\"20241112\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:9:{s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:37:\"w.org/plugins/all-in-one-wp-migration\";s:4:\"slug\";s:23:\"all-in-one-wp-migration\";s:6:\"plugin\";s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";s:11:\"new_version\";s:4:\"7.87\";s:3:\"url\";s:54:\"https://wordpress.org/plugins/all-in-one-wp-migration/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/all-in-one-wp-migration.7.87.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/all-in-one-wp-migration/assets/icon-256x256.png?rev=2458334\";s:2:\"1x\";s:76:\"https://ps.w.org/all-in-one-wp-migration/assets/icon-128x128.png?rev=2458334\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:79:\"https://ps.w.org/all-in-one-wp-migration/assets/banner-1544x500.png?rev=3194978\";s:2:\"1x\";s:78:\"https://ps.w.org/all-in-one-wp-migration/assets/banner-772x250.png?rev=3194978\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.3\";}s:33:\"classic-editor/classic-editor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/classic-editor\";s:4:\"slug\";s:14:\"classic-editor\";s:6:\"plugin\";s:33:\"classic-editor/classic-editor.php\";s:11:\"new_version\";s:5:\"1.6.7\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/classic-editor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/classic-editor.1.6.7.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-256x256.png?rev=1998671\";s:2:\"1x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-128x128.png?rev=1998671\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/classic-editor/assets/banner-1544x500.png?rev=1998671\";s:2:\"1x\";s:69:\"https://ps.w.org/classic-editor/assets/banner-772x250.png?rev=1998676\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:25:\"cloudflare/cloudflare.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/cloudflare\";s:4:\"slug\";s:10:\"cloudflare\";s:6:\"plugin\";s:25:\"cloudflare/cloudflare.php\";s:11:\"new_version\";s:6:\"4.12.8\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/cloudflare/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/cloudflare.4.12.8.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/cloudflare/assets/icon-256x256.png?rev=2471183\";s:2:\"1x\";s:63:\"https://ps.w.org/cloudflare/assets/icon-128x128.png?rev=2471183\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/cloudflare/assets/banner-1544x500.png?rev=2471183\";s:2:\"1x\";s:65:\"https://ps.w.org/cloudflare/assets/banner-772x250.png?rev=2471183\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.4\";}s:32:\"duplicate-page/duplicatepage.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/duplicate-page\";s:4:\"slug\";s:14:\"duplicate-page\";s:6:\"plugin\";s:32:\"duplicate-page/duplicatepage.php\";s:11:\"new_version\";s:5:\"4.5.4\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/duplicate-page/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/duplicate-page.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:67:\"https://ps.w.org/duplicate-page/assets/icon-128x128.jpg?rev=1412874\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:69:\"https://ps.w.org/duplicate-page/assets/banner-772x250.jpg?rev=1410328\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.4\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:8:\"1.5.11.2\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/duplicator.1.5.11.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:63:\"limit-login-attempts-reloaded/limit-login-attempts-reloaded.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:43:\"w.org/plugins/limit-login-attempts-reloaded\";s:4:\"slug\";s:29:\"limit-login-attempts-reloaded\";s:6:\"plugin\";s:63:\"limit-login-attempts-reloaded/limit-login-attempts-reloaded.php\";s:11:\"new_version\";s:7:\"2.26.16\";s:3:\"url\";s:60:\"https://wordpress.org/plugins/limit-login-attempts-reloaded/\";s:7:\"package\";s:80:\"https://downloads.wordpress.org/plugin/limit-login-attempts-reloaded.2.26.16.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:82:\"https://ps.w.org/limit-login-attempts-reloaded/assets/icon-256x256.png?rev=2456910\";s:2:\"1x\";s:82:\"https://ps.w.org/limit-login-attempts-reloaded/assets/icon-128x128.png?rev=2456910\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:85:\"https://ps.w.org/limit-login-attempts-reloaded/assets/banner-1544x500.png?rev=2954981\";s:2:\"1x\";s:84:\"https://ps.w.org/limit-login-attempts-reloaded/assets/banner-772x250.png?rev=2954981\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.0\";}s:59:\"simple-cloudflare-turnstile/simple-cloudflare-turnstile.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:41:\"w.org/plugins/simple-cloudflare-turnstile\";s:4:\"slug\";s:27:\"simple-cloudflare-turnstile\";s:6:\"plugin\";s:59:\"simple-cloudflare-turnstile/simple-cloudflare-turnstile.php\";s:11:\"new_version\";s:6:\"1.27.1\";s:3:\"url\";s:58:\"https://wordpress.org/plugins/simple-cloudflare-turnstile/\";s:7:\"package\";s:77:\"https://downloads.wordpress.org/plugin/simple-cloudflare-turnstile.1.27.1.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:80:\"https://ps.w.org/simple-cloudflare-turnstile/assets/icon-128x128.gif?rev=2937121\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:82:\"https://ps.w.org/simple-cloudflare-turnstile/assets/banner-772x250.gif?rev=2800677\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.7\";}s:33:\"wps-hide-login/wps-hide-login.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/wps-hide-login\";s:4:\"slug\";s:14:\"wps-hide-login\";s:6:\"plugin\";s:33:\"wps-hide-login/wps-hide-login.php\";s:11:\"new_version\";s:8:\"1.9.17.1\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/wps-hide-login/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/wps-hide-login.1.9.17.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/wps-hide-login/assets/icon-256x256.png?rev=1820667\";s:2:\"1x\";s:67:\"https://ps.w.org/wps-hide-login/assets/icon-128x128.png?rev=1820667\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/wps-hide-login/assets/banner-1544x500.jpg?rev=1820667\";s:2:\"1x\";s:69:\"https://ps.w.org/wps-hide-login/assets/banner-772x250.jpg?rev=1820667\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.1\";}s:35:\"wps-limit-login/wps-limit-login.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/wps-limit-login\";s:4:\"slug\";s:15:\"wps-limit-login\";s:6:\"plugin\";s:35:\"wps-limit-login/wps-limit-login.php\";s:11:\"new_version\";s:7:\"1.5.9.1\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/wps-limit-login/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/wps-limit-login.1.5.9.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/wps-limit-login/assets/icon-256x256.jpg?rev=1832086\";s:2:\"1x\";s:68:\"https://ps.w.org/wps-limit-login/assets/icon-128x128.jpg?rev=1832086\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/wps-limit-login/assets/banner-1544x500.jpg?rev=1832086\";s:2:\"1x\";s:70:\"https://ps.w.org/wps-limit-login/assets/banner-772x250.jpg?rev=1832086\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.2\";}}s:7:\"checked\";a:10:{s:34:\"advanced-custom-fields-pro/acf.php\";s:5:\"6.0.7\";s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";s:4:\"7.87\";s:33:\"classic-editor/classic-editor.php\";s:5:\"1.6.7\";s:25:\"cloudflare/cloudflare.php\";s:6:\"4.12.8\";s:32:\"duplicate-page/duplicatepage.php\";s:5:\"4.5.4\";s:25:\"duplicator/duplicator.php\";s:8:\"1.5.11.2\";s:63:\"limit-login-attempts-reloaded/limit-login-attempts-reloaded.php\";s:7:\"2.26.16\";s:59:\"simple-cloudflare-turnstile/simple-cloudflare-turnstile.php\";s:6:\"1.27.1\";s:33:\"wps-hide-login/wps-hide-login.php\";s:8:\"1.9.17.1\";s:35:\"wps-limit-login/wps-limit-login.php\";s:7:\"1.5.9.1\";}}", "off");
INSERT INTO `wp_options` VALUES("41006", "duplicator_version_plugin", "1.5.11.2", "auto");
INSERT INTO `wp_options` VALUES("41008", "duplicator_install_info", "a:3:{s:7:\"version\";s:8:\"1.5.11.2\";s:4:\"time\";i:1734035322;s:10:\"updateTime\";i:1734035322;}", "off");
INSERT INTO `wp_options` VALUES("41009", "duplicator_uninstall_package", "1", "auto");
INSERT INTO `wp_options` VALUES("41010", "duplicator_uninstall_settings", "1", "auto");
INSERT INTO `wp_options` VALUES("41011", "duplicator_settings", "a:20:{s:7:\"version\";s:8:\"1.5.11.2\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:1;s:14:\"usage_tracking\";b:0;i:0;b:0;}", "auto");
INSERT INTO `wp_options` VALUES("41012", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"3M,b6;YEwWPhid1BTCzWKZ1SMyHp2hJongh_watS&2VM\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 229.330000000000012505552149377763271331787109375,\n    \"siteNumFiles\": 6703,\n    \"siteDbSizeMB\": 2.779999999999999804600747665972448885440826416015625,\n    \"siteDbNumTables\": 14\n}", "auto");
INSERT INTO `wp_options` VALUES("41013", "duplicator_notifications", "a:4:{s:6:\"update\";i:1734035322;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("41014", "limit_login_activation_timestamp", "1734035350", "on");
INSERT INTO `wp_options` VALUES("41015", "limit_login_notice_enable_notify_timestamp", "1731270550", "on");
INSERT INTO `wp_options` VALUES("41017", "cfturnstile_tested", "no", "auto");
INSERT INTO `wp_options` VALUES("41018", "_transient_timeout_wps_plugins_adds", "1734121788", "off");
INSERT INTO `wp_options` VALUES("41019", "_transient_wps_plugins_adds", "a:6:{s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:13:{s:4:\"date\";s:29:\"Thu, 12 Dec 2024 20:29:47 GMT\";s:6:\"server\";s:6:\"Apache\";s:12:\"x-robots-tag\";s:7:\"noindex\";s:4:\"link\";s:62:\"<https://www.wpserveur.net/wp-json/>; rel=\"https://api.w.org/\"\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:29:\"access-control-expose-headers\";s:33:\"X-WP-Total, X-WP-TotalPages, Link\";s:28:\"access-control-allow-headers\";s:73:\"Authorization, X-WP-Nonce, Content-Disposition, Content-MD5, Content-Type\";s:10:\"x-wp-total\";s:1:\"4\";s:15:\"x-wp-totalpages\";s:1:\"1\";s:5:\"allow\";s:3:\"GET\";s:4:\"vary\";s:22:\"Origin,Accept-Encoding\";s:16:\"content-encoding\";s:4:\"gzip\";s:12:\"content-type\";s:31:\"application/json; charset=UTF-8\";}}s:4:\"body\";s:73203:\"[{\"id\":70610,\"date\":\"2018-06-26T14:51:51\",\"date_gmt\":\"2018-06-26T12:51:51\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpserveur.net\\/?post_type=wps_plugins_adds&#038;p=70610\"},\"modified\":\"2023-09-29T17:38:24\",\"modified_gmt\":\"2023-09-29T15:38:24\",\"slug\":\"wps-bidouille\",\"status\":\"publish\",\"type\":\"wps_plugins_adds\",\"link\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\",\"title\":{\"rendered\":\"WPS Bidouille\"},\"content\":{\"rendered\":\"<p>WPS Bidouille fournit des informations sur votre WordPress et contient des outils d\'optimisation.<\\/p>\\n\",\"protected\":false},\"featured_media\":0,\"menu_order\":0,\"template\":\"\",\"class_list\":[\"post-70610\",\"wps_plugins_adds\",\"type-wps_plugins_adds\",\"status-publish\",\"hentry\"],\"yoast_head\":\"<!-- This site is optimized with the Yoast SEO plugin v23.7 - https:\\/\\/yoast.com\\/wordpress\\/plugins\\/seo\\/ -->\\n<title>WPS Bidouille - WPServeur<\\/title>\\n<meta name=\\\"robots\\\" content=\\\"noindex, nofollow\\\" \\/>\\n<meta property=\\\"og:locale\\\" content=\\\"fr_FR\\\" \\/>\\n<meta property=\\\"og:type\\\" content=\\\"article\\\" \\/>\\n<meta property=\\\"og:title\\\" content=\\\"WPS Bidouille - WPServeur\\\" \\/>\\n<meta property=\\\"og:description\\\" content=\\\"WPS Bidouille fournit des informations sur votre WordPress et contient des outils d&#039;optimisation.\\\" \\/>\\n<meta property=\\\"og:url\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\\\" \\/>\\n<meta property=\\\"og:site_name\\\" content=\\\"WPServeur\\\" \\/>\\n<meta property=\\\"article:publisher\\\" content=\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\" \\/>\\n<meta property=\\\"article:modified_time\\\" content=\\\"2023-09-29T15:38:24+00:00\\\" \\/>\\n<meta property=\\\"og:image\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\" \\/>\\n\\t<meta property=\\\"og:image:width\\\" content=\\\"501\\\" \\/>\\n\\t<meta property=\\\"og:image:height\\\" content=\\\"133\\\" \\/>\\n\\t<meta property=\\\"og:image:type\\\" content=\\\"image\\/jpeg\\\" \\/>\\n<meta name=\\\"twitter:card\\\" content=\\\"summary_large_image\\\" \\/>\\n<meta name=\\\"twitter:site\\\" content=\\\"@wpserveur\\\" \\/>\\n<meta name=\\\"twitter:label1\\\" content=\\\"Dur\\u00e9e de lecture estim\\u00e9e\\\" \\/>\\n\\t<meta name=\\\"twitter:data1\\\" content=\\\"1 minute\\\" \\/>\\n<script type=\\\"application\\/ld+json\\\" class=\\\"yoast-schema-graph\\\">{\\\"@context\\\":\\\"https:\\/\\/schema.org\\\",\\\"@graph\\\":[{\\\"@type\\\":\\\"WebPage\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\\\",\\\"name\\\":\\\"WPS Bidouille - WPServeur\\\",\\\"isPartOf\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\"},\\\"datePublished\\\":\\\"2018-06-26T12:51:51+00:00\\\",\\\"dateModified\\\":\\\"2023-09-29T15:38:24+00:00\\\",\\\"breadcrumb\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/#breadcrumb\\\"},\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"potentialAction\\\":[{\\\"@type\\\":\\\"ReadAction\\\",\\\"target\\\":[\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\\\"]}]},{\\\"@type\\\":\\\"BreadcrumbList\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/#breadcrumb\\\",\\\"itemListElement\\\":[{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":1,\\\"name\\\":\\\"Accueil\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":2,\\\"name\\\":\\\"Plugins adds\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":3,\\\"name\\\":\\\"WPS Bidouille\\\"}]},{\\\"@type\\\":\\\"WebSite\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"name\\\":\\\"WPServeur\\\",\\\"description\\\":\\\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\\\",\\\"publisher\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\"},\\\"potentialAction\\\":[{\\\"@type\\\":\\\"SearchAction\\\",\\\"target\\\":{\\\"@type\\\":\\\"EntryPoint\\\",\\\"urlTemplate\\\":\\\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\\\"},\\\"query-input\\\":{\\\"@type\\\":\\\"PropertyValueSpecification\\\",\\\"valueRequired\\\":true,\\\"valueName\\\":\\\"search_term_string\\\"}}],\\\"inLanguage\\\":\\\"fr-FR\\\"},{\\\"@type\\\":\\\"Organization\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\",\\\"name\\\":\\\"WPSERVEUR\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"logo\\\":{\\\"@type\\\":\\\"ImageObject\\\",\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"contentUrl\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"width\\\":501,\\\"height\\\":133,\\\"caption\\\":\\\"WPSERVEUR\\\"},\\\"image\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\"},\\\"sameAs\\\":[\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\",\\\"https:\\/\\/x.com\\/wpserveur\\\"]}]}<\\/script>\\n<!-- \\/ Yoast SEO plugin. -->\",\"yoast_head_json\":{\"title\":\"WPS Bidouille - WPServeur\",\"robots\":{\"index\":\"noindex\",\"follow\":\"nofollow\"},\"og_locale\":\"fr_FR\",\"og_type\":\"article\",\"og_title\":\"WPS Bidouille - WPServeur\",\"og_description\":\"WPS Bidouille fournit des informations sur votre WordPress et contient des outils d\'optimisation.\",\"og_url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\",\"og_site_name\":\"WPServeur\",\"article_publisher\":\"https:\\/\\/www.facebook.com\\/wpserveur\",\"article_modified_time\":\"2023-09-29T15:38:24+00:00\",\"og_image\":[{\"width\":501,\"height\":133,\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"type\":\"image\\/jpeg\"}],\"twitter_card\":\"summary_large_image\",\"twitter_site\":\"@wpserveur\",\"twitter_misc\":{\"Dur\\u00e9e de lecture estim\\u00e9e\":\"1 minute\"},\"schema\":{\"@context\":\"https:\\/\\/schema.org\",\"@graph\":[{\"@type\":\"WebPage\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\",\"name\":\"WPS Bidouille - WPServeur\",\"isPartOf\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\"},\"datePublished\":\"2018-06-26T12:51:51+00:00\",\"dateModified\":\"2023-09-29T15:38:24+00:00\",\"breadcrumb\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/#breadcrumb\"},\"inLanguage\":\"fr-FR\",\"potentialAction\":[{\"@type\":\"ReadAction\",\"target\":[\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\"]}]},{\"@type\":\"BreadcrumbList\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/#breadcrumb\",\"itemListElement\":[{\"@type\":\"ListItem\",\"position\":1,\"name\":\"Accueil\",\"item\":\"https:\\/\\/www.wpserveur.net\\/\"},{\"@type\":\"ListItem\",\"position\":2,\"name\":\"Plugins adds\",\"item\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\"},{\"@type\":\"ListItem\",\"position\":3,\"name\":\"WPS Bidouille\"}]},{\"@type\":\"WebSite\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"name\":\"WPServeur\",\"description\":\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\",\"publisher\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\"},\"potentialAction\":[{\"@type\":\"SearchAction\",\"target\":{\"@type\":\"EntryPoint\",\"urlTemplate\":\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\"},\"query-input\":{\"@type\":\"PropertyValueSpecification\",\"valueRequired\":true,\"valueName\":\"search_term_string\"}}],\"inLanguage\":\"fr-FR\"},{\"@type\":\"Organization\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\",\"name\":\"WPSERVEUR\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"logo\":{\"@type\":\"ImageObject\",\"inLanguage\":\"fr-FR\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"contentUrl\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"width\":501,\"height\":133,\"caption\":\"WPSERVEUR\"},\"image\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\"},\"sameAs\":[\"https:\\/\\/www.facebook.com\\/wpserveur\",\"https:\\/\\/x.com\\/wpserveur\"]}]}},\"post-meta-fields\":{\"_edit_lock\":[\"1696001943:4369\"],\"_edit_last\":[\"4369\"],\"plugin\":[\"wps-bidouille\"],\"_plugin\":[\"field_5b3218a08e6ef\"],\"pour_tous\":[\"1\"],\"_pour_tous\":[\"field_5b3218a68e6f0\"],\"description_en\":[\"WPS Bidouille provides information about your WordPress and contains optimization tools.\"],\"_description_en\":[\"field_5b322e3477aa4\"],\"wps_icon\":[\"\"],\"img_64\":[\"data:image\\/jpeg;base64,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\"],\"_img_64\":[\"field_5d2865a27767c\"],\"_yoast_wpseo_estimated-reading-time-minutes\":[\"1\"],\"_yoast_wpseo_meta-robots-noindex\":[\"1\"],\"_yoast_wpseo_meta-robots-nofollow\":[\"1\"],\"_yoast_wpseo_wordproof_timestamp\":[\"\"],\"_cmplz_scanned_post\":[\"1\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\\/70610\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/types\\/wps_plugins_adds\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/media?parent=70610\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}},{\"id\":70609,\"date\":\"2018-06-26T14:51:19\",\"date_gmt\":\"2018-06-26T12:51:19\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpserveur.net\\/?post_type=wps_plugins_adds&#038;p=70609\"},\"modified\":\"2023-09-29T17:38:13\",\"modified_gmt\":\"2023-09-29T15:38:13\",\"slug\":\"wps-cleaner\",\"status\":\"publish\",\"type\":\"wps_plugins_adds\",\"link\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\",\"title\":{\"rendered\":\"WPS Cleaner\"},\"content\":{\"rendered\":\"<p>Nettoyer votre site WordPress.<\\/p>\\n\",\"protected\":false},\"featured_media\":0,\"menu_order\":0,\"template\":\"\",\"class_list\":[\"post-70609\",\"wps_plugins_adds\",\"type-wps_plugins_adds\",\"status-publish\",\"hentry\"],\"yoast_head\":\"<!-- This site is optimized with the Yoast SEO plugin v23.7 - https:\\/\\/yoast.com\\/wordpress\\/plugins\\/seo\\/ -->\\n<title>WPS Cleaner - WPServeur<\\/title>\\n<meta name=\\\"robots\\\" content=\\\"noindex, nofollow\\\" \\/>\\n<meta property=\\\"og:locale\\\" content=\\\"fr_FR\\\" \\/>\\n<meta property=\\\"og:type\\\" content=\\\"article\\\" \\/>\\n<meta property=\\\"og:title\\\" content=\\\"WPS Cleaner - WPServeur\\\" \\/>\\n<meta property=\\\"og:description\\\" content=\\\"Nettoyer votre site WordPress.\\\" \\/>\\n<meta property=\\\"og:url\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\\\" \\/>\\n<meta property=\\\"og:site_name\\\" content=\\\"WPServeur\\\" \\/>\\n<meta property=\\\"article:publisher\\\" content=\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\" \\/>\\n<meta property=\\\"article:modified_time\\\" content=\\\"2023-09-29T15:38:13+00:00\\\" \\/>\\n<meta property=\\\"og:image\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\" \\/>\\n\\t<meta property=\\\"og:image:width\\\" content=\\\"501\\\" \\/>\\n\\t<meta property=\\\"og:image:height\\\" content=\\\"133\\\" \\/>\\n\\t<meta property=\\\"og:image:type\\\" content=\\\"image\\/jpeg\\\" \\/>\\n<meta name=\\\"twitter:card\\\" content=\\\"summary_large_image\\\" \\/>\\n<meta name=\\\"twitter:site\\\" content=\\\"@wpserveur\\\" \\/>\\n<meta name=\\\"twitter:label1\\\" content=\\\"Dur\\u00e9e de lecture estim\\u00e9e\\\" \\/>\\n\\t<meta name=\\\"twitter:data1\\\" content=\\\"1 minute\\\" \\/>\\n<script type=\\\"application\\/ld+json\\\" class=\\\"yoast-schema-graph\\\">{\\\"@context\\\":\\\"https:\\/\\/schema.org\\\",\\\"@graph\\\":[{\\\"@type\\\":\\\"WebPage\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\\\",\\\"name\\\":\\\"WPS Cleaner - WPServeur\\\",\\\"isPartOf\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\"},\\\"datePublished\\\":\\\"2018-06-26T12:51:19+00:00\\\",\\\"dateModified\\\":\\\"2023-09-29T15:38:13+00:00\\\",\\\"breadcrumb\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/#breadcrumb\\\"},\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"potentialAction\\\":[{\\\"@type\\\":\\\"ReadAction\\\",\\\"target\\\":[\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\\\"]}]},{\\\"@type\\\":\\\"BreadcrumbList\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/#breadcrumb\\\",\\\"itemListElement\\\":[{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":1,\\\"name\\\":\\\"Accueil\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":2,\\\"name\\\":\\\"Plugins adds\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":3,\\\"name\\\":\\\"WPS Cleaner\\\"}]},{\\\"@type\\\":\\\"WebSite\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"name\\\":\\\"WPServeur\\\",\\\"description\\\":\\\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\\\",\\\"publisher\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\"},\\\"potentialAction\\\":[{\\\"@type\\\":\\\"SearchAction\\\",\\\"target\\\":{\\\"@type\\\":\\\"EntryPoint\\\",\\\"urlTemplate\\\":\\\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\\\"},\\\"query-input\\\":{\\\"@type\\\":\\\"PropertyValueSpecification\\\",\\\"valueRequired\\\":true,\\\"valueName\\\":\\\"search_term_string\\\"}}],\\\"inLanguage\\\":\\\"fr-FR\\\"},{\\\"@type\\\":\\\"Organization\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\",\\\"name\\\":\\\"WPSERVEUR\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"logo\\\":{\\\"@type\\\":\\\"ImageObject\\\",\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"contentUrl\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"width\\\":501,\\\"height\\\":133,\\\"caption\\\":\\\"WPSERVEUR\\\"},\\\"image\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\"},\\\"sameAs\\\":[\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\",\\\"https:\\/\\/x.com\\/wpserveur\\\"]}]}<\\/script>\\n<!-- \\/ Yoast SEO plugin. -->\",\"yoast_head_json\":{\"title\":\"WPS Cleaner - WPServeur\",\"robots\":{\"index\":\"noindex\",\"follow\":\"nofollow\"},\"og_locale\":\"fr_FR\",\"og_type\":\"article\",\"og_title\":\"WPS Cleaner - WPServeur\",\"og_description\":\"Nettoyer votre site WordPress.\",\"og_url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\",\"og_site_name\":\"WPServeur\",\"article_publisher\":\"https:\\/\\/www.facebook.com\\/wpserveur\",\"article_modified_time\":\"2023-09-29T15:38:13+00:00\",\"og_image\":[{\"width\":501,\"height\":133,\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"type\":\"image\\/jpeg\"}],\"twitter_card\":\"summary_large_image\",\"twitter_site\":\"@wpserveur\",\"twitter_misc\":{\"Dur\\u00e9e de lecture estim\\u00e9e\":\"1 minute\"},\"schema\":{\"@context\":\"https:\\/\\/schema.org\",\"@graph\":[{\"@type\":\"WebPage\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\",\"name\":\"WPS Cleaner - WPServeur\",\"isPartOf\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\"},\"datePublished\":\"2018-06-26T12:51:19+00:00\",\"dateModified\":\"2023-09-29T15:38:13+00:00\",\"breadcrumb\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/#breadcrumb\"},\"inLanguage\":\"fr-FR\",\"potentialAction\":[{\"@type\":\"ReadAction\",\"target\":[\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\"]}]},{\"@type\":\"BreadcrumbList\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/#breadcrumb\",\"itemListElement\":[{\"@type\":\"ListItem\",\"position\":1,\"name\":\"Accueil\",\"item\":\"https:\\/\\/www.wpserveur.net\\/\"},{\"@type\":\"ListItem\",\"position\":2,\"name\":\"Plugins adds\",\"item\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\"},{\"@type\":\"ListItem\",\"position\":3,\"name\":\"WPS Cleaner\"}]},{\"@type\":\"WebSite\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"name\":\"WPServeur\",\"description\":\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\",\"publisher\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\"},\"potentialAction\":[{\"@type\":\"SearchAction\",\"target\":{\"@type\":\"EntryPoint\",\"urlTemplate\":\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\"},\"query-input\":{\"@type\":\"PropertyValueSpecification\",\"valueRequired\":true,\"valueName\":\"search_term_string\"}}],\"inLanguage\":\"fr-FR\"},{\"@type\":\"Organization\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\",\"name\":\"WPSERVEUR\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"logo\":{\"@type\":\"ImageObject\",\"inLanguage\":\"fr-FR\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"contentUrl\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"width\":501,\"height\":133,\"caption\":\"WPSERVEUR\"},\"image\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\"},\"sameAs\":[\"https:\\/\\/www.facebook.com\\/wpserveur\",\"https:\\/\\/x.com\\/wpserveur\"]}]}},\"post-meta-fields\":{\"_edit_lock\":[\"1696001942:4369\"],\"_edit_last\":[\"4369\"],\"plugin\":[\"wps-cleaner\"],\"_plugin\":[\"field_5b3218a08e6ef\"],\"pour_tous\":[\"1\"],\"_pour_tous\":[\"field_5b3218a68e6f0\"],\"description_en\":[\"Clean up your WordPress site.\"],\"_description_en\":[\"field_5b322e3477aa4\"],\"wps_icon\":[\"\"],\"img_64\":[\"data:image\\/jpeg;base64,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\"],\"_img_64\":[\"field_5d2865a27767c\"],\"_yoast_wpseo_estimated-reading-time-minutes\":[\"1\"],\"_yoast_wpseo_meta-robots-noindex\":[\"1\"],\"_yoast_wpseo_meta-robots-nofollow\":[\"1\"],\"_yoast_wpseo_wordproof_timestamp\":[\"\"],\"_cmplz_scanned_post\":[\"1\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\\/70609\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/types\\/wps_plugins_adds\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/media?parent=70609\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}},{\"id\":70607,\"date\":\"2018-06-26T14:50:49\",\"date_gmt\":\"2018-06-26T12:50:49\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpserveur.net\\/?post_type=wps_plugins_adds&#038;p=70607\"},\"modified\":\"2023-09-29T17:37:50\",\"modified_gmt\":\"2023-09-29T15:37:50\",\"slug\":\"wps-hide-login\",\"status\":\"publish\",\"type\":\"wps_plugins_adds\",\"link\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\",\"title\":{\"rendered\":\"WPS Hide Login\"},\"content\":{\"rendered\":\"<p>S\\u00e9curiser l\'acc\\u00e8s \\u00e0 votre administration WordPress<\\/p>\\n\",\"protected\":false},\"featured_media\":0,\"menu_order\":0,\"template\":\"\",\"class_list\":[\"post-70607\",\"wps_plugins_adds\",\"type-wps_plugins_adds\",\"status-publish\",\"hentry\"],\"yoast_head\":\"<!-- This site is optimized with the Yoast SEO plugin v23.7 - https:\\/\\/yoast.com\\/wordpress\\/plugins\\/seo\\/ -->\\n<title>WPS Hide Login - WPServeur<\\/title>\\n<meta name=\\\"robots\\\" content=\\\"noindex, nofollow\\\" \\/>\\n<meta property=\\\"og:locale\\\" content=\\\"fr_FR\\\" \\/>\\n<meta property=\\\"og:type\\\" content=\\\"article\\\" \\/>\\n<meta property=\\\"og:title\\\" content=\\\"WPS Hide Login - WPServeur\\\" \\/>\\n<meta property=\\\"og:description\\\" content=\\\"S\\u00e9curiser l&#039;acc\\u00e8s \\u00e0 votre administration WordPress\\\" \\/>\\n<meta property=\\\"og:url\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\\\" \\/>\\n<meta property=\\\"og:site_name\\\" content=\\\"WPServeur\\\" \\/>\\n<meta property=\\\"article:publisher\\\" content=\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\" \\/>\\n<meta property=\\\"article:modified_time\\\" content=\\\"2023-09-29T15:37:50+00:00\\\" \\/>\\n<meta property=\\\"og:image\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\" \\/>\\n\\t<meta property=\\\"og:image:width\\\" content=\\\"501\\\" \\/>\\n\\t<meta property=\\\"og:image:height\\\" content=\\\"133\\\" \\/>\\n\\t<meta property=\\\"og:image:type\\\" content=\\\"image\\/jpeg\\\" \\/>\\n<meta name=\\\"twitter:card\\\" content=\\\"summary_large_image\\\" \\/>\\n<meta name=\\\"twitter:site\\\" content=\\\"@wpserveur\\\" \\/>\\n<meta name=\\\"twitter:label1\\\" content=\\\"Dur\\u00e9e de lecture estim\\u00e9e\\\" \\/>\\n\\t<meta name=\\\"twitter:data1\\\" content=\\\"1 minute\\\" \\/>\\n<script type=\\\"application\\/ld+json\\\" class=\\\"yoast-schema-graph\\\">{\\\"@context\\\":\\\"https:\\/\\/schema.org\\\",\\\"@graph\\\":[{\\\"@type\\\":\\\"WebPage\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\\\",\\\"name\\\":\\\"WPS Hide Login - WPServeur\\\",\\\"isPartOf\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\"},\\\"datePublished\\\":\\\"2018-06-26T12:50:49+00:00\\\",\\\"dateModified\\\":\\\"2023-09-29T15:37:50+00:00\\\",\\\"breadcrumb\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/#breadcrumb\\\"},\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"potentialAction\\\":[{\\\"@type\\\":\\\"ReadAction\\\",\\\"target\\\":[\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\\\"]}]},{\\\"@type\\\":\\\"BreadcrumbList\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/#breadcrumb\\\",\\\"itemListElement\\\":[{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":1,\\\"name\\\":\\\"Accueil\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":2,\\\"name\\\":\\\"Plugins adds\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":3,\\\"name\\\":\\\"WPS Hide Login\\\"}]},{\\\"@type\\\":\\\"WebSite\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"name\\\":\\\"WPServeur\\\",\\\"description\\\":\\\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\\\",\\\"publisher\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\"},\\\"potentialAction\\\":[{\\\"@type\\\":\\\"SearchAction\\\",\\\"target\\\":{\\\"@type\\\":\\\"EntryPoint\\\",\\\"urlTemplate\\\":\\\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\\\"},\\\"query-input\\\":{\\\"@type\\\":\\\"PropertyValueSpecification\\\",\\\"valueRequired\\\":true,\\\"valueName\\\":\\\"search_term_string\\\"}}],\\\"inLanguage\\\":\\\"fr-FR\\\"},{\\\"@type\\\":\\\"Organization\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\",\\\"name\\\":\\\"WPSERVEUR\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"logo\\\":{\\\"@type\\\":\\\"ImageObject\\\",\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"contentUrl\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"width\\\":501,\\\"height\\\":133,\\\"caption\\\":\\\"WPSERVEUR\\\"},\\\"image\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\"},\\\"sameAs\\\":[\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\",\\\"https:\\/\\/x.com\\/wpserveur\\\"]}]}<\\/script>\\n<!-- \\/ Yoast SEO plugin. -->\",\"yoast_head_json\":{\"title\":\"WPS Hide Login - WPServeur\",\"robots\":{\"index\":\"noindex\",\"follow\":\"nofollow\"},\"og_locale\":\"fr_FR\",\"og_type\":\"article\",\"og_title\":\"WPS Hide Login - WPServeur\",\"og_description\":\"S\\u00e9curiser l\'acc\\u00e8s \\u00e0 votre administration WordPress\",\"og_url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\",\"og_site_name\":\"WPServeur\",\"article_publisher\":\"https:\\/\\/www.facebook.com\\/wpserveur\",\"article_modified_time\":\"2023-09-29T15:37:50+00:00\",\"og_image\":[{\"width\":501,\"height\":133,\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"type\":\"image\\/jpeg\"}],\"twitter_card\":\"summary_large_image\",\"twitter_site\":\"@wpserveur\",\"twitter_misc\":{\"Dur\\u00e9e de lecture estim\\u00e9e\":\"1 minute\"},\"schema\":{\"@context\":\"https:\\/\\/schema.org\",\"@graph\":[{\"@type\":\"WebPage\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\",\"name\":\"WPS Hide Login - WPServeur\",\"isPartOf\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\"},\"datePublished\":\"2018-06-26T12:50:49+00:00\",\"dateModified\":\"2023-09-29T15:37:50+00:00\",\"breadcrumb\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/#breadcrumb\"},\"inLanguage\":\"fr-FR\",\"potentialAction\":[{\"@type\":\"ReadAction\",\"target\":[\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\"]}]},{\"@type\":\"BreadcrumbList\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/#breadcrumb\",\"itemListElement\":[{\"@type\":\"ListItem\",\"position\":1,\"name\":\"Accueil\",\"item\":\"https:\\/\\/www.wpserveur.net\\/\"},{\"@type\":\"ListItem\",\"position\":2,\"name\":\"Plugins adds\",\"item\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\"},{\"@type\":\"ListItem\",\"position\":3,\"name\":\"WPS Hide Login\"}]},{\"@type\":\"WebSite\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"name\":\"WPServeur\",\"description\":\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\",\"publisher\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\"},\"potentialAction\":[{\"@type\":\"SearchAction\",\"target\":{\"@type\":\"EntryPoint\",\"urlTemplate\":\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\"},\"query-input\":{\"@type\":\"PropertyValueSpecification\",\"valueRequired\":true,\"valueName\":\"search_term_string\"}}],\"inLanguage\":\"fr-FR\"},{\"@type\":\"Organization\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\",\"name\":\"WPSERVEUR\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"logo\":{\"@type\":\"ImageObject\",\"inLanguage\":\"fr-FR\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"contentUrl\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"width\":501,\"height\":133,\"caption\":\"WPSERVEUR\"},\"image\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\"},\"sameAs\":[\"https:\\/\\/www.facebook.com\\/wpserveur\",\"https:\\/\\/x.com\\/wpserveur\"]}]}},\"post-meta-fields\":{\"_edit_lock\":[\"1696001880:4369\"],\"_edit_last\":[\"4369\"],\"plugin\":[\"wps-hide-login\"],\"_plugin\":[\"field_5b3218a08e6ef\"],\"pour_tous\":[\"1\"],\"_pour_tous\":[\"field_5b3218a68e6f0\"],\"description_en\":[\"Secure access to your WordPress administration\"],\"_description_en\":[\"field_5b322e3477aa4\"],\"wps_icon\":[\"\"],\"img_64\":[\"data:image\\/png;base64,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\"],\"_img_64\":[\"field_5d2865a27767c\"],\"_yoast_wpseo_estimated-reading-time-minutes\":[\"1\"],\"_yoast_wpseo_meta-robots-noindex\":[\"1\"],\"_yoast_wpseo_meta-robots-nofollow\":[\"1\"],\"_yoast_wpseo_wordproof_timestamp\":[\"\"],\"_cmplz_scanned_post\":[\"1\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\\/70607\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/types\\/wps_plugins_adds\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/media?parent=70607\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}},{\"id\":70606,\"date\":\"2018-06-26T14:50:11\",\"date_gmt\":\"2018-06-26T12:50:11\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpserveur.net\\/?post_type=wps_plugins_adds&#038;p=70606\"},\"modified\":\"2023-09-29T17:37:37\",\"modified_gmt\":\"2023-09-29T15:37:37\",\"slug\":\"wps-limit-login\",\"status\":\"publish\",\"type\":\"wps_plugins_adds\",\"link\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\",\"title\":{\"rendered\":\"WPS Limit Login\"},\"content\":{\"rendered\":\"<p>S\\u00e9curiser la page d\'authentification WordPress<\\/p>\\n\",\"protected\":false},\"featured_media\":0,\"menu_order\":0,\"template\":\"\",\"class_list\":[\"post-70606\",\"wps_plugins_adds\",\"type-wps_plugins_adds\",\"status-publish\",\"hentry\"],\"yoast_head\":\"<!-- This site is optimized with the Yoast SEO plugin v23.7 - https:\\/\\/yoast.com\\/wordpress\\/plugins\\/seo\\/ -->\\n<title>WPS Limit Login - WPServeur<\\/title>\\n<meta name=\\\"robots\\\" content=\\\"noindex, nofollow\\\" \\/>\\n<meta property=\\\"og:locale\\\" content=\\\"fr_FR\\\" \\/>\\n<meta property=\\\"og:type\\\" content=\\\"article\\\" \\/>\\n<meta property=\\\"og:title\\\" content=\\\"WPS Limit Login - WPServeur\\\" \\/>\\n<meta property=\\\"og:description\\\" content=\\\"S\\u00e9curiser la page d&#039;authentification WordPress\\\" \\/>\\n<meta property=\\\"og:url\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\\\" \\/>\\n<meta property=\\\"og:site_name\\\" content=\\\"WPServeur\\\" \\/>\\n<meta property=\\\"article:publisher\\\" content=\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\" \\/>\\n<meta property=\\\"article:modified_time\\\" content=\\\"2023-09-29T15:37:37+00:00\\\" \\/>\\n<meta property=\\\"og:image\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\" \\/>\\n\\t<meta property=\\\"og:image:width\\\" content=\\\"501\\\" \\/>\\n\\t<meta property=\\\"og:image:height\\\" content=\\\"133\\\" \\/>\\n\\t<meta property=\\\"og:image:type\\\" content=\\\"image\\/jpeg\\\" \\/>\\n<meta name=\\\"twitter:card\\\" content=\\\"summary_large_image\\\" \\/>\\n<meta name=\\\"twitter:site\\\" content=\\\"@wpserveur\\\" \\/>\\n<meta name=\\\"twitter:label1\\\" content=\\\"Dur\\u00e9e de lecture estim\\u00e9e\\\" \\/>\\n\\t<meta name=\\\"twitter:data1\\\" content=\\\"1 minute\\\" \\/>\\n<script type=\\\"application\\/ld+json\\\" class=\\\"yoast-schema-graph\\\">{\\\"@context\\\":\\\"https:\\/\\/schema.org\\\",\\\"@graph\\\":[{\\\"@type\\\":\\\"WebPage\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\\\",\\\"name\\\":\\\"WPS Limit Login - WPServeur\\\",\\\"isPartOf\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\"},\\\"datePublished\\\":\\\"2018-06-26T12:50:11+00:00\\\",\\\"dateModified\\\":\\\"2023-09-29T15:37:37+00:00\\\",\\\"breadcrumb\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/#breadcrumb\\\"},\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"potentialAction\\\":[{\\\"@type\\\":\\\"ReadAction\\\",\\\"target\\\":[\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\\\"]}]},{\\\"@type\\\":\\\"BreadcrumbList\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/#breadcrumb\\\",\\\"itemListElement\\\":[{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":1,\\\"name\\\":\\\"Accueil\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":2,\\\"name\\\":\\\"Plugins adds\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":3,\\\"name\\\":\\\"WPS Limit Login\\\"}]},{\\\"@type\\\":\\\"WebSite\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"name\\\":\\\"WPServeur\\\",\\\"description\\\":\\\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\\\",\\\"publisher\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\"},\\\"potentialAction\\\":[{\\\"@type\\\":\\\"SearchAction\\\",\\\"target\\\":{\\\"@type\\\":\\\"EntryPoint\\\",\\\"urlTemplate\\\":\\\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\\\"},\\\"query-input\\\":{\\\"@type\\\":\\\"PropertyValueSpecification\\\",\\\"valueRequired\\\":true,\\\"valueName\\\":\\\"search_term_string\\\"}}],\\\"inLanguage\\\":\\\"fr-FR\\\"},{\\\"@type\\\":\\\"Organization\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\",\\\"name\\\":\\\"WPSERVEUR\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"logo\\\":{\\\"@type\\\":\\\"ImageObject\\\",\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"contentUrl\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"width\\\":501,\\\"height\\\":133,\\\"caption\\\":\\\"WPSERVEUR\\\"},\\\"image\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\"},\\\"sameAs\\\":[\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\",\\\"https:\\/\\/x.com\\/wpserveur\\\"]}]}<\\/script>\\n<!-- \\/ Yoast SEO plugin. -->\",\"yoast_head_json\":{\"title\":\"WPS Limit Login - WPServeur\",\"robots\":{\"index\":\"noindex\",\"follow\":\"nofollow\"},\"og_locale\":\"fr_FR\",\"og_type\":\"article\",\"og_title\":\"WPS Limit Login - WPServeur\",\"og_description\":\"S\\u00e9curiser la page d\'authentification WordPress\",\"og_url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\",\"og_site_name\":\"WPServeur\",\"article_publisher\":\"https:\\/\\/www.facebook.com\\/wpserveur\",\"article_modified_time\":\"2023-09-29T15:37:37+00:00\",\"og_image\":[{\"width\":501,\"height\":133,\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"type\":\"image\\/jpeg\"}],\"twitter_card\":\"summary_large_image\",\"twitter_site\":\"@wpserveur\",\"twitter_misc\":{\"Dur\\u00e9e de lecture estim\\u00e9e\":\"1 minute\"},\"schema\":{\"@context\":\"https:\\/\\/schema.org\",\"@graph\":[{\"@type\":\"WebPage\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\",\"name\":\"WPS Limit Login - WPServeur\",\"isPartOf\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\"},\"datePublished\":\"2018-06-26T12:50:11+00:00\",\"dateModified\":\"2023-09-29T15:37:37+00:00\",\"breadcrumb\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/#breadcrumb\"},\"inLanguage\":\"fr-FR\",\"potentialAction\":[{\"@type\":\"ReadAction\",\"target\":[\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\"]}]},{\"@type\":\"BreadcrumbList\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/#breadcrumb\",\"itemListElement\":[{\"@type\":\"ListItem\",\"position\":1,\"name\":\"Accueil\",\"item\":\"https:\\/\\/www.wpserveur.net\\/\"},{\"@type\":\"ListItem\",\"position\":2,\"name\":\"Plugins adds\",\"item\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\"},{\"@type\":\"ListItem\",\"position\":3,\"name\":\"WPS Limit Login\"}]},{\"@type\":\"WebSite\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"name\":\"WPServeur\",\"description\":\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\",\"publisher\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\"},\"potentialAction\":[{\"@type\":\"SearchAction\",\"target\":{\"@type\":\"EntryPoint\",\"urlTemplate\":\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\"},\"query-input\":{\"@type\":\"PropertyValueSpecification\",\"valueRequired\":true,\"valueName\":\"search_term_string\"}}],\"inLanguage\":\"fr-FR\"},{\"@type\":\"Organization\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\",\"name\":\"WPSERVEUR\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"logo\":{\"@type\":\"ImageObject\",\"inLanguage\":\"fr-FR\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"contentUrl\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"width\":501,\"height\":133,\"caption\":\"WPSERVEUR\"},\"image\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\"},\"sameAs\":[\"https:\\/\\/www.facebook.com\\/wpserveur\",\"https:\\/\\/x.com\\/wpserveur\"]}]}},\"post-meta-fields\":{\"_edit_lock\":[\"1696001735:4369\"],\"_edit_last\":[\"4369\"],\"plugin\":[\"wps-limit-login\"],\"_plugin\":[\"field_5b3218a08e6ef\"],\"pour_tous\":[\"1\"],\"_pour_tous\":[\"field_5b3218a68e6f0\"],\"description_en\":[\"Secure the WordPress authentication page\"],\"_description_en\":[\"field_5b322e3477aa4\"],\"wps_icon\":[\"\"],\"img_64\":[\"data:image\\/jpeg;base64,\\/9j\\/4QAYRXhpZgAASUkqAAgAAAAAAAAAAAAAAP\\/sABFEdWNreQABAAQAAABHAAD\\/4QN6aHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLwA8P3hwYWNrZXQgYmVnaW49Iu+7vyIgaWQ9Ilc1TTBNcENlaGlIenJlU3pOVGN6a2M5ZCI\\/PiA8eDp4bXBtZXRhIHhtbG5zOng9ImFkb2JlOm5zOm1ldGEvIiB4OnhtcHRrPSJBZG9iZSBYTVAgQ29yZSA1LjYtYzE0MiA3OS4xNjA5MjQsIDIwMTcvMDcvMTMtMDE6MDY6MzkgICAgICAgICI+IDxyZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+IDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiIHhtbG5zOnhtcE1NPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvbW0vIiB4bWxuczpzdFJlZj0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL3NUeXBlL1Jlc291cmNlUmVmIyIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bXBNTTpPcmlnaW5hbERvY3VtZW50SUQ9InhtcC5kaWQ6MzcxNTYwOTctZDNlMC00ZDQ3LWI4NDUtOTQxYjI3NDhmNGRkIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOjA5MUVDMjRDMURGMjExRThBMjM4QTVFRTYyN0Y4RTgzIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOjA5MUVDMjRCMURGMjExRThBMjM4QTVFRTYyN0Y4RTgzIiB4bXA6Q3JlYXRvclRvb2w9IkFkb2JlIFBob3Rvc2hvcCBDQyAoV2luZG93cykiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDo3MWQ1YzdmMy0yYWE2LWFkNDUtOTM3MC04MDlkN2ZmMDNiMWEiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6MzcxNTYwOTctZDNlMC00ZDQ3LWI4NDUtOTQxYjI3NDhmNGRkIi8+IDwvcmRmOkRlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJyIj8+\\/+4ADkFkb2JlAGTAAAAAAf\\/bAIQABAMDAwMDBAMDBAYEAwQGBgUEBAUGBwYGBgYGBwoHCAgICAcKCgsMDAwLCgwMDAwMDBERERERExMTExMTExMTEwEEBAQIBwgOCgoOFA4ODhQUExMTExQTExMTExMTExMTExMTExMTExMTExMTExMTExMTExMTExMTExMTExMTExMT\\/8AAEQgAgACAAwERAAIRAQMRAf\\/EAKoAAAEEAwEAAAAAAAAAAAAAAAMCBQYHAQQIAAEAAgIDAQAAAAAAAAAAAAAAAAEEBQIDBgcQAAIBAwMBBAcEBwUJAAAAAAECAwAEBRESBiExQRMHUWFxgaEiFJEyoiOxYnKCYxUI0ZLTNBbxQlLSM7OElEYRAAIBAwEEBwUHBAMAAAAAAAABAhEDBCExEgUGQVFhcZHhE4GhwdEi8LFCUpJTFPEyYoJyIxb\\/2gAMAwEAAhEDEQA\\/AOPwKmEQWBQMWFoAWFoELC0xCgtFAFbaYHttAGdtAGNtACStKgCStACCtIBBWgyEEUAIIoELAoGFiVDIglbw4iyh5NN21Serad+g66UnWmgmXzB\\/TRc3EUc8HKbeSCVVkikWzcq6ONysD4vYQa4eXO0Ytp2XVf5eRH9fsNgf0wX5HTk9vr3a2Umn\\/crD\\/wB3D9p\\/qXyH63YVpzny55D5f3kVvmESazud30eQtyWgm2\\/eX5gCrDvVvdrXT8J41Zzot29GtsXtXzXabIyTIqFq3MjO3TqaALU4t5E8j5Bj4snkLuHDwXCiS3hljeWdkYaqzIpUKCOoBOvqrleIc2WLE3CMXNrbTReZolfSehIB\\/TXeH\\/6SH\\/0n\\/wAWq588R\\/af6vIXr9hDed+T3I+D2n80eWLJ4YMFlvLZWRoWY6L4sbakAnoGBI19FXXCeZbGZLco4T6n09zNkLiZXhWuhNggrQBNOGeVue5nAb+KSPH4rcUW7uAzGVl6ERxr1IB6FiQKpOJ8ctYr3WnKXUujvZFv5cbbptZMl\\/pzvH\\/+jhH\\/AIb\\/AOJVM+cI\\/tP9XkaFxFflG3k3kPLxnj+R5DdcihkhsITKYRaOrSNqFRATIdCzECt+FzSr96NtW3WT\\/N5G23m78kqFOkV1ZOFqKAL68uvJTjPJOK2uXzt5dC+ySGWD6V0RLdCxVdVZW3t01bU6d1cRxnmW\\/j33C3FUjtr0\\/IiSyKSoR3FeZXNPLDLXfFvqo8viMPcy2gtbgarsicr+TIPnTUdi6kD0VZX+B43Ebcb1HCU0nVdvWtj9xsdtS1Op8RkosrjbLKQArBewQ3Mat95VmQOAfWNa8sybDtzlB7YtrwI2wi3nDgxyHy8y0KJvurBVyNt01Ia2O5wPbGXFWnLOX6GbB9Evpf8At50Nlt6nHgUe2vZySO3HMecjm7G101UyrJJ01GyL52119lRM276dqUuz7zRkXNyDZ1jxTOXOUgmivSpurcr86gLvRuwkDpqCNOleScRxI22nHYysx7rktdpJkeqpolJgspj4M3ib7D3IDQX8Ets4PZpKhUH3E61lj3nZuRuLbFp+BmmcOXVpNZXM1lcDbcW0jwyqe542KMPtFe7QmpxUlsar4k2oKO3kuJY7eEbppmWOMelnO0fE05SUU29iBuiqdcYSzixGLssVAAIrOGOBdO\\/YoBPvOpryPKuu7clN7ZOpzE7m9JvrHmKWocogmVX\\/AFBZ36bjNhgY20kydz4syjt8G1G74uy\\/ZXTcpYm9elcf4F735VLLh8ayb6jm9hXoJcC1FAiX8e8xeYcZxzYrD5DwrM7jGrxJI0JbqTEzg7evX21W5fBsfInv3I1fhXvNMrMZOrJl5c+UV1zFE5JyW4khw1xI0qRgk3N98xLuXP3UY6\\/N2nu9NU\\/GuYo4v\\/VZSc0vZH5vs6DG5e3dEdNWyQ20MVvboI4IUWOKNeioiDaqj1ADSvMrjcm29WyLU2iI5o3gmG6GVWjkU9hRxtYe8GtOqdVtRkmcRcgw0mAz2Swkg0awuZYBr3ojHYfeuhr3bCyVfswuL8ST+fvJidUS\\/wAr8WZrq+ybL8sCLbxn9eQ7m+AH21UcwX92MYdevgV\\/EJ6KJcHGpTaZZAeiTqYm9p6r8RXGZ8d+33alfYdJE\\/R655onph0etLRmmcrec2EGI57fyIu23yax38Xo1lG2TT99WPvr1rlfK9XDinth9Phs9xLtuqGny6xgyHLbIuNYbLddya9n5Q+T8ZWpXHL\\/AKeNLrl9Pj5EfPubtp9uh0RFL6684lE55M3opa0yibEznHznzJy3NJrZG3QYqKOzQd3if9SX8Tae6vQ+W8X08VPpm6\\/BF\\/gwpbr1lcsKviYLUUwCaHaQO0g6U0B2lxa7sbrjmJnxpU2DWluINvYFWMKV9oI0PrrxnPtzjemp\\/wB286+JVyqm6j4JVRS7sFQdrMQAPeaguNdg0zYilV1DowdD2MpBB9hFaZRoZJnOXn1hRZcvhy8a6Q5e2V2I7PHt\\/wAp\\/tXYa9O5Myt\\/Fdt7YP3PVe+pKtPQkPAMR9BxWzZ10mvN11J6dJD8n4AKr+NZO\\/kS6o6eHmVmVLem+wkYjaKRZU6OhDKfWDrVW3VUI1KE4hmEiLIvY4DD3jWqCcKOhNTNpHrU0ZJlQ\\/1AYb6nEYrPxrq9lM1pO38O4G5NfY6\\/Gux5Lyt27O0\\/xLeXevJ+4k2Ja0Ij5U2Ihtr7KMPmndbeI\\/qRjc3xI+yrfmS7WUYdWviVnFbv1KPVqWdDNXKyiVaZsy38VjazXs50hto3mkP6salj+itcbTnJRW1uhtgqtI5Ov7uXI3tzkLg6z3Usk8hP\\/FIxY\\/pr1a1aVuKitiVPA6uMaJLqNJhWZkKUUIAyimBJ+N845TxWNoMLfmK1dizW0iLNDuPawVwdCe\\/TSq7N4Tj5LrcjV9exmuduMtpN+P8AHeX+bvi5TP5toMVA5hi1TcjSAAsIoEKIANRqxqmzM3G4VSFq3WT1\\/rLV+wj3LsbWiWoYw8l8k+R2TG9N9xy+OsiruWKaJSBIDGxISVAQwIPw1pVscZsS+nduR8U+jXpixwmrq7Sy\\/N3jjcp45YSWY3z215btG4HXwLsiFz7BuVvdXL8sZ38XIkpbJRfjHVfFGEJ7tTbS0jgijgiGkUSrHGPQqDaPgK1SuOTbe1lc9RLRU1IVB4xcwNuItRvi6Ea9QD1WoORD6q9Zug9BzR6iNGxMZ+a4n\\/UHEsvigN0stu7wD+ND+bHp+8ulTeE5PoZNu50J69z0Zttyo0Vlxi2\\/luEsbQja6xh5R3+JJ87a+86V0vEbvq3pS7fcigyru\\/ck+0kMUtVsompMjfmVlzY8SuIEbSXIOlqvp2E75Pwrp76s+BY2\\/kp9EdfkWPDob11dmpQjCu9OkAsKQClpgTPhHlxyLnJlkxYit7CBtkt9dMVi36a7FChmY6dug6VUcU43YwqKdXJ9C2+RrncUTY5p5bck4IYJcskU+PuSUgv7Vi8JcDXY24Kytp1AI691LhXHbGbVQqpLbF7e\\/tQRmmSjyy8x8bxrHPhM0JI7ZZXmtrmJDIB4mm5HVevaNQRVdx3gdzIn6lulaUa2EXIx3J1QTmPIn81M9ieO8dgkNpAz6TSrtZjLoJJWXrtRFHf\\/AGU+F4K4XZnevNVfR3bF2tsdm36abZ0FHCi2gs16xrEIV19CrtB+FebOb3t7prU0PUjXiFSVbtB0I9Yq3oRBQKt7aQEJ4ryf6nzFzeO362s8Yhthr032PQ6e3c5q\\/wCJ8O3cC1OmqdX\\/AL\\/ZEx26W0\\/tqWej1yEompM2EetUomSZWGXg+gy11bDoiyFo\\/wBh\\/mX4Gulx579tPsKC\\/Ddm0IilpyiYJlZ+aeT+oyVnjFOqWkRlkH8SY9PsVR9tdVy9j7tuU\\/zOnsR0PCbdIOXX8CvGFdAW4FqAPLQB0t5I5uwm4jDird1W+sZJvqoNRvPiyF1k07SCDpr6q845oxJrIc3sklR9y2FdkVU6m95357HQ8IfDXDq2Sv57drW31BdRDIHeXTtAAG3X11o5Tw5vLVxf2xTq+9UobLDqymPLm1w2Q5RbYzO2q3VnfJJCiuzLtm270YFCDqdu3313PG7l23judp7rjR+zpN15tRqjoKHH4HhOHv7\\/ABGMSFLaCSeVIBrLMIlLBS7asfeeledyvXs27GFybdWlrsVewg7zk9WN\\/lz5gz81+vjubFbSay8Nw0Ls8bJKSACWGoYae+pPHuBrC3XGW8pV27dPgbblvdHTKjwL+QdiyaSL+92\\/GomM96CINzRjVk8ouMxl3kGP+WieQetgPlHvOlTMbGd25GH5nQILeaRRfH8pJic\\/YZd21MNwskzelHOkmvtUmvR87FV6xO31rT4FvONYtHTqOD1U6qeoPpHca8hcSsTNhHrVKJkmQznVv4d1aX6jpKhhc\\/rIdV+B+FW\\/C51i49WpV8RhRqRHIpR3nQd5qxlEgJlJ5+\\/OTzF7fE6rLK3h\\/sL8qfACu7w7PpWox6kdnjW9y3GPYNL1IJAFqAPLQBtW1xPbSrPbSvBMv3ZInZHHsZSDWMoKSo1VCaqPeBweb5lmFsLEtdZCRS8k9xKSEjXteSRtToNai5WXaxLW9LSK6EvuRrnNQVWPOe4nyPy5ymPu8gsbfmLcWd1buXidoGDMupCkMO8EdlRsLiNjiFucYV2Uae3UwhcjcTodI2d3De2sN3CQ1vcxpKneCkihh8DXmV204ScXtTp4FbsDWFnYY6Nosfaw2kTtvdII1jDMe8hQNTWF+7O46zk5PtdTPeb2mhyVfyYLof7jGNj6m6j4it+A9XE039lSsPMPKGHCx2KN895KNw\\/hxfOfjtrr+X8fevOf5V739mbMKNZV6irW6jQ9ldmWh0XwfLfzbi+NumbdMkf08x7\\/ABIPyzr7QAa8s4zi+jkzj0Vqu56lZdjSTRJkeqhoxTGrllt9Zgpyo1ktts6\\/udG\\/CTUnAnu3V26EbMhvW32alS5zImxwt5Op0kMZjj\\/bk+Qfp1rq8Kxv3oror9xXYNv1LsV9tCpG6dK7M7IC9IyAtQBhaACrQBLeB8vfhuaOSMH1NtPEYLmFSFcoWDAoT01BHf21WcV4csu1uVo06o0X7W+qD55ieYy82FjaWlq9rj7JnlHjMplklcBdTt1AAHYNaicD4J\\/D3pSlWUtNNiRhYsblSy\\/KrMrkuJ29szhrnGs1rIuvUIDuiJ9RU6e6uZ5ixfTyW+ievzImTGk+8nqPXPNGpMxeWy39pJas23xANraa7WB1B0otz3JKQSVVQ558w7g\\/6ikx3ipKMeghZozqviN87jr3jUA+yvTeAW6Y6nSm\\/r7Ogl4drchr0kTLVdkstTydy67chhJHAbVbu3UnqQRsk09mimuO5qxdYXV\\/xfw+JCy47GWyj1xjRETCkJLG8Ug1jkUo49IYaGtex1G9VQoDzTsjgprXDi4SYS7rnRdd6xj5Y\\/EHcT1+yu\\/5dn6ylcpSmnzoLhmE7cpSfcitWNdOXQFjSMgLUAJU0kAZTTAMpoEFU0xDthM9leP3f1uIuWt5yNrjQMki9u10boRUfKxLd+O7cVV9thhO2pKjJmnnFy4AfJZk+nwG\\/wCeqZ8r43+Xj5Gj+JHtB3nm3zK8t2t0mgtN40MttDtlAPoZi2ntFZ2uWcSEqtOXe9DJY0UQouzMWYlmYksxOpJPUkk99dAtDfQxuoALa3t1YXMd5ZTNBdQndFLGdGU1hdtRuRcZKqYnFNUZMYvN3l0SBGNpKwGm97fRj6ztYD4VRT5ZxW\\/xL2kf+JHtMS+cfMWQpH9JEzdA6W5LD2bmI191YrljFT13n7fIaxY9pDsgmcyVxJksgJrm7uDvlmkO52PdqO4Adg0q8tWoW4qMFRLoJEY0VENUsU0eviRsn7SkfprMyNZjQMExpAIU0AFU0wDKaBBVNMQVTQAQNTAWGpgZ3UCPbqAMFqBmYopbiQRQqXc9w7vWTSA3ybTEDrpc5H8EZ\\/trHaPYagmzFwTcRNKQx7VOin1AHp9lAAjmspCxjkfUr0ZJEGo9vYaKDC290mW8W1uYI1lMbNHIi6NuFIZHmPp7aBCFNIAqmmAVTTAKrUCCBqYggagBQanUDO6gD2+gDBaioDq072uHhktNEMzMs8g+9qNdBrWI+gaItsk8aOfkd1DH1E6GmIzeSTT3UikEsjFEjUE7Qp0AAFIYaa1u7m1iaRCLmMlAJCFd49NV0DdSQdRSGAwrH+ZR+sOD\\/doY0Nc5AlkA7A7AfaaQAVNAwqmmYhFagAgamARWoELDUAKDUxGd9AHt9AGC1ADljHW6gnxkh0Mg8SEnudaTMkadmgF8sMyauCyhG7PEAO3X30AeGRuridUlnMMcjgSGIBNNx0J6afGkBpNI1td7y25oZPva667W9NADlYxLBlLubsit0dwfU\\/zL8KRkiPu5Ylj2kkn30ADBoAIrUCCBqYhYagAgamAoNQAoNQBnfQB7fQBgtQB5JnidZIztdCCregigB3k25NUyFoAMhCVaaHs3bT0IpAN00uOErv4UzszFjGxEaqSddvTU9KAAHIFP8vDFD6CE3t\\/efWkM27uR7LG+FMxN9fHfMT94IOwH9FAxiJoAQDQIWDQMWGoAWGoMRYamAoNQArdTAzuoA9uoAxuoAwWpAejnlgkEsLFJF7GFADg2QsL8AZGIxz9n1EPf7R\\/tpDMIuIsT9V9R9W69YYQNPm7i3spDoNN1cy3czzzHV2+wDuA9VMDXJoEf\\/9k=\"],\"_img_64\":[\"field_5d2865a27767c\"],\"_yoast_wpseo_estimated-reading-time-minutes\":[\"1\"],\"_yoast_wpseo_meta-robots-noindex\":[\"1\"],\"_yoast_wpseo_meta-robots-nofollow\":[\"1\"],\"_yoast_wpseo_wordproof_timestamp\":[\"\"],\"_cmplz_scanned_post\":[\"1\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\\/70606\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/types\\/wps_plugins_adds\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/media?parent=70606\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}}]\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;s:13:\"http_response\";O:25:\"WP_HTTP_Requests_Response\":5:{s:11:\"\0*\0response\";O:23:\"WpOrg\\Requests\\Response\":10:{s:4:\"body\";s:73203:\"[{\"id\":70610,\"date\":\"2018-06-26T14:51:51\",\"date_gmt\":\"2018-06-26T12:51:51\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpserveur.net\\/?post_type=wps_plugins_adds&#038;p=70610\"},\"modified\":\"2023-09-29T17:38:24\",\"modified_gmt\":\"2023-09-29T15:38:24\",\"slug\":\"wps-bidouille\",\"status\":\"publish\",\"type\":\"wps_plugins_adds\",\"link\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\",\"title\":{\"rendered\":\"WPS Bidouille\"},\"content\":{\"rendered\":\"<p>WPS Bidouille fournit des informations sur votre WordPress et contient des outils d\'optimisation.<\\/p>\\n\",\"protected\":false},\"featured_media\":0,\"menu_order\":0,\"template\":\"\",\"class_list\":[\"post-70610\",\"wps_plugins_adds\",\"type-wps_plugins_adds\",\"status-publish\",\"hentry\"],\"yoast_head\":\"<!-- This site is optimized with the Yoast SEO plugin v23.7 - https:\\/\\/yoast.com\\/wordpress\\/plugins\\/seo\\/ -->\\n<title>WPS Bidouille - WPServeur<\\/title>\\n<meta name=\\\"robots\\\" content=\\\"noindex, nofollow\\\" \\/>\\n<meta property=\\\"og:locale\\\" content=\\\"fr_FR\\\" \\/>\\n<meta property=\\\"og:type\\\" content=\\\"article\\\" \\/>\\n<meta property=\\\"og:title\\\" content=\\\"WPS Bidouille - WPServeur\\\" \\/>\\n<meta property=\\\"og:description\\\" content=\\\"WPS Bidouille fournit des informations sur votre WordPress et contient des outils d&#039;optimisation.\\\" \\/>\\n<meta property=\\\"og:url\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\\\" \\/>\\n<meta property=\\\"og:site_name\\\" content=\\\"WPServeur\\\" \\/>\\n<meta property=\\\"article:publisher\\\" content=\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\" \\/>\\n<meta property=\\\"article:modified_time\\\" content=\\\"2023-09-29T15:38:24+00:00\\\" \\/>\\n<meta property=\\\"og:image\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\" \\/>\\n\\t<meta property=\\\"og:image:width\\\" content=\\\"501\\\" \\/>\\n\\t<meta property=\\\"og:image:height\\\" content=\\\"133\\\" \\/>\\n\\t<meta property=\\\"og:image:type\\\" content=\\\"image\\/jpeg\\\" \\/>\\n<meta name=\\\"twitter:card\\\" content=\\\"summary_large_image\\\" \\/>\\n<meta name=\\\"twitter:site\\\" content=\\\"@wpserveur\\\" \\/>\\n<meta name=\\\"twitter:label1\\\" content=\\\"Dur\\u00e9e de lecture estim\\u00e9e\\\" \\/>\\n\\t<meta name=\\\"twitter:data1\\\" content=\\\"1 minute\\\" \\/>\\n<script type=\\\"application\\/ld+json\\\" class=\\\"yoast-schema-graph\\\">{\\\"@context\\\":\\\"https:\\/\\/schema.org\\\",\\\"@graph\\\":[{\\\"@type\\\":\\\"WebPage\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\\\",\\\"name\\\":\\\"WPS Bidouille - WPServeur\\\",\\\"isPartOf\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\"},\\\"datePublished\\\":\\\"2018-06-26T12:51:51+00:00\\\",\\\"dateModified\\\":\\\"2023-09-29T15:38:24+00:00\\\",\\\"breadcrumb\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/#breadcrumb\\\"},\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"potentialAction\\\":[{\\\"@type\\\":\\\"ReadAction\\\",\\\"target\\\":[\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\\\"]}]},{\\\"@type\\\":\\\"BreadcrumbList\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/#breadcrumb\\\",\\\"itemListElement\\\":[{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":1,\\\"name\\\":\\\"Accueil\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":2,\\\"name\\\":\\\"Plugins adds\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":3,\\\"name\\\":\\\"WPS Bidouille\\\"}]},{\\\"@type\\\":\\\"WebSite\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"name\\\":\\\"WPServeur\\\",\\\"description\\\":\\\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\\\",\\\"publisher\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\"},\\\"potentialAction\\\":[{\\\"@type\\\":\\\"SearchAction\\\",\\\"target\\\":{\\\"@type\\\":\\\"EntryPoint\\\",\\\"urlTemplate\\\":\\\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\\\"},\\\"query-input\\\":{\\\"@type\\\":\\\"PropertyValueSpecification\\\",\\\"valueRequired\\\":true,\\\"valueName\\\":\\\"search_term_string\\\"}}],\\\"inLanguage\\\":\\\"fr-FR\\\"},{\\\"@type\\\":\\\"Organization\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\",\\\"name\\\":\\\"WPSERVEUR\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"logo\\\":{\\\"@type\\\":\\\"ImageObject\\\",\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"contentUrl\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"width\\\":501,\\\"height\\\":133,\\\"caption\\\":\\\"WPSERVEUR\\\"},\\\"image\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\"},\\\"sameAs\\\":[\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\",\\\"https:\\/\\/x.com\\/wpserveur\\\"]}]}<\\/script>\\n<!-- \\/ Yoast SEO plugin. -->\",\"yoast_head_json\":{\"title\":\"WPS Bidouille - WPServeur\",\"robots\":{\"index\":\"noindex\",\"follow\":\"nofollow\"},\"og_locale\":\"fr_FR\",\"og_type\":\"article\",\"og_title\":\"WPS Bidouille - WPServeur\",\"og_description\":\"WPS Bidouille fournit des informations sur votre WordPress et contient des outils d\'optimisation.\",\"og_url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\",\"og_site_name\":\"WPServeur\",\"article_publisher\":\"https:\\/\\/www.facebook.com\\/wpserveur\",\"article_modified_time\":\"2023-09-29T15:38:24+00:00\",\"og_image\":[{\"width\":501,\"height\":133,\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"type\":\"image\\/jpeg\"}],\"twitter_card\":\"summary_large_image\",\"twitter_site\":\"@wpserveur\",\"twitter_misc\":{\"Dur\\u00e9e de lecture estim\\u00e9e\":\"1 minute\"},\"schema\":{\"@context\":\"https:\\/\\/schema.org\",\"@graph\":[{\"@type\":\"WebPage\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\",\"name\":\"WPS Bidouille - WPServeur\",\"isPartOf\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\"},\"datePublished\":\"2018-06-26T12:51:51+00:00\",\"dateModified\":\"2023-09-29T15:38:24+00:00\",\"breadcrumb\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/#breadcrumb\"},\"inLanguage\":\"fr-FR\",\"potentialAction\":[{\"@type\":\"ReadAction\",\"target\":[\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\"]}]},{\"@type\":\"BreadcrumbList\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/#breadcrumb\",\"itemListElement\":[{\"@type\":\"ListItem\",\"position\":1,\"name\":\"Accueil\",\"item\":\"https:\\/\\/www.wpserveur.net\\/\"},{\"@type\":\"ListItem\",\"position\":2,\"name\":\"Plugins adds\",\"item\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\"},{\"@type\":\"ListItem\",\"position\":3,\"name\":\"WPS Bidouille\"}]},{\"@type\":\"WebSite\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"name\":\"WPServeur\",\"description\":\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\",\"publisher\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\"},\"potentialAction\":[{\"@type\":\"SearchAction\",\"target\":{\"@type\":\"EntryPoint\",\"urlTemplate\":\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\"},\"query-input\":{\"@type\":\"PropertyValueSpecification\",\"valueRequired\":true,\"valueName\":\"search_term_string\"}}],\"inLanguage\":\"fr-FR\"},{\"@type\":\"Organization\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\",\"name\":\"WPSERVEUR\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"logo\":{\"@type\":\"ImageObject\",\"inLanguage\":\"fr-FR\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"contentUrl\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"width\":501,\"height\":133,\"caption\":\"WPSERVEUR\"},\"image\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\"},\"sameAs\":[\"https:\\/\\/www.facebook.com\\/wpserveur\",\"https:\\/\\/x.com\\/wpserveur\"]}]}},\"post-meta-fields\":{\"_edit_lock\":[\"1696001943:4369\"],\"_edit_last\":[\"4369\"],\"plugin\":[\"wps-bidouille\"],\"_plugin\":[\"field_5b3218a08e6ef\"],\"pour_tous\":[\"1\"],\"_pour_tous\":[\"field_5b3218a68e6f0\"],\"description_en\":[\"WPS Bidouille provides information about your WordPress and contains optimization tools.\"],\"_description_en\":[\"field_5b322e3477aa4\"],\"wps_icon\":[\"\"],\"img_64\":[\"data:image\\/jpeg;base64,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\"],\"_img_64\":[\"field_5d2865a27767c\"],\"_yoast_wpseo_estimated-reading-time-minutes\":[\"1\"],\"_yoast_wpseo_meta-robots-noindex\":[\"1\"],\"_yoast_wpseo_meta-robots-nofollow\":[\"1\"],\"_yoast_wpseo_wordproof_timestamp\":[\"\"],\"_cmplz_scanned_post\":[\"1\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\\/70610\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/types\\/wps_plugins_adds\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/media?parent=70610\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}},{\"id\":70609,\"date\":\"2018-06-26T14:51:19\",\"date_gmt\":\"2018-06-26T12:51:19\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpserveur.net\\/?post_type=wps_plugins_adds&#038;p=70609\"},\"modified\":\"2023-09-29T17:38:13\",\"modified_gmt\":\"2023-09-29T15:38:13\",\"slug\":\"wps-cleaner\",\"status\":\"publish\",\"type\":\"wps_plugins_adds\",\"link\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\",\"title\":{\"rendered\":\"WPS Cleaner\"},\"content\":{\"rendered\":\"<p>Nettoyer votre site WordPress.<\\/p>\\n\",\"protected\":false},\"featured_media\":0,\"menu_order\":0,\"template\":\"\",\"class_list\":[\"post-70609\",\"wps_plugins_adds\",\"type-wps_plugins_adds\",\"status-publish\",\"hentry\"],\"yoast_head\":\"<!-- This site is optimized with the Yoast SEO plugin v23.7 - https:\\/\\/yoast.com\\/wordpress\\/plugins\\/seo\\/ -->\\n<title>WPS Cleaner - WPServeur<\\/title>\\n<meta name=\\\"robots\\\" content=\\\"noindex, nofollow\\\" \\/>\\n<meta property=\\\"og:locale\\\" content=\\\"fr_FR\\\" \\/>\\n<meta property=\\\"og:type\\\" content=\\\"article\\\" \\/>\\n<meta property=\\\"og:title\\\" content=\\\"WPS Cleaner - WPServeur\\\" \\/>\\n<meta property=\\\"og:description\\\" content=\\\"Nettoyer votre site WordPress.\\\" \\/>\\n<meta property=\\\"og:url\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\\\" \\/>\\n<meta property=\\\"og:site_name\\\" content=\\\"WPServeur\\\" \\/>\\n<meta property=\\\"article:publisher\\\" content=\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\" \\/>\\n<meta property=\\\"article:modified_time\\\" content=\\\"2023-09-29T15:38:13+00:00\\\" \\/>\\n<meta property=\\\"og:image\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\" \\/>\\n\\t<meta property=\\\"og:image:width\\\" content=\\\"501\\\" \\/>\\n\\t<meta property=\\\"og:image:height\\\" content=\\\"133\\\" \\/>\\n\\t<meta property=\\\"og:image:type\\\" content=\\\"image\\/jpeg\\\" \\/>\\n<meta name=\\\"twitter:card\\\" content=\\\"summary_large_image\\\" \\/>\\n<meta name=\\\"twitter:site\\\" content=\\\"@wpserveur\\\" \\/>\\n<meta name=\\\"twitter:label1\\\" content=\\\"Dur\\u00e9e de lecture estim\\u00e9e\\\" \\/>\\n\\t<meta name=\\\"twitter:data1\\\" content=\\\"1 minute\\\" \\/>\\n<script type=\\\"application\\/ld+json\\\" class=\\\"yoast-schema-graph\\\">{\\\"@context\\\":\\\"https:\\/\\/schema.org\\\",\\\"@graph\\\":[{\\\"@type\\\":\\\"WebPage\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\\\",\\\"name\\\":\\\"WPS Cleaner - WPServeur\\\",\\\"isPartOf\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\"},\\\"datePublished\\\":\\\"2018-06-26T12:51:19+00:00\\\",\\\"dateModified\\\":\\\"2023-09-29T15:38:13+00:00\\\",\\\"breadcrumb\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/#breadcrumb\\\"},\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"potentialAction\\\":[{\\\"@type\\\":\\\"ReadAction\\\",\\\"target\\\":[\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\\\"]}]},{\\\"@type\\\":\\\"BreadcrumbList\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/#breadcrumb\\\",\\\"itemListElement\\\":[{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":1,\\\"name\\\":\\\"Accueil\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":2,\\\"name\\\":\\\"Plugins adds\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":3,\\\"name\\\":\\\"WPS Cleaner\\\"}]},{\\\"@type\\\":\\\"WebSite\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"name\\\":\\\"WPServeur\\\",\\\"description\\\":\\\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\\\",\\\"publisher\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\"},\\\"potentialAction\\\":[{\\\"@type\\\":\\\"SearchAction\\\",\\\"target\\\":{\\\"@type\\\":\\\"EntryPoint\\\",\\\"urlTemplate\\\":\\\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\\\"},\\\"query-input\\\":{\\\"@type\\\":\\\"PropertyValueSpecification\\\",\\\"valueRequired\\\":true,\\\"valueName\\\":\\\"search_term_string\\\"}}],\\\"inLanguage\\\":\\\"fr-FR\\\"},{\\\"@type\\\":\\\"Organization\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\",\\\"name\\\":\\\"WPSERVEUR\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"logo\\\":{\\\"@type\\\":\\\"ImageObject\\\",\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"contentUrl\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"width\\\":501,\\\"height\\\":133,\\\"caption\\\":\\\"WPSERVEUR\\\"},\\\"image\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\"},\\\"sameAs\\\":[\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\",\\\"https:\\/\\/x.com\\/wpserveur\\\"]}]}<\\/script>\\n<!-- \\/ Yoast SEO plugin. -->\",\"yoast_head_json\":{\"title\":\"WPS Cleaner - WPServeur\",\"robots\":{\"index\":\"noindex\",\"follow\":\"nofollow\"},\"og_locale\":\"fr_FR\",\"og_type\":\"article\",\"og_title\":\"WPS Cleaner - WPServeur\",\"og_description\":\"Nettoyer votre site WordPress.\",\"og_url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\",\"og_site_name\":\"WPServeur\",\"article_publisher\":\"https:\\/\\/www.facebook.com\\/wpserveur\",\"article_modified_time\":\"2023-09-29T15:38:13+00:00\",\"og_image\":[{\"width\":501,\"height\":133,\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"type\":\"image\\/jpeg\"}],\"twitter_card\":\"summary_large_image\",\"twitter_site\":\"@wpserveur\",\"twitter_misc\":{\"Dur\\u00e9e de lecture estim\\u00e9e\":\"1 minute\"},\"schema\":{\"@context\":\"https:\\/\\/schema.org\",\"@graph\":[{\"@type\":\"WebPage\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\",\"name\":\"WPS Cleaner - WPServeur\",\"isPartOf\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\"},\"datePublished\":\"2018-06-26T12:51:19+00:00\",\"dateModified\":\"2023-09-29T15:38:13+00:00\",\"breadcrumb\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/#breadcrumb\"},\"inLanguage\":\"fr-FR\",\"potentialAction\":[{\"@type\":\"ReadAction\",\"target\":[\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\"]}]},{\"@type\":\"BreadcrumbList\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/#breadcrumb\",\"itemListElement\":[{\"@type\":\"ListItem\",\"position\":1,\"name\":\"Accueil\",\"item\":\"https:\\/\\/www.wpserveur.net\\/\"},{\"@type\":\"ListItem\",\"position\":2,\"name\":\"Plugins adds\",\"item\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\"},{\"@type\":\"ListItem\",\"position\":3,\"name\":\"WPS Cleaner\"}]},{\"@type\":\"WebSite\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"name\":\"WPServeur\",\"description\":\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\",\"publisher\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\"},\"potentialAction\":[{\"@type\":\"SearchAction\",\"target\":{\"@type\":\"EntryPoint\",\"urlTemplate\":\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\"},\"query-input\":{\"@type\":\"PropertyValueSpecification\",\"valueRequired\":true,\"valueName\":\"search_term_string\"}}],\"inLanguage\":\"fr-FR\"},{\"@type\":\"Organization\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\",\"name\":\"WPSERVEUR\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"logo\":{\"@type\":\"ImageObject\",\"inLanguage\":\"fr-FR\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"contentUrl\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"width\":501,\"height\":133,\"caption\":\"WPSERVEUR\"},\"image\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\"},\"sameAs\":[\"https:\\/\\/www.facebook.com\\/wpserveur\",\"https:\\/\\/x.com\\/wpserveur\"]}]}},\"post-meta-fields\":{\"_edit_lock\":[\"1696001942:4369\"],\"_edit_last\":[\"4369\"],\"plugin\":[\"wps-cleaner\"],\"_plugin\":[\"field_5b3218a08e6ef\"],\"pour_tous\":[\"1\"],\"_pour_tous\":[\"field_5b3218a68e6f0\"],\"description_en\":[\"Clean up your WordPress site.\"],\"_description_en\":[\"field_5b322e3477aa4\"],\"wps_icon\":[\"\"],\"img_64\":[\"data:image\\/jpeg;base64,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\"],\"_img_64\":[\"field_5d2865a27767c\"],\"_yoast_wpseo_estimated-reading-time-minutes\":[\"1\"],\"_yoast_wpseo_meta-robots-noindex\":[\"1\"],\"_yoast_wpseo_meta-robots-nofollow\":[\"1\"],\"_yoast_wpseo_wordproof_timestamp\":[\"\"],\"_cmplz_scanned_post\":[\"1\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\\/70609\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/types\\/wps_plugins_adds\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/media?parent=70609\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}},{\"id\":70607,\"date\":\"2018-06-26T14:50:49\",\"date_gmt\":\"2018-06-26T12:50:49\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpserveur.net\\/?post_type=wps_plugins_adds&#038;p=70607\"},\"modified\":\"2023-09-29T17:37:50\",\"modified_gmt\":\"2023-09-29T15:37:50\",\"slug\":\"wps-hide-login\",\"status\":\"publish\",\"type\":\"wps_plugins_adds\",\"link\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\",\"title\":{\"rendered\":\"WPS Hide Login\"},\"content\":{\"rendered\":\"<p>S\\u00e9curiser l\'acc\\u00e8s \\u00e0 votre administration WordPress<\\/p>\\n\",\"protected\":false},\"featured_media\":0,\"menu_order\":0,\"template\":\"\",\"class_list\":[\"post-70607\",\"wps_plugins_adds\",\"type-wps_plugins_adds\",\"status-publish\",\"hentry\"],\"yoast_head\":\"<!-- This site is optimized with the Yoast SEO plugin v23.7 - https:\\/\\/yoast.com\\/wordpress\\/plugins\\/seo\\/ -->\\n<title>WPS Hide Login - WPServeur<\\/title>\\n<meta name=\\\"robots\\\" content=\\\"noindex, nofollow\\\" \\/>\\n<meta property=\\\"og:locale\\\" content=\\\"fr_FR\\\" \\/>\\n<meta property=\\\"og:type\\\" content=\\\"article\\\" \\/>\\n<meta property=\\\"og:title\\\" content=\\\"WPS Hide Login - WPServeur\\\" \\/>\\n<meta property=\\\"og:description\\\" content=\\\"S\\u00e9curiser l&#039;acc\\u00e8s \\u00e0 votre administration WordPress\\\" \\/>\\n<meta property=\\\"og:url\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\\\" \\/>\\n<meta property=\\\"og:site_name\\\" content=\\\"WPServeur\\\" \\/>\\n<meta property=\\\"article:publisher\\\" content=\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\" \\/>\\n<meta property=\\\"article:modified_time\\\" content=\\\"2023-09-29T15:37:50+00:00\\\" \\/>\\n<meta property=\\\"og:image\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\" \\/>\\n\\t<meta property=\\\"og:image:width\\\" content=\\\"501\\\" \\/>\\n\\t<meta property=\\\"og:image:height\\\" content=\\\"133\\\" \\/>\\n\\t<meta property=\\\"og:image:type\\\" content=\\\"image\\/jpeg\\\" \\/>\\n<meta name=\\\"twitter:card\\\" content=\\\"summary_large_image\\\" \\/>\\n<meta name=\\\"twitter:site\\\" content=\\\"@wpserveur\\\" \\/>\\n<meta name=\\\"twitter:label1\\\" content=\\\"Dur\\u00e9e de lecture estim\\u00e9e\\\" \\/>\\n\\t<meta name=\\\"twitter:data1\\\" content=\\\"1 minute\\\" \\/>\\n<script type=\\\"application\\/ld+json\\\" class=\\\"yoast-schema-graph\\\">{\\\"@context\\\":\\\"https:\\/\\/schema.org\\\",\\\"@graph\\\":[{\\\"@type\\\":\\\"WebPage\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\\\",\\\"name\\\":\\\"WPS Hide Login - WPServeur\\\",\\\"isPartOf\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\"},\\\"datePublished\\\":\\\"2018-06-26T12:50:49+00:00\\\",\\\"dateModified\\\":\\\"2023-09-29T15:37:50+00:00\\\",\\\"breadcrumb\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/#breadcrumb\\\"},\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"potentialAction\\\":[{\\\"@type\\\":\\\"ReadAction\\\",\\\"target\\\":[\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\\\"]}]},{\\\"@type\\\":\\\"BreadcrumbList\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/#breadcrumb\\\",\\\"itemListElement\\\":[{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":1,\\\"name\\\":\\\"Accueil\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":2,\\\"name\\\":\\\"Plugins adds\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":3,\\\"name\\\":\\\"WPS Hide Login\\\"}]},{\\\"@type\\\":\\\"WebSite\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"name\\\":\\\"WPServeur\\\",\\\"description\\\":\\\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\\\",\\\"publisher\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\"},\\\"potentialAction\\\":[{\\\"@type\\\":\\\"SearchAction\\\",\\\"target\\\":{\\\"@type\\\":\\\"EntryPoint\\\",\\\"urlTemplate\\\":\\\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\\\"},\\\"query-input\\\":{\\\"@type\\\":\\\"PropertyValueSpecification\\\",\\\"valueRequired\\\":true,\\\"valueName\\\":\\\"search_term_string\\\"}}],\\\"inLanguage\\\":\\\"fr-FR\\\"},{\\\"@type\\\":\\\"Organization\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\",\\\"name\\\":\\\"WPSERVEUR\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"logo\\\":{\\\"@type\\\":\\\"ImageObject\\\",\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"contentUrl\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"width\\\":501,\\\"height\\\":133,\\\"caption\\\":\\\"WPSERVEUR\\\"},\\\"image\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\"},\\\"sameAs\\\":[\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\",\\\"https:\\/\\/x.com\\/wpserveur\\\"]}]}<\\/script>\\n<!-- \\/ Yoast SEO plugin. -->\",\"yoast_head_json\":{\"title\":\"WPS Hide Login - WPServeur\",\"robots\":{\"index\":\"noindex\",\"follow\":\"nofollow\"},\"og_locale\":\"fr_FR\",\"og_type\":\"article\",\"og_title\":\"WPS Hide Login - WPServeur\",\"og_description\":\"S\\u00e9curiser l\'acc\\u00e8s \\u00e0 votre administration WordPress\",\"og_url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\",\"og_site_name\":\"WPServeur\",\"article_publisher\":\"https:\\/\\/www.facebook.com\\/wpserveur\",\"article_modified_time\":\"2023-09-29T15:37:50+00:00\",\"og_image\":[{\"width\":501,\"height\":133,\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"type\":\"image\\/jpeg\"}],\"twitter_card\":\"summary_large_image\",\"twitter_site\":\"@wpserveur\",\"twitter_misc\":{\"Dur\\u00e9e de lecture estim\\u00e9e\":\"1 minute\"},\"schema\":{\"@context\":\"https:\\/\\/schema.org\",\"@graph\":[{\"@type\":\"WebPage\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\",\"name\":\"WPS Hide Login - WPServeur\",\"isPartOf\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\"},\"datePublished\":\"2018-06-26T12:50:49+00:00\",\"dateModified\":\"2023-09-29T15:37:50+00:00\",\"breadcrumb\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/#breadcrumb\"},\"inLanguage\":\"fr-FR\",\"potentialAction\":[{\"@type\":\"ReadAction\",\"target\":[\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\"]}]},{\"@type\":\"BreadcrumbList\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/#breadcrumb\",\"itemListElement\":[{\"@type\":\"ListItem\",\"position\":1,\"name\":\"Accueil\",\"item\":\"https:\\/\\/www.wpserveur.net\\/\"},{\"@type\":\"ListItem\",\"position\":2,\"name\":\"Plugins adds\",\"item\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\"},{\"@type\":\"ListItem\",\"position\":3,\"name\":\"WPS Hide Login\"}]},{\"@type\":\"WebSite\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"name\":\"WPServeur\",\"description\":\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\",\"publisher\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\"},\"potentialAction\":[{\"@type\":\"SearchAction\",\"target\":{\"@type\":\"EntryPoint\",\"urlTemplate\":\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\"},\"query-input\":{\"@type\":\"PropertyValueSpecification\",\"valueRequired\":true,\"valueName\":\"search_term_string\"}}],\"inLanguage\":\"fr-FR\"},{\"@type\":\"Organization\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\",\"name\":\"WPSERVEUR\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"logo\":{\"@type\":\"ImageObject\",\"inLanguage\":\"fr-FR\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"contentUrl\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"width\":501,\"height\":133,\"caption\":\"WPSERVEUR\"},\"image\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\"},\"sameAs\":[\"https:\\/\\/www.facebook.com\\/wpserveur\",\"https:\\/\\/x.com\\/wpserveur\"]}]}},\"post-meta-fields\":{\"_edit_lock\":[\"1696001880:4369\"],\"_edit_last\":[\"4369\"],\"plugin\":[\"wps-hide-login\"],\"_plugin\":[\"field_5b3218a08e6ef\"],\"pour_tous\":[\"1\"],\"_pour_tous\":[\"field_5b3218a68e6f0\"],\"description_en\":[\"Secure access to your WordPress administration\"],\"_description_en\":[\"field_5b322e3477aa4\"],\"wps_icon\":[\"\"],\"img_64\":[\"data:image\\/png;base64,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\"],\"_img_64\":[\"field_5d2865a27767c\"],\"_yoast_wpseo_estimated-reading-time-minutes\":[\"1\"],\"_yoast_wpseo_meta-robots-noindex\":[\"1\"],\"_yoast_wpseo_meta-robots-nofollow\":[\"1\"],\"_yoast_wpseo_wordproof_timestamp\":[\"\"],\"_cmplz_scanned_post\":[\"1\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\\/70607\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/types\\/wps_plugins_adds\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/media?parent=70607\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}},{\"id\":70606,\"date\":\"2018-06-26T14:50:11\",\"date_gmt\":\"2018-06-26T12:50:11\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpserveur.net\\/?post_type=wps_plugins_adds&#038;p=70606\"},\"modified\":\"2023-09-29T17:37:37\",\"modified_gmt\":\"2023-09-29T15:37:37\",\"slug\":\"wps-limit-login\",\"status\":\"publish\",\"type\":\"wps_plugins_adds\",\"link\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\",\"title\":{\"rendered\":\"WPS Limit Login\"},\"content\":{\"rendered\":\"<p>S\\u00e9curiser la page d\'authentification WordPress<\\/p>\\n\",\"protected\":false},\"featured_media\":0,\"menu_order\":0,\"template\":\"\",\"class_list\":[\"post-70606\",\"wps_plugins_adds\",\"type-wps_plugins_adds\",\"status-publish\",\"hentry\"],\"yoast_head\":\"<!-- This site is optimized with the Yoast SEO plugin v23.7 - https:\\/\\/yoast.com\\/wordpress\\/plugins\\/seo\\/ -->\\n<title>WPS Limit Login - WPServeur<\\/title>\\n<meta name=\\\"robots\\\" content=\\\"noindex, nofollow\\\" \\/>\\n<meta property=\\\"og:locale\\\" content=\\\"fr_FR\\\" \\/>\\n<meta property=\\\"og:type\\\" content=\\\"article\\\" \\/>\\n<meta property=\\\"og:title\\\" content=\\\"WPS Limit Login - WPServeur\\\" \\/>\\n<meta property=\\\"og:description\\\" content=\\\"S\\u00e9curiser la page d&#039;authentification WordPress\\\" \\/>\\n<meta property=\\\"og:url\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\\\" \\/>\\n<meta property=\\\"og:site_name\\\" content=\\\"WPServeur\\\" \\/>\\n<meta property=\\\"article:publisher\\\" content=\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\" \\/>\\n<meta property=\\\"article:modified_time\\\" content=\\\"2023-09-29T15:37:37+00:00\\\" \\/>\\n<meta property=\\\"og:image\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\" \\/>\\n\\t<meta property=\\\"og:image:width\\\" content=\\\"501\\\" \\/>\\n\\t<meta property=\\\"og:image:height\\\" content=\\\"133\\\" \\/>\\n\\t<meta property=\\\"og:image:type\\\" content=\\\"image\\/jpeg\\\" \\/>\\n<meta name=\\\"twitter:card\\\" content=\\\"summary_large_image\\\" \\/>\\n<meta name=\\\"twitter:site\\\" content=\\\"@wpserveur\\\" \\/>\\n<meta name=\\\"twitter:label1\\\" content=\\\"Dur\\u00e9e de lecture estim\\u00e9e\\\" \\/>\\n\\t<meta name=\\\"twitter:data1\\\" content=\\\"1 minute\\\" \\/>\\n<script type=\\\"application\\/ld+json\\\" class=\\\"yoast-schema-graph\\\">{\\\"@context\\\":\\\"https:\\/\\/schema.org\\\",\\\"@graph\\\":[{\\\"@type\\\":\\\"WebPage\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\\\",\\\"name\\\":\\\"WPS Limit Login - WPServeur\\\",\\\"isPartOf\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\"},\\\"datePublished\\\":\\\"2018-06-26T12:50:11+00:00\\\",\\\"dateModified\\\":\\\"2023-09-29T15:37:37+00:00\\\",\\\"breadcrumb\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/#breadcrumb\\\"},\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"potentialAction\\\":[{\\\"@type\\\":\\\"ReadAction\\\",\\\"target\\\":[\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\\\"]}]},{\\\"@type\\\":\\\"BreadcrumbList\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/#breadcrumb\\\",\\\"itemListElement\\\":[{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":1,\\\"name\\\":\\\"Accueil\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":2,\\\"name\\\":\\\"Plugins adds\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":3,\\\"name\\\":\\\"WPS Limit Login\\\"}]},{\\\"@type\\\":\\\"WebSite\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"name\\\":\\\"WPServeur\\\",\\\"description\\\":\\\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\\\",\\\"publisher\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\"},\\\"potentialAction\\\":[{\\\"@type\\\":\\\"SearchAction\\\",\\\"target\\\":{\\\"@type\\\":\\\"EntryPoint\\\",\\\"urlTemplate\\\":\\\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\\\"},\\\"query-input\\\":{\\\"@type\\\":\\\"PropertyValueSpecification\\\",\\\"valueRequired\\\":true,\\\"valueName\\\":\\\"search_term_string\\\"}}],\\\"inLanguage\\\":\\\"fr-FR\\\"},{\\\"@type\\\":\\\"Organization\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\",\\\"name\\\":\\\"WPSERVEUR\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"logo\\\":{\\\"@type\\\":\\\"ImageObject\\\",\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"contentUrl\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"width\\\":501,\\\"height\\\":133,\\\"caption\\\":\\\"WPSERVEUR\\\"},\\\"image\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\"},\\\"sameAs\\\":[\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\",\\\"https:\\/\\/x.com\\/wpserveur\\\"]}]}<\\/script>\\n<!-- \\/ Yoast SEO plugin. -->\",\"yoast_head_json\":{\"title\":\"WPS Limit Login - WPServeur\",\"robots\":{\"index\":\"noindex\",\"follow\":\"nofollow\"},\"og_locale\":\"fr_FR\",\"og_type\":\"article\",\"og_title\":\"WPS Limit Login - WPServeur\",\"og_description\":\"S\\u00e9curiser la page d\'authentification WordPress\",\"og_url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\",\"og_site_name\":\"WPServeur\",\"article_publisher\":\"https:\\/\\/www.facebook.com\\/wpserveur\",\"article_modified_time\":\"2023-09-29T15:37:37+00:00\",\"og_image\":[{\"width\":501,\"height\":133,\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"type\":\"image\\/jpeg\"}],\"twitter_card\":\"summary_large_image\",\"twitter_site\":\"@wpserveur\",\"twitter_misc\":{\"Dur\\u00e9e de lecture estim\\u00e9e\":\"1 minute\"},\"schema\":{\"@context\":\"https:\\/\\/schema.org\",\"@graph\":[{\"@type\":\"WebPage\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\",\"name\":\"WPS Limit Login - WPServeur\",\"isPartOf\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\"},\"datePublished\":\"2018-06-26T12:50:11+00:00\",\"dateModified\":\"2023-09-29T15:37:37+00:00\",\"breadcrumb\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/#breadcrumb\"},\"inLanguage\":\"fr-FR\",\"potentialAction\":[{\"@type\":\"ReadAction\",\"target\":[\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/\"]}]},{\"@type\":\"BreadcrumbList\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-limit-login\\/#breadcrumb\",\"itemListElement\":[{\"@type\":\"ListItem\",\"position\":1,\"name\":\"Accueil\",\"item\":\"https:\\/\\/www.wpserveur.net\\/\"},{\"@type\":\"ListItem\",\"position\":2,\"name\":\"Plugins adds\",\"item\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\"},{\"@type\":\"ListItem\",\"position\":3,\"name\":\"WPS Limit Login\"}]},{\"@type\":\"WebSite\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"name\":\"WPServeur\",\"description\":\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\",\"publisher\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\"},\"potentialAction\":[{\"@type\":\"SearchAction\",\"target\":{\"@type\":\"EntryPoint\",\"urlTemplate\":\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\"},\"query-input\":{\"@type\":\"PropertyValueSpecification\",\"valueRequired\":true,\"valueName\":\"search_term_string\"}}],\"inLanguage\":\"fr-FR\"},{\"@type\":\"Organization\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\",\"name\":\"WPSERVEUR\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"logo\":{\"@type\":\"ImageObject\",\"inLanguage\":\"fr-FR\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"contentUrl\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"width\":501,\"height\":133,\"caption\":\"WPSERVEUR\"},\"image\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\"},\"sameAs\":[\"https:\\/\\/www.facebook.com\\/wpserveur\",\"https:\\/\\/x.com\\/wpserveur\"]}]}},\"post-meta-fields\":{\"_edit_lock\":[\"1696001735:4369\"],\"_edit_last\":[\"4369\"],\"plugin\":[\"wps-limit-login\"],\"_plugin\":[\"field_5b3218a08e6ef\"],\"pour_tous\":[\"1\"],\"_pour_tous\":[\"field_5b3218a68e6f0\"],\"description_en\":[\"Secure the WordPress authentication page\"],\"_description_en\":[\"field_5b322e3477aa4\"],\"wps_icon\":[\"\"],\"img_64\":[\"data:image\\/jpeg;base64,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\"],\"_img_64\":[\"field_5d2865a27767c\"],\"_yoast_wpseo_estimated-reading-time-minutes\":[\"1\"],\"_yoast_wpseo_meta-robots-noindex\":[\"1\"],\"_yoast_wpseo_meta-robots-nofollow\":[\"1\"],\"_yoast_wpseo_wordproof_timestamp\":[\"\"],\"_cmplz_scanned_post\":[\"1\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\\/70606\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/types\\/wps_plugins_adds\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/media?parent=70606\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}}]\";s:3:\"raw\";s:73767:\"HTTP/1.1 200 OK\r\nDate: Thu, 12 Dec 2024 20:29:47 GMT\r\nServer: Apache\r\nX-Robots-Tag: noindex\r\nLink: <https://www.wpserveur.net/wp-json/>; rel=\"https://api.w.org/\"\r\nX-Content-Type-Options: nosniff\r\nAccess-Control-Expose-Headers: X-WP-Total, X-WP-TotalPages, Link\r\nAccess-Control-Allow-Headers: Authorization, X-WP-Nonce, Content-Disposition, Content-MD5, Content-Type\r\nX-WP-Total: 4\r\nX-WP-TotalPages: 1\r\nAllow: GET\r\nVary: Origin,Accept-Encoding\r\nContent-Encoding: gzip\r\nConnection: close\r\nTransfer-Encoding: chunked\r\nContent-Type: application/json; charset=UTF-8\r\n\r\n[{\"id\":70610,\"date\":\"2018-06-26T14:51:51\",\"date_gmt\":\"2018-06-26T12:51:51\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpserveur.net\\/?post_type=wps_plugins_adds&#038;p=70610\"},\"modified\":\"2023-09-29T17:38:24\",\"modified_gmt\":\"2023-09-29T15:38:24\",\"slug\":\"wps-bidouille\",\"status\":\"publish\",\"type\":\"wps_plugins_adds\",\"link\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\",\"title\":{\"rendered\":\"WPS Bidouille\"},\"content\":{\"rendered\":\"<p>WPS Bidouille fournit des informations sur votre WordPress et contient des outils d\'optimisation.<\\/p>\\n\",\"protected\":false},\"featured_media\":0,\"menu_order\":0,\"template\":\"\",\"class_list\":[\"post-70610\",\"wps_plugins_adds\",\"type-wps_plugins_adds\",\"status-publish\",\"hentry\"],\"yoast_head\":\"<!-- This site is optimized with the Yoast SEO plugin v23.7 - https:\\/\\/yoast.com\\/wordpress\\/plugins\\/seo\\/ -->\\n<title>WPS Bidouille - WPServeur<\\/title>\\n<meta name=\\\"robots\\\" content=\\\"noindex, nofollow\\\" \\/>\\n<meta property=\\\"og:locale\\\" content=\\\"fr_FR\\\" \\/>\\n<meta property=\\\"og:type\\\" content=\\\"article\\\" \\/>\\n<meta property=\\\"og:title\\\" content=\\\"WPS Bidouille - WPServeur\\\" \\/>\\n<meta property=\\\"og:description\\\" content=\\\"WPS Bidouille fournit des informations sur votre WordPress et contient des outils d&#039;optimisation.\\\" \\/>\\n<meta property=\\\"og:url\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\\\" \\/>\\n<meta property=\\\"og:site_name\\\" content=\\\"WPServeur\\\" \\/>\\n<meta property=\\\"article:publisher\\\" content=\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\" \\/>\\n<meta property=\\\"article:modified_time\\\" content=\\\"2023-09-29T15:38:24+00:00\\\" \\/>\\n<meta property=\\\"og:image\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\" \\/>\\n\\t<meta property=\\\"og:image:width\\\" content=\\\"501\\\" \\/>\\n\\t<meta property=\\\"og:image:height\\\" content=\\\"133\\\" \\/>\\n\\t<meta property=\\\"og:image:type\\\" content=\\\"image\\/jpeg\\\" \\/>\\n<meta name=\\\"twitter:card\\\" content=\\\"summary_large_image\\\" \\/>\\n<meta name=\\\"twitter:site\\\" content=\\\"@wpserveur\\\" \\/>\\n<meta name=\\\"twitter:label1\\\" content=\\\"Dur\\u00e9e de lecture estim\\u00e9e\\\" \\/>\\n\\t<meta name=\\\"twitter:data1\\\" content=\\\"1 minute\\\" \\/>\\n<script type=\\\"application\\/ld+json\\\" class=\\\"yoast-schema-graph\\\">{\\\"@context\\\":\\\"https:\\/\\/schema.org\\\",\\\"@graph\\\":[{\\\"@type\\\":\\\"WebPage\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\\\",\\\"name\\\":\\\"WPS Bidouille - WPServeur\\\",\\\"isPartOf\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\"},\\\"datePublished\\\":\\\"2018-06-26T12:51:51+00:00\\\",\\\"dateModified\\\":\\\"2023-09-29T15:38:24+00:00\\\",\\\"breadcrumb\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/#breadcrumb\\\"},\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"potentialAction\\\":[{\\\"@type\\\":\\\"ReadAction\\\",\\\"target\\\":[\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\\\"]}]},{\\\"@type\\\":\\\"BreadcrumbList\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/#breadcrumb\\\",\\\"itemListElement\\\":[{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":1,\\\"name\\\":\\\"Accueil\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":2,\\\"name\\\":\\\"Plugins adds\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":3,\\\"name\\\":\\\"WPS Bidouille\\\"}]},{\\\"@type\\\":\\\"WebSite\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"name\\\":\\\"WPServeur\\\",\\\"description\\\":\\\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\\\",\\\"publisher\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\"},\\\"potentialAction\\\":[{\\\"@type\\\":\\\"SearchAction\\\",\\\"target\\\":{\\\"@type\\\":\\\"EntryPoint\\\",\\\"urlTemplate\\\":\\\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\\\"},\\\"query-input\\\":{\\\"@type\\\":\\\"PropertyValueSpecification\\\",\\\"valueRequired\\\":true,\\\"valueName\\\":\\\"search_term_string\\\"}}],\\\"inLanguage\\\":\\\"fr-FR\\\"},{\\\"@type\\\":\\\"Organization\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\",\\\"name\\\":\\\"WPSERVEUR\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"logo\\\":{\\\"@type\\\":\\\"ImageObject\\\",\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"contentUrl\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"width\\\":501,\\\"height\\\":133,\\\"caption\\\":\\\"WPSERVEUR\\\"},\\\"image\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\"},\\\"sameAs\\\":[\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\",\\\"https:\\/\\/x.com\\/wpserveur\\\"]}]}<\\/script>\\n<!-- \\/ Yoast SEO plugin. -->\",\"yoast_head_json\":{\"title\":\"WPS Bidouille - WPServeur\",\"robots\":{\"index\":\"noindex\",\"follow\":\"nofollow\"},\"og_locale\":\"fr_FR\",\"og_type\":\"article\",\"og_title\":\"WPS Bidouille - WPServeur\",\"og_description\":\"WPS Bidouille fournit des informations sur votre WordPress et contient des outils d\'optimisation.\",\"og_url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\",\"og_site_name\":\"WPServeur\",\"article_publisher\":\"https:\\/\\/www.facebook.com\\/wpserveur\",\"article_modified_time\":\"2023-09-29T15:38:24+00:00\",\"og_image\":[{\"width\":501,\"height\":133,\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"type\":\"image\\/jpeg\"}],\"twitter_card\":\"summary_large_image\",\"twitter_site\":\"@wpserveur\",\"twitter_misc\":{\"Dur\\u00e9e de lecture estim\\u00e9e\":\"1 minute\"},\"schema\":{\"@context\":\"https:\\/\\/schema.org\",\"@graph\":[{\"@type\":\"WebPage\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\",\"name\":\"WPS Bidouille - WPServeur\",\"isPartOf\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\"},\"datePublished\":\"2018-06-26T12:51:51+00:00\",\"dateModified\":\"2023-09-29T15:38:24+00:00\",\"breadcrumb\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/#breadcrumb\"},\"inLanguage\":\"fr-FR\",\"potentialAction\":[{\"@type\":\"ReadAction\",\"target\":[\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/\"]}]},{\"@type\":\"BreadcrumbList\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-bidouille\\/#breadcrumb\",\"itemListElement\":[{\"@type\":\"ListItem\",\"position\":1,\"name\":\"Accueil\",\"item\":\"https:\\/\\/www.wpserveur.net\\/\"},{\"@type\":\"ListItem\",\"position\":2,\"name\":\"Plugins adds\",\"item\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\"},{\"@type\":\"ListItem\",\"position\":3,\"name\":\"WPS Bidouille\"}]},{\"@type\":\"WebSite\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"name\":\"WPServeur\",\"description\":\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\",\"publisher\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\"},\"potentialAction\":[{\"@type\":\"SearchAction\",\"target\":{\"@type\":\"EntryPoint\",\"urlTemplate\":\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\"},\"query-input\":{\"@type\":\"PropertyValueSpecification\",\"valueRequired\":true,\"valueName\":\"search_term_string\"}}],\"inLanguage\":\"fr-FR\"},{\"@type\":\"Organization\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\",\"name\":\"WPSERVEUR\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"logo\":{\"@type\":\"ImageObject\",\"inLanguage\":\"fr-FR\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"contentUrl\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"width\":501,\"height\":133,\"caption\":\"WPSERVEUR\"},\"image\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\"},\"sameAs\":[\"https:\\/\\/www.facebook.com\\/wpserveur\",\"https:\\/\\/x.com\\/wpserveur\"]}]}},\"post-meta-fields\":{\"_edit_lock\":[\"1696001943:4369\"],\"_edit_last\":[\"4369\"],\"plugin\":[\"wps-bidouille\"],\"_plugin\":[\"field_5b3218a08e6ef\"],\"pour_tous\":[\"1\"],\"_pour_tous\":[\"field_5b3218a68e6f0\"],\"description_en\":[\"WPS Bidouille provides information about your WordPress and contains optimization tools.\"],\"_description_en\":[\"field_5b322e3477aa4\"],\"wps_icon\":[\"\"],\"img_64\":[\"data:image\\/jpeg;base64,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\"],\"_img_64\":[\"field_5d2865a27767c\"],\"_yoast_wpseo_estimated-reading-time-minutes\":[\"1\"],\"_yoast_wpseo_meta-robots-noindex\":[\"1\"],\"_yoast_wpseo_meta-robots-nofollow\":[\"1\"],\"_yoast_wpseo_wordproof_timestamp\":[\"\"],\"_cmplz_scanned_post\":[\"1\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\\/70610\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/types\\/wps_plugins_adds\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/media?parent=70610\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}},{\"id\":70609,\"date\":\"2018-06-26T14:51:19\",\"date_gmt\":\"2018-06-26T12:51:19\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpserveur.net\\/?post_type=wps_plugins_adds&#038;p=70609\"},\"modified\":\"2023-09-29T17:38:13\",\"modified_gmt\":\"2023-09-29T15:38:13\",\"slug\":\"wps-cleaner\",\"status\":\"publish\",\"type\":\"wps_plugins_adds\",\"link\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\",\"title\":{\"rendered\":\"WPS Cleaner\"},\"content\":{\"rendered\":\"<p>Nettoyer votre site WordPress.<\\/p>\\n\",\"protected\":false},\"featured_media\":0,\"menu_order\":0,\"template\":\"\",\"class_list\":[\"post-70609\",\"wps_plugins_adds\",\"type-wps_plugins_adds\",\"status-publish\",\"hentry\"],\"yoast_head\":\"<!-- This site is optimized with the Yoast SEO plugin v23.7 - https:\\/\\/yoast.com\\/wordpress\\/plugins\\/seo\\/ -->\\n<title>WPS Cleaner - WPServeur<\\/title>\\n<meta name=\\\"robots\\\" content=\\\"noindex, nofollow\\\" \\/>\\n<meta property=\\\"og:locale\\\" content=\\\"fr_FR\\\" \\/>\\n<meta property=\\\"og:type\\\" content=\\\"article\\\" \\/>\\n<meta property=\\\"og:title\\\" content=\\\"WPS Cleaner - WPServeur\\\" \\/>\\n<meta property=\\\"og:description\\\" content=\\\"Nettoyer votre site WordPress.\\\" \\/>\\n<meta property=\\\"og:url\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\\\" \\/>\\n<meta property=\\\"og:site_name\\\" content=\\\"WPServeur\\\" \\/>\\n<meta property=\\\"article:publisher\\\" content=\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\" \\/>\\n<meta property=\\\"article:modified_time\\\" content=\\\"2023-09-29T15:38:13+00:00\\\" \\/>\\n<meta property=\\\"og:image\\\" content=\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\" \\/>\\n\\t<meta property=\\\"og:image:width\\\" content=\\\"501\\\" \\/>\\n\\t<meta property=\\\"og:image:height\\\" content=\\\"133\\\" \\/>\\n\\t<meta property=\\\"og:image:type\\\" content=\\\"image\\/jpeg\\\" \\/>\\n<meta name=\\\"twitter:card\\\" content=\\\"summary_large_image\\\" \\/>\\n<meta name=\\\"twitter:site\\\" content=\\\"@wpserveur\\\" \\/>\\n<meta name=\\\"twitter:label1\\\" content=\\\"Dur\\u00e9e de lecture estim\\u00e9e\\\" \\/>\\n\\t<meta name=\\\"twitter:data1\\\" content=\\\"1 minute\\\" \\/>\\n<script type=\\\"application\\/ld+json\\\" class=\\\"yoast-schema-graph\\\">{\\\"@context\\\":\\\"https:\\/\\/schema.org\\\",\\\"@graph\\\":[{\\\"@type\\\":\\\"WebPage\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\\\",\\\"name\\\":\\\"WPS Cleaner - WPServeur\\\",\\\"isPartOf\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\"},\\\"datePublished\\\":\\\"2018-06-26T12:51:19+00:00\\\",\\\"dateModified\\\":\\\"2023-09-29T15:38:13+00:00\\\",\\\"breadcrumb\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/#breadcrumb\\\"},\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"potentialAction\\\":[{\\\"@type\\\":\\\"ReadAction\\\",\\\"target\\\":[\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\\\"]}]},{\\\"@type\\\":\\\"BreadcrumbList\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/#breadcrumb\\\",\\\"itemListElement\\\":[{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":1,\\\"name\\\":\\\"Accueil\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":2,\\\"name\\\":\\\"Plugins adds\\\",\\\"item\\\":\\\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\\\"},{\\\"@type\\\":\\\"ListItem\\\",\\\"position\\\":3,\\\"name\\\":\\\"WPS Cleaner\\\"}]},{\\\"@type\\\":\\\"WebSite\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#website\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"name\\\":\\\"WPServeur\\\",\\\"description\\\":\\\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\\\",\\\"publisher\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\"},\\\"potentialAction\\\":[{\\\"@type\\\":\\\"SearchAction\\\",\\\"target\\\":{\\\"@type\\\":\\\"EntryPoint\\\",\\\"urlTemplate\\\":\\\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\\\"},\\\"query-input\\\":{\\\"@type\\\":\\\"PropertyValueSpecification\\\",\\\"valueRequired\\\":true,\\\"valueName\\\":\\\"search_term_string\\\"}}],\\\"inLanguage\\\":\\\"fr-FR\\\"},{\\\"@type\\\":\\\"Organization\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#organization\\\",\\\"name\\\":\\\"WPSERVEUR\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/\\\",\\\"logo\\\":{\\\"@type\\\":\\\"ImageObject\\\",\\\"inLanguage\\\":\\\"fr-FR\\\",\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\",\\\"url\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"contentUrl\\\":\\\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\\\",\\\"width\\\":501,\\\"height\\\":133,\\\"caption\\\":\\\"WPSERVEUR\\\"},\\\"image\\\":{\\\"@id\\\":\\\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\\\"},\\\"sameAs\\\":[\\\"https:\\/\\/www.facebook.com\\/wpserveur\\\",\\\"https:\\/\\/x.com\\/wpserveur\\\"]}]}<\\/script>\\n<!-- \\/ Yoast SEO plugin. -->\",\"yoast_head_json\":{\"title\":\"WPS Cleaner - WPServeur\",\"robots\":{\"index\":\"noindex\",\"follow\":\"nofollow\"},\"og_locale\":\"fr_FR\",\"og_type\":\"article\",\"og_title\":\"WPS Cleaner - WPServeur\",\"og_description\":\"Nettoyer votre site WordPress.\",\"og_url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\",\"og_site_name\":\"WPServeur\",\"article_publisher\":\"https:\\/\\/www.facebook.com\\/wpserveur\",\"article_modified_time\":\"2023-09-29T15:38:13+00:00\",\"og_image\":[{\"width\":501,\"height\":133,\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"type\":\"image\\/jpeg\"}],\"twitter_card\":\"summary_large_image\",\"twitter_site\":\"@wpserveur\",\"twitter_misc\":{\"Dur\\u00e9e de lecture estim\\u00e9e\":\"1 minute\"},\"schema\":{\"@context\":\"https:\\/\\/schema.org\",\"@graph\":[{\"@type\":\"WebPage\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\",\"name\":\"WPS Cleaner - WPServeur\",\"isPartOf\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\"},\"datePublished\":\"2018-06-26T12:51:19+00:00\",\"dateModified\":\"2023-09-29T15:38:13+00:00\",\"breadcrumb\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/#breadcrumb\"},\"inLanguage\":\"fr-FR\",\"potentialAction\":[{\"@type\":\"ReadAction\",\"target\":[\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/\"]}]},{\"@type\":\"BreadcrumbList\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-cleaner\\/#breadcrumb\",\"itemListElement\":[{\"@type\":\"ListItem\",\"position\":1,\"name\":\"Accueil\",\"item\":\"https:\\/\\/www.wpserveur.net\\/\"},{\"@type\":\"ListItem\",\"position\":2,\"name\":\"Plugins adds\",\"item\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/\"},{\"@type\":\"ListItem\",\"position\":3,\"name\":\"WPS Cleaner\"}]},{\"@type\":\"WebSite\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#website\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"name\":\"WPServeur\",\"description\":\"H\\u00e9bergement WordPress Haute Qualit\\u00e9\",\"publisher\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\"},\"potentialAction\":[{\"@type\":\"SearchAction\",\"target\":{\"@type\":\"EntryPoint\",\"urlTemplate\":\"https:\\/\\/www.wpserveur.net\\/?s={search_term_string}\"},\"query-input\":{\"@type\":\"PropertyValueSpecification\",\"valueRequired\":true,\"valueName\":\"search_term_string\"}}],\"inLanguage\":\"fr-FR\"},{\"@type\":\"Organization\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#organization\",\"name\":\"WPSERVEUR\",\"url\":\"https:\\/\\/www.wpserveur.net\\/\",\"logo\":{\"@type\":\"ImageObject\",\"inLanguage\":\"fr-FR\",\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\",\"url\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"contentUrl\":\"https:\\/\\/www.wpserveur.net\\/wp-content\\/uploads\\/2020\\/09\\/wps-twitter.jpg\",\"width\":501,\"height\":133,\"caption\":\"WPSERVEUR\"},\"image\":{\"@id\":\"https:\\/\\/www.wpserveur.net\\/#\\/schema\\/logo\\/image\\/\"},\"sameAs\":[\"https:\\/\\/www.facebook.com\\/wpserveur\",\"https:\\/\\/x.com\\/wpserveur\"]}]}},\"post-meta-fields\":{\"_edit_lock\":[\"1696001942:4369\"],\"_edit_last\":[\"4369\"],\"plugin\":[\"wps-cleaner\"],\"_plugin\":[\"field_5b3218a08e6ef\"],\"pour_tous\":[\"1\"],\"_pour_tous\":[\"field_5b3218a68e6f0\"],\"description_en\":[\"Clean up your WordPress site.\"],\"_description_en\":[\"field_5b322e3477aa4\"],\"wps_icon\":[\"\"],\"img_64\":[\"data:image\\/jpeg;base64,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\"],\"_img_64\":[\"field_5d2865a27767c\"],\"_yoast_wpseo_estimated-reading-time-minutes\":[\"1\"],\"_yoast_wpseo_meta-robots-noindex\":[\"1\"],\"_yoast_wpseo_meta-robots-nofollow\":[\"1\"],\"_yoast_wpseo_wordproof_timestamp\":[\"\"],\"_cmplz_scanned_post\":[\"1\"]},\"_links\":{\"self\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\\/70609\"}],\"collection\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/wps_plugins_adds\"}],\"about\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/types\\/wps_plugins_adds\"}],\"wp:attachment\":[{\"href\":\"https:\\/\\/www.wpserveur.net\\/wp-json\\/wp\\/v2\\/media?parent=70609\"}],\"curies\":[{\"name\":\"wp\",\"href\":\"https:\\/\\/api.w.org\\/{rel}\",\"templated\":true}]}},{\"id\":70607,\"date\":\"2018-06-26T14:50:49\",\"date_gmt\":\"2018-06-26T12:50:49\",\"guid\":{\"rendered\":\"https:\\/\\/www.wpserveur.net\\/?post_type=wps_plugins_adds&#038;p=70607\"},\"modified\":\"2023-09-29T17:37:50\",\"modified_gmt\":\"2023-09-29T15:37:50\",\"slug\":\"wps-hide-login\",\"status\":\"publish\",\"type\":\"wps_plugins_adds\",\"link\":\"https:\\/\\/www.wpserveur.net\\/wps_plugins_adds\\/wps-hide-login\\/\",\"title\":{\"rendered\":\"WPS Hide Login\"},\"content\":{\"rendered\":\"<p>S\\u00e9curiser l\'acc\\u00e8s \\u00e0 votre administration WordPress<\\/p>\\n\",\"protected\":false},\"featured_media\":0,\"menu_order\":0,\"template\":\"\",\"class_list\":[\"post-70607\",\"wps_plugins_adds\",\"type-wps_plugins_adds\",\"status-publish\",\"hentry\"],\"yoast_head\":\"<!-- This site is optimized with the Yoast SEO plugin v23.7 - https:\\/\\/yoast.com\\/wordpress\\/plugins\\/seo\\/ -->\\n<title>WPS Hide Login - WPServeur<\\/title>\\n<meta name=\\\"robots\\\" content=\\\"noindex, nofollow\\\" \\/>\\n<meta property=\\\"og:locale\\\" content=\\\"fr_FR\\\" \\/>\\n<meta property=\\\"og:type\\\" cont